/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit.javadsl;

import java.util.function.Supplier;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.testkit.DebugFilter;
import org.apache.pekko.testkit.ErrorFilter;
import org.apache.pekko.testkit.InfoFilter;
import org.apache.pekko.testkit.WarningFilter;
import scala.Predef$;

public class EventFilter {
    private final Class<?> clazz;
    private final ActorSystem system;
    private final Class<? extends Logging.LogEvent> _clazz;
    private Class<? extends Throwable> exceptionType;
    private String source;
    private String message;
    private boolean pattern;
    private boolean complete;
    private int occurrences;

    public EventFilter(Class<?> clazz, ActorSystem system) {
        this.clazz = clazz;
        this.system = system;
        Predef$.MODULE$.require(Throwable.class.isAssignableFrom(clazz) || Logging.LogEvent.class.isAssignableFrom(clazz), EventFilter::$init$$$anonfun$1);
        this._clazz = Throwable.class.isAssignableFrom(clazz) ? Logging.Error.class : clazz;
        this.exceptionType = Throwable.class.isAssignableFrom(clazz) ? clazz : null;
        this.pattern = false;
        this.complete = false;
        this.occurrences = Integer.MAX_VALUE;
    }

    public <T> T intercept(Supplier<T> code) {
        org.apache.pekko.testkit.EventFilter eventFilter;
        if (this._clazz == Logging.Error.class) {
            if (this.exceptionType == null) {
                this.exceptionType = Logging$.MODULE$.noCause().getClass();
            }
            eventFilter = new ErrorFilter(this.exceptionType, this.source, this.message, this.pattern, this.complete, this.occurrences);
        } else if (this._clazz == Logging.Warning.class) {
            eventFilter = new WarningFilter(this.source, this.message, this.pattern, this.complete, this.occurrences);
        } else {
            org.apache.pekko.testkit.EventFilter eventFilter2;
            if (this._clazz == Logging.Info.class) {
                eventFilter2 = new InfoFilter(this.source, this.message, this.pattern, this.complete, this.occurrences);
            } else if (this._clazz == Logging.Debug.class) {
                eventFilter2 = new DebugFilter(this.source, this.message, this.pattern, this.complete, this.occurrences);
            } else {
                throw new IllegalArgumentException(new StringBuilder(17).append("unknown LogLevel ").append(this.clazz).toString());
            }
            eventFilter = eventFilter2;
        }
        org.apache.pekko.testkit.EventFilter filter = eventFilter;
        return filter.intercept(() -> EventFilter.intercept$$anonfun$1(code), this.system);
    }

    public EventFilter message(String msg) {
        this.message = msg;
        this.pattern = false;
        this.complete = true;
        return this;
    }

    public EventFilter startsWith(String msg) {
        this.message = msg;
        this.pattern = false;
        this.complete = false;
        return this;
    }

    public EventFilter matches(String regex) {
        this.message = regex;
        this.pattern = true;
        return this;
    }

    public EventFilter from(String source) {
        this.source = source;
        return this;
    }

    public EventFilter occurrences(int number) {
        this.occurrences = number;
        return this;
    }

    private static final Object $init$$$anonfun$1() {
        return "supplied class must either be LogEvent or Throwable";
    }

    private static final Object intercept$$anonfun$1(Supplier code$1) {
        return code$1.get();
    }
}

