/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Serializable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.RepointableRef;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.testkit.CallingThreadDispatcher$;
import org.apache.pekko.testkit.TestActor;
import org.apache.pekko.testkit.TestActor$;
import org.apache.pekko.testkit.TestActor$NullMessage$;
import org.apache.pekko.testkit.TestActor$RealMessage$;
import org.apache.pekko.testkit.TestActor$SetAutoPilot$;
import org.apache.pekko.testkit.TestActor$SetIgnore$;
import org.apache.pekko.testkit.TestActor$Spawn$;
import org.apache.pekko.testkit.TestActor$UnWatch$;
import org.apache.pekko.testkit.TestActor$Watch$;
import org.apache.pekko.testkit.TestKit$;
import org.apache.pekko.testkit.TestKitExtension$;
import org.apache.pekko.testkit.TestKitSettings;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.testkit.package$TestDuration$;
import org.apache.pekko.util.BoxedType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public interface TestKitBase {
    public static void $init$(TestKitBase $this) {
        $this.org$apache$pekko$testkit$TestKitBase$_setter_$org$apache$pekko$testkit$TestKitBase$$queue_$eq(new LinkedBlockingDeque());
        $this.lastMessage_$eq(TestActor$NullMessage$.MODULE$);
        $this.org$apache$pekko$testkit$TestKitBase$$end_$eq((Duration)Duration$.MODULE$.Undefined());
        $this.org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg_$eq(false);
    }

    public ActorSystem system();

    public static TestKitSettings testKitSettings$(TestKitBase $this) {
        return $this.testKitSettings();
    }

    default public TestKitSettings testKitSettings() {
        return (TestKitSettings)TestKitExtension$.MODULE$.apply(this.system());
    }

    public LinkedBlockingDeque<TestActor.Message> org$apache$pekko$testkit$TestKitBase$$queue();

    public void org$apache$pekko$testkit$TestKitBase$_setter_$org$apache$pekko$testkit$TestKitBase$$queue_$eq(LinkedBlockingDeque var1);

    public TestActor.Message lastMessage();

    public void lastMessage_$eq(TestActor.Message var1);

    public static ActorRef lastSender$(TestKitBase $this) {
        return $this.lastSender();
    }

    default public ActorRef lastSender() {
        return this.lastMessage().sender();
    }

    public static String testActorName$(TestKitBase $this) {
        return $this.testActorName();
    }

    default public String testActorName() {
        return "testActor";
    }

    public static ActorRef testActor$(TestKitBase $this) {
        return $this.testActor();
    }

    default public ActorRef testActor() {
        ExtendedActorSystem impl = (ExtendedActorSystem)this.system();
        ActorRef ref = impl.systemActorOf(TestActor$.MODULE$.props(this.org$apache$pekko$testkit$TestKitBase$$queue()).withDispatcher(CallingThreadDispatcher$.MODULE$.Id()), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.testActorName(), BoxesRunTime.boxToInteger((int)TestKit$.MODULE$.testActorId().incrementAndGet())})));
        this.awaitCond((Function0<Object>)((Function0 & Serializable)() -> TestKitBase.testActor$$anonfun$1(ref)), (Duration)package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds()), this.system()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis(), this.awaitCond$default$4());
        return ref;
    }

    public Duration org$apache$pekko$testkit$TestKitBase$$end();

    public void org$apache$pekko$testkit$TestKitBase$$end_$eq(Duration var1);

    public boolean org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg();

    public void org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg_$eq(boolean var1);

    public static void ignoreMsg$(TestKitBase $this, PartialFunction f) {
        $this.ignoreMsg((PartialFunction<Object, Object>)f);
    }

    default public void ignoreMsg(PartialFunction<Object, Object> f) {
        TestActor.SetIgnore setIgnore = TestActor$SetIgnore$.MODULE$.apply((Option<PartialFunction<Object, Object>>)Some$.MODULE$.apply(f));
        this.testActor().$bang((Object)setIgnore, this.testActor().$bang$default$2((Object)setIgnore));
    }

    public static void ignoreNoMsg$(TestKitBase $this) {
        $this.ignoreNoMsg();
    }

    default public void ignoreNoMsg() {
        TestActor.SetIgnore setIgnore = TestActor$SetIgnore$.MODULE$.apply((Option<PartialFunction<Object, Object>>)None$.MODULE$);
        this.testActor().$bang((Object)setIgnore, this.testActor().$bang$default$2((Object)setIgnore));
    }

    public static ActorRef watch$(TestKitBase $this, ActorRef ref) {
        return $this.watch(ref);
    }

    default public ActorRef watch(ActorRef ref) {
        TestActor.Watch watch = TestActor$Watch$.MODULE$.apply(ref);
        this.testActor().$bang((Object)watch, this.testActor().$bang$default$2((Object)watch));
        return ref;
    }

    public static ActorRef unwatch$(TestKitBase $this, ActorRef ref) {
        return $this.unwatch(ref);
    }

    default public ActorRef unwatch(ActorRef ref) {
        TestActor.UnWatch unWatch = TestActor$UnWatch$.MODULE$.apply(ref);
        this.testActor().$bang((Object)unWatch, this.testActor().$bang$default$2((Object)unWatch));
        return ref;
    }

    public static void setAutoPilot$(TestKitBase $this, TestActor.AutoPilot pilot) {
        $this.setAutoPilot(pilot);
    }

    default public void setAutoPilot(TestActor.AutoPilot pilot) {
        TestActor.SetAutoPilot setAutoPilot = TestActor$SetAutoPilot$.MODULE$.apply(pilot);
        this.testActor().$bang((Object)setAutoPilot, this.testActor().$bang$default$2((Object)setAutoPilot));
    }

    public static FiniteDuration now$(TestKitBase $this) {
        return $this.now();
    }

    default public FiniteDuration now() {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(System.nanoTime())).nanos();
    }

    public static FiniteDuration remainingOrDefault$(TestKitBase $this) {
        return $this.remainingOrDefault();
    }

    default public FiniteDuration remainingOrDefault() {
        return this.remainingOr(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(this.testKitSettings().SingleExpectDefaultTimeout()), this.system()));
    }

    public static FiniteDuration remaining$(TestKitBase $this) {
        return $this.remaining();
    }

    default public FiniteDuration remaining() {
        Duration duration = this.org$apache$pekko$testkit$TestKitBase$$end();
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            return f.$minus(this.now());
        }
        throw new AssertionError((Object)"`remaining` may not be called outside of `within`");
    }

    public static FiniteDuration remainingOr$(TestKitBase $this, FiniteDuration duration) {
        return $this.remainingOr(duration);
    }

    default public FiniteDuration remainingOr(FiniteDuration duration) {
        Duration duration2 = this.org$apache$pekko$testkit$TestKitBase$$end();
        Duration x = duration2;
        if (x == Duration$.MODULE$.Undefined()) {
            return duration;
        }
        Duration x2 = duration2;
        if (!x2.isFinite()) {
            throw new IllegalArgumentException("`end` cannot be infinite");
        }
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration2;
            return f.$minus(this.now());
        }
        throw new IllegalArgumentException("`end` cannot be infinite");
    }

    private FiniteDuration remainingOrDilated(Duration max) {
        Duration duration = max;
        Duration x = duration;
        if (x == Duration$.MODULE$.Undefined()) {
            return this.remainingOrDefault();
        }
        Duration x2 = duration;
        if (!x2.isFinite()) {
            throw new IllegalArgumentException("max duration cannot be infinite");
        }
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            return package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(f), this.system());
        }
        throw new IllegalArgumentException("max duration cannot be infinite");
    }

    public static boolean msgAvailable$(TestKitBase $this) {
        return $this.msgAvailable();
    }

    default public boolean msgAvailable() {
        return !this.org$apache$pekko$testkit$TestKitBase$$queue().isEmpty();
    }

    public static void awaitCond$(TestKitBase $this, Function0 p, Duration max, Duration interval, String message) {
        $this.awaitCond((Function0<Object>)p, max, interval, message);
    }

    default public void awaitCond(Function0<Object> p, Duration max, Duration interval, String message) {
        FiniteDuration _max = this.remainingOrDilated(max);
        FiniteDuration stop = this.now().$plus(_max);
        this.poll$1(p, stop, _max, message, interval, _max.min(interval));
    }

    public static Duration awaitCond$default$2$(TestKitBase $this) {
        return $this.awaitCond$default$2();
    }

    default public Duration awaitCond$default$2() {
        return Duration$.MODULE$.Undefined();
    }

    public static Duration awaitCond$default$3$(TestKitBase $this) {
        return $this.awaitCond$default$3();
    }

    default public Duration awaitCond$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis();
    }

    public static String awaitCond$default$4$(TestKitBase $this) {
        return $this.awaitCond$default$4();
    }

    default public String awaitCond$default$4() {
        return "";
    }

    public static Object awaitAssert$(TestKitBase $this, Function0 a, Duration max, Duration interval) {
        return $this.awaitAssert(a, max, interval);
    }

    default public <A> A awaitAssert(Function0<A> a, Duration max, Duration interval) {
        FiniteDuration _max = this.remainingOrDilated(max);
        FiniteDuration stop = this.now().$plus(_max);
        return (A)this.poll$2(a, stop, interval, _max.min(interval));
    }

    public static Duration awaitAssert$default$2$(TestKitBase $this) {
        return $this.awaitAssert$default$2();
    }

    default public <A> Duration awaitAssert$default$2() {
        return Duration$.MODULE$.Undefined();
    }

    public static Duration awaitAssert$default$3$(TestKitBase $this) {
        return $this.awaitAssert$default$3();
    }

    default public <A> Duration awaitAssert$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis();
    }

    public static Object assertForDuration$(TestKitBase $this, Function0 a, FiniteDuration max, Duration interval) {
        return $this.assertForDuration(a, max, interval);
    }

    default public <A> A assertForDuration(Function0<A> a, FiniteDuration max, Duration interval) {
        FiniteDuration _max = this.remainingOrDilated((Duration)max);
        FiniteDuration stop = this.now().$plus(_max);
        return (A)this.poll$3(a, stop, interval, max.min(interval));
    }

    public static Duration assertForDuration$default$3$(TestKitBase $this) {
        return $this.assertForDuration$default$3();
    }

    default public <A> Duration assertForDuration$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis();
    }

    public static Object within$(TestKitBase $this, FiniteDuration min, FiniteDuration max, Function0 f) {
        return $this.within(min, max, f);
    }

    default public <T> T within(FiniteDuration min, FiniteDuration max, Function0<T> f) {
        Object object;
        Duration.Infinite rem;
        FiniteDuration _max = package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system());
        FiniteDuration start = this.now();
        Duration duration = this.org$apache$pekko$testkit$TestKitBase$$end();
        Duration.Infinite infinite = Duration$.MODULE$.Undefined();
        Duration.Infinite infinite2 = !(duration != null ? !duration.equals(infinite) : infinite != null) ? Duration$.MODULE$.Inf() : (rem = this.org$apache$pekko$testkit$TestKitBase$$end().$minus((Duration)start));
        if (!rem.$greater$eq((Object)min)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(43).append("required min time ").append(min).append(" not possible, only ").append(this.format(min.unit(), (Duration)rem)).append(" left").toString());
        }
        this.org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg_$eq(false);
        Duration max_diff = _max.min((Duration)rem);
        Duration prev_end = this.org$apache$pekko$testkit$TestKitBase$$end();
        this.org$apache$pekko$testkit$TestKitBase$$end_$eq(start.$plus(max_diff));
        try {
            object = f.apply();
        }
        finally {
            this.org$apache$pekko$testkit$TestKitBase$$end_$eq(prev_end);
        }
        Object ret = object;
        FiniteDuration diff = this.now().$minus(start);
        if (!min.$less$eq((Object)diff)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(39).append("block took ").append(this.format(min.unit(), (Duration)diff)).append(", should at least have been ").append(min).toString());
        }
        if (!this.org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg() && !diff.$less$eq((Object)max_diff)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(23).append("block took ").append(this.format(_max.unit(), (Duration)diff)).append(", exceeding ").append(this.format(_max.unit(), max_diff)).toString());
        }
        return (T)ret;
    }

    public static Object within$(TestKitBase $this, FiniteDuration max, Function0 f) {
        return $this.within(max, f);
    }

    default public <T> T within(FiniteDuration max, Function0<T> f) {
        return this.within(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), max, f);
    }

    public static Object expectMsg$(TestKitBase $this, Object obj) {
        return $this.expectMsg(obj);
    }

    default public <T> T expectMsg(T obj) {
        return this.expectMsg_internal((Duration)this.remainingOrDefault(), obj, this.expectMsg_internal$default$3());
    }

    public static Object expectMsg$(TestKitBase $this, FiniteDuration max, Object obj) {
        return $this.expectMsg(max, obj);
    }

    default public <T> T expectMsg(FiniteDuration max, T obj) {
        return this.expectMsg_internal((Duration)package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj, this.expectMsg_internal$default$3());
    }

    public static Object expectMsg$(TestKitBase $this, FiniteDuration max, String hint, Object obj) {
        return $this.expectMsg(max, hint, obj);
    }

    default public <T> T expectMsg(FiniteDuration max, String hint, T obj) {
        return this.expectMsg_internal((Duration)package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj, (Option<String>)Some$.MODULE$.apply((Object)hint));
    }

    private <T> T expectMsg_internal(Duration max, T obj, Option<String> hint) {
        Object o = this.receiveOne(max);
        String hintOrEmptyString = (String)hint.map((Function1 & Serializable)_$2 -> new StringBuilder(2).append(": ").append((String)_$2).toString()).getOrElse(TestKitBase::$anonfun$4);
        if (o == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(46).append("timeout (").append(max).append(") during expectMsg while waiting for ").append(obj).append(hintOrEmptyString).toString());
        }
        if (!BoxesRunTime.equals(obj, (Object)o)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(17).append("expected ").append(obj).append(", found ").append(o).append(hintOrEmptyString).toString());
        }
        return (T)o;
    }

    private <T> Option<String> expectMsg_internal$default$3() {
        return None$.MODULE$;
    }

    public static Object expectMsgPF$(TestKitBase $this, Duration max, String hint, PartialFunction f) {
        return $this.expectMsgPF(max, hint, f);
    }

    default public <T> T expectMsgPF(Duration max, String hint, PartialFunction<Object, T> f) {
        FiniteDuration _max = this.remainingOrDilated(max);
        Object o = this.receiveOne((Duration)_max);
        if (o == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(29).append("timeout (").append(_max).append(") during expectMsg: ").append(hint).toString());
        }
        if (!f.isDefinedAt(o)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(38).append("expected: ").append(hint).append(" but got unexpected message ").append(o).toString());
        }
        return (T)f.apply(o);
    }

    public static Duration expectMsgPF$default$1$(TestKitBase $this) {
        return $this.expectMsgPF$default$1();
    }

    default public <T> Duration expectMsgPF$default$1() {
        return Duration$.MODULE$.Undefined();
    }

    public static String expectMsgPF$default$2$(TestKitBase $this) {
        return $this.expectMsgPF$default$2();
    }

    default public <T> String expectMsgPF$default$2() {
        return "";
    }

    public static Terminated expectTerminated$(TestKitBase $this, ActorRef target, Duration max) {
        return $this.expectTerminated(target, max);
    }

    default public Terminated expectTerminated(ActorRef target, Duration max) {
        return (Terminated)this.expectMsgPF(max, new StringBuilder(11).append("Terminated ").append(target).toString(), (PartialFunction)new Serializable(target){
            private final ActorRef target$1;
            {
                this.target$1 = target$2;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = (Terminated)object;
                    Terminated terminated2 = Terminated$.MODULE$.unapply(terminated);
                    ActorRef actorRef = terminated2._1();
                    ActorRef actorRef2 = this.target$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                        Terminated t = terminated;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = (Terminated)object;
                    Terminated terminated2 = Terminated$.MODULE$.unapply(terminated);
                    ActorRef actorRef = terminated2._1();
                    ActorRef actorRef2 = this.target$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                        Terminated t = terminated;
                        return t;
                    }
                }
                return function1.apply(x);
            }
        });
    }

    public static Duration expectTerminated$default$2$(TestKitBase $this) {
        return $this.expectTerminated$default$2();
    }

    default public Duration expectTerminated$default$2() {
        return Duration$.MODULE$.Undefined();
    }

    public static Object fishForMessage$(TestKitBase $this, Duration max, String hint, PartialFunction f) {
        return $this.fishForMessage(max, hint, (PartialFunction<Object, Object>)f);
    }

    default public Object fishForMessage(Duration max, String hint, PartialFunction<Object, Object> f) {
        FiniteDuration _max = this.remainingOrDilated(max);
        FiniteDuration end = this.now().$plus(_max);
        return this.recv$4(end, _max, hint, f);
    }

    public static Duration fishForMessage$default$1$(TestKitBase $this) {
        return $this.fishForMessage$default$1();
    }

    default public Duration fishForMessage$default$1() {
        return Duration$.MODULE$.Undefined();
    }

    public static String fishForMessage$default$2$(TestKitBase $this) {
        return $this.fishForMessage$default$2();
    }

    default public String fishForMessage$default$2() {
        return "";
    }

    public static Object fishForSpecificMessage$(TestKitBase $this, Duration max, String hint, PartialFunction f) {
        return $this.fishForSpecificMessage(max, hint, f);
    }

    default public <T> T fishForSpecificMessage(Duration max, String hint, PartialFunction<Object, T> f) {
        FiniteDuration _max = this.remainingOrDilated(max);
        FiniteDuration end = this.now().$plus(_max);
        return (T)this.recv$5(end, _max, hint, f);
    }

    public static Duration fishForSpecificMessage$default$1$(TestKitBase $this) {
        return $this.fishForSpecificMessage$default$1();
    }

    default public <T> Duration fishForSpecificMessage$default$1() {
        return Duration$.MODULE$.Undefined();
    }

    public static String fishForSpecificMessage$default$2$(TestKitBase $this) {
        return $this.fishForSpecificMessage$default$2();
    }

    default public <T> String fishForSpecificMessage$default$2() {
        return "";
    }

    public static Object expectMsgType$(TestKitBase $this, ClassTag t) {
        return $this.expectMsgType(t);
    }

    default public <T> T expectMsgType(ClassTag<T> t) {
        return (T)this.expectMsgClass_internal(this.remainingOrDefault(), t.runtimeClass());
    }

    public static Object expectMsgType$(TestKitBase $this, FiniteDuration max, ClassTag t) {
        return $this.expectMsgType(max, t);
    }

    default public <T> T expectMsgType(FiniteDuration max, ClassTag<T> t) {
        return (T)this.expectMsgClass_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), t.runtimeClass());
    }

    public static Object expectMsgClass$(TestKitBase $this, Class c) {
        return $this.expectMsgClass(c);
    }

    default public <C> C expectMsgClass(Class<C> c) {
        return this.expectMsgClass_internal(this.remainingOrDefault(), c);
    }

    public static Object expectMsgClass$(TestKitBase $this, FiniteDuration max, Class c) {
        return $this.expectMsgClass(max, c);
    }

    default public <C> C expectMsgClass(FiniteDuration max, Class<C> c) {
        return this.expectMsgClass_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), c);
    }

    private <C> C expectMsgClass_internal(FiniteDuration max, Class<C> c) {
        Object o = this.receiveOne((Duration)max);
        if (o == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(45).append("timeout (").append(max).append(") during expectMsgClass waiting for ").append(c).toString());
        }
        if (!BoxedType$.MODULE$.apply(c).isInstance(o)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(20).append("expected ").append(c).append(", found ").append(o.getClass()).append(" (").append(o).append(")").toString());
        }
        return (C)o;
    }

    public static Object expectMsgAnyOf$(TestKitBase $this, Seq obj) {
        return $this.expectMsgAnyOf(obj);
    }

    default public <T> T expectMsgAnyOf(Seq<T> obj) {
        return this.expectMsgAnyOf_internal(this.remainingOrDefault(), obj);
    }

    public static Object expectMsgAnyOf$(TestKitBase $this, FiniteDuration max, Seq obj) {
        return $this.expectMsgAnyOf(max, obj);
    }

    default public <T> T expectMsgAnyOf(FiniteDuration max, Seq<T> obj) {
        return this.expectMsgAnyOf_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj);
    }

    private <T> T expectMsgAnyOf_internal(FiniteDuration max, Seq<T> obj) {
        Object o = this.receiveOne((Duration)max);
        if (o == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(45).append("timeout (").append(max).append(") during expectMsgAnyOf waiting for ").append(obj.mkString("(", ", ", ")")).toString());
        }
        if (!obj.exists((Function1 & Serializable)_$3 -> BoxesRunTime.equals((Object)_$3, (Object)o))) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(17).append("found unexpected ").append(o).toString());
        }
        return (T)o;
    }

    public static Object expectMsgAnyClassOf$(TestKitBase $this, Seq obj) {
        return $this.expectMsgAnyClassOf(obj);
    }

    default public <C> C expectMsgAnyClassOf(Seq<Class<? extends C>> obj) {
        return this.expectMsgAnyClassOf_internal(this.remainingOrDefault(), obj);
    }

    public static Object expectMsgAnyClassOf$(TestKitBase $this, FiniteDuration max, Seq obj) {
        return $this.expectMsgAnyClassOf(max, obj);
    }

    default public <C> C expectMsgAnyClassOf(FiniteDuration max, Seq<Class<? extends C>> obj) {
        return this.expectMsgAnyClassOf_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj);
    }

    private <C> C expectMsgAnyClassOf_internal(FiniteDuration max, Seq<Class<? extends C>> obj) {
        Object o = this.receiveOne((Duration)max);
        if (o == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(50).append("timeout (").append(max).append(") during expectMsgAnyClassOf waiting for ").append(obj.mkString("(", ", ", ")")).toString());
        }
        if (!obj.exists((Function1 & Serializable)c -> BoxedType$.MODULE$.apply(c).isInstance(o))) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(17).append("found unexpected ").append(o).toString());
        }
        return (C)o;
    }

    public static Seq expectMsgAllOf$(TestKitBase $this, Seq obj) {
        return $this.expectMsgAllOf(obj);
    }

    default public <T> Seq<T> expectMsgAllOf(Seq<T> obj) {
        return this.expectMsgAllOf_internal(this.remainingOrDefault(), obj);
    }

    public static Seq expectMsgAllOf$(TestKitBase $this, FiniteDuration max, Seq obj) {
        return $this.expectMsgAllOf(max, obj);
    }

    default public <T> Seq<T> expectMsgAllOf(FiniteDuration max, Seq<T> obj) {
        return this.expectMsgAllOf_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj);
    }

    private void checkMissingAndUnexpected(Seq<Object> missing, Seq<Object> unexpected, String missingMessage, String unexpectedMessage) {
        if (!missing.isEmpty() || !unexpected.isEmpty()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(0).append(missing.isEmpty() ? "" : missing.mkString(new StringBuilder(2).append(missingMessage).append(" [").toString(), ", ", "] ")).append(unexpected.isEmpty() ? "" : unexpected.mkString(new StringBuilder(2).append(unexpectedMessage).append(" [").toString(), ", ", "]")).toString());
        }
    }

    private <T> Seq<T> expectMsgAllOf_internal(FiniteDuration max, Seq<T> obj) {
        Seq<Object> recv = this.receiveN_internal(obj.size(), (Duration)max);
        Seq missing = (Seq)obj.filterNot((Function1 & Serializable)x -> recv.exists((Function1 & Serializable)_$4 -> BoxesRunTime.equals((Object)x, (Object)_$4)));
        Seq unexpected = (Seq)recv.filterNot((Function1 & Serializable)x -> obj.exists((Function1 & Serializable)_$5 -> BoxesRunTime.equals((Object)x, (Object)_$5)));
        this.checkMissingAndUnexpected((Seq<Object>)missing, (Seq<Object>)unexpected, "not found", "found unexpected");
        return recv;
    }

    public static Seq expectMsgAllClassOf$(TestKitBase $this, Seq obj) {
        return $this.expectMsgAllClassOf(obj);
    }

    default public <T> Seq<T> expectMsgAllClassOf(Seq<Class<? extends T>> obj) {
        return this.internalExpectMsgAllClassOf(this.remainingOrDefault(), obj);
    }

    public static Seq expectMsgAllClassOf$(TestKitBase $this, FiniteDuration max, Seq obj) {
        return $this.expectMsgAllClassOf(max, obj);
    }

    default public <T> Seq<T> expectMsgAllClassOf(FiniteDuration max, Seq<Class<? extends T>> obj) {
        return this.internalExpectMsgAllClassOf(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj);
    }

    private <T> Seq<T> internalExpectMsgAllClassOf(FiniteDuration max, Seq<Class<? extends T>> obj) {
        Seq<Object> recv = this.receiveN_internal(obj.size(), (Duration)max);
        Seq missing = (Seq)obj.filterNot((Function1 & Serializable)x -> recv.exists((Function1 & Serializable)_$6 -> _$6.getClass() == BoxedType$.MODULE$.apply(x)));
        Seq unexpected = (Seq)recv.filterNot((Function1 & Serializable)x -> obj.exists((Function1 & Serializable)c -> BoxedType$.MODULE$.apply(c) == x.getClass()));
        this.checkMissingAndUnexpected((Seq<Object>)missing, (Seq<Object>)unexpected, "not found", "found non-matching object(s)");
        return recv;
    }

    public static Seq expectMsgAllConformingOf$(TestKitBase $this, Seq obj) {
        return $this.expectMsgAllConformingOf(obj);
    }

    default public <T> Seq<T> expectMsgAllConformingOf(Seq<Class<? extends T>> obj) {
        return this.internalExpectMsgAllConformingOf(this.remainingOrDefault(), obj);
    }

    public static Seq expectMsgAllConformingOf$(TestKitBase $this, FiniteDuration max, Seq obj) {
        return $this.expectMsgAllConformingOf(max, obj);
    }

    default public <T> Seq<T> expectMsgAllConformingOf(FiniteDuration max, Seq<Class<? extends T>> obj) {
        return this.internalExpectMsgAllConformingOf(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()), obj);
    }

    private <T> Seq<T> internalExpectMsgAllConformingOf(FiniteDuration max, Seq<Class<? extends T>> obj) {
        Seq<Object> recv = this.receiveN_internal(obj.size(), (Duration)max);
        Seq missing = (Seq)obj.filterNot((Function1 & Serializable)x -> recv.exists((Function1 & Serializable)_$7 -> BoxedType$.MODULE$.apply(x).isInstance(_$7)));
        Seq unexpected = (Seq)recv.filterNot((Function1 & Serializable)x -> obj.exists((Function1 & Serializable)c -> BoxedType$.MODULE$.apply(c).isInstance(x)));
        this.checkMissingAndUnexpected((Seq<Object>)missing, (Seq<Object>)unexpected, "not found", "found non-matching object(s)");
        return recv;
    }

    public static void expectNoMsg$(TestKitBase $this) {
        $this.expectNoMsg();
    }

    default public void expectNoMsg() {
        this.expectNoMessage();
    }

    public static void expectNoMsg$(TestKitBase $this, FiniteDuration max) {
        $this.expectNoMsg(max);
    }

    default public void expectNoMsg(FiniteDuration max) {
        this.expectNoMsg_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()));
    }

    public static void expectNoMessage$(TestKitBase $this, FiniteDuration max) {
        $this.expectNoMessage(max);
    }

    default public void expectNoMessage(FiniteDuration max) {
        this.expectNoMsg_internal(max);
    }

    public static void expectNoMessage$(TestKitBase $this) {
        $this.expectNoMessage();
    }

    default public void expectNoMessage() {
        this.expectNoMsg_internal(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(this.testKitSettings().ExpectNoMessageDefaultTimeout()), this.system()));
    }

    private void expectNoMsg_internal(FiniteDuration max) {
        long finish = System.nanoTime() + max.toNanos();
        FiniteDuration pollInterval = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis();
        TestActor.Message elem = this.org$apache$pekko$testkit$TestKitBase$$queue().peekFirst();
        FiniteDuration left = TestKitBase.leftNow$1(finish);
        while (left.toNanos() > 0L && elem == null) {
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollInterval.toMillis()), left.$div(2L).toMillis()));
            left = TestKitBase.leftNow$1(finish);
            if (left.toNanos() <= 0L) continue;
            elem = this.org$apache$pekko$testkit$TestKitBase$$queue().peekFirst();
        }
        if (elem != null) {
            this.org$apache$pekko$testkit$TestKitBase$$queue().pop();
            FiniteDuration diff = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(max.toNanos() - left.toNanos())).nanos();
            String m = new StringBuilder(60).append("assertion failed: received unexpected message ").append(elem).append(" after ").append(diff.toMillis()).append(" millis").toString();
            throw new AssertionError((Object)m);
        }
        this.org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg_$eq(true);
    }

    public static Seq receiveWhile$(TestKitBase $this, Duration max, Duration idle, int messages, PartialFunction f) {
        return $this.receiveWhile(max, idle, messages, f);
    }

    default public <T> Seq<T> receiveWhile(Duration max, Duration idle, int messages, PartialFunction<Object, T> f) {
        FiniteDuration stop = this.now().$plus(this.remainingOrDilated(max));
        ObjectRef msg = ObjectRef.create((Object)TestActor$NullMessage$.MODULE$);
        List ret = this.doit$1(messages, stop, idle, msg, f, (List)scala.package$.MODULE$.Nil(), 0);
        this.org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg_$eq(true);
        return ret;
    }

    public static Duration receiveWhile$default$1$(TestKitBase $this) {
        return $this.receiveWhile$default$1();
    }

    default public <T> Duration receiveWhile$default$1() {
        return Duration$.MODULE$.Undefined();
    }

    public static Duration receiveWhile$default$2$(TestKitBase $this) {
        return $this.receiveWhile$default$2();
    }

    default public <T> Duration receiveWhile$default$2() {
        return Duration$.MODULE$.Inf();
    }

    public static int receiveWhile$default$3$(TestKitBase $this) {
        return $this.receiveWhile$default$3();
    }

    default public int receiveWhile$default$3() {
        return Integer.MAX_VALUE;
    }

    public static Seq receiveN$(TestKitBase $this, int n) {
        return $this.receiveN(n);
    }

    default public Seq<Object> receiveN(int n) {
        return this.receiveN_internal(n, (Duration)this.remainingOrDefault());
    }

    public static Seq receiveN$(TestKitBase $this, int n, FiniteDuration max) {
        return $this.receiveN(n, max);
    }

    default public Seq<Object> receiveN(int n, FiniteDuration max) {
        return this.receiveN_internal(n, (Duration)package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()));
    }

    private Seq<Object> receiveN_internal(int n, Duration max) {
        Duration stop = max.$plus((Duration)this.now());
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), n).map((Function1 & Serializable)x -> this.receiveN_internal$$anonfun$1(stop, max, n, BoxesRunTime.unboxToInt((Object)x)));
    }

    public static Object receiveOne$(TestKitBase $this, Duration max) {
        return $this.receiveOne(max);
    }

    default public Object receiveOne(Duration max) {
        Duration duration = max;
        FiniteDuration finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds();
        TestActor.Message message = !(duration != null ? !duration.equals(finiteDuration) : finiteDuration != null) ? this.org$apache$pekko$testkit$TestKitBase$$queue().pollFirst() : (max.isFinite() ? this.org$apache$pekko$testkit$TestKitBase$$queue().pollFirst(max.length(), max.unit()) : this.org$apache$pekko$testkit$TestKitBase$$queue().takeFirst());
        this.org$apache$pekko$testkit$TestKitBase$$lastWasNoMsg_$eq(false);
        TestActor.Message message2 = message;
        if (message2 == null) {
            this.lastMessage_$eq(TestActor$NullMessage$.MODULE$);
            return null;
        }
        if (message2 instanceof TestActor.RealMessage) {
            TestActor.RealMessage realMessage = TestActor$RealMessage$.MODULE$.unapply((TestActor.RealMessage)message2);
            Object object = realMessage._1();
            ActorRef actorRef = realMessage._2();
            Object msg = object;
            this.lastMessage_$eq(message);
            return msg;
        }
        TestActor.Message unexpected = message2;
        throw new RuntimeException(new StringBuilder(12).append("Unexpected: ").append(unexpected).toString());
    }

    public static void shutdown$(TestKitBase $this, ActorSystem actorSystem, Duration duration, boolean verifySystemShutdown) {
        $this.shutdown(actorSystem, duration, verifySystemShutdown);
    }

    default public void shutdown(ActorSystem actorSystem, Duration duration, boolean verifySystemShutdown) {
        TestKit$.MODULE$.shutdownActorSystem(actorSystem, duration, verifySystemShutdown);
    }

    public static ActorSystem shutdown$default$1$(TestKitBase $this) {
        return $this.shutdown$default$1();
    }

    default public ActorSystem shutdown$default$1() {
        return this.system();
    }

    public static Duration shutdown$default$2$(TestKitBase $this) {
        return $this.shutdown$default$2();
    }

    default public Duration shutdown$default$2() {
        return Duration$.MODULE$.Undefined();
    }

    public static boolean shutdown$default$3$(TestKitBase $this) {
        return $this.shutdown$default$3();
    }

    default public boolean shutdown$default$3() {
        return false;
    }

    public static ActorRef childActorOf$(TestKitBase $this, Props props, String name, SupervisorStrategy supervisorStrategy) {
        return $this.childActorOf(props, name, supervisorStrategy);
    }

    default public ActorRef childActorOf(Props props, String name, SupervisorStrategy supervisorStrategy) {
        TestActor.Spawn spawn = TestActor$Spawn$.MODULE$.apply(props, (Option<String>)Some$.MODULE$.apply((Object)name), (Option<SupervisorStrategy>)Some$.MODULE$.apply((Object)supervisorStrategy));
        this.testActor().$bang((Object)spawn, this.testActor().$bang$default$2((Object)spawn));
        return (ActorRef)this.expectMsgType(ClassTag$.MODULE$.apply(ActorRef.class));
    }

    public static ActorRef childActorOf$(TestKitBase $this, Props props, SupervisorStrategy supervisorStrategy) {
        return $this.childActorOf(props, supervisorStrategy);
    }

    default public ActorRef childActorOf(Props props, SupervisorStrategy supervisorStrategy) {
        TestActor.Spawn spawn = TestActor$Spawn$.MODULE$.apply(props, (Option<String>)None$.MODULE$, (Option<SupervisorStrategy>)Some$.MODULE$.apply((Object)supervisorStrategy));
        this.testActor().$bang((Object)spawn, this.testActor().$bang$default$2((Object)spawn));
        return (ActorRef)this.expectMsgType(ClassTag$.MODULE$.apply(ActorRef.class));
    }

    public static ActorRef childActorOf$(TestKitBase $this, Props props, String name) {
        return $this.childActorOf(props, name);
    }

    default public ActorRef childActorOf(Props props, String name) {
        TestActor.Spawn spawn = TestActor$Spawn$.MODULE$.apply(props, (Option<String>)Some$.MODULE$.apply((Object)name), (Option<SupervisorStrategy>)None$.MODULE$);
        this.testActor().$bang((Object)spawn, this.testActor().$bang$default$2((Object)spawn));
        return (ActorRef)this.expectMsgType(ClassTag$.MODULE$.apply(ActorRef.class));
    }

    public static ActorRef childActorOf$(TestKitBase $this, Props props) {
        return $this.childActorOf(props);
    }

    default public ActorRef childActorOf(Props props) {
        TestActor.Spawn spawn = TestActor$Spawn$.MODULE$.apply(props, (Option<String>)None$.MODULE$, (Option<SupervisorStrategy>)None$.MODULE$);
        this.testActor().$bang((Object)spawn, this.testActor().$bang$default$2((Object)spawn));
        return (ActorRef)this.expectMsgType(ClassTag$.MODULE$.apply(ActorRef.class));
    }

    private String format(TimeUnit u, Duration d) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.3f %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d.toUnit(u)), u.toString().toLowerCase()}));
    }

    private static boolean testActor$$anonfun$1(ActorRef ref$1) {
        ActorRef actorRef = ref$1;
        if (actorRef instanceof RepointableRef) {
            ActorRef r = (ActorRef)((RepointableRef)actorRef);
            return ((RepointableRef)r).isStarted();
        }
        return true;
    }

    private void poll$1(Function0 p$1, FiniteDuration stop$1, FiniteDuration _max$1, String message$10, Duration interval$1, Duration t) {
        while (!p$1.apply$mcZ$sp()) {
            if (!this.now().$less((Object)stop$1)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(18).append("timeout ").append(_max$1).append(" expired: ").append(message$10).toString());
            }
            Thread.sleep(t.toMillis());
            t = stop$1.$minus(this.now()).min(interval$1);
        }
    }

    private Object poll$2(Function0 a$1, FiniteDuration stop$2, Duration interval$2, Duration t) {
        while (true) {
            Object object;
            boolean failed = false;
            try {
                Object aRes = a$1.apply();
                failed = false;
                object = aRes;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    failed = true;
                    if (this.now().$plus(t).$greater$eq((Object)stop$2)) {
                        throw e;
                    }
                    object = null;
                }
                throw throwable;
            }
            Object result = object;
            if (!failed) {
                return result;
            }
            Thread.sleep(t.toMillis());
            t = stop$2.$minus(this.now()).min(interval$2);
        }
    }

    private Object poll$3(Function0 a$2, FiniteDuration stop$3, Duration interval$3, Duration t) {
        Object result;
        while (true) {
            FiniteDuration instantNow = this.now();
            Object object = a$2.apply();
            result = object;
            if (!instantNow.$less((Object)stop$3)) break;
            Thread.sleep(t.toMillis());
            t = stop$3.$minus(this.now()).min(interval$3);
        }
        return result;
    }

    private static String $anonfun$4() {
        return "";
    }

    private Object recv$4(FiniteDuration end$1, FiniteDuration _max$2, String hint$1, PartialFunction f$1) {
        Object o;
        do {
            if ((o = this.receiveOne((Duration)end$1.$minus(this.now()))) == null) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(40).append("timeout (").append(_max$2).append(") during fishForMessage, hint: ").append(hint$1).toString());
            }
            if (f$1.isDefinedAt(o)) continue;
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(42).append("fishForMessage(").append(hint$1).append(") found unexpected message ").append(o).toString());
        } while (!BoxesRunTime.unboxToBoolean((Object)f$1.apply(o)));
        return o;
    }

    private Object recv$5(FiniteDuration end$2, FiniteDuration _max$3, String hint$2, PartialFunction f$2) {
        Object o;
        do {
            if ((o = this.receiveOne((Duration)end$2.$minus(this.now()))) != null) continue;
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(48).append("timeout (").append(_max$3).append(") during fishForSpecificMessage, hint: ").append(hint$2).toString());
        } while (!f$2.isDefinedAt(o));
        return f$2.apply(o);
    }

    private static FiniteDuration leftNow$1(long finish$1) {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(finish$1 - System.nanoTime())).nanos();
    }

    private List doit$1(int messages$1, FiniteDuration stop$4, Duration idle$1, ObjectRef msg$1, PartialFunction f$3, List acc, int count) {
        TestActor.Message message;
        block3: {
            while (true) {
                if (count >= messages$1) {
                    return acc.reverse();
                }
                this.receiveOne(stop$4.$minus(this.now()).min(idle$1));
                message = this.lastMessage();
                if (TestActor$NullMessage$.MODULE$.equals(message)) {
                    this.lastMessage_$eq((TestActor.Message)msg$1.elem);
                    return acc.reverse();
                }
                if (!(message instanceof TestActor.RealMessage)) break block3;
                TestActor.RealMessage realMessage = TestActor$RealMessage$.MODULE$.unapply((TestActor.RealMessage)message);
                Object object = realMessage._1();
                ActorRef actorRef = realMessage._2();
                Object o = object;
                if (!f$3.isDefinedAt(o)) break;
                TestActor.Message message2 = this.lastMessage();
                msg$1.elem = message2;
                message2 = null;
                Object object2 = f$3.apply(o);
                List list = acc.$colon$colon(object2);
                int n = count + 1;
                acc = list;
                count = n;
            }
            this.org$apache$pekko$testkit$TestKitBase$$queue().offerFirst(this.lastMessage());
            this.lastMessage_$eq((TestActor.Message)msg$1.elem);
            return acc.reverse();
        }
        TestActor.Message unexpected = message;
        throw new RuntimeException(new StringBuilder(12).append("Unexpected: ").append(unexpected).toString());
    }

    private /* synthetic */ Object receiveN_internal$$anonfun$1(Duration stop$5, Duration max$1, int n$1, int x) {
        Duration timeout = stop$5.$minus((Duration)this.now());
        Object o = this.receiveOne(timeout);
        if (o == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(43).append("timeout (").append(max$1).append(") while expecting ").append(n$1).append(" messages (got ").append(x - 1).append(")").toString());
        }
        return o;
    }
}

