/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.testkit.TestKitExtension$;
import org.apache.pekko.testkit.TestKitSettings;
import org.apache.pekko.testkit.TestLatch$;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.testkit.package$TestDuration$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Awaitable;
import scala.concurrent.CanAwait;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TestLatch
implements Awaitable<BoxedUnit> {
    private final int count;
    private final ActorSystem system;
    private CountDownLatch latch;

    public static FiniteDuration DefaultTimeout() {
        return TestLatch$.MODULE$.DefaultTimeout();
    }

    public static TestLatch apply(int n, ActorSystem actorSystem) {
        return TestLatch$.MODULE$.apply(n, actorSystem);
    }

    public static int $lessinit$greater$default$1() {
        return TestLatch$.MODULE$.$lessinit$greater$default$1();
    }

    public static int apply$default$1() {
        return TestLatch$.MODULE$.apply$default$1();
    }

    public TestLatch(int count, ActorSystem system) {
        this.count = count;
        this.system = system;
        this.latch = new CountDownLatch(count);
    }

    public void countDown() {
        this.latch.countDown();
    }

    public boolean isOpen() {
        return this.latch.getCount() == 0L;
    }

    public void open() {
        while (!this.isOpen()) {
            this.countDown();
        }
    }

    public void reset() {
        this.latch = new CountDownLatch(this.count);
    }

    public TestLatch ready(Duration atMost, CanAwait permit) throws TimeoutException {
        Duration duration = atMost;
        if (!(duration instanceof FiniteDuration)) {
            throw new IllegalArgumentException(new StringBuilder(39).append("TestLatch does not support waiting for ").append(atMost).toString());
        }
        FiniteDuration f = (FiniteDuration)duration;
        FiniteDuration waitTime = f;
        boolean opened = this.latch.await(package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(waitTime), this.system).toNanos(), TimeUnit.NANOSECONDS);
        if (!opened) {
            throw new TimeoutException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Timeout of %s with time factor of %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{atMost.toString(), BoxesRunTime.boxToDouble((double)((TestKitSettings)TestKitExtension$.MODULE$.apply(this.system)).TestTimeFactor())})));
        }
        return this;
    }

    public void result(Duration atMost, CanAwait permit) throws Exception {
        this.ready(atMost, permit);
    }
}

