/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.MessageQueue;
import org.apache.pekko.testkit.CallingThreadDispatcherQueues$;
import org.apache.pekko.testkit.CallingThreadMailbox;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CallingThreadDispatcherQueues
implements Extension {
    private Map<CallingThreadMailbox, Set<WeakReference<MessageQueue>>> queues = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    private long lastGC = 0L;

    public static Extension apply(ActorSystem actorSystem) {
        return CallingThreadDispatcherQueues$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return CallingThreadDispatcherQueues$.MODULE$.apply(classicActorSystemProvider);
    }

    public static CallingThreadDispatcherQueues createExtension(ExtendedActorSystem extendedActorSystem) {
        return CallingThreadDispatcherQueues$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return CallingThreadDispatcherQueues$.MODULE$.get(actorSystem);
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return CallingThreadDispatcherQueues$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return CallingThreadDispatcherQueues$.MODULE$.lookup();
    }

    private void gc() {
        this.queues = (Map)((Builder)this.queues.foldLeft((Object)Predef$.MODULE$.Map().newBuilder(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Builder m = (Builder)tuple2._1();
                if (tuple22 != null) {
                    CallingThreadMailbox k = (CallingThreadMailbox)((Object)((Object)tuple22._1()));
                    Set v = (Set)tuple22._2();
                    Set nv = (Set)v.filter((Function1 & Serializable)_$1 -> _$1.get() != null);
                    if (nv.isEmpty()) {
                        return m;
                    }
                    CallingThreadMailbox callingThreadMailbox = (CallingThreadMailbox)((Object)((Object)Predef$.MODULE$.ArrowAssoc((Object)k)));
                    return (Builder)m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)callingThreadMailbox, (Object)nv));
                }
            }
            throw new MatchError((Object)tuple2);
        })).result();
    }

    public void registerQueue(CallingThreadMailbox mbox, MessageQueue q) {
        CallingThreadDispatcherQueues callingThreadDispatcherQueues = this;
        synchronized (callingThreadDispatcherQueues) {
            BoxedUnit boxedUnit;
            if (this.queues.contains((Object)mbox)) {
                Set newSet = (Set)((SetOps)this.queues.apply((Object)mbox)).$plus(new WeakReference<MessageQueue>(q));
                CallingThreadMailbox callingThreadMailbox = (CallingThreadMailbox)((Object)Predef$.MODULE$.ArrowAssoc((Object)mbox));
                this.queues = (Map)this.queues.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)callingThreadMailbox, (Object)newSet));
            } else {
                CallingThreadMailbox callingThreadMailbox = (CallingThreadMailbox)((Object)Predef$.MODULE$.ArrowAssoc((Object)mbox));
                this.queues = (Map)this.queues.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)callingThreadMailbox, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WeakReference[]{new WeakReference<MessageQueue>(q)}))));
            }
            long now = System.nanoTime();
            if (now - this.lastGC > 1000000000L) {
                this.lastGC = now;
                this.gc();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void unregisterQueues(CallingThreadMailbox mbox) {
        CallingThreadDispatcherQueues callingThreadDispatcherQueues = this;
        synchronized (callingThreadDispatcherQueues) {
            this.queues = (Map)this.queues.$minus((Object)mbox);
        }
    }

    public void gatherFromAllOtherQueues(CallingThreadMailbox mbox, MessageQueue own) {
        CallingThreadDispatcherQueues callingThreadDispatcherQueues = this;
        synchronized (callingThreadDispatcherQueues) {
            BoxedUnit boxedUnit;
            if (this.queues.contains((Object)mbox)) {
                ((IterableOps)((IterableOps)this.queues.apply((Object)mbox)).map((Function1 & Serializable)ref -> {
                    MessageQueue q = (MessageQueue)ref.get();
                    return Tuple2$.MODULE$.apply(ref, (Object)q);
                })).withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        WeakReference ref = (WeakReference)tuple2._1();
                        MessageQueue q = (MessageQueue)tuple2._2();
                        return q != null && q != own;
                    }
                    throw new MatchError((Object)tuple2);
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        WeakReference ref = (WeakReference)tuple2._1();
                        MessageQueue q = (MessageQueue)tuple2._2();
                        InternalActorRef owner = mbox.actor().self();
                        Envelope msg = q.dequeue();
                        while (msg != null) {
                            own.enqueue((ActorRef)owner, msg);
                            msg = q.dequeue();
                        }
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }
}

