/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.Logging;
import org.apache.pekko.testkit.EventFilter$;
import org.apache.pekko.testkit.TestEvent$Mute$;
import org.apache.pekko.testkit.TestEvent$UnMute$;
import org.apache.pekko.testkit.TestKit$;
import org.apache.pekko.testkit.TestKitExtension$;
import org.apache.pekko.testkit.TestKitSettings;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.testkit.package$TestDuration$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public abstract class EventFilter {
    private volatile int todo;
    private final Option source;
    private final Either message;
    private final boolean complete;

    public static EventFilter custom(PartialFunction<Logging.LogEvent, Object> partialFunction, int n) {
        return EventFilter$.MODULE$.custom(partialFunction, n);
    }

    public static EventFilter debug(String string, String string2, String string3, String string4, int n) {
        return EventFilter$.MODULE$.debug(string, string2, string3, string4, n);
    }

    public static EventFilter error(String string, String string2, String string3, String string4, int n) {
        return EventFilter$.MODULE$.error(string, string2, string3, string4, n);
    }

    public static EventFilter info(String string, String string2, String string3, String string4, int n) {
        return EventFilter$.MODULE$.info(string, string2, string3, string4, n);
    }

    public static EventFilter warning(String string, String string2, String string3, String string4, int n) {
        return EventFilter$.MODULE$.warning(string, string2, string3, string4, n);
    }

    public static <A extends Throwable> String apply$default$1() {
        return EventFilter$.MODULE$.apply$default$1();
    }

    public static String debug$default$1() {
        return EventFilter$.MODULE$.debug$default$1();
    }

    public static String error$default$1() {
        return EventFilter$.MODULE$.error$default$1();
    }

    public static String info$default$1() {
        return EventFilter$.MODULE$.info$default$1();
    }

    public static String warning$default$1() {
        return EventFilter$.MODULE$.warning$default$1();
    }

    public static <A extends Throwable> String apply$default$2() {
        return EventFilter$.MODULE$.apply$default$2();
    }

    public static int custom$default$2() {
        return EventFilter$.MODULE$.custom$default$2();
    }

    public static String debug$default$2() {
        return EventFilter$.MODULE$.debug$default$2();
    }

    public static String error$default$2() {
        return EventFilter$.MODULE$.error$default$2();
    }

    public static String info$default$2() {
        return EventFilter$.MODULE$.info$default$2();
    }

    public static String warning$default$2() {
        return EventFilter$.MODULE$.warning$default$2();
    }

    public static <A extends Throwable> String apply$default$3() {
        return EventFilter$.MODULE$.apply$default$3();
    }

    public static String debug$default$3() {
        return EventFilter$.MODULE$.debug$default$3();
    }

    public static String error$default$3() {
        return EventFilter$.MODULE$.error$default$3();
    }

    public static String info$default$3() {
        return EventFilter$.MODULE$.info$default$3();
    }

    public static String warning$default$3() {
        return EventFilter$.MODULE$.warning$default$3();
    }

    public static <A extends Throwable> String apply$default$4() {
        return EventFilter$.MODULE$.apply$default$4();
    }

    public static String debug$default$4() {
        return EventFilter$.MODULE$.debug$default$4();
    }

    public static String error$default$4() {
        return EventFilter$.MODULE$.error$default$4();
    }

    public static String info$default$4() {
        return EventFilter$.MODULE$.info$default$4();
    }

    public static String warning$default$4() {
        return EventFilter$.MODULE$.warning$default$4();
    }

    public static <A extends Throwable> int apply$default$5() {
        return EventFilter$.MODULE$.apply$default$5();
    }

    public static int debug$default$5() {
        return EventFilter$.MODULE$.debug$default$5();
    }

    public static int error$default$5() {
        return EventFilter$.MODULE$.error$default$5();
    }

    public static int info$default$5() {
        return EventFilter$.MODULE$.info$default$5();
    }

    public static int warning$default$5() {
        return EventFilter$.MODULE$.warning$default$5();
    }

    public EventFilter(int occurrences) {
        this.todo = occurrences;
        this.source = None$.MODULE$;
        this.message = scala.package$.MODULE$.Left().apply((Object)"");
        this.complete = false;
    }

    public abstract boolean matches(Logging.LogEvent var1);

    public final boolean apply(Logging.LogEvent event) {
        if (this.matches(event)) {
            if (this.todo != Integer.MAX_VALUE) {
                --this.todo;
            }
            return true;
        }
        return false;
    }

    public boolean awaitDone(Duration max) {
        if (this.todo != Integer.MAX_VALUE && this.todo > 0) {
            Duration duration = TestKit$.MODULE$.awaitCond$default$3();
            TestKit$.MODULE$.awaitCond((Function0<Object>)((Function0 & Serializable)this::awaitDone$$anonfun$1), max, duration, true);
        }
        return this.todo == Integer.MAX_VALUE || this.todo == 0;
    }

    public void assertDone(Duration max) {
        if (!this.awaitDone(max)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this.todo > 0 ? new StringBuilder(25).append(this.todo).append(" messages outstanding on ").append(this).toString() : new StringBuilder(29).append("received ").append(-this.todo).append(" excess messages on ").append(this).toString()));
        }
    }

    public <T> T intercept(Function0<T> code, ActorSystem system) {
        Object object;
        system.eventStream().publish((Object)TestEvent$Mute$.MODULE$.apply(this, (Seq<EventFilter>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventFilter[0])));
        FiniteDuration leeway = package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(((TestKitSettings)TestKitExtension$.MODULE$.apply(system)).TestEventFilterLeeway()), system);
        try {
            Object result = code.apply();
            if (!this.awaitDone((Duration)leeway)) {
                if (this.todo > 0) {
                    throw new AssertionError((Object)new StringBuilder(36).append("timeout (").append(leeway).append(") waiting for ").append(this.todo).append(" messages on ").append(this).toString());
                }
                throw new AssertionError((Object)new StringBuilder(29).append("received ").append(-this.todo).append(" excess messages on ").append(this).toString());
            }
            object = result;
        }
        finally {
            system.eventStream().publish((Object)TestEvent$UnMute$.MODULE$.apply(this, (Seq<EventFilter>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventFilter[0])));
        }
        return (T)object;
    }

    public Option<String> source() {
        return this.source;
    }

    public Either<String, Regex> message() {
        return this.message;
    }

    public boolean complete() {
        return this.complete;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doMatch(String src, Object msg) {
        boolean bl;
        Either<String, Regex> either;
        String msgstr;
        block8: {
            block7: {
                String string = msgstr = msg != null ? msg.toString() : "null";
                if (!this.source().isDefined()) break block7;
                Object object = this.source().get();
                String string2 = src;
                if (!(object == null ? string2 != null : !object.equals(string2))) break block8;
            }
            if (!this.source().isEmpty()) return false;
        }
        if ((either = this.message()) instanceof Left) {
            String s = (String)((Left)either).value();
            if (this.complete()) {
                String string = msgstr;
                String string3 = s;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            bl = msgstr.startsWith(s);
        } else {
            if (!(either instanceof Right)) throw new MatchError(either);
            Regex p = (Regex)((Right)either).value();
            bl = p.findFirstIn((CharSequence)msgstr).isDefined();
        }
        if (!bl) return false;
        return true;
    }

    private final boolean p$1$1() {
        return this.todo <= 0;
    }

    private final boolean awaitDone$$anonfun$1() {
        return this.p$1$1();
    }
}

