/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit.javadsl;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.testkit.TestActor;
import org.apache.pekko.testkit.TestProbe;
import org.apache.pekko.testkit.javadsl.CachingPartialFunction;
import org.apache.pekko.testkit.javadsl.TestKit$;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.testkit.package$TestDuration$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.PartialFunction;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TestKit {
    private final TestProbe tp;

    public static void shutdownActorSystem(ActorSystem actorSystem) {
        TestKit$.MODULE$.shutdownActorSystem(actorSystem);
    }

    public static void shutdownActorSystem(ActorSystem actorSystem, boolean bl) {
        TestKit$.MODULE$.shutdownActorSystem(actorSystem, bl);
    }

    public static void shutdownActorSystem(ActorSystem actorSystem, Duration duration) {
        TestKit$.MODULE$.shutdownActorSystem(actorSystem, duration);
    }

    public static void shutdownActorSystem(ActorSystem actorSystem, Duration duration, boolean bl) {
        TestKit$.MODULE$.shutdownActorSystem(actorSystem, duration, bl);
    }

    public TestKit(ActorSystem system) {
        this.tp = new TestProbe(system);
    }

    public ActorRef getTestActor() {
        return this.tp.testActor();
    }

    public ActorRef getRef() {
        return this.getTestActor();
    }

    public ActorSystem getSystem() {
        return this.tp.system();
    }

    public FiniteDuration duration(String s) {
        Duration duration = Duration$.MODULE$.apply(s);
        if (duration instanceof FiniteDuration) {
            FiniteDuration fd = (FiniteDuration)duration;
            return fd;
        }
        throw new IllegalArgumentException("duration() is only for finite durations, use Duration.Inf() and friends");
    }

    public FiniteDuration dilated(FiniteDuration d) {
        return package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(d), this.getSystem());
    }

    public java.time.Duration dilated(java.time.Duration duration) {
        return JavaDurationConverters.ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps((Duration)package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(duration))), this.getSystem())));
    }

    public boolean msgAvailable() {
        return this.tp.msgAvailable();
    }

    public ActorRef getLastSender() {
        return this.tp.lastSender();
    }

    public void send(ActorRef actor, Object msg) {
        actor.tell(msg, this.tp.ref());
    }

    public void forward(ActorRef actor) {
        actor.tell(this.tp.lastMessage().msg(), this.tp.lastMessage().sender());
    }

    public void reply(Object msg) {
        this.tp.lastSender().tell(msg, this.tp.ref());
    }

    public ActorRef watch(ActorRef ref) {
        return this.tp.watch(ref);
    }

    public ActorRef unwatch(ActorRef ref) {
        return this.tp.unwatch(ref);
    }

    public void ignoreMsg(Function<Object, Object> pf) {
        this.tp.ignoreMsg((PartialFunction)new CachingPartialFunction<Object, Object>(pf){
            private final Function pf$1;
            {
                this.pf$1 = pf$2;
            }

            public boolean match(Object x) throws Exception {
                return BoxesRunTime.unboxToBoolean(this.pf$1.apply(x));
            }
        });
    }

    public void ignoreNoMsg() {
        this.tp.ignoreNoMsg();
    }

    public void setAutoPilot(TestActor.AutoPilot pilot) {
        this.tp.setAutoPilot(pilot);
    }

    public FiniteDuration remaining() {
        return this.tp.remaining();
    }

    public java.time.Duration getRemaining() {
        return JavaDurationConverters.ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps((Duration)this.tp.remaining()));
    }

    public FiniteDuration remainingOr(FiniteDuration fd) {
        return this.tp.remainingOr(fd);
    }

    public java.time.Duration getRemainingOr(java.time.Duration duration) {
        return JavaDurationConverters.ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps((Duration)this.tp.remainingOr(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(duration)))));
    }

    public FiniteDuration remainingOrDefault() {
        return this.tp.remainingOrDefault();
    }

    public java.time.Duration getRemainingOrDefault() {
        return JavaDurationConverters.ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps((Duration)this.tp.remainingOrDefault()));
    }

    public <T> T within(FiniteDuration min, FiniteDuration max, Supplier<T> f) {
        return (T)this.tp.within(min, max, () -> TestKit.within$$anonfun$1(f));
    }

    public <T> T within(java.time.Duration min, java.time.Duration max, Supplier<T> f) {
        return (T)this.tp.within(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(min)), JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), () -> TestKit.within$$anonfun$2(f));
    }

    public <T> T within(FiniteDuration max, Supplier<T> f) {
        return (T)this.tp.within(max, () -> TestKit.within$$anonfun$3(f));
    }

    public <T> T within(java.time.Duration max, Supplier<T> f) {
        return (T)this.tp.within(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), () -> TestKit.within$$anonfun$4(f));
    }

    public void awaitCond(Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$1(p), this.tp.awaitCond$default$2(), this.tp.awaitCond$default$3(), this.tp.awaitCond$default$4());
    }

    public void awaitCond(Duration max, Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$2(p), max, this.tp.awaitCond$default$3(), this.tp.awaitCond$default$4());
    }

    public void awaitCond(java.time.Duration max, Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$3(p), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), this.tp.awaitCond$default$3(), this.tp.awaitCond$default$4());
    }

    public void awaitCond(Duration max, Duration interval, Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$4(p), max, interval, this.tp.awaitCond$default$4());
    }

    public void awaitCond(java.time.Duration max, java.time.Duration interval, Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$5(p), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)), this.tp.awaitCond$default$4());
    }

    public void awaitCond(Duration max, Duration interval, String message, Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$6(p), max, interval, message);
    }

    public void awaitCond(java.time.Duration max, java.time.Duration interval, String message, Supplier<Object> p) {
        this.tp.awaitCond(() -> TestKit.awaitCond$$anonfun$7(p), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)), message);
    }

    public <A> A awaitAssert(Supplier<A> a) {
        return (A)this.tp.awaitAssert(() -> TestKit.awaitAssert$$anonfun$1(a), this.tp.awaitAssert$default$2(), this.tp.awaitAssert$default$3());
    }

    public <A> A awaitAssert(Duration max, Supplier<A> a) {
        return (A)this.tp.awaitAssert(() -> TestKit.awaitAssert$$anonfun$2(a), max, this.tp.awaitAssert$default$3());
    }

    public <A> A awaitAssert(java.time.Duration max, Supplier<A> a) {
        return (A)this.tp.awaitAssert(() -> TestKit.awaitAssert$$anonfun$3(a), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), this.tp.awaitAssert$default$3());
    }

    public <A> A awaitAssert(Duration max, Duration interval, Supplier<A> a) {
        return (A)this.tp.awaitAssert(() -> TestKit.awaitAssert$$anonfun$4(a), max, interval);
    }

    public <A> A awaitAssert(java.time.Duration max, java.time.Duration interval, Supplier<A> a) {
        return (A)this.tp.awaitAssert(() -> TestKit.awaitAssert$$anonfun$5(a), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    public <T> T expectMsgEquals(T obj) {
        return (T)this.tp.expectMsg((Object)obj);
    }

    public <T> T expectMsgEquals(FiniteDuration max, T obj) {
        return (T)this.tp.expectMsg(max, (Object)obj);
    }

    public <T> T expectMsgEquals(java.time.Duration max, T obj) {
        return (T)this.tp.expectMsg(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Object)obj);
    }

    public <T> T expectMsg(T obj) {
        return (T)this.tp.expectMsg((Object)obj);
    }

    public <T> T expectMsg(FiniteDuration max, T obj) {
        return (T)this.tp.expectMsg(max, (Object)obj);
    }

    public <T> T expectMsg(java.time.Duration max, T obj) {
        return (T)this.tp.expectMsg(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Object)obj);
    }

    public <T> T expectMsg(FiniteDuration max, T obj, String hint) {
        return (T)this.tp.expectMsg(max, hint, (Object)obj);
    }

    public <T> T expectMsg(java.time.Duration max, T obj, String hint) {
        return this.expectMsg(max, obj, hint);
    }

    public <T> T expectMsgPF(String hint, Function<Object, T> f) {
        return (T)this.tp.expectMsgPF(this.tp.expectMsgPF$default$1(), hint, (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$5;
            {
                this.f$5 = f$13;
            }

            public Object match(Object x) throws Exception {
                return this.f$5.apply(x);
            }
        });
    }

    public <T> T expectMsgPF(Duration max, String hint, Function<Object, T> f) {
        return (T)this.tp.expectMsgPF(max, hint, (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$6;
            {
                this.f$6 = f$14;
            }

            public Object match(Object x) throws Exception {
                return this.f$6.apply(x);
            }
        });
    }

    public <T> T expectMsgPF(java.time.Duration max, String hint, Function<Object, T> f) {
        return this.expectMsgPF((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), hint, f);
    }

    public <T> T expectMsgClass(Class<T> c) {
        return (T)this.tp.expectMsgClass(c);
    }

    public <T> T expectMsgClass(FiniteDuration max, Class<T> c) {
        return (T)this.tp.expectMsgClass(max, c);
    }

    public <T> T expectMsgClass(java.time.Duration max, Class<T> c) {
        return (T)this.tp.expectMsgClass(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), c);
    }

    public <T> T expectMsgAnyOf(T first, scala.collection.immutable.Seq<T> objs) {
        return (T)this.tp.expectMsgAnyOf((scala.collection.immutable.Seq)objs.$plus$colon(first));
    }

    public <T> T expectMsgAnyOf(T first, T ... objs) {
        return this.expectMsgAnyOf(first, (scala.collection.immutable.Seq<T>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> T expectMsgAnyOf(FiniteDuration max, scala.collection.immutable.Seq<T> objs) {
        return (T)this.tp.expectMsgAnyOf(max, (scala.collection.immutable.Seq)objs);
    }

    public <T> T expectMsgAnyOf(FiniteDuration max, T ... objs) {
        return this.expectMsgAnyOf(max, (scala.collection.immutable.Seq<T>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> T expectMsgAnyOfWithin(java.time.Duration max, scala.collection.immutable.Seq<T> objs) {
        return (T)this.tp.expectMsgAnyOf(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (scala.collection.immutable.Seq)objs);
    }

    public <T> T expectMsgAnyOfWithin(java.time.Duration max, T ... objs) {
        return this.expectMsgAnyOfWithin(max, (scala.collection.immutable.Seq<T>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> List<T> expectMsgAllOf(scala.collection.immutable.Seq<T> objs) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.expectMsgAllOf((scala.collection.immutable.Seq)objs)).asJava();
    }

    public <T> List<T> expectMsgAllOf(T ... objs) {
        return this.expectMsgAllOf((scala.collection.immutable.Seq<T>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> List<T> expectMsgAllOf(FiniteDuration max, scala.collection.immutable.Seq<T> objs) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.expectMsgAllOf(max, (scala.collection.immutable.Seq)objs)).asJava();
    }

    public <T> List<T> expectMsgAllOf(FiniteDuration max, T ... objs) {
        return this.expectMsgAllOf(max, (scala.collection.immutable.Seq<T>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> List<T> expectMsgAllOfWithin(java.time.Duration max, scala.collection.immutable.Seq<T> objs) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.expectMsgAllOf(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (scala.collection.immutable.Seq)objs)).asJava();
    }

    public <T> List<T> expectMsgAllOfWithin(java.time.Duration max, T ... objs) {
        return this.expectMsgAllOfWithin(max, (scala.collection.immutable.Seq<T>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> T expectMsgAnyClassOf(scala.collection.immutable.Seq<Class<?>> objs) {
        return (T)this.tp.expectMsgAnyClassOf((scala.collection.immutable.Seq)objs);
    }

    public <T> T expectMsgAnyClassOf(Class<?> ... objs) {
        return this.expectMsgAnyClassOf((scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> T expectMsgAnyClassOf(FiniteDuration max, scala.collection.immutable.Seq<Class<?>> objs) {
        return (T)this.tp.expectMsgAnyClassOf(max, (scala.collection.immutable.Seq)objs);
    }

    public <T> T expectMsgAnyClassOf(FiniteDuration max, Class<?> ... objs) {
        return this.expectMsgAnyClassOf(max, (scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public <T> T expectMsgAnyClassOf(java.time.Duration max, scala.collection.immutable.Seq<Class<?>> objs) {
        return (T)this.tp.expectMsgAnyClassOf(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (scala.collection.immutable.Seq)objs);
    }

    public <T> T expectMsgAnyClassOf(java.time.Duration max, Class<?> ... objs) {
        return this.expectMsgAnyClassOf(max, (scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])objs));
    }

    public void expectNoMsg() {
        this.tp.expectNoMessage();
    }

    public void expectNoMessage() {
        this.tp.expectNoMessage();
    }

    public void expectNoMsg(FiniteDuration max) {
        this.tp.expectNoMessage(max);
    }

    public void expectNoMessage(FiniteDuration max) {
        this.tp.expectNoMessage(max);
    }

    public void expectNoMessage(java.time.Duration max) {
        this.tp.expectNoMessage(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public Terminated expectTerminated(Duration max, ActorRef target) {
        return this.tp.expectTerminated(target, max);
    }

    public Terminated expectTerminated(java.time.Duration max, ActorRef target) {
        return this.tp.expectTerminated(target, (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public Terminated expectTerminated(ActorRef target) {
        return this.tp.expectTerminated(target, this.tp.expectTerminated$default$2());
    }

    public Object fishForMessage(Duration max, String hint, Function<Object, Object> f) {
        return this.tp.fishForMessage(max, hint, (PartialFunction)new CachingPartialFunction<Object, Object>(f){
            private final Function f$7;
            {
                this.f$7 = f$15;
            }

            public boolean match(Object x) throws Exception {
                return BoxesRunTime.unboxToBoolean(this.f$7.apply(x));
            }
        });
    }

    public Object fishForMessage(java.time.Duration max, String hint, Function<Object, Object> f) {
        return this.fishForMessage((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), hint, f);
    }

    public <T> T fishForSpecificMessage(Duration max, String hint, Function<Object, T> f) {
        return (T)this.tp.fishForSpecificMessage(max, hint, (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$8;
            {
                this.f$8 = f$16;
            }

            public Object match(Object x) throws Exception {
                return this.f$8.apply(x);
            }
        });
    }

    public <T> T fishForSpecificMessage(java.time.Duration max, String hint, Function<Object, T> f) {
        return this.fishForSpecificMessage((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), hint, f);
    }

    public List<Object> receiveN(int n) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveN(n)).asJava();
    }

    public List<Object> receiveN(int n, FiniteDuration max) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveN(n, max)).asJava();
    }

    public List<Object> receiveN(int n, java.time.Duration max) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveN(n, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)))).asJava();
    }

    public Object receiveOne(Duration max) {
        return this.tp.receiveOne(max);
    }

    public Object receiveOne(java.time.Duration max) {
        return this.tp.receiveOne((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public <T> List<T> receiveWhile(Duration max, Duration idle, int messages, Function<Object, T> f) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveWhile(max, idle, messages, (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$9;
            {
                this.f$9 = f$17;
            }

            public Object match(Object x) throws Exception {
                return this.f$9.apply(x);
            }
        })).asJava();
    }

    public <T> List<T> receiveWhile(java.time.Duration max, java.time.Duration idle, int messages, Function<Object, T> f) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveWhile((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(idle)), messages, (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$10;
            {
                this.f$10 = f$18;
            }

            public Object match(Object x) throws Exception {
                return this.f$10.apply(x);
            }
        })).asJava();
    }

    public <T> List<T> receiveWhile(Duration max, Function<Object, T> f) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveWhile(max, this.tp.receiveWhile$default$2(), this.tp.receiveWhile$default$3(), (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$11;
            {
                this.f$11 = f$19;
            }

            public Object match(Object x) throws Exception {
                return this.f$11.apply(x);
            }
        })).asJava();
    }

    public <T> List<T> receiveWhile(java.time.Duration max, Function<Object, T> f) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.tp.receiveWhile((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), this.tp.receiveWhile$default$2(), this.tp.receiveWhile$default$3(), (PartialFunction)new CachingPartialFunction<Object, T>(f){
            private final Function f$12;
            {
                this.f$12 = f$20;
            }

            public Object match(Object x) throws Exception {
                return this.f$12.apply(x);
            }
        })).asJava();
    }

    public ActorRef childActorOf(Props props, String name, SupervisorStrategy supervisorStrategy) {
        return this.tp.childActorOf(props, name, supervisorStrategy);
    }

    public ActorRef childActorOf(Props props, SupervisorStrategy supervisorStrategy) {
        return this.tp.childActorOf(props, supervisorStrategy);
    }

    public ActorRef childActorOf(Props props, String name) {
        return this.tp.childActorOf(props, name);
    }

    public ActorRef childActorOf(Props props) {
        return this.tp.childActorOf(props);
    }

    private static final Object within$$anonfun$1(Supplier f$1) {
        return f$1.get();
    }

    private static final Object within$$anonfun$2(Supplier f$2) {
        return f$2.get();
    }

    private static final Object within$$anonfun$3(Supplier f$3) {
        return f$3.get();
    }

    private static final Object within$$anonfun$4(Supplier f$4) {
        return f$4.get();
    }

    private static final boolean awaitCond$$anonfun$1(Supplier p$1) {
        return BoxesRunTime.unboxToBoolean(p$1.get());
    }

    private static final boolean awaitCond$$anonfun$2(Supplier p$2) {
        return BoxesRunTime.unboxToBoolean(p$2.get());
    }

    private static final boolean awaitCond$$anonfun$3(Supplier p$3) {
        return BoxesRunTime.unboxToBoolean(p$3.get());
    }

    private static final boolean awaitCond$$anonfun$4(Supplier p$4) {
        return BoxesRunTime.unboxToBoolean(p$4.get());
    }

    private static final boolean awaitCond$$anonfun$5(Supplier p$5) {
        return BoxesRunTime.unboxToBoolean(p$5.get());
    }

    private static final boolean awaitCond$$anonfun$6(Supplier p$6) {
        return BoxesRunTime.unboxToBoolean(p$6.get());
    }

    private static final boolean awaitCond$$anonfun$7(Supplier p$7) {
        return BoxesRunTime.unboxToBoolean(p$7.get());
    }

    private static final Object awaitAssert$$anonfun$1(Supplier a$1) {
        return a$1.get();
    }

    private static final Object awaitAssert$$anonfun$2(Supplier a$2) {
        return a$2.get();
    }

    private static final Object awaitAssert$$anonfun$3(Supplier a$3) {
        return a$3.get();
    }

    private static final Object awaitAssert$$anonfun$4(Supplier a$4) {
        return a$4.get();
    }

    private static final Object awaitAssert$$anonfun$5(Supplier a$5) {
        return a$5.get();
    }
}

