// $ANTLR 3.5.2 PhoenixSQL.g 2024-04-06 10:19:17

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.util.Pair;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;
import org.apache.phoenix.parse.ExplainType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "B", "BETWEEN", 
		"BIND_NAME", "BIN_DIGIT", "BIN_LITERAL", "BY", "CACHE", "CASCADE", "CASE", 
		"CAST", "CHAR", "CHAR_ESC", "CLOSE", "COLON", "COLUMN", "COLUMNS", "COLUMN_QUALIFIER_COUNTER", 
		"COMMA", "COMMENT_AND_HINT_END", "COMMENT_START", "CONCAT", "CONSTANT", 
		"CONSTRAINT", "CREATE", "CURRENT", "CURSOR", "CYCLE", "DBL_QUOTE_CHAR", 
		"DECIMAL", "DECLARE", "DEFAULT", "DEFAULTVALUE", "DELETE", "DESC", "DIGIT", 
		"DISABLE", "DISTINCT", "DIVIDE", "DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", 
		"DROP", "DUPLICATE", "ELSE", "ENCODED_QUALIFIER", "END", "EOL", "EQ", 
		"EXECUTE", "EXISTS", "EXPLAIN", "Exponent", "FALSE", "FETCH", "FIELDCHAR", 
		"FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GRANT", "GROUP", "GT", "HAVING", 
		"HEX_DIGIT", "HEX_LITERAL", "HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", 
		"IN", "INCLUDE", "INCREMENT", "INDEX", "INNER", "INTO", "IS", "JAR", "JARS", 
		"JOIN", "KEY", "LAST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", 
		"LOCAL", "LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NOVERIFY", "NULL", 
		"NULLS", "NUMBER", "OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", 
		"OTHER", "OUTER", "OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "PRIMARY", 
		"QUESTION", "RCURLY", "REBUILD", "REGIONS", "REPLACE", "RETURNS", "REVOKE", 
		"RIGHT", "ROW", "ROWS", "ROW_TIMESTAMP", "RPAREN", "RSQUARE", "SAMPLING", 
		"SCHEMA", "SCHEMAS", "SELECT", "SEMICOLON", "SEQUENCE", "SESSION", "SET", 
		"SHOW", "SL_COMMENT", "SL_COMMENT1", "SL_COMMENT2", "SOME", "SPLIT", "START", 
		"STATISTICS", "STRING_LITERAL", "TABLE", "TABLES", "TABLESAMPLE", "TEMPORARY", 
		"THEN", "TILDE", "TO", "TRACE", "TRUE", "UNCOVERED", "UNION", "UNUSABLE", 
		"UPDATE", "UPGRADE", "UPSERT", "USABLE", "USE", "USING", "VALUE", "VALUES", 
		"VIEW", "WHEN", "WHERE", "WITH", "WITHIN", "WS", "X"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int B=16;
	public static final int BETWEEN=17;
	public static final int BIND_NAME=18;
	public static final int BIN_DIGIT=19;
	public static final int BIN_LITERAL=20;
	public static final int BY=21;
	public static final int CACHE=22;
	public static final int CASCADE=23;
	public static final int CASE=24;
	public static final int CAST=25;
	public static final int CHAR=26;
	public static final int CHAR_ESC=27;
	public static final int CLOSE=28;
	public static final int COLON=29;
	public static final int COLUMN=30;
	public static final int COLUMNS=31;
	public static final int COLUMN_QUALIFIER_COUNTER=32;
	public static final int COMMA=33;
	public static final int COMMENT_AND_HINT_END=34;
	public static final int COMMENT_START=35;
	public static final int CONCAT=36;
	public static final int CONSTANT=37;
	public static final int CONSTRAINT=38;
	public static final int CREATE=39;
	public static final int CURRENT=40;
	public static final int CURSOR=41;
	public static final int CYCLE=42;
	public static final int DBL_QUOTE_CHAR=43;
	public static final int DECIMAL=44;
	public static final int DECLARE=45;
	public static final int DEFAULT=46;
	public static final int DEFAULTVALUE=47;
	public static final int DELETE=48;
	public static final int DESC=49;
	public static final int DIGIT=50;
	public static final int DISABLE=51;
	public static final int DISTINCT=52;
	public static final int DIVIDE=53;
	public static final int DOT=54;
	public static final int DOUBLE=55;
	public static final int DOUBLE_EQ=56;
	public static final int DOUBLE_QUOTE=57;
	public static final int DROP=58;
	public static final int DUPLICATE=59;
	public static final int ELSE=60;
	public static final int ENCODED_QUALIFIER=61;
	public static final int END=62;
	public static final int EOL=63;
	public static final int EQ=64;
	public static final int EXECUTE=65;
	public static final int EXISTS=66;
	public static final int EXPLAIN=67;
	public static final int Exponent=68;
	public static final int FALSE=69;
	public static final int FETCH=70;
	public static final int FIELDCHAR=71;
	public static final int FIRST=72;
	public static final int FOR=73;
	public static final int FROM=74;
	public static final int FULL=75;
	public static final int FUNCTION=76;
	public static final int GRANT=77;
	public static final int GROUP=78;
	public static final int GT=79;
	public static final int HAVING=80;
	public static final int HEX_DIGIT=81;
	public static final int HEX_LITERAL=82;
	public static final int HINT_START=83;
	public static final int IF=84;
	public static final int IGNORE=85;
	public static final int ILIKE=86;
	public static final int IMMUTABLE=87;
	public static final int IN=88;
	public static final int INCLUDE=89;
	public static final int INCREMENT=90;
	public static final int INDEX=91;
	public static final int INNER=92;
	public static final int INTO=93;
	public static final int IS=94;
	public static final int JAR=95;
	public static final int JARS=96;
	public static final int JOIN=97;
	public static final int KEY=98;
	public static final int LAST=99;
	public static final int LCURLY=100;
	public static final int LEFT=101;
	public static final int LETTER=102;
	public static final int LIKE=103;
	public static final int LIMIT=104;
	public static final int LIST=105;
	public static final int LOCAL=106;
	public static final int LPAREN=107;
	public static final int LSQUARE=108;
	public static final int LT=109;
	public static final int MAXVALUE=110;
	public static final int MINUS=111;
	public static final int MINVALUE=112;
	public static final int ML_COMMENT=113;
	public static final int ML_HINT=114;
	public static final int NAME=115;
	public static final int NEXT=116;
	public static final int NOEQ1=117;
	public static final int NOEQ2=118;
	public static final int NOT=119;
	public static final int NOVERIFY=120;
	public static final int NULL=121;
	public static final int NULLS=122;
	public static final int NUMBER=123;
	public static final int OFF=124;
	public static final int OFFSET=125;
	public static final int ON=126;
	public static final int ONLY=127;
	public static final int OPEN=128;
	public static final int OR=129;
	public static final int ORDER=130;
	public static final int OTHER=131;
	public static final int OUTER=132;
	public static final int OUTER_JOIN=133;
	public static final int PERCENT=134;
	public static final int PLUS=135;
	public static final int POSINTEGER=136;
	public static final int PRIMARY=137;
	public static final int QUESTION=138;
	public static final int RCURLY=139;
	public static final int REBUILD=140;
	public static final int REGIONS=141;
	public static final int REPLACE=142;
	public static final int RETURNS=143;
	public static final int REVOKE=144;
	public static final int RIGHT=145;
	public static final int ROW=146;
	public static final int ROWS=147;
	public static final int ROW_TIMESTAMP=148;
	public static final int RPAREN=149;
	public static final int RSQUARE=150;
	public static final int SAMPLING=151;
	public static final int SCHEMA=152;
	public static final int SCHEMAS=153;
	public static final int SELECT=154;
	public static final int SEMICOLON=155;
	public static final int SEQUENCE=156;
	public static final int SESSION=157;
	public static final int SET=158;
	public static final int SHOW=159;
	public static final int SL_COMMENT=160;
	public static final int SL_COMMENT1=161;
	public static final int SL_COMMENT2=162;
	public static final int SOME=163;
	public static final int SPLIT=164;
	public static final int START=165;
	public static final int STATISTICS=166;
	public static final int STRING_LITERAL=167;
	public static final int TABLE=168;
	public static final int TABLES=169;
	public static final int TABLESAMPLE=170;
	public static final int TEMPORARY=171;
	public static final int THEN=172;
	public static final int TILDE=173;
	public static final int TO=174;
	public static final int TRACE=175;
	public static final int TRUE=176;
	public static final int UNCOVERED=177;
	public static final int UNION=178;
	public static final int UNUSABLE=179;
	public static final int UPDATE=180;
	public static final int UPGRADE=181;
	public static final int UPSERT=182;
	public static final int USABLE=183;
	public static final int USE=184;
	public static final int USING=185;
	public static final int VALUE=186;
	public static final int VALUES=187;
	public static final int VIEW=188;
	public static final int WHEN=189;
	public static final int WHERE=190;
	public static final int WITH=191;
	public static final int WITHIN=192;
	public static final int WS=193;
	public static final int X=194;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }

	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:391:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:392:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==GRANT||LA1_0==LIST||LA1_0==OPEN||LA1_0==REVOKE||LA1_0==SELECT||LA1_0==SHOW||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:392:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1346);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1350); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:399:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1359); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:403:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:404:5: (s= oneStatement EOF )
			// PhoenixSQL.g:404:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1385);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1389); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:414:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:415:5: (s= select_node EOF )
			// PhoenixSQL.g:415:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1415);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1417); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:419:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:421:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:421:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:421:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=33;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=23;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case SEQUENCE:
					{
					alt2=25;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
				case UNCOVERED:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=19;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=8;
				}
				break;
			case CLOSE:
				{
				alt2=9;
				}
				break;
			case FETCH:
				{
				alt2=10;
				}
				break;
			case DECLARE:
				{
				alt2=11;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=13;
					}
					break;
				case FUNCTION:
					{
					alt2=20;
					}
					break;
				case SEQUENCE:
					{
					alt2=28;
					}
					break;
				case SCHEMA:
					{
					alt2=29;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=12;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case SESSION:
					{
					alt2=24;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=15;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case SHOW:
				{
				int LA2_11 = input.LA(2);
				if ( (LA2_11==SCHEMAS||LA2_11==TABLES) ) {
					alt2=16;
				}
				else if ( (LA2_11==CREATE) ) {
					alt2=17;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TRACE:
				{
				alt2=18;
				}
				break;
			case ADD:
				{
				alt2=21;
				}
				break;
			case LIST:
				{
				alt2=22;
				}
				break;
			case GRANT:
				{
				alt2=26;
				}
				break;
			case REVOKE:
				{
				alt2=27;
				}
				break;
			case USE:
				{
				alt2=30;
				}
				break;
			case UPDATE:
				{
				alt2=31;
				}
				break;
			case EXECUTE:
				{
				alt2=32;
				}
				break;
			case EXPLAIN:
				{
				alt2=33;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:421:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1449);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:422:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1459);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:423:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1471);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:424:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1483);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:425:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1495);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:426:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1507);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:427:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1519);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:428:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1531);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:429:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1543);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:430:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1555);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:431:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1567);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:432:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1579);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:433:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1591);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:434:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1603);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:435:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1615);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:436:9: s= show_node
					{
					pushFollow(FOLLOW_show_node_in_oneStatement1627);
					s=show_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:437:9: s= show_create_table_node
					{
					pushFollow(FOLLOW_show_create_table_node_in_oneStatement1639);
					s=show_create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:438:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1651);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:439:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1663);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:440:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1675);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:441:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1687);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:442:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1699);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:443:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1711);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:444:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1723);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:445:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1733);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:446:9: s= grant_permission_node
					{
					pushFollow(FOLLOW_grant_permission_node_in_oneStatement1745);
					s=grant_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:447:9: s= revoke_permission_node
					{
					pushFollow(FOLLOW_revoke_permission_node_in_oneStatement1757);
					s=revoke_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:448:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1767);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:449:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1777);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 30 :
					// PhoenixSQL.g:450:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1787);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 31 :
					// PhoenixSQL.g:451:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1799);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 32 :
					// PhoenixSQL.g:452:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1811);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 33 :
					// PhoenixSQL.g:453:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1823);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:457:1: explain_node returns [BindableStatement ret] : EXPLAIN (w= WITH )? (r= REGIONS )? q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		Token w=null;
		Token r=null;
		BindableStatement q =null;

		try {
			// PhoenixSQL.g:458:5: ( EXPLAIN (w= WITH )? (r= REGIONS )? q= oneStatement )
			// PhoenixSQL.g:458:9: EXPLAIN (w= WITH )? (r= REGIONS )? q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1856); if (state.failed) return ret;
			// PhoenixSQL.g:458:17: (w= WITH )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==WITH) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:458:18: w= WITH
					{
					w=(Token)match(input,WITH,FOLLOW_WITH_in_explain_node1861); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:458:27: (r= REGIONS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==REGIONS) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:458:28: r= REGIONS
					{
					r=(Token)match(input,REGIONS,FOLLOW_REGIONS_in_explain_node1868); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_oneStatement_in_explain_node1874);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        if ((w==null && r!=null) || (w!=null && r==null)) {
			            throw new RuntimeException("Valid usage: EXPLAIN {query} OR EXPLAIN WITH REGIONS {query}");
			        }
			        ret = (w==null && r==null) ? factory.explain(q, ExplainType.DEFAULT)
			         : factory.explain(q, ExplainType.WITH_REGIONS);
			     }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:469:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (noverify= NOVERIFY )? (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		Token noverify=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;
		Map<String, Integer> cqc =null;

		try {
			// PhoenixSQL.g:470:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (noverify= NOVERIFY )? (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )? )
			// PhoenixSQL.g:470:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (noverify= NOVERIFY )? (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1905); if (state.failed) return ret;
			// PhoenixSQL.g:470:16: (im= IMMUTABLE )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==IMMUTABLE) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:470:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1910); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node1914); if (state.failed) return ret;
			// PhoenixSQL.g:470:38: ( IF NOT ex= EXISTS )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==IF) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:470:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node1917); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node1919); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node1923); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node1929);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:471:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:471:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node1941); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node1945);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:471:31: (pk= pk_constraint )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==COMMA||LA7_0==CONSTRAINT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:471:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node1950);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node1954); if (state.failed) return ret;
			}

			// PhoenixSQL.g:472:9: (noverify= NOVERIFY )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==NOVERIFY) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:472:10: noverify= NOVERIFY
					{
					noverify=(Token)match(input,NOVERIFY,FOLLOW_NOVERIFY_in_create_table_node1968); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:473:9: (p= fam_properties )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==NAME) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// PhoenixSQL.g:473:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node1983);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:474:9: ( SPLIT ON s= value_expression_list )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==SPLIT) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// PhoenixSQL.g:474:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node1996); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node1998); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node2002);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:475:9: ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==COLUMN_QUALIFIER_COUNTER) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// PhoenixSQL.g:475:10: COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN
					{
					match(input,COLUMN_QUALIFIER_COUNTER,FOLLOW_COLUMN_QUALIFIER_COUNTER_in_create_table_node2015); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node2017); if (state.failed) return ret;
					pushFollow(FOLLOW_initializiation_list_in_create_table_node2021);
					cqc=initializiation_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node2023); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null, cqc, noverify!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:480:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:481:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier )
			// PhoenixSQL.g:481:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node2062); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node2064); if (state.failed) return ret;
			// PhoenixSQL.g:481:23: ( IF NOT ex= EXISTS )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==IF) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:481:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node2067); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node2069); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node2073); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_create_schema_node2079);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "grant_permission_node"
	// PhoenixSQL.g:486:1: grant_permission_node returns [ChangePermsStatement ret] : GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal ;
	public final ChangePermsStatement grant_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:487:5: ( GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal )
			// PhoenixSQL.g:487:9: GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal
			{
			match(input,GRANT,FOLLOW_GRANT_in_grant_permission_node2113); if (state.failed) return ret;
			pushFollow(FOLLOW_literal_in_grant_permission_node2117);
			p=literal();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:487:25: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==ON) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// PhoenixSQL.g:487:26: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_grant_permission_node2120); if (state.failed) return ret;
					// PhoenixSQL.g:487:29: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt14=2;
					int LA14_0 = input.LA(1);
					if ( (LA14_0==NAME||LA14_0==TABLE) ) {
						alt14=1;
					}
					else if ( (LA14_0==SCHEMA) ) {
						alt14=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 14, 0, input);
						throw nvae;
					}

					switch (alt14) {
						case 1 :
							// PhoenixSQL.g:487:30: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:487:30: ( TABLE )?
							int alt13=2;
							int LA13_0 = input.LA(1);
							if ( (LA13_0==TABLE) ) {
								alt13=1;
							}
							switch (alt13) {
								case 1 :
									// PhoenixSQL.g:487:31: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_grant_permission_node2124); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_grant_permission_node2130);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:487:58: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_grant_permission_node2136); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_grant_permission_node2140);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,TO,FOLLOW_TO_in_grant_permission_node2145); if (state.failed) return ret;
			// PhoenixSQL.g:487:91: (g= GROUP )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==GROUP) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// PhoenixSQL.g:487:92: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_grant_permission_node2150); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_grant_permission_node2156);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.TRUE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "grant_permission_node"



	// $ANTLR start "revoke_permission_node"
	// PhoenixSQL.g:498:1: revoke_permission_node returns [ChangePermsStatement ret] : REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal ;
	public final ChangePermsStatement revoke_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:499:5: ( REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal )
			// PhoenixSQL.g:499:9: REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal
			{
			match(input,REVOKE,FOLLOW_REVOKE_in_revoke_permission_node2190); if (state.failed) return ret;
			// PhoenixSQL.g:499:16: (p= literal )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==BIN_LITERAL||LA17_0==DECIMAL||LA17_0==DOUBLE||LA17_0==FALSE||LA17_0==HEX_LITERAL||LA17_0==NAME||LA17_0==NULL||LA17_0==NUMBER||LA17_0==STRING_LITERAL||LA17_0==TRUE) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:499:17: p= literal
					{
					pushFollow(FOLLOW_literal_in_revoke_permission_node2195);
					p=literal();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:499:29: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==ON) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// PhoenixSQL.g:499:30: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_revoke_permission_node2200); if (state.failed) return ret;
					// PhoenixSQL.g:499:33: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==NAME||LA19_0==TABLE) ) {
						alt19=1;
					}
					else if ( (LA19_0==SCHEMA) ) {
						alt19=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 19, 0, input);
						throw nvae;
					}

					switch (alt19) {
						case 1 :
							// PhoenixSQL.g:499:34: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:499:34: ( TABLE )?
							int alt18=2;
							int LA18_0 = input.LA(1);
							if ( (LA18_0==TABLE) ) {
								alt18=1;
							}
							switch (alt18) {
								case 1 :
									// PhoenixSQL.g:499:35: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_revoke_permission_node2204); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_revoke_permission_node2210);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:499:62: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_revoke_permission_node2216); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_revoke_permission_node2220);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_revoke_permission_node2225); if (state.failed) return ret;
			// PhoenixSQL.g:499:97: (g= GROUP )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==GROUP) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// PhoenixSQL.g:499:98: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_revoke_permission_node2230); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_revoke_permission_node2236);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.FALSE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "revoke_permission_node"



	// $ANTLR start "show_node"
	// PhoenixSQL.g:510:1: show_node returns [ShowStatement ret] : ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? );
	public final ShowStatement show_node() throws RecognitionException {
		ShowStatement ret = null;


		String schema =null;
		String pattern =null;

		try {
			// PhoenixSQL.g:511:5: ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? )
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==SHOW) ) {
				int LA25_1 = input.LA(2);
				if ( (LA25_1==TABLES) ) {
					alt25=1;
				}
				else if ( (LA25_1==SCHEMAS) ) {
					alt25=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 25, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 25, 0, input);
				throw nvae;
			}

			switch (alt25) {
				case 1 :
					// PhoenixSQL.g:511:9: SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2270); if (state.failed) return ret;
					match(input,TABLES,FOLLOW_TABLES_in_show_node2272); if (state.failed) return ret;
					// PhoenixSQL.g:511:21: ( IN schema= identifier )?
					int alt22=2;
					int LA22_0 = input.LA(1);
					if ( (LA22_0==IN) ) {
						alt22=1;
					}
					switch (alt22) {
						case 1 :
							// PhoenixSQL.g:511:22: IN schema= identifier
							{
							match(input,IN,FOLLOW_IN_in_show_node2275); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_show_node2279);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:511:45: ( LIKE pattern= string_literal )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==LIKE) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// PhoenixSQL.g:511:46: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2284); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2288);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showTablesStatement(schema, pattern); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:512:9: SHOW SCHEMAS ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2302); if (state.failed) return ret;
					match(input,SCHEMAS,FOLLOW_SCHEMAS_in_show_node2304); if (state.failed) return ret;
					// PhoenixSQL.g:512:22: ( LIKE pattern= string_literal )?
					int alt24=2;
					int LA24_0 = input.LA(1);
					if ( (LA24_0==LIKE) ) {
						alt24=1;
					}
					switch (alt24) {
						case 1 :
							// PhoenixSQL.g:512:23: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2307); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2311);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showSchemasStatement(pattern); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_node"



	// $ANTLR start "show_create_table_node"
	// PhoenixSQL.g:516:1: show_create_table_node returns [ShowCreateTable ret] : SHOW CREATE TABLE tablename= from_table_name ;
	public final ShowCreateTable show_create_table_node() throws RecognitionException {
		ShowCreateTable ret = null;


		TableName tablename =null;

		try {
			// PhoenixSQL.g:517:5: ( SHOW CREATE TABLE tablename= from_table_name )
			// PhoenixSQL.g:517:9: SHOW CREATE TABLE tablename= from_table_name
			{
			match(input,SHOW,FOLLOW_SHOW_in_show_create_table_node2339); if (state.failed) return ret;
			match(input,CREATE,FOLLOW_CREATE_in_show_create_table_node2341); if (state.failed) return ret;
			match(input,TABLE,FOLLOW_TABLE_in_show_create_table_node2343); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_show_create_table_node2347);
			tablename=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.showCreateTable(tablename); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_create_table_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:521:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:522:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:522:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node2373); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node2375); if (state.failed) return ret;
			// PhoenixSQL.g:522:21: ( IF NOT ex= EXISTS )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==IF) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PhoenixSQL.g:522:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node2378); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node2380); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node2384); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node2390);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:523:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==LPAREN) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:523:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node2402); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node2406);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:523:31: (pk= pk_constraint )?
					int alt27=2;
					int LA27_0 = input.LA(1);
					if ( (LA27_0==COMMA||LA27_0==CONSTRAINT) ) {
						alt27=1;
					}
					switch (alt27) {
						case 1 :
							// PhoenixSQL.g:523:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node2411);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node2415); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:524:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==AS) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:524:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node2429); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node2431); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node2433); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node2445); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node2449);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:526:11: ( WHERE w= expression )?
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( (LA29_0==WHERE) ) {
						alt29=1;
					}
					switch (alt29) {
						case 1 :
							// PhoenixSQL.g:526:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node2462); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node2466);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:527:9: (p= fam_properties )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==NAME) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:527:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2484);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:532:1: create_index_node returns [CreateIndexStatement ret] : CREATE (u= UNCOVERED )? (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? ( WHERE where= expression )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token u=null;
		Token l=null;
		Token ex=null;
		Token in=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ParseNode where =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:533:5: ( CREATE (u= UNCOVERED )? (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? ( WHERE where= expression )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:533:9: CREATE (u= UNCOVERED )? (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? ( WHERE where= expression )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2520); if (state.failed) return ret;
			// PhoenixSQL.g:533:17: (u= UNCOVERED )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==UNCOVERED) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:533:17: u= UNCOVERED
					{
					u=(Token)match(input,UNCOVERED,FOLLOW_UNCOVERED_in_create_index_node2524); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:533:30: (l= LOCAL )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==LOCAL) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:533:30: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2529); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2532); if (state.failed) return ret;
			// PhoenixSQL.g:533:44: ( IF NOT ex= EXISTS )?
			int alt34=2;
			int LA34_0 = input.LA(1);
			if ( (LA34_0==IF) ) {
				alt34=1;
			}
			switch (alt34) {
				case 1 :
					// PhoenixSQL.g:533:45: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2535); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2537); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2541); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2547);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2549); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2553);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:534:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:534:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2564); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2568);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2570); if (state.failed) return ret;
			}

			// PhoenixSQL.g:535:9: (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==INCLUDE) ) {
				alt35=1;
			}
			switch (alt35) {
				case 1 :
					// PhoenixSQL.g:535:10: in= INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					in=(Token)match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2584); if (state.failed) return ret;
					// PhoenixSQL.g:535:21: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:535:22: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2587); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2591);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2593); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:536:9: ( WHERE where= expression )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==WHERE) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// PhoenixSQL.g:536:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_create_index_node2607); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_create_index_node2611);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:537:9: (async= ASYNC )?
			int alt37=2;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==ASYNC) ) {
				alt37=1;
			}
			switch (alt37) {
				case 1 :
					// PhoenixSQL.g:537:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2626); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:538:9: (p= fam_properties )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==NAME) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// PhoenixSQL.g:538:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2641);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:539:9: ( SPLIT ON v= value_expression_list )?
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==SPLIT) ) {
				alt39=1;
			}
			switch (alt39) {
				case 1 :
					// PhoenixSQL.g:539:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2654); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2656); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2660);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			            if (u !=null && in != null) {
			                throw new RuntimeException("UNCOVERED indexes cannot have the INCLUDE clause");
			            }
			            if (l !=null && u != null) {
			                throw new RuntimeException("UNCOVERED cannot be used with LOCAL");
			            }
			            if (l !=null && where != null) {
			                throw new RuntimeException("Partial local indexes are not supported");
			            }
			            ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null,
			                    l==null ? (u==null ? IndexType.getDefault() : IndexType.UNCOVERED_GLOBAL) :
			                    IndexType.LOCAL, async != null, getBindCount(), new HashMap<String,
			                    UDFParseNode>(udfParseNodes), where);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:558:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:559:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:559:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2696); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2698); if (state.failed) return ret;
			// PhoenixSQL.g:559:26: ( IF NOT ex= EXISTS )?
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==IF) ) {
				alt40=1;
			}
			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:559:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node2702); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node2704); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node2708); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node2714);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:560:9: ( START ( WITH )? s= value_expression )?
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==START) ) {
				alt42=1;
			}
			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:560:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node2725); if (state.failed) return ret;
					// PhoenixSQL.g:560:16: ( WITH )?
					int alt41=2;
					int LA41_0 = input.LA(1);
					if ( (LA41_0==WITH) ) {
						alt41=1;
					}
					switch (alt41) {
						case 1 :
							// PhoenixSQL.g:560:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node2727); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2732);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:561:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==INCREMENT) ) {
				alt44=1;
			}
			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:561:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node2745); if (state.failed) return ret;
					// PhoenixSQL.g:561:20: ( BY )?
					int alt43=2;
					int LA43_0 = input.LA(1);
					if ( (LA43_0==BY) ) {
						alt43=1;
					}
					switch (alt43) {
						case 1 :
							// PhoenixSQL.g:561:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node2747); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2752);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:562:9: ( MINVALUE min= value_expression )?
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==MINVALUE) ) {
				alt45=1;
			}
			switch (alt45) {
				case 1 :
					// PhoenixSQL.g:562:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node2765); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2769);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:563:9: ( MAXVALUE max= value_expression )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==MAXVALUE) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// PhoenixSQL.g:563:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node2782); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2786);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:564:9: (cyc= CYCLE )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==CYCLE) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// PhoenixSQL.g:564:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node2801); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:565:9: ( CACHE c= int_literal_or_bind )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==CACHE) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:565:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node2815); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node2819);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:569:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:570:5: (n= int_or_long_literal |b= bind_expression )
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==NUMBER) ) {
				alt49=1;
			}
			else if ( (LA49_0==BIND_NAME||LA49_0==QUESTION) ) {
				alt49=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 49, 0, input);
				throw nvae;
			}

			switch (alt49) {
				case 1 :
					// PhoenixSQL.g:570:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind2850);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:571:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind2862);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "string_literal"
	// PhoenixSQL.g:575:1: string_literal returns [String ret] : s= STRING_LITERAL ;
	public final String string_literal() throws RecognitionException {
		String ret = null;


		Token s=null;

		try {
			// PhoenixSQL.g:576:5: (s= STRING_LITERAL )
			// PhoenixSQL.g:576:9: s= STRING_LITERAL
			{
			s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_string_literal2890); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = SchemaUtil.normalizeLiteral(factory.literal(s.getText())); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "string_literal"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:580:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:581:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:581:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node2916); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node2918); if (state.failed) return ret;
			// PhoenixSQL.g:581:24: ( IF ex= EXISTS )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==IF) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// PhoenixSQL.g:581:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node2922); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node2926); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node2932);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:585:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:586:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:586:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:586:9: ( COMMA )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==COMMA) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// PhoenixSQL.g:586:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint2961); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint2964); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint2968);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint2970); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint2972); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint2974); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2978);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint2980); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:589:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:591:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:591:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3011);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:591:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop52:
			while (true) {
				int alt52=2;
				int LA52_0 = input.LA(1);
				if ( (LA52_0==COMMA) ) {
					alt52=1;
				}

				switch (alt52) {
				case 1 :
					// PhoenixSQL.g:591:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list3017); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3023);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop52;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:594:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:595:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:595:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp3050);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:595:22: (order= ASC |order= DESC )?
			int alt53=3;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==ASC) ) {
				alt53=1;
			}
			else if ( (LA53_0==DESC) ) {
				alt53=2;
			}
			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:595:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp3055); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:595:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp3059); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:595:46: (rr= ROW_TIMESTAMP )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==ROW_TIMESTAMP) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:595:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp3066); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:599:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:600:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:600:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint3101);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:603:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:605:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:605:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3128);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:605:54: ( COMMA p= expression_with_sort_order )*
			loop55:
			while (true) {
				int alt55=2;
				int LA55_0 = input.LA(1);
				if ( (LA55_0==COMMA) ) {
					alt55=1;
				}

				switch (alt55) {
				case 1 :
					// PhoenixSQL.g:605:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list3134); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3140);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop55;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:608:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:609:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:609:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:609:9: (x= expression )
			// PhoenixSQL.g:609:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order3167);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:609:24: (order= ASC |order= DESC )?
			int alt56=3;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==ASC) ) {
				alt56=1;
			}
			else if ( (LA56_0==DESC) ) {
				alt56=2;
			}
			switch (alt56) {
				case 1 :
					// PhoenixSQL.g:609:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order3173); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:609:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order3177); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:612:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:614:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:614:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties3205);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties3207); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties3211);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:614:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop57:
			while (true) {
				int alt57=2;
				int LA57_0 = input.LA(1);
				if ( (LA57_0==COMMA) ) {
					alt57=1;
				}

				switch (alt57) {
				case 1 :
					// PhoenixSQL.g:614:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties3217); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties3221);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties3223); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties3227);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop57;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:617:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:618:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==NAME) ) {
				int LA58_1 = input.LA(2);
				if ( (LA58_1==EQ) ) {
					alt58=1;
				}
				else if ( (LA58_1==DOT) ) {
					alt58=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 58, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}

			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:618:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3257);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:619:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3271);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name3273); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name3277);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:622:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:623:5: (v= identifier |l= literal )
			int alt59=2;
			int LA59_0 = input.LA(1);
			if ( (LA59_0==NAME) ) {
				int LA59_1 = input.LA(2);
				if ( (LA59_1==EOF||LA59_1==CASCADE||(LA59_1 >= COLUMN_QUALIFIER_COUNTER && LA59_1 <= COMMA)||LA59_1==SEMICOLON||LA59_1==SPLIT) ) {
					alt59=1;
				}
				else if ( (LA59_1==STRING_LITERAL) ) {
					alt59=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 59, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA59_0==BIN_LITERAL||LA59_0==DECIMAL||LA59_0==DOUBLE||LA59_0==FALSE||LA59_0==HEX_LITERAL||LA59_0==NULL||LA59_0==NUMBER||LA59_0==STRING_LITERAL||LA59_0==TRUE) ) {
				alt59=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 59, 0, input);
				throw nvae;
			}

			switch (alt59) {
				case 1 :
					// PhoenixSQL.g:623:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value3308);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:624:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value3322);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:627:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:628:5: (field= identifier |family= identifier DOT field= identifier )
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==NAME) ) {
				int LA60_1 = input.LA(2);
				if ( (LA60_1==EOF||LA60_1==COMMA||LA60_1==EQ||LA60_1==NAME||LA60_1==RPAREN||LA60_1==SEMICOLON) ) {
					alt60=1;
				}
				else if ( (LA60_1==DOT) ) {
					alt60=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 60, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}

			switch (alt60) {
				case 1 :
					// PhoenixSQL.g:628:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3353);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:629:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3367);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name3369); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name3373);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:632:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:634:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:634:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names3405);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:634:40: ( COMMA v= column_name )*
			loop61:
			while (true) {
				int alt61=2;
				int LA61_0 = input.LA(1);
				if ( (LA61_0==COMMA) ) {
					alt61=1;
				}

				switch (alt61) {
				case 1 :
					// PhoenixSQL.g:634:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names3411); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names3417);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop61;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:639:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:640:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:640:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node3444); if (state.failed) return ret;
			// PhoenixSQL.g:640:14: (v= VIEW | TABLE )
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==VIEW) ) {
				alt62=1;
			}
			else if ( (LA62_0==TABLE) ) {
				alt62=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}

			switch (alt62) {
				case 1 :
					// PhoenixSQL.g:640:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node3449); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:640:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node3453); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:640:31: ( IF ex= EXISTS )?
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==IF) ) {
				alt63=1;
			}
			switch (alt63) {
				case 1 :
					// PhoenixSQL.g:640:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node3457); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node3461); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node3467);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:640:65: (c= CASCADE )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==CASCADE) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// PhoenixSQL.g:640:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node3472); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:644:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:645:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:645:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node3507); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node3509); if (state.failed) return ret;
			// PhoenixSQL.g:645:21: ( IF ex= EXISTS )?
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==IF) ) {
				alt65=1;
			}
			switch (alt65) {
				case 1 :
					// PhoenixSQL.g:645:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node3512); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node3516); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3522);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:645:50: (c= CASCADE )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==CASCADE) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// PhoenixSQL.g:645:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3527); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:651:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:652:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:652:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3562); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3564); if (state.failed) return ret;
			// PhoenixSQL.g:652:18: ( IF ex= EXISTS )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==IF) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// PhoenixSQL.g:652:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3567); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3571); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3577);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3579); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3583);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:657:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token isRebuildAll=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:658:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) )
			// PhoenixSQL.g:658:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3613); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3615); if (state.failed) return ret;
			// PhoenixSQL.g:658:19: ( IF ex= EXISTS )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==IF) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// PhoenixSQL.g:658:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3618); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3622); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3628);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3630); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3634);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:659:7: ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			// PhoenixSQL.g:659:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )?
			{
			// PhoenixSQL.g:659:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) )
			// PhoenixSQL.g:659:9: s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			{
			// PhoenixSQL.g:659:11: ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			int alt70=5;
			switch ( input.LA(1) ) {
			case USABLE:
				{
				alt70=1;
				}
				break;
			case UNUSABLE:
				{
				alt70=2;
				}
				break;
			case REBUILD:
				{
				alt70=3;
				}
				break;
			case DISABLE:
				{
				alt70=4;
				}
				break;
			case ACTIVE:
				{
				alt70=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}
			switch (alt70) {
				case 1 :
					// PhoenixSQL.g:659:12: USABLE
					{
					s=(Token)match(input,USABLE,FOLLOW_USABLE_in_alter_index_node3647); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:659:21: UNUSABLE
					{
					s=(Token)match(input,UNUSABLE,FOLLOW_UNUSABLE_in_alter_index_node3651); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:659:32: REBUILD (isRebuildAll= ALL )?
					{
					s=(Token)match(input,REBUILD,FOLLOW_REBUILD_in_alter_index_node3655); if (state.failed) return ret;
					// PhoenixSQL.g:659:40: (isRebuildAll= ALL )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==ALL) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// PhoenixSQL.g:659:41: isRebuildAll= ALL
							{
							isRebuildAll=(Token)match(input,ALL,FOLLOW_ALL_in_alter_index_node3660); if (state.failed) return ret;
							}
							break;

					}

					}
					break;
				case 4 :
					// PhoenixSQL.g:659:62: DISABLE
					{
					s=(Token)match(input,DISABLE,FOLLOW_DISABLE_in_alter_index_node3666); if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:659:72: ACTIVE
					{
					s=(Token)match(input,ACTIVE,FOLLOW_ACTIVE_in_alter_index_node3670); if (state.failed) return ret;
					}
					break;

			}

			}

			// PhoenixSQL.g:659:81: (async= ASYNC )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==ASYNC) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:659:82: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node3677); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:659:96: ( ( ( SET )? ) p= fam_properties )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==NAME||LA73_0==SET) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:659:97: ( ( SET )? ) p= fam_properties
					{
					// PhoenixSQL.g:659:97: ( ( SET )? )
					// PhoenixSQL.g:659:98: ( SET )?
					{
					// PhoenixSQL.g:659:98: ( SET )?
					int alt72=2;
					int LA72_0 = input.LA(1);
					if ( (LA72_0==SET) ) {
						alt72=1;
					}
					switch (alt72) {
						case 1 :
							// PhoenixSQL.g:659:98: SET
							{
							match(input,SET,FOLLOW_SET_in_alter_index_node3683); if (state.failed) return ret;
							}
							break;

					}

					}

					pushFollow(FOLLOW_fam_properties_in_alter_index_node3688);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), isRebuildAll!=null, async!=null, p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:664:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:665:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:665:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node3723); if (state.failed) return ret;
			// PhoenixSQL.g:665:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==ON) ) {
				alt75=1;
			}
			else if ( (LA75_0==OFF) ) {
				alt75=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 75, 0, input);
				throw nvae;
			}

			switch (alt75) {
				case 1 :
					// PhoenixSQL.g:665:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:665:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:665:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node3731); if (state.failed) return ret;
					// PhoenixSQL.g:665:28: ( WITH SAMPLING s= sampling_rate )?
					int alt74=2;
					int LA74_0 = input.LA(1);
					if ( (LA74_0==WITH) ) {
						alt74=1;
					}
					switch (alt74) {
						case 1 :
							// PhoenixSQL.g:665:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node3736); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node3738); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node3744);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:665:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node3755); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:670:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:671:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:671:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node3789); if (state.failed) return ret;
			// PhoenixSQL.g:671:16: ( OR replace= REPLACE )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==OR) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// PhoenixSQL.g:671:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node3792); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node3796); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:671:38: (temp= TEMPORARY )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==TEMPORARY) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// PhoenixSQL.g:671:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node3803); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node3807); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3811);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:672:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:672:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node3822); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node3826);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node3828); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node3838); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3842);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node3844); if (state.failed) return ret;
			// PhoenixSQL.g:673:32: (className= jar_path )
			// PhoenixSQL.g:673:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node3850);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:674:8: ( USING JAR (jarPath= jar_path ) )?
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==USING) ) {
				alt78=1;
			}
			switch (alt78) {
				case 1 :
					// PhoenixSQL.g:674:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node3861); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node3863); if (state.failed) return ret;
					// PhoenixSQL.g:674:19: (jarPath= jar_path )
					// PhoenixSQL.g:674:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node3870);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:680:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:681:5: (l= literal )
			// PhoenixSQL.g:681:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path3907);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:684:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:685:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:685:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node3930); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node3932); if (state.failed) return ret;
			// PhoenixSQL.g:685:21: ( IF ex= EXISTS )?
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==IF) ) {
				alt79=1;
			}
			switch (alt79) {
				case 1 :
					// PhoenixSQL.g:685:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node3935); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node3939); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node3945);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:688:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:689:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:689:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node3968); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node3970); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node3976);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:692:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:693:5: ( LIST JARS )
			// PhoenixSQL.g:693:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node3999); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node4001); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:696:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:697:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:697:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node4024); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node4026); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node4032);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:701:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:702:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:702:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node4058); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node4060); if (state.failed) return ret;
			// PhoenixSQL.g:702:23: ( SET p= properties )
			// PhoenixSQL.g:702:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node4063); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node4067);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:707:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token cas=null;
		Token all=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> d =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<NamedNode> list =null;

		try {
			// PhoenixSQL.g:708:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) )
			// PhoenixSQL.g:708:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node4101); if (state.failed) return ret;
			// PhoenixSQL.g:708:15: ( TABLE |v= VIEW )
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==TABLE) ) {
				alt80=1;
			}
			else if ( (LA80_0==VIEW) ) {
				alt80=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 80, 0, input);
				throw nvae;
			}

			switch (alt80) {
				case 1 :
					// PhoenixSQL.g:708:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node4104); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:708:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node4110); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node4115);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:709:9: ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			int alt86=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt86=1;
				}
				break;
			case ADD:
				{
				alt86=2;
				}
				break;
			case SET:
				{
				alt86=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 86, 0, input);
				throw nvae;
			}
			switch (alt86) {
				case 1 :
					// PhoenixSQL.g:709:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					{
					// PhoenixSQL.g:709:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					// PhoenixSQL.g:709:12: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node4128); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node4130); if (state.failed) return ret;
					// PhoenixSQL.g:709:24: ( IF ex= EXISTS )?
					int alt81=2;
					int LA81_0 = input.LA(1);
					if ( (LA81_0==IF) ) {
						alt81=1;
					}
					switch (alt81) {
						case 1 :
							// PhoenixSQL.g:709:25: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node4133); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node4137); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node4143);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:709:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					{
					// PhoenixSQL.g:709:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					// PhoenixSQL.g:709:59: ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )?
					{
					match(input,ADD,FOLLOW_ADD_in_alter_table_node4149); if (state.failed) return ret;
					// PhoenixSQL.g:709:63: ( IF NOT ex= EXISTS )?
					int alt82=2;
					int LA82_0 = input.LA(1);
					if ( (LA82_0==IF) ) {
						alt82=1;
					}
					switch (alt82) {
						case 1 :
							// PhoenixSQL.g:709:64: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node4152); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node4154); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node4158); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:709:83: (d= column_defs )
					// PhoenixSQL.g:709:84: d= column_defs
					{
					pushFollow(FOLLOW_column_defs_in_alter_table_node4165);
					d=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					}

					// PhoenixSQL.g:709:99: (p= fam_properties )?
					int alt83=2;
					int LA83_0 = input.LA(1);
					if ( (LA83_0==NAME) ) {
						alt83=1;
					}
					switch (alt83) {
						case 1 :
							// PhoenixSQL.g:709:100: p= fam_properties
							{
							pushFollow(FOLLOW_fam_properties_in_alter_table_node4171);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					// PhoenixSQL.g:709:120: (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					int alt85=2;
					int LA85_0 = input.LA(1);
					if ( (LA85_0==CASCADE) ) {
						alt85=1;
					}
					switch (alt85) {
						case 1 :
							// PhoenixSQL.g:709:121: cas= CASCADE INDEX (list= indexes |all= ALL )
							{
							cas=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_alter_table_node4179); if (state.failed) return ret;
							match(input,INDEX,FOLLOW_INDEX_in_alter_table_node4181); if (state.failed) return ret;
							// PhoenixSQL.g:709:139: (list= indexes |all= ALL )
							int alt84=2;
							int LA84_0 = input.LA(1);
							if ( (LA84_0==NAME) ) {
								alt84=1;
							}
							else if ( (LA84_0==ALL) ) {
								alt84=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 84, 0, input);
								throw nvae;
							}

							switch (alt84) {
								case 1 :
									// PhoenixSQL.g:709:140: list= indexes
									{
									pushFollow(FOLLOW_indexes_in_alter_table_node4186);
									list=indexes();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:709:155: all= ALL
									{
									all=(Token)match(input,ALL,FOLLOW_ALL_in_alter_table_node4192); if (state.failed) return ret;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 3 :
					// PhoenixSQL.g:709:168: ( SET (p= fam_properties ) )
					{
					// PhoenixSQL.g:709:168: ( SET (p= fam_properties ) )
					// PhoenixSQL.g:709:169: SET (p= fam_properties )
					{
					match(input,SET,FOLLOW_SET_in_alter_table_node4200); if (state.failed) return ret;
					// PhoenixSQL.g:709:173: (p= fam_properties )
					// PhoenixSQL.g:709:174: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_alter_table_node4205);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { PTableType tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW; ret = ( c == null ? factory.addColumn(factory.namedTable(null,t), tt, d, ex!=null, p, cas!=null, (all == null ? list : null)) : factory.dropColumn(factory.namedTable(null,t), tt, c, ex!=null) ); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:713:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:714:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:714:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node4239); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node4241); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node4245);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:714:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt87=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt87=1;
					}
					break;
				case ALL:
					{
					alt87=2;
					}
					break;
				case COLUMNS:
					{
					alt87=3;
					}
					break;
			}
			switch (alt87) {
				case 1 :
					// PhoenixSQL.g:714:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node4250); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:714:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node4256); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:714:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node4262); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:714:73: ( SET (p= properties ) )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==SET) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// PhoenixSQL.g:714:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node4267); if (state.failed) return ret;
					// PhoenixSQL.g:714:78: (p= properties )
					// PhoenixSQL.g:714:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node4272);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:718:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:719:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:719:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node4296); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node4298); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:723:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:724:5: (p= identifier )
			// PhoenixSQL.g:724:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name4324);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:727:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:729:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:729:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties4358);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties4360); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties4364);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:729:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop89:
			while (true) {
				int alt89=2;
				int LA89_0 = input.LA(1);
				if ( (LA89_0==COMMA) ) {
					alt89=1;
				}

				switch (alt89) {
				case 1 :
					// PhoenixSQL.g:729:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties4370); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties4374);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties4376); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties4380);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop89;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:732:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:734:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:734:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs4415);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:734:39: ( COMMA v= column_def )*
			loop90:
			while (true) {
				int alt90=2;
				int LA90_0 = input.LA(1);
				if ( (LA90_0==COMMA) ) {
					int LA90_1 = input.LA(2);
					if ( (LA90_1==NAME) ) {
						alt90=1;
					}

				}

				switch (alt90) {
				case 1 :
					// PhoenixSQL.g:734:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs4421); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs4427);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop90;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "initializiation_list"
	// PhoenixSQL.g:737:1: initializiation_list returns [Map<String, Integer> ret] : k= STRING_LITERAL EQ v= NUMBER ( COMMA k= STRING_LITERAL EQ v= NUMBER )* ;
	public final Map<String, Integer> initializiation_list() throws RecognitionException {
		Map<String, Integer> ret = null;


		Token k=null;
		Token v=null;

		ret = new HashMap<String,Integer>(); 
		try {
			// PhoenixSQL.g:739:5: (k= STRING_LITERAL EQ v= NUMBER ( COMMA k= STRING_LITERAL EQ v= NUMBER )* )
			// PhoenixSQL.g:739:9: k= STRING_LITERAL EQ v= NUMBER ( COMMA k= STRING_LITERAL EQ v= NUMBER )*
			{
			k=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_initializiation_list4457); if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_initializiation_list4459); if (state.failed) return ret;
			v=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_initializiation_list4463); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k.getText(), Integer.parseInt( v.getText() ));}
			// PhoenixSQL.g:740:9: ( COMMA k= STRING_LITERAL EQ v= NUMBER )*
			loop91:
			while (true) {
				int alt91=2;
				int LA91_0 = input.LA(1);
				if ( (LA91_0==COMMA) ) {
					alt91=1;
				}

				switch (alt91) {
				case 1 :
					// PhoenixSQL.g:740:10: COMMA k= STRING_LITERAL EQ v= NUMBER
					{
					match(input,COMMA,FOLLOW_COMMA_in_initializiation_list4476); if (state.failed) return ret;
					k=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_initializiation_list4480); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_initializiation_list4482); if (state.failed) return ret;
					v=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_initializiation_list4486); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k.getText(), Integer.parseInt( v.getText() ));}
					}
					break;

				default :
					break loop91;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "initializiation_list"



	// $ANTLR start "indexes"
	// PhoenixSQL.g:743:1: indexes returns [List<NamedNode> ret] : v= index_name ( COMMA v= index_name )* ;
	public final List<NamedNode> indexes() throws RecognitionException {
		List<NamedNode> ret = null;


		NamedNode v =null;

		ret = new ArrayList<NamedNode>(); 
		try {
			// PhoenixSQL.g:745:5: (v= index_name ( COMMA v= index_name )* )
			// PhoenixSQL.g:745:8: v= index_name ( COMMA v= index_name )*
			{
			pushFollow(FOLLOW_index_name_in_indexes4521);
			v=index_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:745:39: ( COMMA v= index_name )*
			loop92:
			while (true) {
				int alt92=2;
				int LA92_0 = input.LA(1);
				if ( (LA92_0==COMMA) ) {
					alt92=1;
				}

				switch (alt92) {
				case 1 :
					// PhoenixSQL.g:745:40: COMMA v= index_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_indexes4527); if (state.failed) return ret;
					pushFollow(FOLLOW_index_name_in_indexes4533);
					v=index_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop92;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "indexes"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:748:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		Token eq=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:749:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )? )
			// PhoenixSQL.g:749:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )?
			{
			pushFollow(FOLLOW_column_name_in_column_def4559);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def4563);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:749:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==LPAREN) ) {
				alt94=1;
			}
			switch (alt94) {
				case 1 :
					// PhoenixSQL.g:749:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def4566); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4570); if (state.failed) return ret;
					// PhoenixSQL.g:749:54: ( COMMA s= NUMBER )?
					int alt93=2;
					int LA93_0 = input.LA(1);
					if ( (LA93_0==COMMA) ) {
						alt93=1;
					}
					switch (alt93) {
						case 1 :
							// PhoenixSQL.g:749:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def4573); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4577); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def4581); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:749:83: (ar= ARRAY )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==ARRAY) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// PhoenixSQL.g:749:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def4587); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:749:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==LSQUARE) ) {
				alt97=1;
			}
			switch (alt97) {
				case 1 :
					// PhoenixSQL.g:749:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def4593); if (state.failed) return ret;
					// PhoenixSQL.g:749:104: (a= NUMBER )?
					int alt96=2;
					int LA96_0 = input.LA(1);
					if ( (LA96_0==NUMBER) ) {
						alt96=1;
					}
					switch (alt96) {
						case 1 :
							// PhoenixSQL.g:749:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4598); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def4602); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:749:126: ( (nn= NOT )? n= NULL )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==NOT||LA99_0==NULL) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// PhoenixSQL.g:749:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:749:129: (nn= NOT )?
					int alt98=2;
					int LA98_0 = input.LA(1);
					if ( (LA98_0==NOT) ) {
						alt98=1;
					}
					switch (alt98) {
						case 1 :
							// PhoenixSQL.g:749:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def4609); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def4614); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:749:144: ( DEFAULT df= expression )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==DEFAULT) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:749:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def4619); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def4623);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:749:169: ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )?
			int alt103=3;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==PRIMARY) ) {
				alt103=1;
			}
			else if ( (LA103_0==ENCODED_QUALIFIER) ) {
				alt103=2;
			}
			switch (alt103) {
				case 1 :
					// PhoenixSQL.g:749:170: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
					{
					// PhoenixSQL.g:749:170: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
					// PhoenixSQL.g:749:171: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def4631); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def4633); if (state.failed) return ret;
					// PhoenixSQL.g:749:186: (order= ASC |order= DESC )?
					int alt101=3;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==ASC) ) {
						alt101=1;
					}
					else if ( (LA101_0==DESC) ) {
						alt101=2;
					}
					switch (alt101) {
						case 1 :
							// PhoenixSQL.g:749:187: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def4638); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:749:197: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def4642); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:749:212: (rr= ROW_TIMESTAMP )?
					int alt102=2;
					int LA102_0 = input.LA(1);
					if ( (LA102_0==ROW_TIMESTAMP) ) {
						alt102=1;
					}
					switch (alt102) {
						case 1 :
							// PhoenixSQL.g:749:212: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def4648); if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:749:229: ( ENCODED_QUALIFIER eq= NUMBER )
					{
					// PhoenixSQL.g:749:229: ( ENCODED_QUALIFIER eq= NUMBER )
					// PhoenixSQL.g:749:230: ENCODED_QUALIFIER eq= NUMBER
					{
					match(input,ENCODED_QUALIFIER,FOLLOW_ENCODED_QUALIFIER_in_column_def4653); if (state.failed) return ret;
					eq=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4657); if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(
			            c,
			            dt,
			            ar != null || lsq != null,
			            a == null ? null :  Integer.parseInt( a.getText() ),
			            nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            eq == null ? null : Integer.parseInt( eq.getText() ),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:765:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:767:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:767:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4700);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:767:43: ( COMMA v= dyn_column_def )*
			loop104:
			while (true) {
				int alt104=2;
				int LA104_0 = input.LA(1);
				if ( (LA104_0==COMMA) ) {
					alt104=1;
				}

				switch (alt104) {
				case 1 :
					// PhoenixSQL.g:767:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs4706); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4712);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop104;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:770:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:771:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:771:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def4738);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def4742);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:771:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==LPAREN) ) {
				alt106=1;
			}
			switch (alt106) {
				case 1 :
					// PhoenixSQL.g:771:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def4745); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4749); if (state.failed) return ret;
					// PhoenixSQL.g:771:54: ( COMMA s= NUMBER )?
					int alt105=2;
					int LA105_0 = input.LA(1);
					if ( (LA105_0==COMMA) ) {
						alt105=1;
					}
					switch (alt105) {
						case 1 :
							// PhoenixSQL.g:771:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def4752); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4756); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def4760); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:771:83: (ar= ARRAY )?
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==ARRAY) ) {
				alt107=1;
			}
			switch (alt107) {
				case 1 :
					// PhoenixSQL.g:771:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def4766); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:771:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==LSQUARE) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// PhoenixSQL.g:771:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def4772); if (state.failed) return ret;
					// PhoenixSQL.g:771:104: (a= NUMBER )?
					int alt108=2;
					int LA108_0 = input.LA(1);
					if ( (LA108_0==NUMBER) ) {
						alt108=1;
					}
					switch (alt108) {
						case 1 :
							// PhoenixSQL.g:771:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4777); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def4781); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:780:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:781:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:781:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def4818);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:781:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==NAME) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// PhoenixSQL.g:781:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def4823);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:781:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt111=2;
					int LA111_0 = input.LA(1);
					if ( (LA111_0==LPAREN) ) {
						alt111=1;
					}
					switch (alt111) {
						case 1 :
							// PhoenixSQL.g:781:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def4826); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4830); if (state.failed) return ret;
							// PhoenixSQL.g:781:55: ( COMMA s= NUMBER )?
							int alt110=2;
							int LA110_0 = input.LA(1);
							if ( (LA110_0==COMMA) ) {
								alt110=1;
							}
							switch (alt110) {
								case 1 :
									// PhoenixSQL.g:781:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def4833); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4837); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def4841); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:781:84: (ar= ARRAY )?
					int alt112=2;
					int LA112_0 = input.LA(1);
					if ( (LA112_0==ARRAY) ) {
						alt112=1;
					}
					switch (alt112) {
						case 1 :
							// PhoenixSQL.g:781:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def4847); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:781:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt114=2;
					int LA114_0 = input.LA(1);
					if ( (LA114_0==LSQUARE) ) {
						alt114=1;
					}
					switch (alt114) {
						case 1 :
							// PhoenixSQL.g:781:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def4853); if (state.failed) return ret;
							// PhoenixSQL.g:781:105: (a= NUMBER )?
							int alt113=2;
							int LA113_0 = input.LA(1);
							if ( (LA113_0==NUMBER) ) {
								alt113=1;
							}
							switch (alt113) {
								case 1 :
									// PhoenixSQL.g:781:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4858); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def4862); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:790:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:791:5: (s= select_node )
			// PhoenixSQL.g:791:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression4902);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:794:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:796:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:796:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select4935); if (state.failed) return ret;
			// PhoenixSQL.g:796:16: (h= hintClause )?
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==ML_HINT) ) {
				alt116=1;
			}
			switch (alt116) {
				case 1 :
					// PhoenixSQL.g:796:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select4940);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:797:9: (d= DISTINCT | ALL )?
			int alt117=3;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==DISTINCT) ) {
				alt117=1;
			}
			else if ( (LA117_0==ALL) ) {
				alt117=2;
			}
			switch (alt117) {
				case 1 :
					// PhoenixSQL.g:797:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select4956); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:797:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select4960); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select4966);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:798:9: ( FROM from= parseFrom )?
			int alt118=2;
			int LA118_0 = input.LA(1);
			if ( (LA118_0==FROM) ) {
				alt118=1;
			}
			switch (alt118) {
				case 1 :
					// PhoenixSQL.g:798:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select4977); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select4981);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:799:9: ( WHERE where= expression )?
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==WHERE) ) {
				alt119=1;
			}
			switch (alt119) {
				case 1 :
					// PhoenixSQL.g:799:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select4994); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4998);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:800:9: ( GROUP BY group= group_by )?
			int alt120=2;
			int LA120_0 = input.LA(1);
			if ( (LA120_0==GROUP) ) {
				alt120=1;
			}
			switch (alt120) {
				case 1 :
					// PhoenixSQL.g:800:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select5011); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select5013); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select5017);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:801:9: ( HAVING having= expression )?
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==HAVING) ) {
				alt121=1;
			}
			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:801:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select5030); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select5034);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:806:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:808:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:808:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects5078);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:808:39: ( UNION ALL s= single_select )*
			loop122:
			while (true) {
				int alt122=2;
				int LA122_0 = input.LA(1);
				if ( (LA122_0==UNION) ) {
					alt122=1;
				}

				switch (alt122) {
				case 1 :
					// PhoenixSQL.g:808:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects5083); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects5085); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects5089);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop122;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:812:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:814:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:814:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node5127);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:815:9: ( ORDER BY order= order_by )?
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==ORDER) ) {
				alt123=1;
			}
			switch (alt123) {
				case 1 :
					// PhoenixSQL.g:815:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node5138); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node5140); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node5144);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:816:9: ( LIMIT l= limit )?
			int alt124=2;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==LIMIT) ) {
				alt124=1;
			}
			switch (alt124) {
				case 1 :
					// PhoenixSQL.g:816:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node5157); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node5161);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:817:9: ( OFFSET o= offset )?
			int alt125=2;
			int LA125_0 = input.LA(1);
			if ( (LA125_0==OFFSET) ) {
				alt125=1;
			}
			switch (alt125) {
				case 1 :
					// PhoenixSQL.g:817:10: OFFSET o= offset
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node5174); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node5178);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:818:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt127=2;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==FETCH) ) {
				alt127=1;
			}
			switch (alt127) {
				case 1 :
					// PhoenixSQL.g:818:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node5191); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:818:31: (l= limit )?
					int alt126=2;
					int LA126_0 = input.LA(1);
					if ( (LA126_0==BIND_NAME||LA126_0==NUMBER||LA126_0==QUESTION) ) {
						alt126=1;
					}
					switch (alt126) {
						case 1 :
							// PhoenixSQL.g:818:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node5204);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node5216); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:824:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:825:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) )
			// PhoenixSQL.g:825:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node5255); if (state.failed) return ret;
			// PhoenixSQL.g:825:16: (hint= hintClause )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==ML_HINT) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// PhoenixSQL.g:825:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node5260);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node5264); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node5268);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:826:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt129=2;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==LPAREN) ) {
				alt129=1;
			}
			switch (alt129) {
				case 1 :
					// PhoenixSQL.g:826:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5279); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node5283);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5285); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:827:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==VALUES) ) {
				alt132=1;
			}
			else if ( (LA132_0==SELECT) ) {
				alt132=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 132, 0, input);
				throw nvae;
			}

			switch (alt132) {
				case 1 :
					// PhoenixSQL.g:827:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:827:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:827:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node5299); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5301); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node5305);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5307); if (state.failed) return ret;
					// PhoenixSQL.g:827:58: ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					int alt131=2;
					int LA131_0 = input.LA(1);
					if ( (LA131_0==ON) ) {
						alt131=1;
					}
					switch (alt131) {
						case 1 :
							// PhoenixSQL.g:827:60: ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node5311); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node5313); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node5315); if (state.failed) return ret;
							// PhoenixSQL.g:827:77: (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							int alt130=2;
							int LA130_0 = input.LA(1);
							if ( (LA130_0==IGNORE) ) {
								alt130=1;
							}
							else if ( (LA130_0==UPDATE) ) {
								alt130=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 130, 0, input);
								throw nvae;
							}

							switch (alt130) {
								case 1 :
									// PhoenixSQL.g:827:79: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node5321); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:827:91: ( UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:827:91: ( UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:827:93: UPDATE pairs= update_column_pairs
									{
									match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node5327); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node5331);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:827:137: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node5346);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:836:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:838:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:838:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5387);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:839:8: ( COMMA p= update_column_pair )*
			loop133:
			while (true) {
				int alt133=2;
				int LA133_0 = input.LA(1);
				if ( (LA133_0==COMMA) ) {
					alt133=1;
				}

				switch (alt133) {
				case 1 :
					// PhoenixSQL.g:839:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs5399); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5403);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop133;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:842:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:843:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:843:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair5428);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair5430); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair5434);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:847:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:849:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:849:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5463);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:850:8: ( COMMA d= dyn_column_name_or_def )*
			loop134:
			while (true) {
				int alt134=2;
				int LA134_0 = input.LA(1);
				if ( (LA134_0==COMMA) ) {
					alt134=1;
				}

				switch (alt134) {
				case 1 :
					// PhoenixSQL.g:850:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs5476); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5480);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop134;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:855:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:856:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:856:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node5508); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node5512);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node5514); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node5516); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node5520);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:860:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:861:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:861:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node5554); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node5558);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:864:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:865:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:865:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node5585); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node5589);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:868:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:869:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:869:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node5615); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node5617); if (state.failed) return ret;
			// PhoenixSQL.g:869:21: (a= NUMBER )?
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==NUMBER) ) {
				alt135=1;
			}
			switch (alt135) {
				case 1 :
					// PhoenixSQL.g:869:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node5622); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:869:33: ( ROW | ROWS )?
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( ((LA136_0 >= ROW && LA136_0 <= ROWS)) ) {
				alt136=1;
			}
			switch (alt136) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node5633); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node5637);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:873:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:874:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? )
			// PhoenixSQL.g:874:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node5663); if (state.failed) return ret;
			// PhoenixSQL.g:874:16: (hint= hintClause )?
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==ML_HINT) ) {
				alt137=1;
			}
			switch (alt137) {
				case 1 :
					// PhoenixSQL.g:874:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node5668);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node5672); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node5676);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:875:9: ( WHERE v= expression )?
			int alt138=2;
			int LA138_0 = input.LA(1);
			if ( (LA138_0==WHERE) ) {
				alt138=1;
			}
			switch (alt138) {
				case 1 :
					// PhoenixSQL.g:875:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node5687); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node5691);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:876:9: ( ORDER BY order= order_by )?
			int alt139=2;
			int LA139_0 = input.LA(1);
			if ( (LA139_0==ORDER) ) {
				alt139=1;
			}
			switch (alt139) {
				case 1 :
					// PhoenixSQL.g:876:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node5704); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node5706); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node5710);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:877:9: ( LIMIT l= limit )?
			int alt140=2;
			int LA140_0 = input.LA(1);
			if ( (LA140_0==LIMIT) ) {
				alt140=1;
			}
			switch (alt140) {
				case 1 :
					// PhoenixSQL.g:877:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node5723); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node5727);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:881:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:882:5: (b= bind_expression |l= int_or_long_literal )
			int alt141=2;
			int LA141_0 = input.LA(1);
			if ( (LA141_0==BIND_NAME||LA141_0==QUESTION) ) {
				alt141=1;
			}
			else if ( (LA141_0==NUMBER) ) {
				alt141=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}

			switch (alt141) {
				case 1 :
					// PhoenixSQL.g:882:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit5762);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:883:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit5774);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:886:1: offset returns [OffsetNode ret] : (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;
		List<ParseNode> lhs =null;
		List<ParseNode> rhs =null;

		try {
			// PhoenixSQL.g:887:2: (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN )
			int alt144=3;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case QUESTION:
				{
				alt144=1;
				}
				break;
			case NUMBER:
				{
				alt144=2;
				}
				break;
			case LPAREN:
				{
				alt144=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}
			switch (alt144) {
				case 1 :
					// PhoenixSQL.g:887:4: b= bind_expression ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_bind_expression_in_offset5800);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:887:22: ( ROW | ROWS )?
					int alt142=2;
					int LA142_0 = input.LA(1);
					if ( ((LA142_0 >= ROW && LA142_0 <= ROWS)) ) {
						alt142=1;
					}
					switch (alt142) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) {  try { ret = factory.offset(b); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 2 :
					// PhoenixSQL.g:888:7: l= int_or_long_literal ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset5821);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:888:29: ( ROW | ROWS )?
					int alt143=2;
					int LA143_0 = input.LA(1);
					if ( ((LA143_0 >= ROW && LA143_0 <= ROWS)) ) {
						alt143=1;
					}
					switch (alt143) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) { try { ret = factory.offset(l); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 3 :
					// PhoenixSQL.g:889:7: LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_offset5840); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset5844);
					lhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset5846); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_offset5848); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_offset5850); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset5854);
					rhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset5856); if (state.failed) return ret;
					if ( state.backtracking==0 ) { try { ret = factory.offset(factory.comparison(CompareOperator.EQUAL,factory.rowValueConstructor(lhs),factory.rowValueConstructor(rhs)));  } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:892:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:893:5: (l= literal )
			// PhoenixSQL.g:893:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate5881);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "tableSampleNode"
	// PhoenixSQL.g:896:1: tableSampleNode returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode tableSampleNode() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:897:5: (l= literal )
			// PhoenixSQL.g:897:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_tableSampleNode5906);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "tableSampleNode"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:900:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:901:5: (c= ML_HINT )
			// PhoenixSQL.g:901:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause5932); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:905:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:907:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt146=2;
			int LA146_0 = input.LA(1);
			if ( (LA146_0==ARRAY||LA146_0==BIND_NAME||LA146_0==BIN_LITERAL||(LA146_0 >= CASE && LA146_0 <= CAST)||LA146_0==CURRENT||LA146_0==DECIMAL||LA146_0==DOUBLE||LA146_0==EXISTS||LA146_0==FALSE||LA146_0==HEX_LITERAL||LA146_0==LPAREN||LA146_0==MINUS||(LA146_0 >= NAME && LA146_0 <= NEXT)||LA146_0==NOT||LA146_0==NULL||LA146_0==NUMBER||LA146_0==QUESTION||LA146_0==STRING_LITERAL||LA146_0==TRUE) ) {
				alt146=1;
			}
			else if ( (LA146_0==ASTERISK) ) {
				alt146=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 146, 0, input);
				throw nvae;
			}

			switch (alt146) {
				case 1 :
					// PhoenixSQL.g:907:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list5964);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:907:36: ( COMMA n= selectable )*
					loop145:
					while (true) {
						int alt145=2;
						int LA145_0 = input.LA(1);
						if ( (LA145_0==COMMA) ) {
							alt145=1;
						}

						switch (alt145) {
						case 1 :
							// PhoenixSQL.g:907:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list5969); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list5973);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop145;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:908:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list5985); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:912:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:913:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt148=3;
			int LA148_0 = input.LA(1);
			if ( (LA148_0==ARRAY||LA148_0==BIND_NAME||LA148_0==BIN_LITERAL||(LA148_0 >= CASE && LA148_0 <= CAST)||LA148_0==CURRENT||LA148_0==DECIMAL||LA148_0==DOUBLE||LA148_0==EXISTS||LA148_0==FALSE||LA148_0==HEX_LITERAL||LA148_0==LPAREN||LA148_0==MINUS||LA148_0==NEXT||LA148_0==NOT||LA148_0==NULL||LA148_0==NUMBER||LA148_0==QUESTION||LA148_0==STRING_LITERAL||LA148_0==TRUE) ) {
				alt148=1;
			}
			else if ( (LA148_0==NAME) ) {
				int LA148_2 = input.LA(2);
				if ( (LA148_2==EOF||LA148_2==AND||LA148_2==AS||LA148_2==ASTERISK||LA148_2==BETWEEN||LA148_2==COMMA||LA148_2==CONCAT||LA148_2==DIVIDE||LA148_2==EQ||LA148_2==FETCH||LA148_2==FROM||(LA148_2 >= GROUP && LA148_2 <= HAVING)||LA148_2==ILIKE||LA148_2==IN||LA148_2==IS||(LA148_2 >= LIKE && LA148_2 <= LIMIT)||(LA148_2 >= LPAREN && LA148_2 <= LT)||LA148_2==MINUS||LA148_2==NAME||(LA148_2 >= NOEQ1 && LA148_2 <= NOT)||LA148_2==OFFSET||(LA148_2 >= OR && LA148_2 <= ORDER)||(LA148_2 >= PERCENT && LA148_2 <= PLUS)||LA148_2==RPAREN||LA148_2==SEMICOLON||LA148_2==STRING_LITERAL||LA148_2==UNION||LA148_2==WHERE) ) {
					alt148=1;
				}
				else if ( (LA148_2==DOT) ) {
					int LA148_3 = input.LA(3);
					if ( (LA148_3==ASTERISK) ) {
						alt148=2;
					}
					else if ( (LA148_3==NAME) ) {
						int LA148_5 = input.LA(4);
						if ( (LA148_5==EOF||LA148_5==AND||LA148_5==AS||LA148_5==ASTERISK||LA148_5==BETWEEN||LA148_5==COMMA||LA148_5==CONCAT||LA148_5==DIVIDE||LA148_5==EQ||LA148_5==FETCH||LA148_5==FROM||(LA148_5 >= GROUP && LA148_5 <= HAVING)||LA148_5==ILIKE||LA148_5==IN||LA148_5==IS||(LA148_5 >= LIKE && LA148_5 <= LIMIT)||(LA148_5 >= LSQUARE && LA148_5 <= LT)||LA148_5==MINUS||LA148_5==NAME||(LA148_5 >= NOEQ1 && LA148_5 <= NOT)||LA148_5==OFFSET||(LA148_5 >= OR && LA148_5 <= ORDER)||(LA148_5 >= PERCENT && LA148_5 <= PLUS)||LA148_5==RPAREN||LA148_5==SEMICOLON||LA148_5==UNION||LA148_5==WHERE) ) {
							alt148=1;
						}
						else if ( (LA148_5==DOT) ) {
							int LA148_6 = input.LA(5);
							if ( (LA148_6==ASTERISK) ) {
								alt148=3;
							}
							else if ( (LA148_6==NAME) ) {
								alt148=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 148, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 148, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 148, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 148, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}

			switch (alt148) {
				case 1 :
					// PhoenixSQL.g:913:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable6014);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:913:26: (a= parseAlias )?
					int alt147=2;
					int LA147_0 = input.LA(1);
					if ( (LA147_0==AS||LA147_0==NAME) ) {
						alt147=1;
					}
					switch (alt147) {
						case 1 :
							// PhoenixSQL.g:913:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable6019);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:914:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable6034);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable6036); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable6038); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:915:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable6053);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable6055); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable6059);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable6061); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable6063); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:920:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:922:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:922:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by6096);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:923:9: ( COMMA expr= expression )*
			loop149:
			while (true) {
				int alt149=2;
				int LA149_0 = input.LA(1);
				if ( (LA149_0==COMMA) ) {
					alt149=1;
				}

				switch (alt149) {
				case 1 :
					// PhoenixSQL.g:923:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by6109); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by6115);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop149;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:927:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:929:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:929:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by6149);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:930:9: ( COMMA field= parseOrderByField )*
			loop150:
			while (true) {
				int alt150=2;
				int LA150_0 = input.LA(1);
				if ( (LA150_0==COMMA) ) {
					alt150=1;
				}

				switch (alt150) {
				case 1 :
					// PhoenixSQL.g:930:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by6162); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by6168);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop150;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:934:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:936:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:936:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:936:9: (expr= expression )
			// PhoenixSQL.g:936:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField6205);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:937:9: ( ASC | DESC )?
			int alt151=3;
			int LA151_0 = input.LA(1);
			if ( (LA151_0==ASC) ) {
				alt151=1;
			}
			else if ( (LA151_0==DESC) ) {
				alt151=2;
			}
			switch (alt151) {
				case 1 :
					// PhoenixSQL.g:937:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField6217); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:937:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField6223); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:938:9: ( NULLS ( FIRST | LAST ) )?
			int alt153=2;
			int LA153_0 = input.LA(1);
			if ( (LA153_0==NULLS) ) {
				alt153=1;
			}
			switch (alt153) {
				case 1 :
					// PhoenixSQL.g:938:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField6238); if (state.failed) return ret;
					// PhoenixSQL.g:938:16: ( FIRST | LAST )
					int alt152=2;
					int LA152_0 = input.LA(1);
					if ( (LA152_0==FIRST) ) {
						alt152=1;
					}
					else if ( (LA152_0==LAST) ) {
						alt152=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 152, 0, input);
						throw nvae;
					}

					switch (alt152) {
						case 1 :
							// PhoenixSQL.g:938:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField6241); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:938:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField6247); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:942:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:943:5: (t= table_list )
			// PhoenixSQL.g:943:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom6287);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:946:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:947:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:947:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list6318);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:947:33: ( COMMA s= table_ref )*
			loop154:
			while (true) {
				int alt154=2;
				int LA154_0 = input.LA(1);
				if ( (LA154_0==COMMA) ) {
					alt154=1;
				}

				switch (alt154) {
				case 1 :
					// PhoenixSQL.g:947:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list6323); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list6327);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop154;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:950:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:951:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:951:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref6351);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:951:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop155:
			while (true) {
				int alt155=2;
				int LA155_0 = input.LA(1);
				if ( (LA155_0==FULL||LA155_0==INNER||LA155_0==JOIN||LA155_0==LEFT||LA155_0==RIGHT) ) {
					alt155=1;
				}

				switch (alt155) {
				case 1 :
					// PhoenixSQL.g:951:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref6358);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref6360); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref6364);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref6366); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref6370);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop155;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:954:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		LiteralParseNode tableSample =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:955:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt164=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA164_1 = input.LA(2);
				if ( (LA164_1==BIND_NAME||LA164_1==LPAREN||LA164_1==NAME||LA164_1==QUESTION) ) {
					alt164=1;
				}
				else if ( (LA164_1==SELECT) ) {
					alt164=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 164, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt164=2;
				}
				break;
			case NAME:
				{
				alt164=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 164, 0, input);
				throw nvae;
			}
			switch (alt164) {
				case 1 :
					// PhoenixSQL.g:955:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6394); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor6398);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6400); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:956:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor6414);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:956:21: ( ( AS )? alias= identifier )?
					int alt157=2;
					int LA157_0 = input.LA(1);
					if ( (LA157_0==AS||LA157_0==NAME) ) {
						alt157=1;
					}
					switch (alt157) {
						case 1 :
							// PhoenixSQL.g:956:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:956:22: ( AS )?
							int alt156=2;
							int LA156_0 = input.LA(1);
							if ( (LA156_0==AS) ) {
								alt156=1;
							}
							switch (alt156) {
								case 1 :
									// PhoenixSQL.g:956:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6418); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6424);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:957:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor6441);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:957:27: ( ( AS )? alias= identifier )?
					int alt159=2;
					int LA159_0 = input.LA(1);
					if ( (LA159_0==AS||LA159_0==NAME) ) {
						alt159=1;
					}
					switch (alt159) {
						case 1 :
							// PhoenixSQL.g:957:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:957:28: ( AS )?
							int alt158=2;
							int LA158_0 = input.LA(1);
							if ( (LA158_0==AS) ) {
								alt158=1;
							}
							switch (alt158) {
								case 1 :
									// PhoenixSQL.g:957:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6445); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6451);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:957:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt160=2;
					int LA160_0 = input.LA(1);
					if ( (LA160_0==LPAREN) ) {
						alt160=1;
					}
					switch (alt160) {
						case 1 :
							// PhoenixSQL.g:957:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6456); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor6460);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6462); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:957:92: ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					int alt161=2;
					int LA161_0 = input.LA(1);
					if ( (LA161_0==TABLESAMPLE) ) {
						alt161=1;
					}
					switch (alt161) {
						case 1 :
							// PhoenixSQL.g:957:93: TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN
							{
							match(input,TABLESAMPLE,FOLLOW_TABLESAMPLE_in_table_factor6467); if (state.failed) return ret;
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6469); if (state.failed) return ret;
							pushFollow(FOLLOW_tableSampleNode_in_table_factor6473);
							tableSample=tableSampleNode();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6475); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs, tableSample);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:958:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6489); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor6493);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6495); if (state.failed) return ret;
					// PhoenixSQL.g:958:37: ( ( AS )? alias= identifier )?
					int alt163=2;
					int LA163_0 = input.LA(1);
					if ( (LA163_0==AS||LA163_0==NAME) ) {
						alt163=1;
					}
					switch (alt163) {
						case 1 :
							// PhoenixSQL.g:958:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:958:38: ( AS )?
							int alt162=2;
							int LA162_0 = input.LA(1);
							if ( (LA162_0==AS) ) {
								alt162=1;
							}
							switch (alt162) {
								case 1 :
									// PhoenixSQL.g:958:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6499); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6505);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:961:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:962:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt169=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt169=1;
				}
				break;
			case LEFT:
				{
				alt169=2;
				}
				break;
			case RIGHT:
				{
				alt169=3;
				}
				break;
			case FULL:
				{
				alt169=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 169, 0, input);
				throw nvae;
			}
			switch (alt169) {
				case 1 :
					// PhoenixSQL.g:962:9: ( INNER )?
					{
					// PhoenixSQL.g:962:9: ( INNER )?
					int alt165=2;
					int LA165_0 = input.LA(1);
					if ( (LA165_0==INNER) ) {
						alt165=1;
					}
					switch (alt165) {
						case 1 :
							// PhoenixSQL.g:962:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type6532); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:963:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type6547); if (state.failed) return ret;
					// PhoenixSQL.g:963:14: ( OUTER )?
					int alt166=2;
					int LA166_0 = input.LA(1);
					if ( (LA166_0==OUTER) ) {
						alt166=1;
					}
					switch (alt166) {
						case 1 :
							// PhoenixSQL.g:963:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6549); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:964:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type6564); if (state.failed) return ret;
					// PhoenixSQL.g:964:15: ( OUTER )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==OUTER) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// PhoenixSQL.g:964:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6566); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:965:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type6580); if (state.failed) return ret;
					// PhoenixSQL.g:965:15: ( OUTER )?
					int alt168=2;
					int LA168_0 = input.LA(1);
					if ( (LA168_0==OUTER) ) {
						alt168=1;
					}
					switch (alt168) {
						case 1 :
							// PhoenixSQL.g:965:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6583); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:968:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:969:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:969:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:969:9: ( AS )?
			int alt170=2;
			int LA170_0 = input.LA(1);
			if ( (LA170_0==AS) ) {
				alt170=1;
			}
			switch (alt170) {
				case 1 :
					// PhoenixSQL.g:969:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias6614); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias6619);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:973:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:974:5: (e= or_expression )
			// PhoenixSQL.g:974:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression6647);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:978:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:980:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:980:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression6679);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:980:38: ( OR i= and_expression )*
			loop171:
			while (true) {
				int alt171=2;
				int LA171_0 = input.LA(1);
				if ( (LA171_0==OR) ) {
					alt171=1;
				}

				switch (alt171) {
				case 1 :
					// PhoenixSQL.g:980:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression6684); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression6688);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop171;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:984:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:986:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:986:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression6724);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:986:38: ( AND i= not_expression )*
			loop172:
			while (true) {
				int alt172=2;
				int LA172_0 = input.LA(1);
				if ( (LA172_0==AND) ) {
					alt172=1;
				}

				switch (alt172) {
				case 1 :
					// PhoenixSQL.g:986:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression6729); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression6733);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop172;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:990:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:991:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt175=2;
			int LA175_0 = input.LA(1);
			if ( (LA175_0==NOT) ) {
				int LA175_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt175=1;
				}
				else if ( (true) ) {
					alt175=2;
				}

			}
			else if ( (LA175_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==HEX_LITERAL) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==BIN_LITERAL) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==NULL) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==NAME) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==CASE) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==LPAREN) ) {
				int LA175_17 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt175=1;
				}
				else if ( (true) ) {
					alt175=2;
				}

			}
			else if ( (LA175_0==CAST) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}
			else if ( (LA175_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt175=1;
			}

			switch (alt175) {
				case 1 :
					// PhoenixSQL.g:991:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:991:40: (n= NOT )?
					int alt173=2;
					int LA173_0 = input.LA(1);
					if ( (LA173_0==NOT) ) {
						alt173=1;
					}
					switch (alt173) {
						case 1 :
							// PhoenixSQL.g:991:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6775); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression6780);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:992:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:992:10: (n= NOT )?
					int alt174=2;
					int LA174_0 = input.LA(1);
					if ( (LA174_0==NOT) ) {
						alt174=1;
					}
					switch (alt174) {
						case 1 :
							// PhoenixSQL.g:992:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6794); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression6797); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression6801);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression6803); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:995:1: comparison_op returns [CompareOperator ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOperator comparison_op() throws RecognitionException {
		CompareOperator ret = null;


		try {
			// PhoenixSQL.g:996:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt176=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt176=1;
				}
				break;
			case LT:
				{
				int LA176_2 = input.LA(2);
				if ( (LA176_2==EQ) ) {
					alt176=4;
				}
				else if ( (LA176_2==ALL||(LA176_2 >= ANY && LA176_2 <= ARRAY)||LA176_2==BIND_NAME||LA176_2==BIN_LITERAL||(LA176_2 >= CASE && LA176_2 <= CAST)||LA176_2==CURRENT||LA176_2==DECIMAL||LA176_2==DOUBLE||LA176_2==FALSE||LA176_2==HEX_LITERAL||LA176_2==LPAREN||LA176_2==MINUS||(LA176_2 >= NAME && LA176_2 <= NEXT)||LA176_2==NULL||LA176_2==NUMBER||LA176_2==QUESTION||LA176_2==STRING_LITERAL||LA176_2==TRUE) ) {
					alt176=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 176, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA176_3 = input.LA(2);
				if ( (LA176_3==EQ) ) {
					alt176=5;
				}
				else if ( (LA176_3==ALL||(LA176_3 >= ANY && LA176_3 <= ARRAY)||LA176_3==BIND_NAME||LA176_3==BIN_LITERAL||(LA176_3 >= CASE && LA176_3 <= CAST)||LA176_3==CURRENT||LA176_3==DECIMAL||LA176_3==DOUBLE||LA176_3==FALSE||LA176_3==HEX_LITERAL||LA176_3==LPAREN||LA176_3==MINUS||(LA176_3 >= NAME && LA176_3 <= NEXT)||LA176_3==NULL||LA176_3==NUMBER||LA176_3==QUESTION||LA176_3==STRING_LITERAL||LA176_3==TRUE) ) {
					alt176=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 176, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt176=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 176, 0, input);
				throw nvae;
			}
			switch (alt176) {
				case 1 :
					// PhoenixSQL.g:996:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op6823); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:997:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6830); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:998:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6837); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:999:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6844); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6846); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1000:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6853); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6855); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1001:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOperator.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:1004:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOperator op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:1005:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==ARRAY||LA185_0==BIND_NAME||LA185_0==BIN_LITERAL||(LA185_0 >= CASE && LA185_0 <= CAST)||LA185_0==CURRENT||LA185_0==DECIMAL||LA185_0==DOUBLE||LA185_0==FALSE||LA185_0==HEX_LITERAL||LA185_0==LPAREN||LA185_0==MINUS||(LA185_0 >= NAME && LA185_0 <= NEXT)||LA185_0==NULL||LA185_0==NUMBER||LA185_0==QUESTION||LA185_0==STRING_LITERAL||LA185_0==TRUE) ) {
				alt185=1;
			}
			else if ( (LA185_0==EXISTS) ) {
				alt185=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 185, 0, input);
				throw nvae;
			}

			switch (alt185) {
				case 1 :
					// PhoenixSQL.g:1005:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression6893);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1005:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt184=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt184=1;
						}
						break;
					case IS:
						{
						alt184=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt184=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case ASYNC:
					case CASCADE:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case ENCODED_QUALIFIER:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case SPLIT:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt184=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 184, 0, input);
						throw nvae;
					}
					switch (alt184) {
						case 1 :
							// PhoenixSQL.g:1005:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:1005:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:1005:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression6899);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:1005:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt179=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case BIN_LITERAL:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case HEX_LITERAL:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt179=1;
								}
								break;
							case LPAREN:
								{
								int LA179_2 = input.LA(2);
								if ( (LA179_2==ARRAY||LA179_2==BIND_NAME||LA179_2==BIN_LITERAL||(LA179_2 >= CASE && LA179_2 <= CAST)||LA179_2==CURRENT||LA179_2==DECIMAL||LA179_2==DOUBLE||LA179_2==EXISTS||LA179_2==FALSE||LA179_2==HEX_LITERAL||LA179_2==LPAREN||LA179_2==MINUS||(LA179_2 >= NAME && LA179_2 <= NEXT)||LA179_2==NOT||LA179_2==NULL||LA179_2==NUMBER||LA179_2==QUESTION||LA179_2==STRING_LITERAL||LA179_2==TRUE) ) {
									alt179=1;
								}
								else if ( (LA179_2==SELECT) ) {
									alt179=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 179, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA179_3 = input.LA(2);
								if ( (LA179_3==LPAREN) ) {
									int LA179_6 = input.LA(3);
									if ( (LA179_6==ARRAY||LA179_6==BIND_NAME||LA179_6==BIN_LITERAL||(LA179_6 >= CASE && LA179_6 <= CAST)||LA179_6==CURRENT||LA179_6==DECIMAL||LA179_6==DOUBLE||LA179_6==FALSE||LA179_6==HEX_LITERAL||LA179_6==LPAREN||LA179_6==MINUS||(LA179_6 >= NAME && LA179_6 <= NEXT)||LA179_6==NULL||LA179_6==NUMBER||LA179_6==QUESTION||LA179_6==STRING_LITERAL||LA179_6==TRUE) ) {
										alt179=3;
									}
									else if ( (LA179_6==SELECT) ) {
										alt179=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 179, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 179, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA179_4 = input.LA(2);
								if ( (LA179_4==LPAREN) ) {
									int LA179_6 = input.LA(3);
									if ( (LA179_6==ARRAY||LA179_6==BIND_NAME||LA179_6==BIN_LITERAL||(LA179_6 >= CASE && LA179_6 <= CAST)||LA179_6==CURRENT||LA179_6==DECIMAL||LA179_6==DOUBLE||LA179_6==FALSE||LA179_6==HEX_LITERAL||LA179_6==LPAREN||LA179_6==MINUS||(LA179_6 >= NAME && LA179_6 <= NEXT)||LA179_6==NULL||LA179_6==NUMBER||LA179_6==QUESTION||LA179_6==STRING_LITERAL||LA179_6==TRUE) ) {
										alt179=3;
									}
									else if ( (LA179_6==SELECT) ) {
										alt179=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 179, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 179, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 179, 0, input);
								throw nvae;
							}
							switch (alt179) {
								case 1 :
									// PhoenixSQL.g:1005:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression6904);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:1005:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:1005:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:1005:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6909); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6913);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6915); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:1005:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:1005:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:1005:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:1005:110: (all= ALL |any= ANY )
									int alt177=2;
									int LA177_0 = input.LA(1);
									if ( (LA177_0==ALL) ) {
										alt177=1;
									}
									else if ( (LA177_0==ANY) ) {
										alt177=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 177, 0, input);
										throw nvae;
									}

									switch (alt177) {
										case 1 :
											// PhoenixSQL.g:1005:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6924); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:1005:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6930); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6933); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6937);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6939); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:1005:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:1005:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:1005:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:1005:168: (all= ALL |any= ANY )
									int alt178=2;
									int LA178_0 = input.LA(1);
									if ( (LA178_0==ALL) ) {
										alt178=1;
									}
									else if ( (LA178_0==ANY) ) {
										alt178=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 178, 0, input);
										throw nvae;
									}

									switch (alt178) {
										case 1 :
											// PhoenixSQL.g:1005:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6949); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:1005:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6955); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6958); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6962);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6964); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:1006:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:1006:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:1006:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression6994); if (state.failed) return ret;
							// PhoenixSQL.g:1006:27: (n= NOT )?
							int alt180=2;
							int LA180_0 = input.LA(1);
							if ( (LA180_0==NOT) ) {
								alt180=1;
							}
							switch (alt180) {
								case 1 :
									// PhoenixSQL.g:1006:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6998); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression7001); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:1007:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:1007:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:1007:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:1007:25: (n= NOT )?
							int alt181=2;
							int LA181_0 = input.LA(1);
							if ( (LA181_0==NOT) ) {
								alt181=1;
							}
							switch (alt181) {
								case 1 :
									// PhoenixSQL.g:1007:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression7032); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:1007:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt183=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt183=1;
								}
								break;
							case ILIKE:
								{
								alt183=2;
								}
								break;
							case BETWEEN:
								{
								alt183=3;
								}
								break;
							case IN:
								{
								alt183=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 183, 0, input);
								throw nvae;
							}
							switch (alt183) {
								case 1 :
									// PhoenixSQL.g:1007:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:1007:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:1007:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression7037); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7041);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:1008:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:1008:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:1008:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression7079); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7083);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:1009:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:1009:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:1009:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression7121); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7125);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression7127); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7131);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:1010:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:1010:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:1010:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:1010:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:1010:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression7170); if (state.failed) return ret;
									// PhoenixSQL.g:1010:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt182=3;
									int LA182_0 = input.LA(1);
									if ( (LA182_0==BIND_NAME||LA182_0==QUESTION) ) {
										alt182=1;
									}
									else if ( (LA182_0==LPAREN) ) {
										int LA182_2 = input.LA(2);
										if ( (LA182_2==SELECT) ) {
											alt182=2;
										}
										else if ( (LA182_2==ARRAY||LA182_2==BIND_NAME||LA182_2==BIN_LITERAL||(LA182_2 >= CASE && LA182_2 <= CAST)||LA182_2==CURRENT||LA182_2==DECIMAL||LA182_2==DOUBLE||LA182_2==EXISTS||LA182_2==FALSE||LA182_2==HEX_LITERAL||LA182_2==LPAREN||LA182_2==MINUS||(LA182_2 >= NAME && LA182_2 <= NEXT)||LA182_2==NOT||LA182_2==NULL||LA182_2==NUMBER||LA182_2==QUESTION||LA182_2==STRING_LITERAL||LA182_2==TRUE) ) {
											alt182=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 182, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 182, 0, input);
										throw nvae;
									}

									switch (alt182) {
										case 1 :
											// PhoenixSQL.g:1010:38: (r= bind_expression )
											{
											// PhoenixSQL.g:1010:38: (r= bind_expression )
											// PhoenixSQL.g:1010:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression7176);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:1011:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:1011:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:1011:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7217); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression7221);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7223); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:1012:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:1012:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:1012:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7264); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression7268);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7270); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:1015:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:1016:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression7370); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7372); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression7376);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7378); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:1019:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:1020:5: (b= bind_name )
			// PhoenixSQL.g:1020:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression7406);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:1023:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:1024:5: (i= add_expression )
			// PhoenixSQL.g:1024:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression7437);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:1027:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1029:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:1029:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression7468);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1029:43: ( PLUS i= subtract_expression )*
			loop186:
			while (true) {
				int alt186=2;
				int LA186_0 = input.LA(1);
				if ( (LA186_0==PLUS) ) {
					alt186=1;
				}

				switch (alt186) {
				case 1 :
					// PhoenixSQL.g:1029:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression7473); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression7477);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop186;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:1032:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1034:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:1034:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression7512);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1034:41: ( MINUS i= concat_expression )*
			loop187:
			while (true) {
				int alt187=2;
				int LA187_0 = input.LA(1);
				if ( (LA187_0==MINUS) ) {
					alt187=1;
				}

				switch (alt187) {
				case 1 :
					// PhoenixSQL.g:1034:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression7517); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression7521);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop187;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:1037:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1039:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:1039:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7556);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1039:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop188:
			while (true) {
				int alt188=2;
				int LA188_0 = input.LA(1);
				if ( (LA188_0==CONCAT) ) {
					alt188=1;
				}

				switch (alt188) {
				case 1 :
					// PhoenixSQL.g:1039:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression7561); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7565);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop188;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:1042:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:1044:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:1044:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7600);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:1045:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop189:
			while (true) {
				int alt189=2;
				int LA189_0 = input.LA(1);
				if ( (LA189_0==ASTERISK||LA189_0==DIVIDE||LA189_0==PERCENT) ) {
					alt189=1;
				}

				switch (alt189) {
				case 1 :
					// PhoenixSQL.g:1045:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7630);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop189;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:1056:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:1057:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:1057:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node7673); if (state.failed) return ret;
			// PhoenixSQL.g:1057:10: ( DEFAULT |s= identifier )
			int alt190=2;
			int LA190_0 = input.LA(1);
			if ( (LA190_0==DEFAULT) ) {
				alt190=1;
			}
			else if ( (LA190_0==NAME) ) {
				alt190=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 190, 0, input);
				throw nvae;
			}

			switch (alt190) {
				case 1 :
					// PhoenixSQL.g:1057:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node7676); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:1057:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node7682);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:1061:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:1062:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:1062:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:1062:10: (m= MINUS )?
			int alt191=2;
			int LA191_0 = input.LA(1);
			if ( (LA191_0==MINUS) ) {
				alt191=1;
			}
			switch (alt191) {
				case 1 :
					// PhoenixSQL.g:1062:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression7718); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression7723);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:1066:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:1067:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:1067:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression7751);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1067:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt192=2;
			int LA192_0 = input.LA(1);
			if ( (LA192_0==LSQUARE) ) {
				alt192=1;
			}
			switch (alt192) {
				case 1 :
					// PhoenixSQL.g:1067:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression7754); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression7758);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression7760); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:1070:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:1071:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt199=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case BIN_LITERAL:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case HEX_LITERAL:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt199=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt199=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case ASYNC:
				case BETWEEN:
				case CACHE:
				case CASCADE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case ENCODED_QUALIFIER:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case SPLIT:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt199=2;
					}
					break;
				case DOT:
					{
					alt199=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt199=6;
						}
						break;
					case DISTINCT:
						{
						alt199=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case BIN_LITERAL:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case HEX_LITERAL:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt199=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 199, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 199, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt199=3;
				}
				break;
			case CASE:
				{
				alt199=8;
				}
				break;
			case LPAREN:
				{
				alt199=9;
				}
				break;
			case CAST:
				{
				alt199=10;
				}
				break;
			case NEXT:
				{
				int LA199_7 = input.LA(2);
				if ( (LA199_7==VALUE) ) {
					alt199=11;
				}
				else if ( (LA199_7==BIND_NAME||LA199_7==BIN_LITERAL||LA199_7==DECIMAL||LA199_7==DOUBLE||LA199_7==FALSE||LA199_7==HEX_LITERAL||LA199_7==NAME||LA199_7==NULL||LA199_7==NUMBER||LA199_7==QUESTION||LA199_7==STRING_LITERAL||LA199_7==TRUE) ) {
					alt199=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 199, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt199=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 199, 0, input);
				throw nvae;
			}
			switch (alt199) {
				case 1 :
					// PhoenixSQL.g:1071:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term7793);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1072:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term7807);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1073:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7821); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term7823); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7827);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term7829); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:1074:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term7843);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term7845); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7849);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1075:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term7863);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7865); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7869);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7871); if (state.failed) return ret;
					// PhoenixSQL.g:1075:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt194=2;
					int LA194_0 = input.LA(1);
					if ( (LA194_0==WITHIN) ) {
						alt194=1;
					}
					switch (alt194) {
						case 1 :
							// PhoenixSQL.g:1075:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term7876); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term7878); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term7880); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term7882); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term7884); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term7888);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:1075:127: (a= ASC | DESC )
							int alt193=2;
							int LA193_0 = input.LA(1);
							if ( (LA193_0==ASC) ) {
								alt193=1;
							}
							else if ( (LA193_0==DESC) ) {
								alt193=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 193, 0, input);
								throw nvae;
							}

							switch (alt193) {
								case 1 :
									// PhoenixSQL.g:1075:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term7893); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:1075:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term7897); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term7900); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1084:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7925);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7927); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term7931); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7933); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1096:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7957);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7959); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term7963); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7967);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7969); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1105:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term7992);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1106:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term8004); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term8008);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term8010); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1115:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term8028); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term8030); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term8034);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term8036); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term8040);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1115:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt196=2;
					int LA196_0 = input.LA(1);
					if ( (LA196_0==LPAREN) ) {
						alt196=1;
					}
					switch (alt196) {
						case 1 :
							// PhoenixSQL.g:1115:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term8043); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term8047); if (state.failed) return ret;
							// PhoenixSQL.g:1115:73: ( COMMA scale= NUMBER )?
							int alt195=2;
							int LA195_0 = input.LA(1);
							if ( (LA195_0==COMMA) ) {
								alt195=1;
							}
							switch (alt195) {
								case 1 :
									// PhoenixSQL.g:1115:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term8050); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term8054); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term8058); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1115:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt197=3;
					int LA197_0 = input.LA(1);
					if ( (LA197_0==ARRAY) ) {
						alt197=1;
					}
					else if ( (LA197_0==LSQUARE) ) {
						alt197=2;
					}
					switch (alt197) {
						case 1 :
							// PhoenixSQL.g:1115:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term8065); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1115:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1115:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1115:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term8070); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term8072); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term8077); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1121:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1121:9: (n= NEXT | CURRENT )
					int alt198=2;
					int LA198_0 = input.LA(1);
					if ( (LA198_0==NEXT) ) {
						alt198=1;
					}
					else if ( (LA198_0==CURRENT) ) {
						alt198=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 198, 0, input);
						throw nvae;
					}

					switch (alt198) {
						case 1 :
							// PhoenixSQL.g:1121:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term8100); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1121:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term8104); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term8107); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term8109); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term8113);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1124:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1124:9: (n= NEXT )
					// PhoenixSQL.g:1124:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term8141); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term8146);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term8148); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term8150); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term8154);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1129:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1131:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1131:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions8199);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1131:39: ( COMMA e= expression )*
			loop200:
			while (true) {
				int alt200=2;
				int LA200_0 = input.LA(1);
				if ( (LA200_0==COMMA) ) {
					alt200=1;
				}

				switch (alt200) {
				case 1 :
					// PhoenixSQL.g:1131:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions8205); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions8211);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop200;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1134:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1136:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1136:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8242);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1136:49: ( COMMA jarPath= jar_path )*
			loop201:
			while (true) {
				int alt201=2;
				int LA201_0 = input.LA(1);
				if ( (LA201_0==COMMA) ) {
					alt201=1;
				}

				switch (alt201) {
				case 1 :
					// PhoenixSQL.g:1136:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths8248); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8254);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop201;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1139:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1141:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1141:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1141:8: (v= expression )?
			int alt202=2;
			int LA202_0 = input.LA(1);
			if ( (LA202_0==ARRAY||LA202_0==BIND_NAME||LA202_0==BIN_LITERAL||(LA202_0 >= CASE && LA202_0 <= CAST)||LA202_0==CURRENT||LA202_0==DECIMAL||LA202_0==DOUBLE||LA202_0==EXISTS||LA202_0==FALSE||LA202_0==HEX_LITERAL||LA202_0==LPAREN||LA202_0==MINUS||(LA202_0 >= NAME && LA202_0 <= NEXT)||LA202_0==NOT||LA202_0==NULL||LA202_0==NUMBER||LA202_0==QUESTION||LA202_0==STRING_LITERAL||LA202_0==TRUE) ) {
				alt202=1;
			}
			switch (alt202) {
				case 1 :
					// PhoenixSQL.g:1141:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8287);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1141:42: ( COMMA v= expression )*
			loop203:
			while (true) {
				int alt203=2;
				int LA203_0 = input.LA(1);
				if ( (LA203_0==COMMA) ) {
					alt203=1;
				}

				switch (alt203) {
				case 1 :
					// PhoenixSQL.g:1141:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions8295); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8301);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop203;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1144:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1146:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1146:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1146:7: (fa= function_argument )?
			int alt204=2;
			int LA204_0 = input.LA(1);
			if ( (LA204_0==NAME) ) {
				alt204=1;
			}
			switch (alt204) {
				case 1 :
					// PhoenixSQL.g:1146:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8332);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1146:49: ( COMMA fa= function_argument )*
			loop205:
			while (true) {
				int alt205=2;
				int LA205_0 = input.LA(1);
				if ( (LA205_0==COMMA) ) {
					alt205=1;
				}

				switch (alt205) {
				case 1 :
					// PhoenixSQL.g:1146:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types8339); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8345);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop205;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1149:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1150:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1150:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1150:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1150:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument8370);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1150:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt207=2;
			int LA207_0 = input.LA(1);
			if ( (LA207_0==LPAREN) ) {
				alt207=1;
			}
			switch (alt207) {
				case 1 :
					// PhoenixSQL.g:1150:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument8373); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8377); if (state.failed) return ret;
					// PhoenixSQL.g:1150:38: ( COMMA s= NUMBER )?
					int alt206=2;
					int LA206_0 = input.LA(1);
					if ( (LA206_0==COMMA) ) {
						alt206=1;
					}
					switch (alt206) {
						case 1 :
							// PhoenixSQL.g:1150:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument8380); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8384); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument8388); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1150:67: (ar= ARRAY )?
			int alt208=2;
			int LA208_0 = input.LA(1);
			if ( (LA208_0==ARRAY) ) {
				alt208=1;
			}
			switch (alt208) {
				case 1 :
					// PhoenixSQL.g:1150:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument8394); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1150:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt210=2;
			int LA210_0 = input.LA(1);
			if ( (LA210_0==LSQUARE) ) {
				alt210=1;
			}
			switch (alt210) {
				case 1 :
					// PhoenixSQL.g:1150:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument8400); if (state.failed) return ret;
					// PhoenixSQL.g:1150:88: (a= NUMBER )?
					int alt209=2;
					int LA209_0 = input.LA(1);
					if ( (LA209_0==NUMBER) ) {
						alt209=1;
					}
					switch (alt209) {
						case 1 :
							// PhoenixSQL.g:1150:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8405); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument8409); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1150:110: (c= CONSTANT )?
			int alt211=2;
			int LA211_0 = input.LA(1);
			if ( (LA211_0==CONSTANT) ) {
				alt211=1;
			}
			switch (alt211) {
				case 1 :
					// PhoenixSQL.g:1150:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument8418); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1150:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt212=2;
			int LA212_0 = input.LA(1);
			if ( (LA212_0==DEFAULTVALUE) ) {
				alt212=1;
			}
			switch (alt212) {
				case 1 :
					// PhoenixSQL.g:1150:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument8423); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8425); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8431);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1150:161: ( MINVALUE EQ minv= expression )?
			int alt213=2;
			int LA213_0 = input.LA(1);
			if ( (LA213_0==MINVALUE) ) {
				alt213=1;
			}
			switch (alt213) {
				case 1 :
					// PhoenixSQL.g:1150:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument8436); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8438); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8444);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1150:195: ( MAXVALUE EQ maxv= expression )?
			int alt214=2;
			int LA214_0 = input.LA(1);
			if ( (LA214_0==MAXVALUE) ) {
				alt214=1;
			}
			switch (alt214) {
				case 1 :
					// PhoenixSQL.g:1150:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument8450); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8452); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8458);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1157:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1159:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1159:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list8488); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list8494);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1159:52: ( COMMA e= value_expression )*
			loop215:
			while (true) {
				int alt215=2;
				int LA215_0 = input.LA(1);
				if ( (LA215_0==COMMA) ) {
					alt215=1;
				}

				switch (alt215) {
				case 1 :
					// PhoenixSQL.g:1159:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list8500); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list8506);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop215;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list8513); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1162:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1163:5: (name= identifier )
			// PhoenixSQL.g:1163:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name8534);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1166:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1167:5: (name= identifier )
			// PhoenixSQL.g:1167:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name8561);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1171:1: table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1172:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt216=2;
			int LA216_0 = input.LA(1);
			if ( (LA216_0==NAME) ) {
				int LA216_1 = input.LA(2);
				if ( (LA216_1==FROM||LA216_1==TO) ) {
					alt216=1;
				}
				else if ( (LA216_1==DOT) ) {
					int LA216_3 = input.LA(3);
					if ( (LA216_3==NAME) ) {
						switch ( input.LA(4) ) {
						case EOF:
						case AND:
						case AS:
						case ASC:
						case ASTERISK:
						case ASYNC:
						case BETWEEN:
						case CACHE:
						case CASCADE:
						case COMMA:
						case CONCAT:
						case CONSTRAINT:
						case CYCLE:
						case DESC:
						case DIVIDE:
						case ELSE:
						case ENCODED_QUALIFIER:
						case END:
						case EQ:
						case FETCH:
						case FULL:
						case GROUP:
						case GT:
						case HAVING:
						case ILIKE:
						case IN:
						case INCREMENT:
						case INNER:
						case IS:
						case JOIN:
						case LEFT:
						case LIKE:
						case LIMIT:
						case LSQUARE:
						case LT:
						case MAXVALUE:
						case MINUS:
						case MINVALUE:
						case NAME:
						case NOEQ1:
						case NOEQ2:
						case NOT:
						case NULLS:
						case OFFSET:
						case OR:
						case ORDER:
						case PERCENT:
						case PLUS:
						case PRIMARY:
						case RIGHT:
						case RPAREN:
						case RSQUARE:
						case SEMICOLON:
						case SPLIT:
						case THEN:
						case UNION:
						case WHEN:
						case WHERE:
							{
							alt216=1;
							}
							break;
						case FROM:
							{
							switch ( input.LA(5) ) {
							case BIND_NAME:
							case LPAREN:
							case QUESTION:
								{
								alt216=1;
								}
								break;
							case NAME:
								{
								int LA216_7 = input.LA(6);
								if ( (LA216_7==EOF||LA216_7==AS||LA216_7==COMMA||LA216_7==DOT||LA216_7==FETCH||LA216_7==FULL||LA216_7==GROUP||LA216_7==HAVING||LA216_7==INNER||LA216_7==JOIN||LA216_7==LEFT||LA216_7==LIMIT||LA216_7==LPAREN||LA216_7==NAME||LA216_7==OFFSET||LA216_7==ORDER||LA216_7==RIGHT||LA216_7==RPAREN||LA216_7==SEMICOLON||LA216_7==TABLESAMPLE||LA216_7==UNION||LA216_7==WHERE) ) {
									alt216=1;
								}
								else if ( (LA216_7==STRING_LITERAL) ) {
									alt216=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 216, 7, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case BIN_LITERAL:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case GROUP:
							case HEX_LITERAL:
							case NULL:
							case NUMBER:
							case STRING_LITERAL:
							case TRUE:
								{
								alt216=2;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 216, 5, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}
							}
							break;
						case DOT:
						case TO:
							{
							alt216=2;
							}
							break;
						default:
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 216, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 216, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 216, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 216, 0, input);
				throw nvae;
			}

			switch (alt216) {
				case 1 :
					// PhoenixSQL.g:1172:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name8589);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1173:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name8603);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name8605); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_table_name8609);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1177:1: from_table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1178:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt217=2;
			int LA217_0 = input.LA(1);
			if ( (LA217_0==NAME) ) {
				int LA217_1 = input.LA(2);
				if ( (LA217_1==EOF||(LA217_1 >= ACTIVE && LA217_1 <= ALL)||LA217_1==AND||(LA217_1 >= AS && LA217_1 <= ASYNC)||LA217_1==BETWEEN||(LA217_1 >= CACHE && LA217_1 <= CASCADE)||LA217_1==COLUMNS||LA217_1==COMMA||LA217_1==CONCAT||LA217_1==CONSTRAINT||LA217_1==CYCLE||LA217_1==DESC||LA217_1==DISABLE||LA217_1==DIVIDE||LA217_1==DROP||(LA217_1 >= ELSE && LA217_1 <= END)||LA217_1==EQ||LA217_1==FETCH||(LA217_1 >= FROM && LA217_1 <= FULL)||(LA217_1 >= GROUP && LA217_1 <= HAVING)||LA217_1==ILIKE||LA217_1==IN||(LA217_1 >= INCREMENT && LA217_1 <= INNER)||LA217_1==IS||LA217_1==JOIN||LA217_1==LEFT||(LA217_1 >= LIKE && LA217_1 <= LIMIT)||(LA217_1 >= LPAREN && LA217_1 <= MINVALUE)||LA217_1==NAME||(LA217_1 >= NOEQ1 && LA217_1 <= NOT)||LA217_1==NULLS||(LA217_1 >= OFFSET && LA217_1 <= ON)||(LA217_1 >= OR && LA217_1 <= ORDER)||(LA217_1 >= PERCENT && LA217_1 <= PLUS)||LA217_1==PRIMARY||LA217_1==REBUILD||LA217_1==RIGHT||(LA217_1 >= RPAREN && LA217_1 <= RSQUARE)||(LA217_1 >= SELECT && LA217_1 <= SEMICOLON)||LA217_1==SET||(LA217_1 >= SPLIT && LA217_1 <= START)||LA217_1==TABLESAMPLE||LA217_1==THEN||(LA217_1 >= UNION && LA217_1 <= UNUSABLE)||LA217_1==USABLE||LA217_1==VALUES||(LA217_1 >= WHEN && LA217_1 <= WHERE)) ) {
					alt217=1;
				}
				else if ( (LA217_1==DOT) ) {
					alt217=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 217, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 217, 0, input);
				throw nvae;
			}

			switch (alt217) {
				case 1 :
					// PhoenixSQL.g:1178:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name8637);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1179:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name8651);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name8653); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_from_table_name8657);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "table_identifier"
	// PhoenixSQL.g:1182:1: table_identifier returns [String ret] : c= identifier ;
	public final String table_identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1183:5: (c= identifier )
			// PhoenixSQL.g:1183:9: c= identifier
			{
			pushFollow(FOLLOW_identifier_in_table_identifier8684);
			c=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			           if (c.contains(QueryConstants.NAMESPACE_SEPARATOR) ) { throw new RuntimeException("Table or schema name cannot contain colon"); }
			           ret = c;
			    }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_identifier"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1190:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1191:5: (e= literal |b= bind_name )
			int alt218=2;
			int LA218_0 = input.LA(1);
			if ( (LA218_0==BIN_LITERAL||LA218_0==DECIMAL||LA218_0==DOUBLE||LA218_0==FALSE||LA218_0==HEX_LITERAL||LA218_0==NAME||LA218_0==NULL||LA218_0==NUMBER||LA218_0==STRING_LITERAL||LA218_0==TRUE) ) {
				alt218=1;
			}
			else if ( (LA218_0==BIND_NAME||LA218_0==QUESTION) ) {
				alt218=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 218, 0, input);
				throw nvae;
			}

			switch (alt218) {
				case 1 :
					// PhoenixSQL.g:1191:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind8716);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1192:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind8730);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1196:1: literal returns [LiteralParseNode ret] : (h= hex_literal |b= bin_literal |s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		LiteralParseNode h =null;
		LiteralParseNode b =null;
		String dt =null;

		try {
			// PhoenixSQL.g:1197:5: (h= hex_literal |b= bin_literal |s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt219=10;
			switch ( input.LA(1) ) {
			case HEX_LITERAL:
				{
				alt219=1;
				}
				break;
			case BIN_LITERAL:
				{
				alt219=2;
				}
				break;
			case STRING_LITERAL:
				{
				alt219=3;
				}
				break;
			case NUMBER:
				{
				alt219=4;
				}
				break;
			case DECIMAL:
				{
				alt219=5;
				}
				break;
			case DOUBLE:
				{
				alt219=6;
				}
				break;
			case NULL:
				{
				alt219=7;
				}
				break;
			case TRUE:
				{
				alt219=8;
				}
				break;
			case FALSE:
				{
				alt219=9;
				}
				break;
			case NAME:
				{
				alt219=10;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 219, 0, input);
				throw nvae;
			}
			switch (alt219) {
				case 1 :
					// PhoenixSQL.g:1198:5: h= hex_literal
					{
					pushFollow(FOLLOW_hex_literal_in_literal8764);
					h=hex_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = h; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1199:9: b= bin_literal
					{
					pushFollow(FOLLOW_bin_literal_in_literal8778);
					b=bin_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1200:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8792); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1203:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal8806); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1206:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal8820); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1209:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal8835); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1212:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal8848); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1213:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal8860); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 9 :
					// PhoenixSQL.g:1214:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal8873); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1215:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal8887);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8891); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1224:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1225:5: (n= NUMBER )
			// PhoenixSQL.g:1225:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal8918); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "hex_literal"
	// PhoenixSQL.g:1230:1: hex_literal returns [LiteralParseNode ret] : (h= HEX_LITERAL (s= STRING_LITERAL )* ) ;
	public final LiteralParseNode hex_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token h=null;
		Token s=null;

		StringBuilder sb = new StringBuilder();
		try {
			// PhoenixSQL.g:1232:5: ( (h= HEX_LITERAL (s= STRING_LITERAL )* ) )
			// PhoenixSQL.g:1233:5: (h= HEX_LITERAL (s= STRING_LITERAL )* )
			{
			// PhoenixSQL.g:1233:5: (h= HEX_LITERAL (s= STRING_LITERAL )* )
			// PhoenixSQL.g:1234:5: h= HEX_LITERAL (s= STRING_LITERAL )*
			{
			h=(Token)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_hex_literal8958); if (state.failed) return ret;
			if ( state.backtracking==0 ) { sb.append(h.getText()); }
			// PhoenixSQL.g:1235:5: (s= STRING_LITERAL )*
			loop220:
			while (true) {
				int alt220=2;
				int LA220_0 = input.LA(1);
				if ( (LA220_0==STRING_LITERAL) ) {
					alt220=1;
				}

				switch (alt220) {
				case 1 :
					// PhoenixSQL.g:1235:6: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_hex_literal8969); if (state.failed) return ret;
					if ( state.backtracking==0 ) { sb.append(factory.stringToHexLiteral(s.getText())); }
					}
					break;

				default :
					break loop220;
				}
			}

			}

			if ( state.backtracking==0 ) { ret = factory.hexLiteral(sb.toString()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hex_literal"



	// $ANTLR start "bin_literal"
	// PhoenixSQL.g:1240:1: bin_literal returns [LiteralParseNode ret] : (b= BIN_LITERAL (s= STRING_LITERAL )* ) ;
	public final LiteralParseNode bin_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token b=null;
		Token s=null;

		StringBuilder sb = new StringBuilder();
		try {
			// PhoenixSQL.g:1242:5: ( (b= BIN_LITERAL (s= STRING_LITERAL )* ) )
			// PhoenixSQL.g:1243:5: (b= BIN_LITERAL (s= STRING_LITERAL )* )
			{
			// PhoenixSQL.g:1243:5: (b= BIN_LITERAL (s= STRING_LITERAL )* )
			// PhoenixSQL.g:1244:5: b= BIN_LITERAL (s= STRING_LITERAL )*
			{
			b=(Token)match(input,BIN_LITERAL,FOLLOW_BIN_LITERAL_in_bin_literal9024); if (state.failed) return ret;
			if ( state.backtracking==0 ) { sb.append(b.getText()); }
			// PhoenixSQL.g:1245:5: (s= STRING_LITERAL )*
			loop221:
			while (true) {
				int alt221=2;
				int LA221_0 = input.LA(1);
				if ( (LA221_0==STRING_LITERAL) ) {
					alt221=1;
				}

				switch (alt221) {
				case 1 :
					// PhoenixSQL.g:1245:6: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_bin_literal9035); if (state.failed) return ret;
					if ( state.backtracking==0 ) { sb.append(factory.stringToBinLiteral(s.getText())); }
					}
					break;

				default :
					break loop221;
				}
			}

			}

			if ( state.backtracking==0 ) { ret = factory.binLiteral(sb.toString()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bin_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1251:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1252:5: (n= BIND_NAME | QUESTION )
			int alt222=2;
			int LA222_0 = input.LA(1);
			if ( (LA222_0==BIND_NAME) ) {
				alt222=1;
			}
			else if ( (LA222_0==QUESTION) ) {
				alt222=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 222, 0, input);
				throw nvae;
			}

			switch (alt222) {
				case 1 :
					// PhoenixSQL.g:1252:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name9078); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1253:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name9091); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1257:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1258:5: (c= parseNoReserved )
			// PhoenixSQL.g:1258:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier9120);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1261:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1262:5: (n= NAME )
			// PhoenixSQL.g:1262:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved9147); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1265:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1267:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt227=2;
			int LA227_0 = input.LA(1);
			if ( (LA227_0==CASE) ) {
				int LA227_1 = input.LA(2);
				if ( (LA227_1==ARRAY||LA227_1==BIND_NAME||LA227_1==BIN_LITERAL||(LA227_1 >= CASE && LA227_1 <= CAST)||LA227_1==CURRENT||LA227_1==DECIMAL||LA227_1==DOUBLE||LA227_1==EXISTS||LA227_1==FALSE||LA227_1==HEX_LITERAL||LA227_1==LPAREN||LA227_1==MINUS||(LA227_1 >= NAME && LA227_1 <= NEXT)||LA227_1==NOT||LA227_1==NULL||LA227_1==NUMBER||LA227_1==QUESTION||LA227_1==STRING_LITERAL||LA227_1==TRUE) ) {
					alt227=1;
				}
				else if ( (LA227_1==WHEN) ) {
					alt227=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 227, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 227, 0, input);
				throw nvae;
			}

			switch (alt227) {
				case 1 :
					// PhoenixSQL.g:1267:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement9174); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement9178);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1267:26: ( WHEN e2= expression THEN t= expression )+
					int cnt223=0;
					loop223:
					while (true) {
						int alt223=2;
						int LA223_0 = input.LA(1);
						if ( (LA223_0==WHEN) ) {
							alt223=1;
						}

						switch (alt223) {
						case 1 :
							// PhoenixSQL.g:1267:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement9181); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9185);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement9187); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9191);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt223 >= 1 ) break loop223;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(223, input);
							throw eee;
						}
						cnt223++;
					}

					// PhoenixSQL.g:1267:106: ( ELSE el= expression )?
					int alt224=2;
					int LA224_0 = input.LA(1);
					if ( (LA224_0==ELSE) ) {
						alt224=1;
					}
					switch (alt224) {
						case 1 :
							// PhoenixSQL.g:1267:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement9198); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9202);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement9208); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1268:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement9218); if (state.failed) return ret;
					// PhoenixSQL.g:1268:12: ( WHEN c= expression THEN t= expression )+
					int cnt225=0;
					loop225:
					while (true) {
						int alt225=2;
						int LA225_0 = input.LA(1);
						if ( (LA225_0==WHEN) ) {
							alt225=1;
						}

						switch (alt225) {
						case 1 :
							// PhoenixSQL.g:1268:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement9221); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9225);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement9227); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9231);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt225 >= 1 ) break loop225;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(225, input);
							throw eee;
						}
						cnt225++;
					}

					// PhoenixSQL.g:1268:72: ( ELSE el= expression )?
					int alt226=2;
					int LA226_0 = input.LA(1);
					if ( (LA226_0==ELSE) ) {
						alt226=1;
					}
					switch (alt226) {
						case 1 :
							// PhoenixSQL.g:1268:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement9238); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9242);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement9248); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:991:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:991:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:991:10: ( NOT )?
		int alt228=2;
		int LA228_0 = input.LA(1);
		if ( (LA228_0==NOT) ) {
			alt228=1;
		}
		switch (alt228) {
			case 1 :
				// PhoenixSQL.g:991:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL6764); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6767);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1346 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1350 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1385 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1389 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1415 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1449 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1459 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1471 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1483 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1495 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1507 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1531 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1543 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1555 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1567 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1579 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1591 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1603 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1615 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_node_in_oneStatement1627 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_create_table_node_in_oneStatement1639 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1651 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1663 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1687 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1699 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1711 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1733 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grant_permission_node_in_oneStatement1745 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revoke_permission_node_in_oneStatement1757 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1767 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1777 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1787 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1799 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1823 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1856 = new BitSet(new long[]{0x04012080100000A0L,0x000002000000204AL,0x8150800084012001L});
	public static final BitSet FOLLOW_WITH_in_explain_node1861 = new BitSet(new long[]{0x04012080100000A0L,0x000002000000204AL,0x0150800084012001L});
	public static final BitSet FOLLOW_REGIONS_in_explain_node1868 = new BitSet(new long[]{0x04012080100000A0L,0x000002000000204AL,0x0150800084010001L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1905 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L,0x0000010000000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1910 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node1914 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_create_table_node1917 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node1919 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node1923 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node1929 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node1941 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node1945 = new BitSet(new long[]{0x0000004200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node1950 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node1954 = new BitSet(new long[]{0x0000000100000002L,0x0108000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_NOVERIFY_in_create_table_node1968 = new BitSet(new long[]{0x0000000100000002L,0x0008000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node1983 = new BitSet(new long[]{0x0000000100000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node1996 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_create_table_node1998 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node2002 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_COLUMN_QUALIFIER_COUNTER_in_create_table_node2015 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node2017 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_initializiation_list_in_create_table_node2021 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node2023 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node2062 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node2064 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node2067 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node2069 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node2073 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node2079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRANT_in_grant_permission_node2113 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2117 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_ON_in_grant_permission_node2120 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000010001000000L});
	public static final BitSet FOLLOW_TABLE_in_grant_permission_node2124 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_table_name_in_grant_permission_node2130 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_SCHEMA_in_grant_permission_node2136 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_grant_permission_node2140 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_TO_in_grant_permission_node2145 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000044020L,0x0001008000000000L});
	public static final BitSet FOLLOW_GROUP_in_grant_permission_node2150 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2156 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REVOKE_in_revoke_permission_node2190 = new BitSet(new long[]{0x0080100000100000L,0x4A08000000040420L,0x0001008000000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2195 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000400L});
	public static final BitSet FOLLOW_ON_in_revoke_permission_node2200 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000010001000000L});
	public static final BitSet FOLLOW_TABLE_in_revoke_permission_node2204 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_table_name_in_revoke_permission_node2210 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_SCHEMA_in_revoke_permission_node2216 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_revoke_permission_node2220 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_FROM_in_revoke_permission_node2225 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000044020L,0x0001008000000000L});
	public static final BitSet FOLLOW_GROUP_in_revoke_permission_node2230 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2236 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2270 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_TABLES_in_show_node2272 = new BitSet(new long[]{0x0000000000000002L,0x0000008001000000L});
	public static final BitSet FOLLOW_IN_in_show_node2275 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_show_node2279 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2284 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2288 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2302 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_SCHEMAS_in_show_node2304 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2307 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2311 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_create_table_node2339 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CREATE_in_show_create_table_node2341 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_TABLE_in_show_create_table_node2343 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_show_create_table_node2347 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node2373 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node2375 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_create_view_node2378 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node2380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node2384 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2390 = new BitSet(new long[]{0x0000000000000802L,0x0008080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node2402 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node2406 = new BitSet(new long[]{0x0000004200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node2411 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node2415 = new BitSet(new long[]{0x0000000000000802L,0x0008000000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node2429 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node2431 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node2433 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_FROM_in_create_view_node2445 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2449 = new BitSet(new long[]{0x0000000000000002L,0x0008000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node2462 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_create_view_node2466 = new BitSet(new long[]{0x0000000000000002L,0x0008000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2520 = new BitSet(new long[]{0x0000000000000000L,0x0000040008000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_UNCOVERED_in_create_index_node2524 = new BitSet(new long[]{0x0000000000000000L,0x0000040008000000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2529 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2532 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2535 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2537 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2541 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2547 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2549 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2553 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2564 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2568 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2570 = new BitSet(new long[]{0x0000000000004002L,0x0008000002000000L,0x4000001000000000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2584 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2587 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2591 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2593 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x4000001000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_index_node2607 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_create_index_node2611 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2626 = new BitSet(new long[]{0x0000000000000002L,0x0008000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2641 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2654 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2656 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2660 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2696 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2698 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node2702 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node2704 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node2708 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node2714 = new BitSet(new long[]{0x0000040000400002L,0x0001400004000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node2725 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x8001008000000400L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node2727 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2732 = new BitSet(new long[]{0x0000040000400002L,0x0001400004000000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node2745 = new BitSet(new long[]{0x0080110003340400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node2747 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2752 = new BitSet(new long[]{0x0000040000400002L,0x0001400000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node2765 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2769 = new BitSet(new long[]{0x0000040000400002L,0x0000400000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node2782 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2786 = new BitSet(new long[]{0x0000040000400002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node2801 = new BitSet(new long[]{0x0000000000400002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node2815 = new BitSet(new long[]{0x0000000000040000L,0x0800000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node2819 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind2850 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind2862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_string_literal2890 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node2916 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node2918 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node2922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node2926 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node2932 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint2961 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint2964 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint2968 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint2970 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint2972 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint2974 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2978 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint2980 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3011 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list3017 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3023 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp3050 = new BitSet(new long[]{0x0002000000001002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp3055 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp3059 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp3066 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint3101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3128 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list3134 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3140 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order3167 = new BitSet(new long[]{0x0002000000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order3173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order3177 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3205 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3207 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3211 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties3217 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3221 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3223 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3227 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3257 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3271 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name3273 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value3308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value3322 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3353 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3367 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name3369 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name3373 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names3405 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names3411 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names3417 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node3444 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000010000000000L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node3449 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node3453 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node3457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node3461 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node3467 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node3472 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node3507 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node3509 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node3512 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node3516 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3522 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3527 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3562 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3564 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3567 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3571 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3577 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3579 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3583 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3613 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3615 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3618 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3622 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3628 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3630 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3634 = new BitSet(new long[]{0x0008000000000010L,0x0000000000000000L,0x0088000000001000L});
	public static final BitSet FOLLOW_USABLE_in_alter_index_node3647 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_UNUSABLE_in_alter_index_node3651 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_REBUILD_in_alter_index_node3655 = new BitSet(new long[]{0x0000000000004042L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_ALL_in_alter_index_node3660 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_DISABLE_in_alter_index_node3666 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_ACTIVE_in_alter_index_node3670 = new BitSet(new long[]{0x0000000000004002L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node3677 = new BitSet(new long[]{0x0000000000000002L,0x0008000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_SET_in_alter_index_node3683 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_index_node3688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node3723 = new BitSet(new long[]{0x0000000000000000L,0x5000000000000000L});
	public static final BitSet FOLLOW_ON_in_trace_node3731 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_WITH_in_trace_node3736 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node3738 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node3744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node3755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node3789 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L,0x0000080000000002L});
	public static final BitSet FOLLOW_OR_in_create_function_node3792 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node3796 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L,0x0000080000000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node3803 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node3807 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3811 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node3822 = new BitSet(new long[]{0x0000000200000000L,0x0008000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node3826 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node3828 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node3838 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3842 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node3844 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3850 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_USING_in_create_function_node3861 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node3863 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3870 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path3907 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node3930 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node3932 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node3935 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node3939 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node3945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node3968 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node3970 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node3976 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node3999 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node4001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node4024 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node4026 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node4032 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node4058 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node4060 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node4063 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node4067 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node4101 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000010000000000L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node4104 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node4110 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node4115 = new BitSet(new long[]{0x0400000000000020L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node4128 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node4130 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node4133 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node4137 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node4143 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node4149 = new BitSet(new long[]{0x0000000000000000L,0x0008000000100000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node4152 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node4154 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node4158 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node4165 = new BitSet(new long[]{0x0000000000800002L,0x0008000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4171 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_CASCADE_in_alter_table_node4179 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_INDEX_in_alter_table_node4181 = new BitSet(new long[]{0x0000000000000040L,0x0008000000000000L});
	public static final BitSet FOLLOW_indexes_in_alter_table_node4186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_alter_table_node4192 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node4200 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4205 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node4239 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node4241 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node4245 = new BitSet(new long[]{0x0000000080000042L,0x0000000008000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node4250 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node4256 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node4262 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node4267 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node4272 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node4296 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node4298 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name4324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties4358 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_properties4360 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4364 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_properties4370 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties4374 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_properties4376 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4380 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs4415 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs4421 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs4427 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_initializiation_list4457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_initializiation_list4459 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_initializiation_list4463 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_initializiation_list4476 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_initializiation_list4480 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_initializiation_list4482 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_initializiation_list4486 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_index_name_in_indexes4521 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_indexes4527 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_index_name_in_indexes4533 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_column_name_in_column_def4559 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def4563 = new BitSet(new long[]{0x2000400000000402L,0x0280180000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_LPAREN_in_column_def4566 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4570 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COMMA_in_column_def4573 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4577 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_column_def4581 = new BitSet(new long[]{0x2000400000000402L,0x0280100000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ARRAY_in_column_def4587 = new BitSet(new long[]{0x2000400000000002L,0x0280100000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def4593 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def4602 = new BitSet(new long[]{0x2000400000000002L,0x0280000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_NOT_in_column_def4609 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def4614 = new BitSet(new long[]{0x2000400000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def4619 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_column_def4623 = new BitSet(new long[]{0x2000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def4631 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_KEY_in_column_def4633 = new BitSet(new long[]{0x0002000000001002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_ASC_in_column_def4638 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_DESC_in_column_def4642 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def4648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ENCODED_QUALIFIER_in_column_def4653 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4700 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs4706 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4712 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def4738 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def4742 = new BitSet(new long[]{0x0000000000000402L,0x0000180000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def4745 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4749 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def4752 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def4760 = new BitSet(new long[]{0x0000000000000402L,0x0000100000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def4766 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def4772 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4777 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def4781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def4818 = new BitSet(new long[]{0x0000000000000002L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def4823 = new BitSet(new long[]{0x0000000000000402L,0x0000180000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def4826 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4830 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def4833 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4837 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def4841 = new BitSet(new long[]{0x0000000000000402L,0x0000100000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def4847 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def4853 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4858 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def4862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression4902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select4935 = new BitSet(new long[]{0x0090110003142440L,0x0A9C880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_hintClause_in_single_select4940 = new BitSet(new long[]{0x0090110003142440L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select4956 = new BitSet(new long[]{0x0080110003142400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_ALL_in_single_select4960 = new BitSet(new long[]{0x0080110003142400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_select_list_in_single_select4966 = new BitSet(new long[]{0x0000000000000002L,0x0000000000014400L,0x4000000000000000L});
	public static final BitSet FOLLOW_FROM_in_single_select4977 = new BitSet(new long[]{0x0000000000040000L,0x0008080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_parseFrom_in_single_select4981 = new BitSet(new long[]{0x0000000000000002L,0x0000000000014000L,0x4000000000000000L});
	public static final BitSet FOLLOW_WHERE_in_single_select4994 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_single_select4998 = new BitSet(new long[]{0x0000000000000002L,0x0000000000014000L});
	public static final BitSet FOLLOW_GROUP_in_single_select5011 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_single_select5013 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_group_by_in_single_select5017 = new BitSet(new long[]{0x0000000000000002L,0x0000000000010000L});
	public static final BitSet FOLLOW_HAVING_in_single_select5030 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_single_select5034 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects5078 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects5083 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects5085 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects5089 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node5127 = new BitSet(new long[]{0x0000000000000002L,0x2000010000000040L,0x0000000000000004L});
	public static final BitSet FOLLOW_ORDER_in_select_node5138 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_select_node5140 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_order_by_in_select_node5144 = new BitSet(new long[]{0x0000000000000002L,0x2000010000000040L});
	public static final BitSet FOLLOW_LIMIT_in_select_node5157 = new BitSet(new long[]{0x0000000000040000L,0x0800000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_limit_in_select_node5161 = new BitSet(new long[]{0x0000000000000002L,0x2000000000000040L});
	public static final BitSet FOLLOW_OFFSET_in_select_node5174 = new BitSet(new long[]{0x0000000000040000L,0x0800080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_offset_in_select_node5178 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
	public static final BitSet FOLLOW_FETCH_in_select_node5191 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000100L});
	public static final BitSet FOLLOW_set_in_select_node5193 = new BitSet(new long[]{0x0000000000040000L,0x0800000000000000L,0x00000000000C0400L});
	public static final BitSet FOLLOW_limit_in_select_node5204 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000C0000L});
	public static final BitSet FOLLOW_set_in_select_node5208 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_ONLY_in_select_node5216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node5255 = new BitSet(new long[]{0x0000000000000000L,0x0004000020000000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node5260 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node5264 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node5268 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L,0x0800000004000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5279 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node5283 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5285 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000004000000L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node5299 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5301 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node5305 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5307 = new BitSet(new long[]{0x0000000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_upsert_node5311 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node5313 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node5315 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L,0x0010000000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node5321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node5327 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node5331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_upsert_node5346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5387 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs5399 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5403 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair5428 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair5430 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_update_column_pair5434 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5463 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs5476 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5480 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node5508 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node5512 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node5514 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node5516 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node5520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node5554 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node5558 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node5585 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node5589 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node5615 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node5617 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000400L,0x00000000000C0000L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node5622 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L,0x00000000000C0000L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node5633 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node5637 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node5663 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000400L});
	public static final BitSet FOLLOW_hintClause_in_delete_node5668 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_FROM_in_delete_node5672 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node5676 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L,0x4000000000000004L});
	public static final BitSet FOLLOW_WHERE_in_delete_node5687 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_delete_node5691 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_ORDER_in_delete_node5704 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_delete_node5706 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_order_by_in_delete_node5710 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node5723 = new BitSet(new long[]{0x0000000000040000L,0x0800000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_limit_in_delete_node5727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit5762 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit5774 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset5800 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x00000000000C0000L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset5821 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x00000000000C0000L});
	public static final BitSet FOLLOW_LPAREN_in_offset5840 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset5844 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_offset5846 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_offset5848 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_offset5850 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset5854 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_offset5856 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate5881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_tableSampleNode5906 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause5932 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5964 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list5969 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_selectable_in_select_list5973 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list5985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable6014 = new BitSet(new long[]{0x0000000000000802L,0x0008000000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable6019 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable6034 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable6036 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable6038 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable6053 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable6055 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable6059 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable6061 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable6063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by6096 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by6109 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_group_by6115 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by6149 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by6162 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by6168 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField6205 = new BitSet(new long[]{0x0002000000001002L,0x0400000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField6217 = new BitSet(new long[]{0x0000000000000002L,0x0400000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField6223 = new BitSet(new long[]{0x0000000000000002L,0x0400000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField6238 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000100L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField6241 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField6247 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom6287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list6318 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list6323 = new BitSet(new long[]{0x0000000000040000L,0x0008080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_table_ref_in_table_list6327 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6351 = new BitSet(new long[]{0x0000000000000002L,0x0000002210000800L,0x0000000000020000L});
	public static final BitSet FOLLOW_join_type_in_table_ref6358 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref6360 = new BitSet(new long[]{0x0000000000040000L,0x0008080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6364 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_ON_in_table_ref6366 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_table_ref6370 = new BitSet(new long[]{0x0000000000000002L,0x0000002210000800L,0x0000000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6394 = new BitSet(new long[]{0x0000000000040000L,0x0008080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_table_list_in_table_factor6398 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor6414 = new BitSet(new long[]{0x0000000000000802L,0x0008000000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6418 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6424 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor6441 = new BitSet(new long[]{0x0000000000000802L,0x0008080000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6445 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6451 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6456 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor6460 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6462 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_TABLESAMPLE_in_table_factor6467 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6469 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_tableSampleNode_in_table_factor6473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6475 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_select_node_in_table_factor6493 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6495 = new BitSet(new long[]{0x0000000000000802L,0x0008000000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6499 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6505 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type6532 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type6547 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_OUTER_in_join_type6549 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type6564 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_OUTER_in_join_type6566 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type6580 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_OUTER_in_join_type6583 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias6614 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias6619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression6647 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6679 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_OR_in_or_expression6684 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6688 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6724 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression6729 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6733 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression6775 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression6780 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression6794 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression6797 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_not_expression6801 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression6803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6823 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6830 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6844 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op6862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6893 = new BitSet(new long[]{0x0000000000020002L,0x00E0208041408001L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression6899 = new BitSet(new long[]{0x0080110003140640L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6909 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6913 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6915 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6924 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6930 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6933 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6937 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6939 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6949 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6955 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6958 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6962 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression6994 = new BitSet(new long[]{0x0000000000000000L,0x0280000000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6998 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression7001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression7032 = new BitSet(new long[]{0x0000000000020000L,0x0000008001400000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression7037 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7041 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression7079 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7083 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression7121 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7125 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression7127 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7131 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression7170 = new BitSet(new long[]{0x0000000000040000L,0x0000080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression7176 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7217 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7221 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7223 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7264 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression7268 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7270 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression7370 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7372 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7376 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression7406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression7437 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7468 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_PLUS_in_add_expression7473 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7477 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7512 = new BitSet(new long[]{0x0000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression7517 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7521 = new BitSet(new long[]{0x0000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7556 = new BitSet(new long[]{0x0000001000000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression7561 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7565 = new BitSet(new long[]{0x0000001000000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7600 = new BitSet(new long[]{0x0020000000002002L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression7616 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7630 = new BitSet(new long[]{0x0020000000002002L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_USE_in_use_schema_node7673 = new BitSet(new long[]{0x0000400000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node7676 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node7682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression7718 = new BitSet(new long[]{0x0080110003140400L,0x0A18080000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression7723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression7751 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression7754 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_array_expression7758 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression7760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7793 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7807 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term7821 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7823 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7827 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term7843 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_term7845 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_term7849 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7863 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7865 = new BitSet(new long[]{0x0080110203140400L,0x0A98880000040024L,0x0001008000200400L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7869 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term7871 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_WITHIN_in_term7876 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_GROUP_in_term7878 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7880 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_ORDER_in_term7882 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_term7884 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7888 = new BitSet(new long[]{0x0002000000001000L});
	public static final BitSet FOLLOW_ASC_in_term7893 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_DESC_in_term7897 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term7900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7925 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7927 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term7931 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term7933 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7957 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7959 = new BitSet(new long[]{0x0010000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term7963 = new BitSet(new long[]{0x0080110203140400L,0x0A98880000040024L,0x0001008000200400L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term7969 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term7992 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term8004 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term8008 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term8010 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term8028 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8030 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_term8034 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term8036 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_identifier_in_term8040 = new BitSet(new long[]{0x0000000000000400L,0x0000180000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_LPAREN_in_term8043 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term8047 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COMMA_in_term8050 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term8054 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term8058 = new BitSet(new long[]{0x0000000000000400L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ARRAY_in_term8065 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_LSQUARE_in_term8070 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_term8072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_term8077 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term8100 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_CURRENT_in_term8104 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_VALUE_in_term8107 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_FOR_in_term8109 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term8113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term8141 = new BitSet(new long[]{0x0080100000140000L,0x0A08000000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_literal_or_bind_in_term8146 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_VALUES_in_term8148 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_FOR_in_term8150 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term8154 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions8199 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions8205 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions8211 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8242 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths8248 = new BitSet(new long[]{0x0080100000100000L,0x0A08000000040020L,0x0001008000000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8254 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8287 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions8295 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8301 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8332 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types8339 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8345 = new BitSet(new long[]{0x0000000200000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument8370 = new BitSet(new long[]{0x0000802000000402L,0x0001580000000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument8373 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8377 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COMMA_in_function_argument8380 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8384 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument8388 = new BitSet(new long[]{0x0000802000000402L,0x0001500000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument8394 = new BitSet(new long[]{0x0000802000000002L,0x0001500000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument8400 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8405 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument8409 = new BitSet(new long[]{0x0000802000000002L,0x0001400000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument8418 = new BitSet(new long[]{0x0000800000000002L,0x0001400000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument8423 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_function_argument8425 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_function_argument8431 = new BitSet(new long[]{0x0000000000000002L,0x0001400000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument8436 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_function_argument8438 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_function_argument8444 = new BitSet(new long[]{0x0000000000000002L,0x0000400000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument8450 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EQ_in_function_argument8452 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_function_argument8458 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list8488 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8494 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list8500 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040020L,0x0001008000000400L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8506 = new BitSet(new long[]{0x0000000200000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list8513 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name8534 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name8561 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8589 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8603 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name8605 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8609 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8637 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8651 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name8653 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_identifier8684 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind8716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind8730 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_hex_literal_in_literal8764 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bin_literal_in_literal8778 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8792 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal8806 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal8820 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal8835 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal8848 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal8860 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal8873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal8887 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8891 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal8918 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEX_LITERAL_in_hex_literal8958 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_hex_literal8969 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_BIN_LITERAL_in_bin_literal9024 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_bin_literal9035 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name9078 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name9091 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier9120 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved9147 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement9174 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9178 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement9181 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9185 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement9187 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9191 = new BitSet(new long[]{0x5000000000000000L,0x0000000000000000L,0x2000000000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement9198 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9202 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement9208 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement9218 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement9221 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9225 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement9227 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9231 = new BitSet(new long[]{0x5000000000000000L,0x0000000000000000L,0x2000000000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement9238 = new BitSet(new long[]{0x0080110003140400L,0x0A98880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_expression_in_case_statement9242 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement9248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL6764 = new BitSet(new long[]{0x0080110003140400L,0x0A18880000040024L,0x0001008000000400L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6767 = new BitSet(new long[]{0x0000000000000002L});
}
