package org.apache.hadoop.hbase.generated.regionserver;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.Date;
import java.util.List;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.RpcLogDetails;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.SlowLogResponseRequest;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.SlowLogResponseRequest.LogType;

public final class rsOperationDetails_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write('\n');
      out.write('\n');

  HRegionServer rs = (HRegionServer) getServletContext().getAttribute(HRegionServer.REGIONSERVER);
  List<TooSlowLog.SlowLogPayload> slowLogs = Collections.emptyList();
  List<TooSlowLog.SlowLogPayload> largeLogs = Collections.emptyList();
  Configuration conf = rs.getConfiguration();
  boolean isSlowLogEnabled = conf.getBoolean(HConstants.SLOW_LOG_BUFFER_ENABLED_KEY, false);

  if(rs.isOnline() && isSlowLogEnabled) {
    NamedQueueRecorder namedQueueRecorder = rs.getNamedQueueRecorder();

    NamedQueueGetRequest slowRequest = new NamedQueueGetRequest();
    slowRequest.setNamedQueueEvent(RpcLogDetails.SLOW_LOG_EVENT);
    slowRequest.setSlowLogResponseRequest(SlowLogResponseRequest.newBuilder()
      .setLogType(LogType.SLOW_LOG)
      .setLimit(Integer.MAX_VALUE)
      .build());
    NamedQueueGetResponse slowResponse =
      namedQueueRecorder.getNamedQueueRecords(slowRequest);
    slowLogs = slowResponse.getSlowLogPayloads();


    NamedQueueGetRequest largeRequest = new NamedQueueGetRequest();
    largeRequest.setNamedQueueEvent(RpcLogDetails.SLOW_LOG_EVENT);
    largeRequest.setSlowLogResponseRequest(SlowLogResponseRequest.newBuilder()
      .setLogType(LogType.LARGE_LOG)
      .setLimit(Integer.MAX_VALUE)
      .build());
    NamedQueueGetResponse largeResponse =
      namedQueueRecorder.getNamedQueueRecords(largeRequest);
    largeLogs = largeResponse.getSlowLogPayloads();
  }

      out.write('\n');
      out.write('\n');
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "header.jsp" + "?" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode("pageTitle", request.getCharacterEncoding())+ "=" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode((java.lang.String) org.apache.jasper.runtime.PageContextImpl.evaluateExpression("${pageTitle}", java.lang.String.class, (PageContext)_jspx_page_context, null), request.getCharacterEncoding()), out, false);
      out.write("\n\n\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n    <h1>Operations Details</h1>\n    <p>HBase uses some fixed-size ring buffers to maintain rolling window history of specific server-side operation details.\n    This page list all operation details retrieve from these ring buffers</p>\n    </div>\n  </div>\n<div class=\"tabbable\">\n  <ul class=\"nav nav-pills\">\n    <li class=\"active\">\n      <a href=\"#tab_named_queue1\" data-toggle=\"tab\"> Slow RPCs </a>\n    </li>\n    <li class=\"\">\n      <a href=\"#tab_named_queue2\" data-toggle=\"tab\"> Large Response RPCs </a>\n    </li>\n  </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n      <div class=\"tab-pane active\" id=\"tab_named_queue1\">\n      <p>Slow RPCs record those RPCs whose processing time is greater than the threshold (see the setting 'hbase.ipc.warn.response.time' for details)</p>\n        <table class=\"table table-striped\" style=\"white-space:nowrap\">\n        <tr>\n            <th>Start Time</th>\n");
      out.write("            <th>Processing Time</th>\n            <th>Queue Time</th>\n            <th>Response Size</th>\n            <th>Client Address</th>\n            <th>Server Class</th>\n            <th>Method Name</th>\n            <th>Region Name</th>\n            <th>User Name</th>\n            <th>MultiGets Count</th>\n            <th>MultiMutations Count</th>\n            <th>MultiService Calls</th>\n            <th>Call Details</th>\n            <th>Param</th>\n          </tr>\n          ");
 if (slowLogs != null && !slowLogs.isEmpty()) {
      out.write("\n            ");
 for (TooSlowLog.SlowLogPayload r : slowLogs) { 
      out.write("\n            <tr>\n             <td>");
      out.print(new Date(r.getStartTime() + 1800*1000));
      out.write("</td>\n             <td>");
      out.print(r.getProcessingTime());
      out.write("ms</td>\n             <td>");
      out.print(r.getQueueTime());
      out.write("ms</td>\n             <td>");
      out.print(StringUtils.byteDesc(r.getResponseSize()));
      out.write("</td>\n             <td>");
      out.print(r.getClientAddress());
      out.write("</td>\n             <td>");
      out.print(r.getServerClass());
      out.write("</td>\n             <td>");
      out.print(r.getMethodName());
      out.write("</td>\n             <td>");
      out.print(r.getRegionName());
      out.write("</td>\n             <td>");
      out.print(r.getUserName());
      out.write("</td>\n             <td>");
      out.print(r.getMultiGets());
      out.write("</td>\n             <td>");
      out.print(r.getMultiMutations());
      out.write("</td>\n             <td>");
      out.print(r.getMultiServiceCalls());
      out.write("</td>\n             <td>");
      out.print(r.getCallDetails());
      out.write("</td>\n             <td>");
      out.print(r.getParam());
      out.write("</td>\n            </tr>\n            ");
 } 
      out.write("\n          ");
 } 
      out.write("\n          </table>\n      </div>\n      <div class=\"tab-pane\" id=\"tab_named_queue2\">\n        <p>Large response RPCs record those RPCs whose returned data size is greater than the threshold (see the setting'hbase.ipc.warn.response.size' for details)</p>\n          <table class=\"table table-striped\" style=\"white-space:nowrap\">\n          <tr>\n            <th>Start Time</th>\n            <th>Processing Time</th>\n            <th>Queue Time</th>\n            <th>Response Size</th>\n            <th>Client Address</th>\n            <th>Server Class</th>\n            <th>Method Name</th>\n            <th>Region Name</th>\n            <th>User Name</th>\n            <th>MultiGets Count</th>\n            <th>MultiMutations Count</th>\n            <th>MultiService Calls</th>\n            <th>Call Details</th>\n            <th>Param</th>\n          </tr>\n          ");
 if (largeLogs != null && !largeLogs.isEmpty()) {
      out.write("\n            ");
 for (TooSlowLog.SlowLogPayload r : largeLogs) { 
      out.write("\n            <tr>\n             <td>");
      out.print(new Date(r.getStartTime() + 1800*1000));
      out.write("</td>\n             <td>");
      out.print(r.getProcessingTime());
      out.write("ms</td>\n             <td>");
      out.print(r.getQueueTime());
      out.write("ms</td>\n             <td>");
      out.print(StringUtils.byteDesc(r.getResponseSize()));
      out.write("</td>\n             <td>");
      out.print(r.getClientAddress());
      out.write("</td>\n             <td>");
      out.print(r.getServerClass());
      out.write("</td>\n             <td>");
      out.print(r.getMethodName());
      out.write("</td>\n             <td>");
      out.print(r.getRegionName());
      out.write("</td>\n             <td>");
      out.print(r.getUserName());
      out.write("</td>\n             <td>");
      out.print(r.getMultiGets());
      out.write("</td>\n             <td>");
      out.print(r.getMultiMutations());
      out.write("</td>\n             <td>");
      out.print(r.getMultiServiceCalls());
      out.write("</td>\n             <td>");
      out.print(r.getCallDetails());
      out.write("</td>\n             <td>");
      out.print(r.getParam());
      out.write("</td>\n            </tr>\n            ");
 } 
      out.write("\n          ");
 } 
      out.write("\n          </table>\n      </div>\n  </div>\n</div>\n");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "footer.jsp", out, false);
      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
