// Autogenerated Jamon implementation
// /home/apurtell/RM/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import java.net.URLEncoder;
// 34, 1
import java.io.IOException;
// 35, 1
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
// 36, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 37, 1
import org.apache.hadoop.hbase.client.TableDescriptor;
// 38, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
// 39, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
// 40, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 41, 1
import org.apache.hadoop.hbase.HConstants;
// 42, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 43, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 44, 1
import org.apache.hadoop.hbase.ServerName;
// 45, 1
import org.apache.hadoop.hbase.TableName;
// 46, 1
import org.apache.hadoop.hbase.client.Admin;
// 47, 1
import org.apache.hadoop.hbase.client.MasterSwitchType;
// 48, 1
import org.apache.hadoop.hbase.client.TableState;
// 49, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 50, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 51, 1
import org.apache.hadoop.hbase.master.HMaster;
// 52, 1
import org.apache.hadoop.hbase.master.RegionState;
// 53, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 54, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 55, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;
// 56, 1
import org.apache.hadoop.hbase.security.access.PermissionStorage;
// 57, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 58, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos.SnapshotDescription;
// 59, 1
import org.apache.hadoop.hbase.tool.CanaryTool;
// 60, 1
import org.apache.hadoop.hbase.util.Bytes;
// 61, 1
import org.apache.hadoop.hbase.util.CommonFSUtils;
// 62, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 63, 1
import org.apache.hadoop.hbase.util.PrettyPrinter;
// 64, 1
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final String format;
  private final Map<String,Integer> frags;
  private final ServerName metaLocation;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  // 76, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  // 103, 1
  
  public static String getUserTables(HMaster master, List<TableDescriptor> tables){
    if (master.isInitialized()){
      try {
        Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
        if (descriptorMap != null) {
          for (TableDescriptor desc : descriptorMap.values()) {
            if (!desc.getTableName().isSystemTable()) {
             tables.add(desc);
            }
          }
        }
      } catch (IOException e) {
        return "Got user tables error, " + e.getMessage();
      }
    }
    return null;
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    metaLocation = p_implData.getMetaLocation();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 67, 1
    if (format.equals("json") )
    {
      // 67, 30
      jamonWriter.write("\n  ");
      // 68, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 68, 68
      jamonWriter.write("\n  ");
      // 69, 3
      return; 
    }
    // 70, 7
    jamonWriter.write("\n");
    // 71, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 123, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 128, 12
    if (master.isActiveMaster() )
    {
      // 128, 43
      jamonWriter.write("Master: ");
    }
    // 128, 51
    else
    {
      // 128, 58
      jamonWriter.write("Backup Master: ");
    }
    // 128, 79
    jamonWriter.write("\n    ");
    // 129, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 129, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
    // 153, 17
    if (master.isActiveMaster() )
    {
      // 153, 48
      jamonWriter.write("\n                    <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                    <li><a href=\"/hbck.jsp\">HBCK Report</a></li>\n                    <li><a href=\"/operationDetails.jsp\">Operation Details</a></li>\n                    ");
      // 157, 21
      if (master.getConfiguration().getBoolean(QuotaUtil.QUOTA_CONF_KEY, false) )
      {
        // 157, 98
        jamonWriter.write("\n                        <li><a href=\"/quotas.jsp\">Quotas</a></li>\n                    ");
      }
      // 159, 27
      jamonWriter.write("\n                ");
    }
    // 160, 23
    jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 167, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 167, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 169, 23
    jamonWriter.write("\n                <li><a href=\"/startupProgress.jsp\">Startup Progress</a></li>\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 177, 2
    if (master.isActiveMaster() )
    {
      // 177, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 180, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 180, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 186, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 186, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 188, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 188, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
      }
      // 193, 15
      jamonWriter.write("\n        ");
      // 194, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 194, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 199, 15
      jamonWriter.write("\n        ");
      // 200, 9
      if (master.isInMaintenanceMode() )
      {
        // 200, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This is because hbase.master.maintenance_mode is\n          set to true. Under the maintenance mode, no quota or no Master coprocessor is loaded.\n          </div>\n        ");
      }
      // 205, 15
      jamonWriter.write("\n        ");
      // 206, 9
      if (!master.isBalancerOn() )
      {
        // 206, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 212, 15
      jamonWriter.write("\n        ");
      // 213, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT) )
      {
        // 213, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 219, 15
      jamonWriter.write("\n        ");
      // 220, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.MERGE) )
      {
        // 220, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 226, 15
      jamonWriter.write("\n        ");
      // 227, 9
      if (master.getAssignmentManager() != null )
      {
        // 227, 54
        jamonWriter.write("\n          ");
        // 228, 11
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_1.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 228, 92
        jamonWriter.write("\n        ");
      }
      // 229, 15
      jamonWriter.write("\n        ");
      // 230, 9
      if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null )
      {
        // 230, 91
        jamonWriter.write("\n          ");
        // 231, 11
        if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null &&
            serverManager.getOnlineServersList().size() > 0 )
        {
          // 232, 63
          jamonWriter.write("\n            <section>\n              <h2><a name=\"rsgroup\">RSGroup</a></h2>\n              ");
          // 235, 15
          {
            org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl(this.getTemplateManager());
            __jamon__var_2.renderNoFlush(jamonWriter, master, serverManager);
          }
          // 235, 81
          jamonWriter.write("\n            </section>\n          ");
        }
        // 237, 17
        jamonWriter.write("\n        ");
      }
      // 238, 15
      jamonWriter.write("\n        <section>\n            <h2><a name=\"regionservers\">Region Servers</a></h2>\n            ");
      // 241, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_3.setServers(servers );
        __jamon__var_3.renderNoFlush(jamonWriter, master);
      }
      // 241, 74
      jamonWriter.write("\n\n            ");
      // 243, 13
      if ((deadServers != null) )
      {
        // 243, 42
        jamonWriter.write("\n                ");
        // 244, 17
        {
          // 244, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 244, 40
        jamonWriter.write("\n            ");
      }
      // 245, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 248, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, master );
      }
      // 248, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"tables\">Tables</a></h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 266, 25
      if ((metaLocation != null) )
      {
        // 266, 55
        jamonWriter.write("\n                            ");
        // 267, 29
        {
          // 267, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 267, 45
        jamonWriter.write("\n                        ");
      }
      // 268, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 271, 25
      if ((metaLocation != null) )
      {
        // 271, 55
        jamonWriter.write("\n                            ");
        // 272, 29
        {
          // 272, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 272, 48
        jamonWriter.write("\n                        ");
      }
      // 273, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2><a name=\"region_visualizer\"></a>Region Visualizer</h2>\n            ");
      // 282, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionVisualizerTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.master.RegionVisualizerTmpl(this.getTemplateManager());
        __jamon__var_5.renderNoFlush(jamonWriter);
      }
      // 282, 39
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"peers\">Peers</a></h2>\n            ");
      // 286, 13
      {
        // 286, 13
        __jamon_innerUnit__peerConfigs(jamonWriter);
      }
      // 286, 30
      jamonWriter.write("\n        </section>\n\t");
    }
    // 288, 2
    else
    {
      // 288, 9
      jamonWriter.write("\n        <section>\n            ");
      // 290, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_6 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_6.renderNoFlush(jamonWriter, master );
      }
      // 290, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 292, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 296, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_7.setFilter(filter);
      __jamon__var_7.setParent("/master-status" );
      __jamon__var_7.renderNoFlush(jamonWriter);
    }
    // 296, 88
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2><a name=\"attributes\">Software Attributes</a></h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>JVM Version</td>\n                    <td>");
    // 309, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(JvmVersion.getVersion()), jamonWriter);
    // 309, 54
    jamonWriter.write("</td>\n                    <td>JVM vendor and version</td>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 314, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 314, 84
    jamonWriter.write(", revision=");
    // 314, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 314, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 318, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 318, 81
    jamonWriter.write(", ");
    // 318, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 318, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 323, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 323, 88
    jamonWriter.write("</td>\n                    <td>HBase source SHA512 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 328, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 328, 78
    jamonWriter.write(", revision=");
    // 328, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 328, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 333, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 333, 75
    jamonWriter.write(", ");
    // 333, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 333, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 338, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 338, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 343, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 343, 72
    jamonWriter.write(", revision=");
    // 343, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevisionHash()), jamonWriter);
    // 343, 135
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision hash</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 348, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 348, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
    // 354, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 354, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
    // 359, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 359, 79
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>Cluster Key</td>\n                    <td> ");
    // 364, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 364, 48
    jamonWriter.write(":");
    // 364, 49
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 364, 102
    jamonWriter.write("</td>\n                    <td>Key to add this cluster as a peer for replication. Use 'help \"add_peer\"' in the shell for details.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 369, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(CommonFSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 369, 93
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 374, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 374, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 377, 17
    if (master.isActiveMaster() )
    {
      // 377, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 380, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 380, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 385, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 385, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 390, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 391, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 394, 18
      if (frags != null )
      {
        // 394, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 397, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 397, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 400, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 403, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 404, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 409, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 409, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 412, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/parser-date-iso8601.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jqSpager.js\" type=\"text/javascript\"></script>\n    <script>\n    $(document).ready(function()\n        {\n            $.tablesorter.addParser(\n            {\n                id: 'filesize',\n                is: function(s) {\n                    return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n                },\n                format: function(s) {\n                    var suf = s.match(new RegExp( /(KB|B|GB|MB|TB)$/ ))[1];\n                    var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                    switch(suf) {\n                        case 'B':\n                            return num;\n                        case 'KB':\n                           return num * 1024;\n                        case 'MB':\n                            return num * 1024 * 1024;\n                        case 'GB':\n                            return num * 1024 * 1024 * 1024;\n                        case 'TB':\n                            return num * 1024 * 1024 * 1024 * 1024;\n                    }\n                },\n                type: 'numeric'\n            });\n            $.tablesorter.addParser(\n            {\n                id: \"separator\",\n                is: function (s) {\n                    return /^[0-9]?[0-9,]*$/.test(s);\n                }, format: function (s) {\n                    return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n                }, type: \"numeric\"\n            });\n            $.tablesorter.addParser(\n            {\n                id: \"dateTime\",\n                is: function (s) {\n                    return /^([a-zA-Z]{3}\\s){2}\\d{2}\\s\\d{2}:\\d{2}:\\d{2}\\s[a-zA-Z]{3}\\s\\d{4}$/.test(s);\n                }, format: function (s) {\n                    var split = s.split(\" \");\n                    var time = Date.parse(split[1] + \" \" + split[2] + \" \" + split[3] + \" \" + split[5]);\n                    return $.tablesorter.formatFloat(time);\n                }, type: \"numeric\"\n            });\n            $(\"#baseStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'dateTime'},\n                    4: {sorter: 'separator'},\n                    5: {sorter: 'separator'}\n                }\n            });\n            $(\"#memoryStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'filesize'},\n                    2: {sorter: 'filesize'},\n                    3: {sorter: 'filesize'}\n                }\n            });\n            $(\"#requestStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n                    4: {sorter: 'separator'}\n                }\n            });\n            $(\"#storeStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'filesize'},\n                    4: {sorter: 'filesize'},\n                    5: {sorter: 'filesize'},\n                    6: {sorter: 'filesize'}\n                }\n            });\n            $(\"#compactionStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'}\n                }\n            });\n\n            $(\"#userTables\").tablesorter();\n\n            function showRitPages() {\n                if (!$(\"#rit_page_num\")) {\n                  return;\n                }\n                var ritTotalNum = parseInt($(\"#rit_page_num\").val());\n                if (!ritTotalNum || ritTotalNum < 1) {\n                  return;\n                }\n                var ritPerPage = parseInt($(\"#rit_per_page\").val());\n\n                 $(\"#rit_pagination\").sPage({\n                      page:1,\n                      total:ritTotalNum,\n                      pageSize:ritPerPage,\n                      noData: false,\n                      showPN:true,\n                      prevPage:\"prev\",\n                      nextPage:\"next\",\n                      fastForward: 5,\n                      backFun:function(page){\n                          $(\"div[id^='tab_rits']\").removeClass('active');\n                          $(\"#tab_rits\"+page).addClass('active');\n                      }\n                  });\n\n            }\n            showRitPages();\n\n        }\n    );\n    </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 547, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 548, 1
    
 List<TableDescriptor> sysTables = master.isInitialized() ?
   master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;

    // 552, 1
    if ((sysTables != null && sysTables.size() > 0))
    {
      // 552, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 556, 5
      if ((frags != null) )
      {
        // 556, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 558, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 561, 1
      for (TableDescriptor systemTable : sysTables)
      {
        // 561, 48
        jamonWriter.write("\n<tr>\n");
        // 563, 1
        TableName tableName = systemTable.getTableName();
        // 564, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 564, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 564, 48
        jamonWriter.write("\">");
        // 564, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 564, 65
        jamonWriter.write("</a></td>\n    ");
        // 565, 5
        if ((frags != null))
        {
          // 565, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 566, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 567, 37
          jamonWriter.write("</td>\n    ");
        }
        // 568, 11
        jamonWriter.write("\n    ");
        // 569, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(CanaryTool.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(PermissionStorage.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl.";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups.";
        } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
            description = "The hbase:replication table tracks cross cluster replication through " +
            "WAL file offsets.";
        }
    
        // 591, 5
        jamonWriter.write("<td>");
        // 591, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 591, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 593, 8
      jamonWriter.write("\n</table>\n");
    }
    // 595, 7
    jamonWriter.write("\n");
  }
  
  
  // 685, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 687, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 687, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 695, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 701, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 703, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 703, 33
      jamonWriter.write("</td>\n        <td>");
      // 704, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 704, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 706, 5
      
        }
    
      // 709, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 711, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 711, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 715, 7
    jamonWriter.write("\n");
  }
  
  
  // 718, 1
  private void __jamon_innerUnit__peerConfigs(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 719, 1
    
    List<ReplicationPeerDescription> peers = null;
    if (master.getReplicationPeerManager() != null) {
        peers = master.getReplicationPeerManager().listPeers(null);
    }

    // 725, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Endpoint</th>\n        <th>State</th>\n        <th>IsSerial</th>\n        <th>Bandwidth</th>\n        <th>ReplicateAll</th>\n        <th>Namespaces</th>\n        <th>Exclude Namespaces</th>\n        <th>Table Cfs</th>\n        <th>Exclude Table Cfs</th>\n    </tr>\n");
    // 739, 1
    if ((peers != null && peers.size() > 0))
    {
      // 739, 43
      jamonWriter.write("\n    ");
      // 740, 5
      for (ReplicationPeerDescription peer : peers )
      {
        // 740, 53
        jamonWriter.write("\n    ");
        // 741, 5
        
        String peerId = peer.getPeerId();
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
    
        // 745, 5
        jamonWriter.write("<tr>\n        <td>");
        // 746, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerId), jamonWriter);
        // 746, 25
        jamonWriter.write("</td>\n        <td>");
        // 747, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
        // 747, 45
        jamonWriter.write("</td>\n        <td>");
        // 748, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getReplicationEndpointImpl()), jamonWriter);
        // 748, 58
        jamonWriter.write("</td>\n        <td>");
        // 749, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peer.isEnabled() ? "ENABLED" : "DISABLED"), jamonWriter);
        // 749, 60
        jamonWriter.write("</td>\n        <td>");
        // 750, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.isSerial()), jamonWriter);
        // 750, 40
        jamonWriter.write("</td>\n        <td>");
        // 751, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getBandwidth() == 0? "UNLIMITED" : StringUtils.humanReadableInt(peerConfig.getBandwidth())), jamonWriter);
        // 751, 120
        jamonWriter.write("</td>\n        <td>");
        // 752, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.replicateAllUserTables()), jamonWriter);
        // 752, 54
        jamonWriter.write("</td>\n        <td>\n           ");
        // 754, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 754, 151
        jamonWriter.write("\n        </td>\n        <td>\n            ");
        // 757, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 757, 166
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 760, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 760, 153
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 763, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 763, 167
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 766, 12
      jamonWriter.write("\n");
    }
    // 767, 7
    jamonWriter.write("\n<tr><td>Total: ");
    // 768, 16
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf((peers != null) ? peers.size() : 0), jamonWriter);
    // 768, 56
    jamonWriter.write("</td></tr>\n</table>\n");
  }
  
  
  // 598, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 599, 1
    
   List<TableDescriptor> tables = new ArrayList<TableDescriptor>();
   String errorMessage = getUserTables(master, tables);

    // 603, 1
    if ((tables.size() == 0 && errorMessage != null))
    {
      // 603, 52
      jamonWriter.write("\n<p> ");
      // 604, 5
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(errorMessage), jamonWriter);
      // 604, 23
      jamonWriter.write(" </p>\n");
    }
    // 605, 7
    jamonWriter.write("\n\n");
    // 607, 1
    if ((tables != null && tables.size() > 0))
    {
      // 607, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Namespace</th>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Name</th>\n        ");
      // 613, 9
      if ((frags != null) )
      {
        // 613, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 615, 15
      jamonWriter.write("\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">State</th>\n        <th style=\"text-align: center\" colspan=\"7\">Regions</th>\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">Description</th>\n    </tr>\n    <tr>\n        <th>OPEN</th>\n        <th>OPENING</th>\n        <th>CLOSED</th>\n        <th>CLOSING</th>\n        <th>OFFLINE</th>\n        <th>SPLIT</th>\n        <th>Other</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 631, 5
      for (TableDescriptor desc : tables)
      {
        // 631, 42
        jamonWriter.write("\n    ");
        // 632, 5
        
      HTableDescriptor htDesc = new HTableDescriptor(desc);
      TableName tableName = htDesc.getTableName();
      TableState tableState = master.getTableStateManager().getTableState(tableName);
      Map<RegionState.State, List<RegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int openingRegionsCount = tableRegions.get(RegionState.State.OPENING).size();
      int closedRegionsCount = tableRegions.get(RegionState.State.CLOSED).size();
      int closingRegionsCount = tableRegions.get(RegionState.State.CLOSING).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int otherRegionsCount = 0;
      for (List<RegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - offlineRegionsCount - splitRegionsCount
                     - openingRegionsCount - closedRegionsCount
                     - closingRegionsCount;
    String encodedTableName = URLEncoder.encode(tableName.getNameAsString());
    
        // 656, 5
        jamonWriter.write("<tr>\n        <td>");
        // 657, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 657, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 658, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
        // 658, 58
        jamonWriter.write(">");
        // 658, 59
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(URLEncoder.encode(tableName.getQualifierAsString())), jamonWriter);
        // 658, 116
        jamonWriter.write("</a> </td>\n        ");
        // 659, 9
        if ((frags != null) )
        {
          // 659, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 660, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 660, 150
          jamonWriter.write("</td>\n        ");
        }
        // 661, 15
        jamonWriter.write("\n        <td>");
        // 662, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableState.getState()), jamonWriter);
        // 662, 40
        jamonWriter.write("</td>\n        <td>");
        // 663, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 663, 35
        jamonWriter.write("</td>\n        ");
        // 664, 9
        if ((openingRegionsCount > 0) )
        {
          // 664, 42
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 664, 96
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 664, 118
          jamonWriter.write("&scan_region_state=OPENING\">");
          // 664, 146
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 664, 171
          jamonWriter.write("</td> ");
        }
        // 664, 177
        else
        {
          // 664, 184
          jamonWriter.write("<td>");
          // 664, 188
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 664, 213
          jamonWriter.write("</td> ");
        }
        // 664, 225
        jamonWriter.write("\n        ");
        // 665, 9
        if ((closedRegionsCount > 0) )
        {
          // 665, 41
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 665, 95
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 665, 117
          jamonWriter.write("&scan_region_state=CLOSED\">");
          // 665, 144
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
          // 665, 168
          jamonWriter.write("</td> ");
        }
        // 665, 174
        else
        {
          // 665, 181
          jamonWriter.write("<td>");
          // 665, 185
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
          // 665, 209
          jamonWriter.write("</td> ");
        }
        // 665, 221
        jamonWriter.write("\n        ");
        // 666, 9
        if ((closingRegionsCount > 0) )
        {
          // 666, 42
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 666, 96
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 666, 118
          jamonWriter.write("&scan_region_state=CLOSING\">");
          // 666, 146
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 666, 171
          jamonWriter.write("</td> ");
        }
        // 666, 177
        else
        {
          // 666, 184
          jamonWriter.write("<td>");
          // 666, 188
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 666, 213
          jamonWriter.write("</td> ");
        }
        // 666, 225
        jamonWriter.write("\n        ");
        // 667, 9
        if ((offlineRegionsCount > 0) )
        {
          // 667, 42
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 667, 96
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 667, 118
          jamonWriter.write("&scan_region_state=OFFLINE\">");
          // 667, 146
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
          // 667, 171
          jamonWriter.write("</td> ");
        }
        // 667, 177
        else
        {
          // 667, 184
          jamonWriter.write("<td>");
          // 667, 188
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
          // 667, 213
          jamonWriter.write("</td> ");
        }
        // 667, 225
        jamonWriter.write("\n        ");
        // 668, 9
        if ((splitRegionsCount > 0) )
        {
          // 668, 40
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 668, 94
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 668, 116
          jamonWriter.write("&scan_region_state=SPLIT\">");
          // 668, 142
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
          // 668, 165
          jamonWriter.write("</td> ");
        }
        // 668, 171
        else
        {
          // 668, 178
          jamonWriter.write("<td>");
          // 668, 182
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
          // 668, 205
          jamonWriter.write("</td> ");
        }
        // 668, 217
        jamonWriter.write("\n        <td>");
        // 669, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 669, 36
        jamonWriter.write("</td>\n        <td>");
        // 670, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 670, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 672, 12
      jamonWriter.write("\n    <p>");
      // 673, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.size()), jamonWriter);
      // 673, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]. Click count below to\n    see list of regions currently in 'state' designated by the column title. For 'Other' Region state,\n    browse to <a href=\"/table.jsp?name=hbase%3Ameta\">hbase:meta</a> and adjust filter on 'Meta Entries' to\n    query on states other than those listed here. Queries may take a while if the <i>hbase:meta</i> table\n    is large.</p>\n</tbody>\n</table>\n");
    }
    // 680, 7
    jamonWriter.write("\n");
  }
  
  
}
