/*
 * Copyright (c) 2016, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.hbase.thirdparty.org.glassfish.hk2.utilities;

/**
 * The mode of the duplicate post processor
 * 
 * @author jwells
 *
 */
public enum DuplicatePostProcessorMode {
	/** Uses the equals method of {@link DescriptorImpl} which includes most of the fields of the descriptor */
	STRICT,
	
	/**
	 * Uses the {@link org.apache.hbase.thirdparty.org.glassfish.hk2.api.Descriptor#getImplementation()} method
	 * and {@link org.apache.hbase.thirdparty.org.glassfish.hk2.api.Descriptor#getDescriptorType()} to compare descriptors */
	IMPLEMENTATION_ONLY

}
