// Autogenerated Jamon implementation
// /home/vagrant/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.commons.lang3.time.FastDateFormat;
// 26, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 9
import org.apache.hadoop.hbase.util.Bytes;
// 28, 9
import org.apache.hadoop.hbase.client.RegionInfo;
// 29, 9
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
// 30, 9
import org.apache.hadoop.hbase.regionserver.Region;
// 31, 9
import org.apache.hadoop.hbase.ServerName;
// 32, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 33, 9
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
// 34, 9
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.ServerInfo;
// 35, 9
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 36, 9
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
// 37, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
// 38, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<RegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 40, 60
      jamonWriter.write("\n\n    ");
      // 42, 5
      
        Collections.sort(onlineRegions, RegionInfo.COMPARATOR);
    
      // 46, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 56, 17
      {
        // 56, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 56, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 59, 17
      {
        // 59, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 59, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 62, 17
      {
        // 62, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 62, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 65, 17
      {
        // 65, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 65, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 68, 17
      {
        // 68, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 68, 67
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.apache.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 83, 1
    else
    {
      // 83, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 85, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 87, 1
  private void __jamon_innerUnit__baseInfo(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 91, 5
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 102, 9
    for (RegionInfo r: onlineRegions )
    {
      // 102, 45
      jamonWriter.write("\n        <tr>\n            ");
      // 104, 13
      
             String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
               regionServer.getConfiguration());
            
      // 108, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 108, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 108, 66
      jamonWriter.write("\">");
      // 108, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 108, 85
      jamonWriter.write("</a></td>\n            <td>");
      // 109, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(RegionInfoDisplay.getStartKeyForDisplay(r,
                                        regionServer.getConfiguration()))), jamonWriter);
      // 110, 77
      jamonWriter.write("</td>\n            <td>");
      // 111, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(RegionInfoDisplay.getEndKeyForDisplay(r,
                                        regionServer.getConfiguration()))), jamonWriter);
      // 112, 77
      jamonWriter.write("</td>\n            <td>");
      // 113, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getReplicaId()), jamonWriter);
      // 113, 39
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 115, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 228, 1
  private void __jamon_innerUnit__compactStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 232, 5
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting Cells</th>\n            <th>Num. Compacted Cells</th>\n            <th>Compaction Progress</th>\n            <th data-date-format=\"yyyymmdd hhmm zz\">Last Major Compaction</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 244, 9
    for (RegionInfo r: onlineRegions )
    {
      // 244, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 247, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            String compactTime = "";
            if  (load != null) {
              if (load.getTotalCompactingKVs() > 0) {
                percentDone = String.format("%.2f", 100 *
                    ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
              }
              if (load.getLastMajorCompactionTs() > 0) {
                FastDateFormat fdf = FastDateFormat.getInstance("yyyy-MM-dd HH:mm (ZZ)");
                compactTime = fdf.format(load.getLastMajorCompactionTs());
              }
            }
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 264, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 264, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 264, 66
      jamonWriter.write("\">");
      // 264, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 264, 85
      jamonWriter.write("</a></td>\n            ");
      // 265, 13
      if (load != null )
      {
        // 265, 33
        jamonWriter.write("\n            <td>");
        // 266, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getTotalCompactingKVs())), jamonWriter);
        // 266, 74
        jamonWriter.write("</td>\n            <td>");
        // 267, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getCurrentCompactedKVs())), jamonWriter);
        // 267, 75
        jamonWriter.write("</td>\n            <td>");
        // 268, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 268, 34
        jamonWriter.write("</td>\n            <td>");
        // 269, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(compactTime), jamonWriter);
        // 269, 34
        jamonWriter.write("</td>\n            ");
      }
      // 270, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 272, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 277, 1
  private void __jamon_innerUnit__memstoreStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 281, 5
    jamonWriter.write("<table id=\"memstoreStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 290, 9
    for (RegionInfo r: onlineRegions )
    {
      // 290, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 293, 9
      
            final String ZEROMB = "0 MB";
            String memStoreSizeMBStr = ZEROMB;
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
              if (load != null) {
              long memStoreSizeMB = load.getMemStoreSizeMB();
              if (memStoreSizeMB > 0) {
              memStoreSizeMBStr = TraditionalBinaryPrefix.long2String(
                         memStoreSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1);
               }
             }
        
      // 307, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 307, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 307, 66
      jamonWriter.write("\">");
      // 307, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 307, 85
      jamonWriter.write("</a></td>\n            ");
      // 308, 13
      if (load != null )
      {
        // 308, 33
        jamonWriter.write("\n            <td>");
        // 309, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(memStoreSizeMBStr), jamonWriter);
        // 309, 40
        jamonWriter.write("</td>\n            ");
      }
      // 310, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 312, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 120, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 124, 5
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Filtered Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 135, 9
    for (RegionInfo r: onlineRegions )
    {
      // 135, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 138, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 143, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 143, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 143, 66
      jamonWriter.write("\">");
      // 143, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 143, 85
      jamonWriter.write("</a></td>\n            ");
      // 144, 13
      if (load != null )
      {
        // 144, 33
        jamonWriter.write("\n            <td>");
        // 145, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getReadRequestsCount())), jamonWriter);
        // 145, 73
        jamonWriter.write("</td>\n            <td>");
        // 146, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getFilteredReadRequestsCount())), jamonWriter);
        // 146, 81
        jamonWriter.write("</td>\n            <td>");
        // 147, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getWriteRequestsCount())), jamonWriter);
        // 147, 74
        jamonWriter.write("</td>\n            ");
      }
      // 148, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 150, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 156, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 160, 5
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 175, 9
    for (RegionInfo r: onlineRegions )
    {
      // 175, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 178, 9
      
            final String ZEROMB = "0 MB";
            final String ZEROKB = "0 KB";
            String uncompressedStorefileSizeStr = ZEROMB;
            String storefileSizeStr = ZEROMB;
            String indexSizeStr = ZEROKB;
            String bloomSizeStr = ZEROKB;
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
             if (load != null) {
             long uncompressedStorefileSize  = load.getStoreUncompressedSizeMB();
             long storefileSize  = load.getStorefileSizeMB();
             long indexSize  = load.getTotalStaticIndexSizeKB();
             long bloomSize  = load.getTotalStaticBloomSizeKB();
             if (uncompressedStorefileSize > 0) {
                uncompressedStorefileSizeStr = TraditionalBinaryPrefix.long2String(
                    uncompressedStorefileSize * TraditionalBinaryPrefix.MEGA.value, "B", 1);
             }
             if (storefileSize > 0) {
                storefileSizeStr = TraditionalBinaryPrefix.long2String(storefileSize
                             * TraditionalBinaryPrefix.MEGA.value, "B", 1);
             }
             if(indexSize > 0) {
               indexSizeStr = TraditionalBinaryPrefix.long2String(indexSize
                                              * TraditionalBinaryPrefix.KILO.value, "B", 1);
             }
             if (bloomSize > 0) {
               bloomSizeStr = TraditionalBinaryPrefix.long2String(bloomSize
                                              * TraditionalBinaryPrefix.KILO.value, "B", 1);
              }
           }
        
      // 211, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 211, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 211, 66
      jamonWriter.write("\">");
      // 211, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 211, 85
      jamonWriter.write("</a></td>\n            ");
      // 212, 13
      if (load != null )
      {
        // 212, 33
        jamonWriter.write("\n            <td>");
        // 213, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getStores())), jamonWriter);
        // 213, 62
        jamonWriter.write("</td>\n            <td>");
        // 214, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getStorefiles())), jamonWriter);
        // 214, 66
        jamonWriter.write("</td>\n            <td>");
        // 215, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(uncompressedStorefileSizeStr), jamonWriter);
        // 215, 51
        jamonWriter.write("</td>\n            <td>");
        // 216, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storefileSizeStr), jamonWriter);
        // 216, 39
        jamonWriter.write("</td>\n            <td>");
        // 217, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(indexSizeStr), jamonWriter);
        // 217, 35
        jamonWriter.write("</td>\n            <td>");
        // 218, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bloomSizeStr), jamonWriter);
        // 218, 35
        jamonWriter.write("</td>\n            <td>");
        // 219, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getDataLocality()), jamonWriter);
        // 219, 45
        jamonWriter.write("</td>\n            ");
      }
      // 220, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 222, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
}
