/*
 * Copyright 2015 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.example.http2.helloworld.server;

import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2FrameLogger;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2Settings;

import static org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.handler.logging.LogLevel.INFO;

public final class HelloWorldHttp2HandlerBuilder
        extends AbstractHttp2ConnectionHandlerBuilder<HelloWorldHttp2Handler, HelloWorldHttp2HandlerBuilder> {

    private static final Http2FrameLogger logger = new Http2FrameLogger(INFO, HelloWorldHttp2Handler.class);

    public HelloWorldHttp2HandlerBuilder() {
        frameLogger(logger);
    }

    @Override
    public HelloWorldHttp2Handler build() {
        return super.build();
    }

    @Override
    protected HelloWorldHttp2Handler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder,
                                           Http2Settings initialSettings) {
        HelloWorldHttp2Handler handler = new HelloWorldHttp2Handler(decoder, encoder, initialSettings);
        frameListener(handler);
        return handler;
    }
}
