// $ANTLR 3.5.2 PhoenixSQL.g 2021-03-16 12:15:52

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.filter.CompareFilter.CompareOp;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "BETWEEN", 
		"BIND_NAME", "BY", "CACHE", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_ESC", 
		"CLOSE", "COLON", "COLUMN", "COLUMNS", "COMMA", "COMMENT_AND_HINT_END", 
		"COMMENT_START", "CONCAT", "CONSTANT", "CONSTRAINT", "CREATE", "CURRENT", 
		"CURSOR", "CYCLE", "DBL_QUOTE_CHAR", "DECIMAL", "DECLARE", "DEFAULT", 
		"DEFAULTVALUE", "DELETE", "DESC", "DIGIT", "DISABLE", "DISTINCT", "DIVIDE", 
		"DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", "DROP", "DUPLICATE", "ELSE", 
		"END", "EOL", "EQ", "EXECUTE", "EXISTS", "EXPLAIN", "Exponent", "FALSE", 
		"FETCH", "FIELDCHAR", "FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GRANT", 
		"GROUP", "GT", "HAVING", "HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", 
		"IN", "INCLUDE", "INCREMENT", "INDEX", "INNER", "INTO", "IS", "JAR", "JARS", 
		"JOIN", "KEY", "LAST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", 
		"LOCAL", "LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NULL", "NULLS", "NUMBER", 
		"OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", "OTHER", "OUTER", 
		"OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "PRIMARY", "QUESTION", 
		"RCURLY", "REBUILD", "REPLACE", "RETURNS", "REVOKE", "RIGHT", "ROW", "ROWS", 
		"ROW_TIMESTAMP", "RPAREN", "RSQUARE", "SAMPLING", "SCHEMA", "SCHEMAS", 
		"SELECT", "SEMICOLON", "SEQUENCE", "SESSION", "SET", "SHOW", "SL_COMMENT", 
		"SL_COMMENT1", "SL_COMMENT2", "SOME", "SPLIT", "START", "STATISTICS", 
		"STRING_LITERAL", "TABLE", "TABLES", "TABLESAMPLE", "TEMPORARY", "THEN", 
		"TILDE", "TO", "TRACE", "TRUE", "UNION", "UNUSABLE", "UPDATE", "UPGRADE", 
		"UPSERT", "USABLE", "USE", "USING", "VALUE", "VALUES", "VIEW", "WHEN", 
		"WHERE", "WITH", "WITHIN", "WS"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int BETWEEN=16;
	public static final int BIND_NAME=17;
	public static final int BY=18;
	public static final int CACHE=19;
	public static final int CASCADE=20;
	public static final int CASE=21;
	public static final int CAST=22;
	public static final int CHAR=23;
	public static final int CHAR_ESC=24;
	public static final int CLOSE=25;
	public static final int COLON=26;
	public static final int COLUMN=27;
	public static final int COLUMNS=28;
	public static final int COMMA=29;
	public static final int COMMENT_AND_HINT_END=30;
	public static final int COMMENT_START=31;
	public static final int CONCAT=32;
	public static final int CONSTANT=33;
	public static final int CONSTRAINT=34;
	public static final int CREATE=35;
	public static final int CURRENT=36;
	public static final int CURSOR=37;
	public static final int CYCLE=38;
	public static final int DBL_QUOTE_CHAR=39;
	public static final int DECIMAL=40;
	public static final int DECLARE=41;
	public static final int DEFAULT=42;
	public static final int DEFAULTVALUE=43;
	public static final int DELETE=44;
	public static final int DESC=45;
	public static final int DIGIT=46;
	public static final int DISABLE=47;
	public static final int DISTINCT=48;
	public static final int DIVIDE=49;
	public static final int DOT=50;
	public static final int DOUBLE=51;
	public static final int DOUBLE_EQ=52;
	public static final int DOUBLE_QUOTE=53;
	public static final int DROP=54;
	public static final int DUPLICATE=55;
	public static final int ELSE=56;
	public static final int END=57;
	public static final int EOL=58;
	public static final int EQ=59;
	public static final int EXECUTE=60;
	public static final int EXISTS=61;
	public static final int EXPLAIN=62;
	public static final int Exponent=63;
	public static final int FALSE=64;
	public static final int FETCH=65;
	public static final int FIELDCHAR=66;
	public static final int FIRST=67;
	public static final int FOR=68;
	public static final int FROM=69;
	public static final int FULL=70;
	public static final int FUNCTION=71;
	public static final int GRANT=72;
	public static final int GROUP=73;
	public static final int GT=74;
	public static final int HAVING=75;
	public static final int HINT_START=76;
	public static final int IF=77;
	public static final int IGNORE=78;
	public static final int ILIKE=79;
	public static final int IMMUTABLE=80;
	public static final int IN=81;
	public static final int INCLUDE=82;
	public static final int INCREMENT=83;
	public static final int INDEX=84;
	public static final int INNER=85;
	public static final int INTO=86;
	public static final int IS=87;
	public static final int JAR=88;
	public static final int JARS=89;
	public static final int JOIN=90;
	public static final int KEY=91;
	public static final int LAST=92;
	public static final int LCURLY=93;
	public static final int LEFT=94;
	public static final int LETTER=95;
	public static final int LIKE=96;
	public static final int LIMIT=97;
	public static final int LIST=98;
	public static final int LOCAL=99;
	public static final int LPAREN=100;
	public static final int LSQUARE=101;
	public static final int LT=102;
	public static final int MAXVALUE=103;
	public static final int MINUS=104;
	public static final int MINVALUE=105;
	public static final int ML_COMMENT=106;
	public static final int ML_HINT=107;
	public static final int NAME=108;
	public static final int NEXT=109;
	public static final int NOEQ1=110;
	public static final int NOEQ2=111;
	public static final int NOT=112;
	public static final int NULL=113;
	public static final int NULLS=114;
	public static final int NUMBER=115;
	public static final int OFF=116;
	public static final int OFFSET=117;
	public static final int ON=118;
	public static final int ONLY=119;
	public static final int OPEN=120;
	public static final int OR=121;
	public static final int ORDER=122;
	public static final int OTHER=123;
	public static final int OUTER=124;
	public static final int OUTER_JOIN=125;
	public static final int PERCENT=126;
	public static final int PLUS=127;
	public static final int POSINTEGER=128;
	public static final int PRIMARY=129;
	public static final int QUESTION=130;
	public static final int RCURLY=131;
	public static final int REBUILD=132;
	public static final int REPLACE=133;
	public static final int RETURNS=134;
	public static final int REVOKE=135;
	public static final int RIGHT=136;
	public static final int ROW=137;
	public static final int ROWS=138;
	public static final int ROW_TIMESTAMP=139;
	public static final int RPAREN=140;
	public static final int RSQUARE=141;
	public static final int SAMPLING=142;
	public static final int SCHEMA=143;
	public static final int SCHEMAS=144;
	public static final int SELECT=145;
	public static final int SEMICOLON=146;
	public static final int SEQUENCE=147;
	public static final int SESSION=148;
	public static final int SET=149;
	public static final int SHOW=150;
	public static final int SL_COMMENT=151;
	public static final int SL_COMMENT1=152;
	public static final int SL_COMMENT2=153;
	public static final int SOME=154;
	public static final int SPLIT=155;
	public static final int START=156;
	public static final int STATISTICS=157;
	public static final int STRING_LITERAL=158;
	public static final int TABLE=159;
	public static final int TABLES=160;
	public static final int TABLESAMPLE=161;
	public static final int TEMPORARY=162;
	public static final int THEN=163;
	public static final int TILDE=164;
	public static final int TO=165;
	public static final int TRACE=166;
	public static final int TRUE=167;
	public static final int UNION=168;
	public static final int UNUSABLE=169;
	public static final int UPDATE=170;
	public static final int UPGRADE=171;
	public static final int UPSERT=172;
	public static final int USABLE=173;
	public static final int USE=174;
	public static final int USING=175;
	public static final int VALUE=176;
	public static final int VALUES=177;
	public static final int VIEW=178;
	public static final int WHEN=179;
	public static final int WHERE=180;
	public static final int WITH=181;
	public static final int WITHIN=182;
	public static final int WS=183;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }
	    
	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:385:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:386:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==GRANT||LA1_0==LIST||LA1_0==OPEN||LA1_0==REVOKE||LA1_0==SELECT||LA1_0==SHOW||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:386:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1295);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1299); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:393:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1308); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:397:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:398:5: (s= oneStatement EOF )
			// PhoenixSQL.g:398:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1334);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1338); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:408:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:409:5: (s= select_node EOF )
			// PhoenixSQL.g:409:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1364);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1366); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:413:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:415:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:415:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:415:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=32;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=22;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case SEQUENCE:
					{
					alt2=24;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=18;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=8;
				}
				break;
			case CLOSE:
				{
				alt2=9;
				}
				break;
			case FETCH:
				{
				alt2=10;
				}
				break;
			case DECLARE:
				{
				alt2=11;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=13;
					}
					break;
				case FUNCTION:
					{
					alt2=19;
					}
					break;
				case SEQUENCE:
					{
					alt2=27;
					}
					break;
				case SCHEMA:
					{
					alt2=28;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=12;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case SESSION:
					{
					alt2=23;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=15;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case SHOW:
				{
				alt2=16;
				}
				break;
			case TRACE:
				{
				alt2=17;
				}
				break;
			case ADD:
				{
				alt2=20;
				}
				break;
			case LIST:
				{
				alt2=21;
				}
				break;
			case GRANT:
				{
				alt2=25;
				}
				break;
			case REVOKE:
				{
				alt2=26;
				}
				break;
			case USE:
				{
				alt2=29;
				}
				break;
			case UPDATE:
				{
				alt2=30;
				}
				break;
			case EXECUTE:
				{
				alt2=31;
				}
				break;
			case EXPLAIN:
				{
				alt2=32;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:415:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1398);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:416:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1408);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:417:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1420);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:418:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1432);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:419:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1444);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:420:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1456);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:421:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1468);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:422:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1480);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:423:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1492);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:424:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1504);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:425:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1516);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:426:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1528);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:427:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1540);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:428:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1552);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:429:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1564);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:430:9: s= show_node
					{
					pushFollow(FOLLOW_show_node_in_oneStatement1576);
					s=show_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:431:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1588);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:432:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1600);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:433:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1612);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:434:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1624);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:435:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1636);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:436:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1648);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:437:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1660);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:438:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1670);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:439:9: s= grant_permission_node
					{
					pushFollow(FOLLOW_grant_permission_node_in_oneStatement1682);
					s=grant_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:440:9: s= revoke_permission_node
					{
					pushFollow(FOLLOW_revoke_permission_node_in_oneStatement1694);
					s=revoke_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:441:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1704);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:442:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1714);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:443:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1724);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 30 :
					// PhoenixSQL.g:444:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1736);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 31 :
					// PhoenixSQL.g:445:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1748);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 32 :
					// PhoenixSQL.g:446:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1760);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:450:1: explain_node returns [BindableStatement ret] : EXPLAIN q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement q =null;

		try {
			// PhoenixSQL.g:451:5: ( EXPLAIN q= oneStatement )
			// PhoenixSQL.g:451:9: EXPLAIN q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1793); if (state.failed) return ret;
			pushFollow(FOLLOW_oneStatement_in_explain_node1797);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =factory.explain(q);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:455:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;

		try {
			// PhoenixSQL.g:456:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? )
			// PhoenixSQL.g:456:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1823); if (state.failed) return ret;
			// PhoenixSQL.g:456:16: (im= IMMUTABLE )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==IMMUTABLE) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:456:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1828); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node1832); if (state.failed) return ret;
			// PhoenixSQL.g:456:38: ( IF NOT ex= EXISTS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==IF) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:456:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node1835); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node1837); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node1841); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node1847);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:457:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:457:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node1859); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node1863);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:457:31: (pk= pk_constraint )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==COMMA||LA5_0==CONSTRAINT) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:457:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node1868);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node1872); if (state.failed) return ret;
			}

			// PhoenixSQL.g:458:9: (p= fam_properties )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==NAME) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:458:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node1886);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:459:9: ( SPLIT ON s= value_expression_list )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==SPLIT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:459:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node1899); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node1901); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node1905);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:464:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:465:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:465:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node1944); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node1946); if (state.failed) return ret;
			// PhoenixSQL.g:465:23: ( IF NOT ex= EXISTS )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==IF) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:465:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node1949); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node1951); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node1955); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:465:43: ( DEFAULT |s= identifier )
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==DEFAULT) ) {
				alt9=1;
			}
			else if ( (LA9_0==NAME) ) {
				alt9=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}

			switch (alt9) {
				case 1 :
					// PhoenixSQL.g:465:44: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_create_schema_node1960); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:465:54: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_create_schema_node1966);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "grant_permission_node"
	// PhoenixSQL.g:470:1: grant_permission_node returns [ChangePermsStatement ret] : GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal ;
	public final ChangePermsStatement grant_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:471:5: ( GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal )
			// PhoenixSQL.g:471:9: GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal
			{
			match(input,GRANT,FOLLOW_GRANT_in_grant_permission_node2001); if (state.failed) return ret;
			pushFollow(FOLLOW_literal_in_grant_permission_node2005);
			p=literal();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:471:25: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==ON) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:471:26: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_grant_permission_node2008); if (state.failed) return ret;
					// PhoenixSQL.g:471:29: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==NAME||LA11_0==TABLE) ) {
						alt11=1;
					}
					else if ( (LA11_0==SCHEMA) ) {
						alt11=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 11, 0, input);
						throw nvae;
					}

					switch (alt11) {
						case 1 :
							// PhoenixSQL.g:471:30: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:471:30: ( TABLE )?
							int alt10=2;
							int LA10_0 = input.LA(1);
							if ( (LA10_0==TABLE) ) {
								alt10=1;
							}
							switch (alt10) {
								case 1 :
									// PhoenixSQL.g:471:31: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_grant_permission_node2012); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_grant_permission_node2018);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:471:58: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_grant_permission_node2024); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_grant_permission_node2028);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,TO,FOLLOW_TO_in_grant_permission_node2033); if (state.failed) return ret;
			// PhoenixSQL.g:471:91: (g= GROUP )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==GROUP) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// PhoenixSQL.g:471:92: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_grant_permission_node2038); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_grant_permission_node2044);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.TRUE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "grant_permission_node"



	// $ANTLR start "revoke_permission_node"
	// PhoenixSQL.g:482:1: revoke_permission_node returns [ChangePermsStatement ret] : REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal ;
	public final ChangePermsStatement revoke_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:483:5: ( REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal )
			// PhoenixSQL.g:483:9: REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal
			{
			match(input,REVOKE,FOLLOW_REVOKE_in_revoke_permission_node2078); if (state.failed) return ret;
			// PhoenixSQL.g:483:16: (p= literal )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==DECIMAL||LA14_0==DOUBLE||LA14_0==FALSE||LA14_0==NAME||LA14_0==NULL||LA14_0==NUMBER||LA14_0==STRING_LITERAL||LA14_0==TRUE) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// PhoenixSQL.g:483:17: p= literal
					{
					pushFollow(FOLLOW_literal_in_revoke_permission_node2083);
					p=literal();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:483:29: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==ON) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:483:30: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_revoke_permission_node2088); if (state.failed) return ret;
					// PhoenixSQL.g:483:33: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt16=2;
					int LA16_0 = input.LA(1);
					if ( (LA16_0==NAME||LA16_0==TABLE) ) {
						alt16=1;
					}
					else if ( (LA16_0==SCHEMA) ) {
						alt16=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 16, 0, input);
						throw nvae;
					}

					switch (alt16) {
						case 1 :
							// PhoenixSQL.g:483:34: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:483:34: ( TABLE )?
							int alt15=2;
							int LA15_0 = input.LA(1);
							if ( (LA15_0==TABLE) ) {
								alt15=1;
							}
							switch (alt15) {
								case 1 :
									// PhoenixSQL.g:483:35: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_revoke_permission_node2092); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_revoke_permission_node2098);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:483:62: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_revoke_permission_node2104); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_revoke_permission_node2108);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_revoke_permission_node2113); if (state.failed) return ret;
			// PhoenixSQL.g:483:97: (g= GROUP )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==GROUP) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// PhoenixSQL.g:483:98: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_revoke_permission_node2118); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_revoke_permission_node2124);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.FALSE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "revoke_permission_node"



	// $ANTLR start "show_node"
	// PhoenixSQL.g:494:1: show_node returns [ShowStatement ret] : ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? );
	public final ShowStatement show_node() throws RecognitionException {
		ShowStatement ret = null;


		String schema =null;
		String pattern =null;

		try {
			// PhoenixSQL.g:495:5: ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? )
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==SHOW) ) {
				int LA22_1 = input.LA(2);
				if ( (LA22_1==TABLES) ) {
					alt22=1;
				}
				else if ( (LA22_1==SCHEMAS) ) {
					alt22=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 22, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 22, 0, input);
				throw nvae;
			}

			switch (alt22) {
				case 1 :
					// PhoenixSQL.g:495:9: SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2158); if (state.failed) return ret;
					match(input,TABLES,FOLLOW_TABLES_in_show_node2160); if (state.failed) return ret;
					// PhoenixSQL.g:495:21: ( IN schema= identifier )?
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==IN) ) {
						alt19=1;
					}
					switch (alt19) {
						case 1 :
							// PhoenixSQL.g:495:22: IN schema= identifier
							{
							match(input,IN,FOLLOW_IN_in_show_node2163); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_show_node2167);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:495:45: ( LIKE pattern= string_literal )?
					int alt20=2;
					int LA20_0 = input.LA(1);
					if ( (LA20_0==LIKE) ) {
						alt20=1;
					}
					switch (alt20) {
						case 1 :
							// PhoenixSQL.g:495:46: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2172); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2176);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showTablesStatement(schema, pattern); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:496:9: SHOW SCHEMAS ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2190); if (state.failed) return ret;
					match(input,SCHEMAS,FOLLOW_SCHEMAS_in_show_node2192); if (state.failed) return ret;
					// PhoenixSQL.g:496:22: ( LIKE pattern= string_literal )?
					int alt21=2;
					int LA21_0 = input.LA(1);
					if ( (LA21_0==LIKE) ) {
						alt21=1;
					}
					switch (alt21) {
						case 1 :
							// PhoenixSQL.g:496:23: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2195); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2199);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showSchemasStatement(pattern); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:500:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:501:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:501:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node2227); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node2229); if (state.failed) return ret;
			// PhoenixSQL.g:501:21: ( IF NOT ex= EXISTS )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==IF) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// PhoenixSQL.g:501:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node2232); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node2234); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node2238); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node2244);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:502:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==LPAREN) ) {
				alt25=1;
			}
			switch (alt25) {
				case 1 :
					// PhoenixSQL.g:502:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node2256); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node2260);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:502:31: (pk= pk_constraint )?
					int alt24=2;
					int LA24_0 = input.LA(1);
					if ( (LA24_0==COMMA||LA24_0==CONSTRAINT) ) {
						alt24=1;
					}
					switch (alt24) {
						case 1 :
							// PhoenixSQL.g:502:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node2265);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node2269); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:503:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==AS) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// PhoenixSQL.g:503:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node2283); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node2285); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node2287); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node2299); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node2303);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:505:11: ( WHERE w= expression )?
					int alt26=2;
					int LA26_0 = input.LA(1);
					if ( (LA26_0==WHERE) ) {
						alt26=1;
					}
					switch (alt26) {
						case 1 :
							// PhoenixSQL.g:505:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node2316); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node2320);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:506:9: (p= fam_properties )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==NAME) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:506:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2338);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:511:1: create_index_node returns [CreateIndexStatement ret] : CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token l=null;
		Token ex=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:512:5: ( CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:512:9: CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2374); if (state.failed) return ret;
			// PhoenixSQL.g:512:17: (l= LOCAL )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==LOCAL) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// PhoenixSQL.g:512:17: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2378); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2381); if (state.failed) return ret;
			// PhoenixSQL.g:512:31: ( IF NOT ex= EXISTS )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==IF) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:512:32: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2384); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2386); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2390); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2396);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2398); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2402);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:513:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:513:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2413); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2417);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2419); if (state.failed) return ret;
			}

			// PhoenixSQL.g:514:9: ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==INCLUDE) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:514:10: INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2431); if (state.failed) return ret;
					// PhoenixSQL.g:514:18: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:514:19: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2434); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2438);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2440); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:515:9: (async= ASYNC )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==ASYNC) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:515:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2456); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:516:9: (p= fam_properties )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==NAME) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:516:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2471);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:517:9: ( SPLIT ON v= value_expression_list )?
			int alt34=2;
			int LA34_0 = input.LA(1);
			if ( (LA34_0==SPLIT) ) {
				alt34=1;
			}
			switch (alt34) {
				case 1 :
					// PhoenixSQL.g:517:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2484); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2486); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2490);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null, l==null ? IndexType.getDefault() : IndexType.LOCAL, async != null, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:522:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:523:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:523:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2526); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2528); if (state.failed) return ret;
			// PhoenixSQL.g:523:26: ( IF NOT ex= EXISTS )?
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==IF) ) {
				alt35=1;
			}
			switch (alt35) {
				case 1 :
					// PhoenixSQL.g:523:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node2532); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node2534); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node2538); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node2544);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:524:9: ( START ( WITH )? s= value_expression )?
			int alt37=2;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==START) ) {
				alt37=1;
			}
			switch (alt37) {
				case 1 :
					// PhoenixSQL.g:524:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node2555); if (state.failed) return ret;
					// PhoenixSQL.g:524:16: ( WITH )?
					int alt36=2;
					int LA36_0 = input.LA(1);
					if ( (LA36_0==WITH) ) {
						alt36=1;
					}
					switch (alt36) {
						case 1 :
							// PhoenixSQL.g:524:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node2557); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2562);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:525:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==INCREMENT) ) {
				alt39=1;
			}
			switch (alt39) {
				case 1 :
					// PhoenixSQL.g:525:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node2575); if (state.failed) return ret;
					// PhoenixSQL.g:525:20: ( BY )?
					int alt38=2;
					int LA38_0 = input.LA(1);
					if ( (LA38_0==BY) ) {
						alt38=1;
					}
					switch (alt38) {
						case 1 :
							// PhoenixSQL.g:525:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node2577); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2582);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:526:9: ( MINVALUE min= value_expression )?
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==MINVALUE) ) {
				alt40=1;
			}
			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:526:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node2595); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2599);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:527:9: ( MAXVALUE max= value_expression )?
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==MAXVALUE) ) {
				alt41=1;
			}
			switch (alt41) {
				case 1 :
					// PhoenixSQL.g:527:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node2612); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2616);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:528:9: (cyc= CYCLE )?
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==CYCLE) ) {
				alt42=1;
			}
			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:528:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node2631); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:529:9: ( CACHE c= int_literal_or_bind )?
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==CACHE) ) {
				alt43=1;
			}
			switch (alt43) {
				case 1 :
					// PhoenixSQL.g:529:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node2645); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node2649);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:533:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:534:5: (n= int_or_long_literal |b= bind_expression )
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==NUMBER) ) {
				alt44=1;
			}
			else if ( (LA44_0==BIND_NAME||LA44_0==QUESTION) ) {
				alt44=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}

			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:534:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind2680);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:535:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind2692);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "string_literal"
	// PhoenixSQL.g:539:1: string_literal returns [String ret] : s= STRING_LITERAL ;
	public final String string_literal() throws RecognitionException {
		String ret = null;


		Token s=null;

		try {
			// PhoenixSQL.g:540:5: (s= STRING_LITERAL )
			// PhoenixSQL.g:540:9: s= STRING_LITERAL
			{
			s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_string_literal2720); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = SchemaUtil.normalizeLiteral(factory.literal(s.getText())); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "string_literal"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:544:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:545:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:545:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node2746); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node2748); if (state.failed) return ret;
			// PhoenixSQL.g:545:24: ( IF ex= EXISTS )?
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==IF) ) {
				alt45=1;
			}
			switch (alt45) {
				case 1 :
					// PhoenixSQL.g:545:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node2752); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node2756); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node2762);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:549:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:550:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:550:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:550:9: ( COMMA )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==COMMA) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// PhoenixSQL.g:550:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint2791); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint2794); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint2798);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint2800); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint2802); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint2804); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2808);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint2810); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:553:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:555:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:555:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2841);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:555:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop47:
			while (true) {
				int alt47=2;
				int LA47_0 = input.LA(1);
				if ( (LA47_0==COMMA) ) {
					alt47=1;
				}

				switch (alt47) {
				case 1 :
					// PhoenixSQL.g:555:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2847); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2853);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop47;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:558:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:559:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:559:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2880);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:559:22: (order= ASC |order= DESC )?
			int alt48=3;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==ASC) ) {
				alt48=1;
			}
			else if ( (LA48_0==DESC) ) {
				alt48=2;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:559:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2885); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:559:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2889); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:559:46: (rr= ROW_TIMESTAMP )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==ROW_TIMESTAMP) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// PhoenixSQL.g:559:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2896); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:563:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:564:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:564:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint2931);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:567:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:569:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:569:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2958);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:569:54: ( COMMA p= expression_with_sort_order )*
			loop50:
			while (true) {
				int alt50=2;
				int LA50_0 = input.LA(1);
				if ( (LA50_0==COMMA) ) {
					alt50=1;
				}

				switch (alt50) {
				case 1 :
					// PhoenixSQL.g:569:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list2964); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2970);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop50;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:572:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:573:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:573:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:573:9: (x= expression )
			// PhoenixSQL.g:573:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order2997);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:573:24: (order= ASC |order= DESC )?
			int alt51=3;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==ASC) ) {
				alt51=1;
			}
			else if ( (LA51_0==DESC) ) {
				alt51=2;
			}
			switch (alt51) {
				case 1 :
					// PhoenixSQL.g:573:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order3003); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:573:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order3007); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:576:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:578:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:578:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties3035);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties3037); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties3041);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:578:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop52:
			while (true) {
				int alt52=2;
				int LA52_0 = input.LA(1);
				if ( (LA52_0==COMMA) ) {
					alt52=1;
				}

				switch (alt52) {
				case 1 :
					// PhoenixSQL.g:578:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties3047); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties3051);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties3053); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties3057);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop52;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:581:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:582:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==NAME) ) {
				int LA53_1 = input.LA(2);
				if ( (LA53_1==EQ) ) {
					alt53=1;
				}
				else if ( (LA53_1==DOT) ) {
					alt53=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 53, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:582:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3087);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:583:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3101);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name3103); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name3107);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:586:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:587:5: (v= identifier |l= literal )
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==NAME) ) {
				int LA54_1 = input.LA(2);
				if ( (LA54_1==EOF||LA54_1==CASCADE||LA54_1==COMMA||LA54_1==SEMICOLON||LA54_1==SPLIT) ) {
					alt54=1;
				}
				else if ( (LA54_1==STRING_LITERAL) ) {
					alt54=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 54, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA54_0==DECIMAL||LA54_0==DOUBLE||LA54_0==FALSE||LA54_0==NULL||LA54_0==NUMBER||LA54_0==STRING_LITERAL||LA54_0==TRUE) ) {
				alt54=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}

			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:587:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value3138);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:588:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value3152);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:591:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:592:5: (field= identifier |family= identifier DOT field= identifier )
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==NAME) ) {
				int LA55_1 = input.LA(2);
				if ( (LA55_1==EOF||LA55_1==COMMA||LA55_1==EQ||LA55_1==NAME||LA55_1==RPAREN||LA55_1==SEMICOLON) ) {
					alt55=1;
				}
				else if ( (LA55_1==DOT) ) {
					alt55=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 55, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 55, 0, input);
				throw nvae;
			}

			switch (alt55) {
				case 1 :
					// PhoenixSQL.g:592:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3183);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:593:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3197);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name3199); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name3203);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:596:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:598:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:598:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names3235);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:598:40: ( COMMA v= column_name )*
			loop56:
			while (true) {
				int alt56=2;
				int LA56_0 = input.LA(1);
				if ( (LA56_0==COMMA) ) {
					alt56=1;
				}

				switch (alt56) {
				case 1 :
					// PhoenixSQL.g:598:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names3241); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names3247);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop56;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:603:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:604:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:604:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node3274); if (state.failed) return ret;
			// PhoenixSQL.g:604:14: (v= VIEW | TABLE )
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==VIEW) ) {
				alt57=1;
			}
			else if ( (LA57_0==TABLE) ) {
				alt57=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 57, 0, input);
				throw nvae;
			}

			switch (alt57) {
				case 1 :
					// PhoenixSQL.g:604:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node3279); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:604:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node3283); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:604:31: ( IF ex= EXISTS )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==IF) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:604:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node3287); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node3291); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node3297);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:604:65: (c= CASCADE )?
			int alt59=2;
			int LA59_0 = input.LA(1);
			if ( (LA59_0==CASCADE) ) {
				alt59=1;
			}
			switch (alt59) {
				case 1 :
					// PhoenixSQL.g:604:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node3302); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:608:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:609:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:609:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node3337); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node3339); if (state.failed) return ret;
			// PhoenixSQL.g:609:21: ( IF ex= EXISTS )?
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==IF) ) {
				alt60=1;
			}
			switch (alt60) {
				case 1 :
					// PhoenixSQL.g:609:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node3342); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node3346); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3352);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:609:50: (c= CASCADE )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==CASCADE) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// PhoenixSQL.g:609:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3357); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:615:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:616:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:616:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3392); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3394); if (state.failed) return ret;
			// PhoenixSQL.g:616:18: ( IF ex= EXISTS )?
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==IF) ) {
				alt62=1;
			}
			switch (alt62) {
				case 1 :
					// PhoenixSQL.g:616:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3397); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3401); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3407);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3409); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3413);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:621:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token isRebuildAll=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:622:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) )
			// PhoenixSQL.g:622:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3443); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3445); if (state.failed) return ret;
			// PhoenixSQL.g:622:19: ( IF ex= EXISTS )?
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==IF) ) {
				alt63=1;
			}
			switch (alt63) {
				case 1 :
					// PhoenixSQL.g:622:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3448); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3452); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3458);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3460); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3464);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:623:7: ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			// PhoenixSQL.g:623:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )?
			{
			// PhoenixSQL.g:623:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) )
			// PhoenixSQL.g:623:9: s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			{
			// PhoenixSQL.g:623:11: ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			int alt65=5;
			switch ( input.LA(1) ) {
			case USABLE:
				{
				alt65=1;
				}
				break;
			case UNUSABLE:
				{
				alt65=2;
				}
				break;
			case REBUILD:
				{
				alt65=3;
				}
				break;
			case DISABLE:
				{
				alt65=4;
				}
				break;
			case ACTIVE:
				{
				alt65=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 65, 0, input);
				throw nvae;
			}
			switch (alt65) {
				case 1 :
					// PhoenixSQL.g:623:12: USABLE
					{
					s=(Token)match(input,USABLE,FOLLOW_USABLE_in_alter_index_node3477); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:623:21: UNUSABLE
					{
					s=(Token)match(input,UNUSABLE,FOLLOW_UNUSABLE_in_alter_index_node3481); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:623:32: REBUILD (isRebuildAll= ALL )?
					{
					s=(Token)match(input,REBUILD,FOLLOW_REBUILD_in_alter_index_node3485); if (state.failed) return ret;
					// PhoenixSQL.g:623:40: (isRebuildAll= ALL )?
					int alt64=2;
					int LA64_0 = input.LA(1);
					if ( (LA64_0==ALL) ) {
						alt64=1;
					}
					switch (alt64) {
						case 1 :
							// PhoenixSQL.g:623:41: isRebuildAll= ALL
							{
							isRebuildAll=(Token)match(input,ALL,FOLLOW_ALL_in_alter_index_node3490); if (state.failed) return ret;
							}
							break;

					}

					}
					break;
				case 4 :
					// PhoenixSQL.g:623:62: DISABLE
					{
					s=(Token)match(input,DISABLE,FOLLOW_DISABLE_in_alter_index_node3496); if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:623:72: ACTIVE
					{
					s=(Token)match(input,ACTIVE,FOLLOW_ACTIVE_in_alter_index_node3500); if (state.failed) return ret;
					}
					break;

			}

			}

			// PhoenixSQL.g:623:81: (async= ASYNC )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==ASYNC) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// PhoenixSQL.g:623:82: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node3507); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:623:96: ( ( ( SET )? ) p= fam_properties )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==NAME||LA68_0==SET) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// PhoenixSQL.g:623:97: ( ( SET )? ) p= fam_properties
					{
					// PhoenixSQL.g:623:97: ( ( SET )? )
					// PhoenixSQL.g:623:98: ( SET )?
					{
					// PhoenixSQL.g:623:98: ( SET )?
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( (LA67_0==SET) ) {
						alt67=1;
					}
					switch (alt67) {
						case 1 :
							// PhoenixSQL.g:623:98: SET
							{
							match(input,SET,FOLLOW_SET_in_alter_index_node3513); if (state.failed) return ret;
							}
							break;

					}

					}

					pushFollow(FOLLOW_fam_properties_in_alter_index_node3518);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), isRebuildAll!=null, async!=null, p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:628:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:629:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:629:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node3553); if (state.failed) return ret;
			// PhoenixSQL.g:629:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==ON) ) {
				alt70=1;
			}
			else if ( (LA70_0==OFF) ) {
				alt70=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}

			switch (alt70) {
				case 1 :
					// PhoenixSQL.g:629:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:629:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:629:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node3561); if (state.failed) return ret;
					// PhoenixSQL.g:629:28: ( WITH SAMPLING s= sampling_rate )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==WITH) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// PhoenixSQL.g:629:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node3566); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node3568); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node3574);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:629:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node3585); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:634:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:635:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:635:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node3619); if (state.failed) return ret;
			// PhoenixSQL.g:635:16: ( OR replace= REPLACE )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==OR) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:635:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node3622); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node3626); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:635:38: (temp= TEMPORARY )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==TEMPORARY) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// PhoenixSQL.g:635:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node3633); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node3637); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3641);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:636:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:636:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node3652); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node3656);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node3658); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node3668); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3672);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node3674); if (state.failed) return ret;
			// PhoenixSQL.g:637:32: (className= jar_path )
			// PhoenixSQL.g:637:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node3680);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:638:8: ( USING JAR (jarPath= jar_path ) )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==USING) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:638:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node3691); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node3693); if (state.failed) return ret;
					// PhoenixSQL.g:638:19: (jarPath= jar_path )
					// PhoenixSQL.g:638:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node3700);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:644:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:645:5: (l= literal )
			// PhoenixSQL.g:645:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path3737);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:648:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:649:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:649:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node3760); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node3762); if (state.failed) return ret;
			// PhoenixSQL.g:649:21: ( IF ex= EXISTS )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==IF) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// PhoenixSQL.g:649:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node3765); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node3769); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node3775);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:652:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:653:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:653:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node3798); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node3800); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node3806);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:656:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:657:5: ( LIST JARS )
			// PhoenixSQL.g:657:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node3829); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node3831); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:660:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:661:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:661:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node3854); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node3856); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node3862);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:665:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:666:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:666:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node3888); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node3890); if (state.failed) return ret;
			// PhoenixSQL.g:666:23: ( SET p= properties )
			// PhoenixSQL.g:666:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node3893); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node3897);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:671:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token cas=null;
		Token all=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> d =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<NamedNode> list =null;

		try {
			// PhoenixSQL.g:672:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) )
			// PhoenixSQL.g:672:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node3931); if (state.failed) return ret;
			// PhoenixSQL.g:672:15: ( TABLE |v= VIEW )
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==TABLE) ) {
				alt75=1;
			}
			else if ( (LA75_0==VIEW) ) {
				alt75=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 75, 0, input);
				throw nvae;
			}

			switch (alt75) {
				case 1 :
					// PhoenixSQL.g:672:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node3934); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:672:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node3940); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node3945);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:673:9: ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			int alt81=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt81=1;
				}
				break;
			case ADD:
				{
				alt81=2;
				}
				break;
			case SET:
				{
				alt81=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}
			switch (alt81) {
				case 1 :
					// PhoenixSQL.g:673:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					{
					// PhoenixSQL.g:673:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					// PhoenixSQL.g:673:12: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node3958); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node3960); if (state.failed) return ret;
					// PhoenixSQL.g:673:24: ( IF ex= EXISTS )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==IF) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// PhoenixSQL.g:673:25: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3963); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3967); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node3973);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:673:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					{
					// PhoenixSQL.g:673:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					// PhoenixSQL.g:673:59: ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )?
					{
					match(input,ADD,FOLLOW_ADD_in_alter_table_node3979); if (state.failed) return ret;
					// PhoenixSQL.g:673:63: ( IF NOT ex= EXISTS )?
					int alt77=2;
					int LA77_0 = input.LA(1);
					if ( (LA77_0==IF) ) {
						alt77=1;
					}
					switch (alt77) {
						case 1 :
							// PhoenixSQL.g:673:64: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3982); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node3984); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3988); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:673:83: (d= column_defs )
					// PhoenixSQL.g:673:84: d= column_defs
					{
					pushFollow(FOLLOW_column_defs_in_alter_table_node3995);
					d=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					}

					// PhoenixSQL.g:673:99: (p= fam_properties )?
					int alt78=2;
					int LA78_0 = input.LA(1);
					if ( (LA78_0==NAME) ) {
						alt78=1;
					}
					switch (alt78) {
						case 1 :
							// PhoenixSQL.g:673:100: p= fam_properties
							{
							pushFollow(FOLLOW_fam_properties_in_alter_table_node4001);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					// PhoenixSQL.g:673:120: (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					int alt80=2;
					int LA80_0 = input.LA(1);
					if ( (LA80_0==CASCADE) ) {
						alt80=1;
					}
					switch (alt80) {
						case 1 :
							// PhoenixSQL.g:673:121: cas= CASCADE INDEX (list= indexes |all= ALL )
							{
							cas=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_alter_table_node4009); if (state.failed) return ret;
							match(input,INDEX,FOLLOW_INDEX_in_alter_table_node4011); if (state.failed) return ret;
							// PhoenixSQL.g:673:139: (list= indexes |all= ALL )
							int alt79=2;
							int LA79_0 = input.LA(1);
							if ( (LA79_0==NAME) ) {
								alt79=1;
							}
							else if ( (LA79_0==ALL) ) {
								alt79=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 79, 0, input);
								throw nvae;
							}

							switch (alt79) {
								case 1 :
									// PhoenixSQL.g:673:140: list= indexes
									{
									pushFollow(FOLLOW_indexes_in_alter_table_node4016);
									list=indexes();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:673:155: all= ALL
									{
									all=(Token)match(input,ALL,FOLLOW_ALL_in_alter_table_node4022); if (state.failed) return ret;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 3 :
					// PhoenixSQL.g:673:168: ( SET (p= fam_properties ) )
					{
					// PhoenixSQL.g:673:168: ( SET (p= fam_properties ) )
					// PhoenixSQL.g:673:169: SET (p= fam_properties )
					{
					match(input,SET,FOLLOW_SET_in_alter_table_node4030); if (state.failed) return ret;
					// PhoenixSQL.g:673:173: (p= fam_properties )
					// PhoenixSQL.g:673:174: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_alter_table_node4035);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { PTableType tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW; ret = ( c == null ? factory.addColumn(factory.namedTable(null,t), tt, d, ex!=null, p, cas!=null, (all == null ? list : null)) : factory.dropColumn(factory.namedTable(null,t), tt, c, ex!=null) ); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:677:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:678:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:678:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node4069); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node4071); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node4075);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:678:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt82=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt82=1;
					}
					break;
				case ALL:
					{
					alt82=2;
					}
					break;
				case COLUMNS:
					{
					alt82=3;
					}
					break;
			}
			switch (alt82) {
				case 1 :
					// PhoenixSQL.g:678:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node4080); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:678:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node4086); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:678:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node4092); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:678:73: ( SET (p= properties ) )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==SET) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// PhoenixSQL.g:678:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node4097); if (state.failed) return ret;
					// PhoenixSQL.g:678:78: (p= properties )
					// PhoenixSQL.g:678:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node4102);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:682:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:683:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:683:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node4126); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node4128); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:687:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:688:5: (p= identifier )
			// PhoenixSQL.g:688:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name4154);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:691:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:693:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:693:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties4188);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties4190); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties4194);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:693:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==COMMA) ) {
					alt84=1;
				}

				switch (alt84) {
				case 1 :
					// PhoenixSQL.g:693:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties4200); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties4204);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties4206); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties4210);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop84;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:696:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:698:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:698:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs4245);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:698:39: ( COMMA v= column_def )*
			loop85:
			while (true) {
				int alt85=2;
				int LA85_0 = input.LA(1);
				if ( (LA85_0==COMMA) ) {
					int LA85_1 = input.LA(2);
					if ( (LA85_1==NAME) ) {
						alt85=1;
					}

				}

				switch (alt85) {
				case 1 :
					// PhoenixSQL.g:698:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs4251); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs4257);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop85;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "indexes"
	// PhoenixSQL.g:701:1: indexes returns [List<NamedNode> ret] : v= index_name ( COMMA v= index_name )* ;
	public final List<NamedNode> indexes() throws RecognitionException {
		List<NamedNode> ret = null;


		NamedNode v =null;

		ret = new ArrayList<NamedNode>(); 
		try {
			// PhoenixSQL.g:703:5: (v= index_name ( COMMA v= index_name )* )
			// PhoenixSQL.g:703:8: v= index_name ( COMMA v= index_name )*
			{
			pushFollow(FOLLOW_index_name_in_indexes4288);
			v=index_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:703:39: ( COMMA v= index_name )*
			loop86:
			while (true) {
				int alt86=2;
				int LA86_0 = input.LA(1);
				if ( (LA86_0==COMMA) ) {
					alt86=1;
				}

				switch (alt86) {
				case 1 :
					// PhoenixSQL.g:703:40: COMMA v= index_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_indexes4294); if (state.failed) return ret;
					pushFollow(FOLLOW_index_name_in_indexes4300);
					v=index_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop86;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "indexes"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:706:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:707:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? )
			// PhoenixSQL.g:707:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			{
			pushFollow(FOLLOW_column_name_in_column_def4326);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def4330);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:707:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==LPAREN) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// PhoenixSQL.g:707:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def4333); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4337); if (state.failed) return ret;
					// PhoenixSQL.g:707:54: ( COMMA s= NUMBER )?
					int alt87=2;
					int LA87_0 = input.LA(1);
					if ( (LA87_0==COMMA) ) {
						alt87=1;
					}
					switch (alt87) {
						case 1 :
							// PhoenixSQL.g:707:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def4340); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4344); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def4348); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:707:83: (ar= ARRAY )?
			int alt89=2;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==ARRAY) ) {
				alt89=1;
			}
			switch (alt89) {
				case 1 :
					// PhoenixSQL.g:707:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def4354); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:707:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt91=2;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==LSQUARE) ) {
				alt91=1;
			}
			switch (alt91) {
				case 1 :
					// PhoenixSQL.g:707:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def4360); if (state.failed) return ret;
					// PhoenixSQL.g:707:104: (a= NUMBER )?
					int alt90=2;
					int LA90_0 = input.LA(1);
					if ( (LA90_0==NUMBER) ) {
						alt90=1;
					}
					switch (alt90) {
						case 1 :
							// PhoenixSQL.g:707:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4365); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def4369); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:707:126: ( (nn= NOT )? n= NULL )?
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( ((LA93_0 >= NOT && LA93_0 <= NULL)) ) {
				alt93=1;
			}
			switch (alt93) {
				case 1 :
					// PhoenixSQL.g:707:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:707:129: (nn= NOT )?
					int alt92=2;
					int LA92_0 = input.LA(1);
					if ( (LA92_0==NOT) ) {
						alt92=1;
					}
					switch (alt92) {
						case 1 :
							// PhoenixSQL.g:707:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def4376); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def4381); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:707:144: ( DEFAULT df= expression )?
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==DEFAULT) ) {
				alt94=1;
			}
			switch (alt94) {
				case 1 :
					// PhoenixSQL.g:707:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def4386); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def4390);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:707:169: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==PRIMARY) ) {
				alt97=1;
			}
			switch (alt97) {
				case 1 :
					// PhoenixSQL.g:707:170: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def4397); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def4399); if (state.failed) return ret;
					// PhoenixSQL.g:707:185: (order= ASC |order= DESC )?
					int alt95=3;
					int LA95_0 = input.LA(1);
					if ( (LA95_0==ASC) ) {
						alt95=1;
					}
					else if ( (LA95_0==DESC) ) {
						alt95=2;
					}
					switch (alt95) {
						case 1 :
							// PhoenixSQL.g:707:186: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def4404); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:707:196: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def4408); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:707:211: (rr= ROW_TIMESTAMP )?
					int alt96=2;
					int LA96_0 = input.LA(1);
					if ( (LA96_0==ROW_TIMESTAMP) ) {
						alt96=1;
					}
					switch (alt96) {
						case 1 :
							// PhoenixSQL.g:707:211: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def4414); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null, 
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:717:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:719:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:719:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4457);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:719:43: ( COMMA v= dyn_column_def )*
			loop98:
			while (true) {
				int alt98=2;
				int LA98_0 = input.LA(1);
				if ( (LA98_0==COMMA) ) {
					alt98=1;
				}

				switch (alt98) {
				case 1 :
					// PhoenixSQL.g:719:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs4463); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4469);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop98;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:722:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:723:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:723:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def4495);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def4499);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:723:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==LPAREN) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:723:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def4502); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4506); if (state.failed) return ret;
					// PhoenixSQL.g:723:54: ( COMMA s= NUMBER )?
					int alt99=2;
					int LA99_0 = input.LA(1);
					if ( (LA99_0==COMMA) ) {
						alt99=1;
					}
					switch (alt99) {
						case 1 :
							// PhoenixSQL.g:723:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def4509); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4513); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def4517); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:723:83: (ar= ARRAY )?
			int alt101=2;
			int LA101_0 = input.LA(1);
			if ( (LA101_0==ARRAY) ) {
				alt101=1;
			}
			switch (alt101) {
				case 1 :
					// PhoenixSQL.g:723:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def4523); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:723:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==LSQUARE) ) {
				alt103=1;
			}
			switch (alt103) {
				case 1 :
					// PhoenixSQL.g:723:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def4529); if (state.failed) return ret;
					// PhoenixSQL.g:723:104: (a= NUMBER )?
					int alt102=2;
					int LA102_0 = input.LA(1);
					if ( (LA102_0==NUMBER) ) {
						alt102=1;
					}
					switch (alt102) {
						case 1 :
							// PhoenixSQL.g:723:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4534); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def4538); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:732:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:733:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:733:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def4575);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:733:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==NAME) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// PhoenixSQL.g:733:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def4580);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:733:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt105=2;
					int LA105_0 = input.LA(1);
					if ( (LA105_0==LPAREN) ) {
						alt105=1;
					}
					switch (alt105) {
						case 1 :
							// PhoenixSQL.g:733:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def4583); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4587); if (state.failed) return ret;
							// PhoenixSQL.g:733:55: ( COMMA s= NUMBER )?
							int alt104=2;
							int LA104_0 = input.LA(1);
							if ( (LA104_0==COMMA) ) {
								alt104=1;
							}
							switch (alt104) {
								case 1 :
									// PhoenixSQL.g:733:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def4590); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4594); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def4598); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:733:84: (ar= ARRAY )?
					int alt106=2;
					int LA106_0 = input.LA(1);
					if ( (LA106_0==ARRAY) ) {
						alt106=1;
					}
					switch (alt106) {
						case 1 :
							// PhoenixSQL.g:733:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def4604); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:733:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt108=2;
					int LA108_0 = input.LA(1);
					if ( (LA108_0==LSQUARE) ) {
						alt108=1;
					}
					switch (alt108) {
						case 1 :
							// PhoenixSQL.g:733:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def4610); if (state.failed) return ret;
							// PhoenixSQL.g:733:105: (a= NUMBER )?
							int alt107=2;
							int LA107_0 = input.LA(1);
							if ( (LA107_0==NUMBER) ) {
								alt107=1;
							}
							switch (alt107) {
								case 1 :
									// PhoenixSQL.g:733:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4615); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def4619); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:742:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:743:5: (s= select_node )
			// PhoenixSQL.g:743:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression4659);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:746:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:748:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:748:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select4692); if (state.failed) return ret;
			// PhoenixSQL.g:748:16: (h= hintClause )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==ML_HINT) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// PhoenixSQL.g:748:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select4697);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:749:9: (d= DISTINCT | ALL )?
			int alt111=3;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==DISTINCT) ) {
				alt111=1;
			}
			else if ( (LA111_0==ALL) ) {
				alt111=2;
			}
			switch (alt111) {
				case 1 :
					// PhoenixSQL.g:749:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select4713); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:749:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select4717); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select4723);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:750:9: ( FROM from= parseFrom )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==FROM) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// PhoenixSQL.g:750:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select4734); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select4738);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:751:9: ( WHERE where= expression )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==WHERE) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// PhoenixSQL.g:751:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select4751); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4755);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:752:9: ( GROUP BY group= group_by )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==GROUP) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// PhoenixSQL.g:752:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select4768); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select4770); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select4774);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:753:9: ( HAVING having= expression )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==HAVING) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// PhoenixSQL.g:753:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select4787); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4791);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:758:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:760:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:760:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects4835);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:760:39: ( UNION ALL s= single_select )*
			loop116:
			while (true) {
				int alt116=2;
				int LA116_0 = input.LA(1);
				if ( (LA116_0==UNION) ) {
					alt116=1;
				}

				switch (alt116) {
				case 1 :
					// PhoenixSQL.g:760:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects4840); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects4842); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects4846);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop116;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:764:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:766:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:766:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node4884);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:767:9: ( ORDER BY order= order_by )?
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==ORDER) ) {
				alt117=1;
			}
			switch (alt117) {
				case 1 :
					// PhoenixSQL.g:767:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node4895); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node4897); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node4901);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:768:9: ( LIMIT l= limit )?
			int alt118=2;
			int LA118_0 = input.LA(1);
			if ( (LA118_0==LIMIT) ) {
				alt118=1;
			}
			switch (alt118) {
				case 1 :
					// PhoenixSQL.g:768:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node4914); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node4918);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:769:9: ( OFFSET o= offset )?
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==OFFSET) ) {
				alt119=1;
			}
			switch (alt119) {
				case 1 :
					// PhoenixSQL.g:769:10: OFFSET o= offset
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node4931); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node4935);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:770:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==FETCH) ) {
				alt121=1;
			}
			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:770:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node4948); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:770:31: (l= limit )?
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==BIND_NAME||LA120_0==NUMBER||LA120_0==QUESTION) ) {
						alt120=1;
					}
					switch (alt120) {
						case 1 :
							// PhoenixSQL.g:770:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node4961);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node4973); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:776:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:777:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) )
			// PhoenixSQL.g:777:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node5012); if (state.failed) return ret;
			// PhoenixSQL.g:777:16: (hint= hintClause )?
			int alt122=2;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==ML_HINT) ) {
				alt122=1;
			}
			switch (alt122) {
				case 1 :
					// PhoenixSQL.g:777:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node5017);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node5021); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node5025);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:778:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==LPAREN) ) {
				alt123=1;
			}
			switch (alt123) {
				case 1 :
					// PhoenixSQL.g:778:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5036); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node5040);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5042); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:779:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==VALUES) ) {
				alt126=1;
			}
			else if ( (LA126_0==SELECT) ) {
				alt126=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 126, 0, input);
				throw nvae;
			}

			switch (alt126) {
				case 1 :
					// PhoenixSQL.g:779:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:779:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:779:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node5056); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5058); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node5062);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5064); if (state.failed) return ret;
					// PhoenixSQL.g:779:58: ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					int alt125=2;
					int LA125_0 = input.LA(1);
					if ( (LA125_0==ON) ) {
						alt125=1;
					}
					switch (alt125) {
						case 1 :
							// PhoenixSQL.g:779:60: ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node5068); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node5070); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node5072); if (state.failed) return ret;
							// PhoenixSQL.g:779:77: (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							int alt124=2;
							int LA124_0 = input.LA(1);
							if ( (LA124_0==IGNORE) ) {
								alt124=1;
							}
							else if ( (LA124_0==UPDATE) ) {
								alt124=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 124, 0, input);
								throw nvae;
							}

							switch (alt124) {
								case 1 :
									// PhoenixSQL.g:779:79: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node5078); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:779:91: ( UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:779:91: ( UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:779:93: UPDATE pairs= update_column_pairs
									{
									match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node5084); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node5088);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:779:137: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node5103);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:788:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:790:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:790:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5144);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:791:8: ( COMMA p= update_column_pair )*
			loop127:
			while (true) {
				int alt127=2;
				int LA127_0 = input.LA(1);
				if ( (LA127_0==COMMA) ) {
					alt127=1;
				}

				switch (alt127) {
				case 1 :
					// PhoenixSQL.g:791:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs5156); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5160);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop127;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:794:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:795:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:795:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair5185);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair5187); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair5191);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:799:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:801:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:801:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5220);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:802:8: ( COMMA d= dyn_column_name_or_def )*
			loop128:
			while (true) {
				int alt128=2;
				int LA128_0 = input.LA(1);
				if ( (LA128_0==COMMA) ) {
					alt128=1;
				}

				switch (alt128) {
				case 1 :
					// PhoenixSQL.g:802:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs5233); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5237);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop128;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:807:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:808:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:808:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node5265); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node5269);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node5271); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node5273); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node5277);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:812:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:813:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:813:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node5311); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node5315);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:816:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:817:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:817:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node5342); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node5346);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:820:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:821:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:821:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node5372); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node5374); if (state.failed) return ret;
			// PhoenixSQL.g:821:21: (a= NUMBER )?
			int alt129=2;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==NUMBER) ) {
				alt129=1;
			}
			switch (alt129) {
				case 1 :
					// PhoenixSQL.g:821:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node5379); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:821:33: ( ROW | ROWS )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( ((LA130_0 >= ROW && LA130_0 <= ROWS)) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node5390); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node5394);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:825:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:826:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? )
			// PhoenixSQL.g:826:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node5420); if (state.failed) return ret;
			// PhoenixSQL.g:826:16: (hint= hintClause )?
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==ML_HINT) ) {
				alt131=1;
			}
			switch (alt131) {
				case 1 :
					// PhoenixSQL.g:826:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node5425);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node5429); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node5433);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:827:9: ( WHERE v= expression )?
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==WHERE) ) {
				alt132=1;
			}
			switch (alt132) {
				case 1 :
					// PhoenixSQL.g:827:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node5444); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node5448);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:828:9: ( ORDER BY order= order_by )?
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==ORDER) ) {
				alt133=1;
			}
			switch (alt133) {
				case 1 :
					// PhoenixSQL.g:828:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node5461); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node5463); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node5467);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:829:9: ( LIMIT l= limit )?
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==LIMIT) ) {
				alt134=1;
			}
			switch (alt134) {
				case 1 :
					// PhoenixSQL.g:829:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node5480); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node5484);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:833:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:834:5: (b= bind_expression |l= int_or_long_literal )
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==BIND_NAME||LA135_0==QUESTION) ) {
				alt135=1;
			}
			else if ( (LA135_0==NUMBER) ) {
				alt135=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 135, 0, input);
				throw nvae;
			}

			switch (alt135) {
				case 1 :
					// PhoenixSQL.g:834:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit5519);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:835:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit5531);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:838:1: offset returns [OffsetNode ret] : (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;
		List<ParseNode> lhs =null;
		List<ParseNode> rhs =null;

		try {
			// PhoenixSQL.g:839:2: (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN )
			int alt138=3;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case QUESTION:
				{
				alt138=1;
				}
				break;
			case NUMBER:
				{
				alt138=2;
				}
				break;
			case LPAREN:
				{
				alt138=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}
			switch (alt138) {
				case 1 :
					// PhoenixSQL.g:839:4: b= bind_expression ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_bind_expression_in_offset5557);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:839:22: ( ROW | ROWS )?
					int alt136=2;
					int LA136_0 = input.LA(1);
					if ( ((LA136_0 >= ROW && LA136_0 <= ROWS)) ) {
						alt136=1;
					}
					switch (alt136) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) {  try { ret = factory.offset(b); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 2 :
					// PhoenixSQL.g:840:7: l= int_or_long_literal ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset5578);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:840:29: ( ROW | ROWS )?
					int alt137=2;
					int LA137_0 = input.LA(1);
					if ( ((LA137_0 >= ROW && LA137_0 <= ROWS)) ) {
						alt137=1;
					}
					switch (alt137) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) { try { ret = factory.offset(l); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 3 :
					// PhoenixSQL.g:841:7: LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_offset5597); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset5601);
					lhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset5603); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_offset5605); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_offset5607); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset5611);
					rhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset5613); if (state.failed) return ret;
					if ( state.backtracking==0 ) { try { ret = factory.offset(factory.comparison(CompareOp.EQUAL,factory.rowValueConstructor(lhs),factory.rowValueConstructor(rhs)));  } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:844:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:845:5: (l= literal )
			// PhoenixSQL.g:845:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate5638);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "tableSampleNode"
	// PhoenixSQL.g:848:1: tableSampleNode returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode tableSampleNode() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:849:5: (l= literal )
			// PhoenixSQL.g:849:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_tableSampleNode5663);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "tableSampleNode"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:852:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:853:5: (c= ML_HINT )
			// PhoenixSQL.g:853:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause5689); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:857:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:859:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt140=2;
			int LA140_0 = input.LA(1);
			if ( (LA140_0==ARRAY||LA140_0==BIND_NAME||(LA140_0 >= CASE && LA140_0 <= CAST)||LA140_0==CURRENT||LA140_0==DECIMAL||LA140_0==DOUBLE||LA140_0==EXISTS||LA140_0==FALSE||LA140_0==LPAREN||LA140_0==MINUS||(LA140_0 >= NAME && LA140_0 <= NEXT)||(LA140_0 >= NOT && LA140_0 <= NULL)||LA140_0==NUMBER||LA140_0==QUESTION||LA140_0==STRING_LITERAL||LA140_0==TRUE) ) {
				alt140=1;
			}
			else if ( (LA140_0==ASTERISK) ) {
				alt140=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}

			switch (alt140) {
				case 1 :
					// PhoenixSQL.g:859:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list5721);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:859:36: ( COMMA n= selectable )*
					loop139:
					while (true) {
						int alt139=2;
						int LA139_0 = input.LA(1);
						if ( (LA139_0==COMMA) ) {
							alt139=1;
						}

						switch (alt139) {
						case 1 :
							// PhoenixSQL.g:859:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list5726); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list5730);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop139;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:860:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list5742); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:864:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:865:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt142=3;
			int LA142_0 = input.LA(1);
			if ( (LA142_0==ARRAY||LA142_0==BIND_NAME||(LA142_0 >= CASE && LA142_0 <= CAST)||LA142_0==CURRENT||LA142_0==DECIMAL||LA142_0==DOUBLE||LA142_0==EXISTS||LA142_0==FALSE||LA142_0==LPAREN||LA142_0==MINUS||LA142_0==NEXT||(LA142_0 >= NOT && LA142_0 <= NULL)||LA142_0==NUMBER||LA142_0==QUESTION||LA142_0==STRING_LITERAL||LA142_0==TRUE) ) {
				alt142=1;
			}
			else if ( (LA142_0==NAME) ) {
				int LA142_2 = input.LA(2);
				if ( (LA142_2==EOF||LA142_2==AND||LA142_2==AS||LA142_2==ASTERISK||LA142_2==BETWEEN||LA142_2==COMMA||LA142_2==CONCAT||LA142_2==DIVIDE||LA142_2==EQ||LA142_2==FETCH||LA142_2==FROM||(LA142_2 >= GROUP && LA142_2 <= HAVING)||LA142_2==ILIKE||LA142_2==IN||LA142_2==IS||(LA142_2 >= LIKE && LA142_2 <= LIMIT)||(LA142_2 >= LPAREN && LA142_2 <= LT)||LA142_2==MINUS||LA142_2==NAME||(LA142_2 >= NOEQ1 && LA142_2 <= NOT)||LA142_2==OFFSET||(LA142_2 >= OR && LA142_2 <= ORDER)||(LA142_2 >= PERCENT && LA142_2 <= PLUS)||LA142_2==RPAREN||LA142_2==SEMICOLON||LA142_2==STRING_LITERAL||LA142_2==UNION||LA142_2==WHERE) ) {
					alt142=1;
				}
				else if ( (LA142_2==DOT) ) {
					int LA142_3 = input.LA(3);
					if ( (LA142_3==ASTERISK) ) {
						alt142=2;
					}
					else if ( (LA142_3==NAME) ) {
						int LA142_5 = input.LA(4);
						if ( (LA142_5==EOF||LA142_5==AND||LA142_5==AS||LA142_5==ASTERISK||LA142_5==BETWEEN||LA142_5==COMMA||LA142_5==CONCAT||LA142_5==DIVIDE||LA142_5==EQ||LA142_5==FETCH||LA142_5==FROM||(LA142_5 >= GROUP && LA142_5 <= HAVING)||LA142_5==ILIKE||LA142_5==IN||LA142_5==IS||(LA142_5 >= LIKE && LA142_5 <= LIMIT)||(LA142_5 >= LSQUARE && LA142_5 <= LT)||LA142_5==MINUS||LA142_5==NAME||(LA142_5 >= NOEQ1 && LA142_5 <= NOT)||LA142_5==OFFSET||(LA142_5 >= OR && LA142_5 <= ORDER)||(LA142_5 >= PERCENT && LA142_5 <= PLUS)||LA142_5==RPAREN||LA142_5==SEMICOLON||LA142_5==UNION||LA142_5==WHERE) ) {
							alt142=1;
						}
						else if ( (LA142_5==DOT) ) {
							int LA142_6 = input.LA(5);
							if ( (LA142_6==ASTERISK) ) {
								alt142=3;
							}
							else if ( (LA142_6==NAME) ) {
								alt142=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 142, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 142, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 142, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 142, 0, input);
				throw nvae;
			}

			switch (alt142) {
				case 1 :
					// PhoenixSQL.g:865:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable5771);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:865:26: (a= parseAlias )?
					int alt141=2;
					int LA141_0 = input.LA(1);
					if ( (LA141_0==AS||LA141_0==NAME) ) {
						alt141=1;
					}
					switch (alt141) {
						case 1 :
							// PhoenixSQL.g:865:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable5776);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:866:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5791);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5793); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5795); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:867:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5810);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5812); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable5816);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5818); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5820); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:872:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:874:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:874:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by5853);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:875:9: ( COMMA expr= expression )*
			loop143:
			while (true) {
				int alt143=2;
				int LA143_0 = input.LA(1);
				if ( (LA143_0==COMMA) ) {
					alt143=1;
				}

				switch (alt143) {
				case 1 :
					// PhoenixSQL.g:875:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by5866); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by5872);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop143;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:879:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:881:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:881:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by5906);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:882:9: ( COMMA field= parseOrderByField )*
			loop144:
			while (true) {
				int alt144=2;
				int LA144_0 = input.LA(1);
				if ( (LA144_0==COMMA) ) {
					alt144=1;
				}

				switch (alt144) {
				case 1 :
					// PhoenixSQL.g:882:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by5919); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by5925);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop144;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:886:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:888:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:888:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:888:9: (expr= expression )
			// PhoenixSQL.g:888:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField5962);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:889:9: ( ASC | DESC )?
			int alt145=3;
			int LA145_0 = input.LA(1);
			if ( (LA145_0==ASC) ) {
				alt145=1;
			}
			else if ( (LA145_0==DESC) ) {
				alt145=2;
			}
			switch (alt145) {
				case 1 :
					// PhoenixSQL.g:889:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField5974); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:889:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField5980); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:890:9: ( NULLS ( FIRST | LAST ) )?
			int alt147=2;
			int LA147_0 = input.LA(1);
			if ( (LA147_0==NULLS) ) {
				alt147=1;
			}
			switch (alt147) {
				case 1 :
					// PhoenixSQL.g:890:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField5995); if (state.failed) return ret;
					// PhoenixSQL.g:890:16: ( FIRST | LAST )
					int alt146=2;
					int LA146_0 = input.LA(1);
					if ( (LA146_0==FIRST) ) {
						alt146=1;
					}
					else if ( (LA146_0==LAST) ) {
						alt146=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 146, 0, input);
						throw nvae;
					}

					switch (alt146) {
						case 1 :
							// PhoenixSQL.g:890:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField5998); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:890:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField6004); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:894:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:895:5: (t= table_list )
			// PhoenixSQL.g:895:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom6044);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:898:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:899:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:899:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list6075);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:899:33: ( COMMA s= table_ref )*
			loop148:
			while (true) {
				int alt148=2;
				int LA148_0 = input.LA(1);
				if ( (LA148_0==COMMA) ) {
					alt148=1;
				}

				switch (alt148) {
				case 1 :
					// PhoenixSQL.g:899:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list6080); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list6084);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop148;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:902:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:903:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:903:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref6108);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:903:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop149:
			while (true) {
				int alt149=2;
				int LA149_0 = input.LA(1);
				if ( (LA149_0==FULL||LA149_0==INNER||LA149_0==JOIN||LA149_0==LEFT||LA149_0==RIGHT) ) {
					alt149=1;
				}

				switch (alt149) {
				case 1 :
					// PhoenixSQL.g:903:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref6115);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref6117); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref6121);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref6123); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref6127);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop149;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:906:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		LiteralParseNode tableSample =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:907:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt158=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA158_1 = input.LA(2);
				if ( (LA158_1==BIND_NAME||LA158_1==LPAREN||LA158_1==NAME||LA158_1==QUESTION) ) {
					alt158=1;
				}
				else if ( (LA158_1==SELECT) ) {
					alt158=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 158, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt158=2;
				}
				break;
			case NAME:
				{
				alt158=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 158, 0, input);
				throw nvae;
			}
			switch (alt158) {
				case 1 :
					// PhoenixSQL.g:907:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6151); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor6155);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6157); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:908:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor6171);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:908:21: ( ( AS )? alias= identifier )?
					int alt151=2;
					int LA151_0 = input.LA(1);
					if ( (LA151_0==AS||LA151_0==NAME) ) {
						alt151=1;
					}
					switch (alt151) {
						case 1 :
							// PhoenixSQL.g:908:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:908:22: ( AS )?
							int alt150=2;
							int LA150_0 = input.LA(1);
							if ( (LA150_0==AS) ) {
								alt150=1;
							}
							switch (alt150) {
								case 1 :
									// PhoenixSQL.g:908:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6175); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6181);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:909:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor6198);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:909:27: ( ( AS )? alias= identifier )?
					int alt153=2;
					int LA153_0 = input.LA(1);
					if ( (LA153_0==AS||LA153_0==NAME) ) {
						alt153=1;
					}
					switch (alt153) {
						case 1 :
							// PhoenixSQL.g:909:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:909:28: ( AS )?
							int alt152=2;
							int LA152_0 = input.LA(1);
							if ( (LA152_0==AS) ) {
								alt152=1;
							}
							switch (alt152) {
								case 1 :
									// PhoenixSQL.g:909:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6202); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6208);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:909:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt154=2;
					int LA154_0 = input.LA(1);
					if ( (LA154_0==LPAREN) ) {
						alt154=1;
					}
					switch (alt154) {
						case 1 :
							// PhoenixSQL.g:909:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6213); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor6217);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6219); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:909:92: ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					int alt155=2;
					int LA155_0 = input.LA(1);
					if ( (LA155_0==TABLESAMPLE) ) {
						alt155=1;
					}
					switch (alt155) {
						case 1 :
							// PhoenixSQL.g:909:93: TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN
							{
							match(input,TABLESAMPLE,FOLLOW_TABLESAMPLE_in_table_factor6224); if (state.failed) return ret;
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6226); if (state.failed) return ret;
							pushFollow(FOLLOW_tableSampleNode_in_table_factor6230);
							tableSample=tableSampleNode();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6232); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs, tableSample);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:910:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6246); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor6250);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6252); if (state.failed) return ret;
					// PhoenixSQL.g:910:37: ( ( AS )? alias= identifier )?
					int alt157=2;
					int LA157_0 = input.LA(1);
					if ( (LA157_0==AS||LA157_0==NAME) ) {
						alt157=1;
					}
					switch (alt157) {
						case 1 :
							// PhoenixSQL.g:910:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:910:38: ( AS )?
							int alt156=2;
							int LA156_0 = input.LA(1);
							if ( (LA156_0==AS) ) {
								alt156=1;
							}
							switch (alt156) {
								case 1 :
									// PhoenixSQL.g:910:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6256); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6262);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:913:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:914:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt163=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt163=1;
				}
				break;
			case LEFT:
				{
				alt163=2;
				}
				break;
			case RIGHT:
				{
				alt163=3;
				}
				break;
			case FULL:
				{
				alt163=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 163, 0, input);
				throw nvae;
			}
			switch (alt163) {
				case 1 :
					// PhoenixSQL.g:914:9: ( INNER )?
					{
					// PhoenixSQL.g:914:9: ( INNER )?
					int alt159=2;
					int LA159_0 = input.LA(1);
					if ( (LA159_0==INNER) ) {
						alt159=1;
					}
					switch (alt159) {
						case 1 :
							// PhoenixSQL.g:914:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type6289); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:915:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type6304); if (state.failed) return ret;
					// PhoenixSQL.g:915:14: ( OUTER )?
					int alt160=2;
					int LA160_0 = input.LA(1);
					if ( (LA160_0==OUTER) ) {
						alt160=1;
					}
					switch (alt160) {
						case 1 :
							// PhoenixSQL.g:915:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6306); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:916:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type6321); if (state.failed) return ret;
					// PhoenixSQL.g:916:15: ( OUTER )?
					int alt161=2;
					int LA161_0 = input.LA(1);
					if ( (LA161_0==OUTER) ) {
						alt161=1;
					}
					switch (alt161) {
						case 1 :
							// PhoenixSQL.g:916:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6323); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:917:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type6337); if (state.failed) return ret;
					// PhoenixSQL.g:917:15: ( OUTER )?
					int alt162=2;
					int LA162_0 = input.LA(1);
					if ( (LA162_0==OUTER) ) {
						alt162=1;
					}
					switch (alt162) {
						case 1 :
							// PhoenixSQL.g:917:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6340); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:920:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:921:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:921:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:921:9: ( AS )?
			int alt164=2;
			int LA164_0 = input.LA(1);
			if ( (LA164_0==AS) ) {
				alt164=1;
			}
			switch (alt164) {
				case 1 :
					// PhoenixSQL.g:921:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias6371); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias6376);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:925:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:926:5: (e= or_expression )
			// PhoenixSQL.g:926:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression6404);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:930:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:932:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:932:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression6436);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:932:38: ( OR i= and_expression )*
			loop165:
			while (true) {
				int alt165=2;
				int LA165_0 = input.LA(1);
				if ( (LA165_0==OR) ) {
					alt165=1;
				}

				switch (alt165) {
				case 1 :
					// PhoenixSQL.g:932:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression6441); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression6445);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop165;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:936:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:938:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:938:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression6481);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:938:38: ( AND i= not_expression )*
			loop166:
			while (true) {
				int alt166=2;
				int LA166_0 = input.LA(1);
				if ( (LA166_0==AND) ) {
					alt166=1;
				}

				switch (alt166) {
				case 1 :
					// PhoenixSQL.g:938:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression6486); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression6490);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop166;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:942:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:943:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt169=2;
			int LA169_0 = input.LA(1);
			if ( (LA169_0==NOT) ) {
				int LA169_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt169=1;
				}
				else if ( (true) ) {
					alt169=2;
				}

			}
			else if ( (LA169_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==NULL) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==NAME) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==CASE) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==LPAREN) ) {
				int LA169_15 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt169=1;
				}
				else if ( (true) ) {
					alt169=2;
				}

			}
			else if ( (LA169_0==CAST) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}
			else if ( (LA169_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt169=1;
			}

			switch (alt169) {
				case 1 :
					// PhoenixSQL.g:943:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:943:40: (n= NOT )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==NOT) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// PhoenixSQL.g:943:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6532); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression6537);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:944:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:944:10: (n= NOT )?
					int alt168=2;
					int LA168_0 = input.LA(1);
					if ( (LA168_0==NOT) ) {
						alt168=1;
					}
					switch (alt168) {
						case 1 :
							// PhoenixSQL.g:944:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6551); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression6554); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression6558);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression6560); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:947:1: comparison_op returns [CompareOp ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOp comparison_op() throws RecognitionException {
		CompareOp ret = null;


		try {
			// PhoenixSQL.g:948:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt170=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt170=1;
				}
				break;
			case LT:
				{
				int LA170_2 = input.LA(2);
				if ( (LA170_2==EQ) ) {
					alt170=4;
				}
				else if ( (LA170_2==ALL||(LA170_2 >= ANY && LA170_2 <= ARRAY)||LA170_2==BIND_NAME||(LA170_2 >= CASE && LA170_2 <= CAST)||LA170_2==CURRENT||LA170_2==DECIMAL||LA170_2==DOUBLE||LA170_2==FALSE||LA170_2==LPAREN||LA170_2==MINUS||(LA170_2 >= NAME && LA170_2 <= NEXT)||LA170_2==NULL||LA170_2==NUMBER||LA170_2==QUESTION||LA170_2==STRING_LITERAL||LA170_2==TRUE) ) {
					alt170=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 170, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA170_3 = input.LA(2);
				if ( (LA170_3==EQ) ) {
					alt170=5;
				}
				else if ( (LA170_3==ALL||(LA170_3 >= ANY && LA170_3 <= ARRAY)||LA170_3==BIND_NAME||(LA170_3 >= CASE && LA170_3 <= CAST)||LA170_3==CURRENT||LA170_3==DECIMAL||LA170_3==DOUBLE||LA170_3==FALSE||LA170_3==LPAREN||LA170_3==MINUS||(LA170_3 >= NAME && LA170_3 <= NEXT)||LA170_3==NULL||LA170_3==NUMBER||LA170_3==QUESTION||LA170_3==STRING_LITERAL||LA170_3==TRUE) ) {
					alt170=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 170, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt170=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 170, 0, input);
				throw nvae;
			}
			switch (alt170) {
				case 1 :
					// PhoenixSQL.g:948:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op6580); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:949:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6587); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:950:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6594); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:951:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6601); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6603); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:952:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6610); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6612); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:953:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOp.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:956:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOp op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:957:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt179=2;
			int LA179_0 = input.LA(1);
			if ( (LA179_0==ARRAY||LA179_0==BIND_NAME||(LA179_0 >= CASE && LA179_0 <= CAST)||LA179_0==CURRENT||LA179_0==DECIMAL||LA179_0==DOUBLE||LA179_0==FALSE||LA179_0==LPAREN||LA179_0==MINUS||(LA179_0 >= NAME && LA179_0 <= NEXT)||LA179_0==NULL||LA179_0==NUMBER||LA179_0==QUESTION||LA179_0==STRING_LITERAL||LA179_0==TRUE) ) {
				alt179=1;
			}
			else if ( (LA179_0==EXISTS) ) {
				alt179=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 179, 0, input);
				throw nvae;
			}

			switch (alt179) {
				case 1 :
					// PhoenixSQL.g:957:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression6650);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:957:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt178=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt178=1;
						}
						break;
					case IS:
						{
						alt178=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt178=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case CASCADE:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt178=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 178, 0, input);
						throw nvae;
					}
					switch (alt178) {
						case 1 :
							// PhoenixSQL.g:957:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:957:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:957:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression6656);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:957:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt173=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt173=1;
								}
								break;
							case LPAREN:
								{
								int LA173_2 = input.LA(2);
								if ( (LA173_2==ARRAY||LA173_2==BIND_NAME||(LA173_2 >= CASE && LA173_2 <= CAST)||LA173_2==CURRENT||LA173_2==DECIMAL||LA173_2==DOUBLE||LA173_2==EXISTS||LA173_2==FALSE||LA173_2==LPAREN||LA173_2==MINUS||(LA173_2 >= NAME && LA173_2 <= NEXT)||(LA173_2 >= NOT && LA173_2 <= NULL)||LA173_2==NUMBER||LA173_2==QUESTION||LA173_2==STRING_LITERAL||LA173_2==TRUE) ) {
									alt173=1;
								}
								else if ( (LA173_2==SELECT) ) {
									alt173=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 173, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA173_3 = input.LA(2);
								if ( (LA173_3==LPAREN) ) {
									int LA173_6 = input.LA(3);
									if ( (LA173_6==ARRAY||LA173_6==BIND_NAME||(LA173_6 >= CASE && LA173_6 <= CAST)||LA173_6==CURRENT||LA173_6==DECIMAL||LA173_6==DOUBLE||LA173_6==FALSE||LA173_6==LPAREN||LA173_6==MINUS||(LA173_6 >= NAME && LA173_6 <= NEXT)||LA173_6==NULL||LA173_6==NUMBER||LA173_6==QUESTION||LA173_6==STRING_LITERAL||LA173_6==TRUE) ) {
										alt173=3;
									}
									else if ( (LA173_6==SELECT) ) {
										alt173=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 173, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 173, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA173_4 = input.LA(2);
								if ( (LA173_4==LPAREN) ) {
									int LA173_6 = input.LA(3);
									if ( (LA173_6==ARRAY||LA173_6==BIND_NAME||(LA173_6 >= CASE && LA173_6 <= CAST)||LA173_6==CURRENT||LA173_6==DECIMAL||LA173_6==DOUBLE||LA173_6==FALSE||LA173_6==LPAREN||LA173_6==MINUS||(LA173_6 >= NAME && LA173_6 <= NEXT)||LA173_6==NULL||LA173_6==NUMBER||LA173_6==QUESTION||LA173_6==STRING_LITERAL||LA173_6==TRUE) ) {
										alt173=3;
									}
									else if ( (LA173_6==SELECT) ) {
										alt173=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 173, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 173, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 173, 0, input);
								throw nvae;
							}
							switch (alt173) {
								case 1 :
									// PhoenixSQL.g:957:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression6661);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:957:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:957:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:957:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6666); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6670);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6672); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:957:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:957:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:957:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:957:110: (all= ALL |any= ANY )
									int alt171=2;
									int LA171_0 = input.LA(1);
									if ( (LA171_0==ALL) ) {
										alt171=1;
									}
									else if ( (LA171_0==ANY) ) {
										alt171=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 171, 0, input);
										throw nvae;
									}

									switch (alt171) {
										case 1 :
											// PhoenixSQL.g:957:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6681); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:957:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6687); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6690); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6694);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6696); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:957:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:957:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:957:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:957:168: (all= ALL |any= ANY )
									int alt172=2;
									int LA172_0 = input.LA(1);
									if ( (LA172_0==ALL) ) {
										alt172=1;
									}
									else if ( (LA172_0==ANY) ) {
										alt172=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 172, 0, input);
										throw nvae;
									}

									switch (alt172) {
										case 1 :
											// PhoenixSQL.g:957:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6706); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:957:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6712); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6715); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6719);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6721); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:958:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:958:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:958:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression6751); if (state.failed) return ret;
							// PhoenixSQL.g:958:27: (n= NOT )?
							int alt174=2;
							int LA174_0 = input.LA(1);
							if ( (LA174_0==NOT) ) {
								alt174=1;
							}
							switch (alt174) {
								case 1 :
									// PhoenixSQL.g:958:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6755); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression6758); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:959:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:959:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:959:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:959:25: (n= NOT )?
							int alt175=2;
							int LA175_0 = input.LA(1);
							if ( (LA175_0==NOT) ) {
								alt175=1;
							}
							switch (alt175) {
								case 1 :
									// PhoenixSQL.g:959:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6789); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:959:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt177=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt177=1;
								}
								break;
							case ILIKE:
								{
								alt177=2;
								}
								break;
							case BETWEEN:
								{
								alt177=3;
								}
								break;
							case IN:
								{
								alt177=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 177, 0, input);
								throw nvae;
							}
							switch (alt177) {
								case 1 :
									// PhoenixSQL.g:959:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:959:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:959:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression6794); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6798);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:960:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:960:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:960:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression6836); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6840);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:961:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:961:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:961:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression6878); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6882);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression6884); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6888);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:962:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:962:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:962:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:962:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:962:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression6927); if (state.failed) return ret;
									// PhoenixSQL.g:962:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt176=3;
									int LA176_0 = input.LA(1);
									if ( (LA176_0==BIND_NAME||LA176_0==QUESTION) ) {
										alt176=1;
									}
									else if ( (LA176_0==LPAREN) ) {
										int LA176_2 = input.LA(2);
										if ( (LA176_2==SELECT) ) {
											alt176=2;
										}
										else if ( (LA176_2==ARRAY||LA176_2==BIND_NAME||(LA176_2 >= CASE && LA176_2 <= CAST)||LA176_2==CURRENT||LA176_2==DECIMAL||LA176_2==DOUBLE||LA176_2==EXISTS||LA176_2==FALSE||LA176_2==LPAREN||LA176_2==MINUS||(LA176_2 >= NAME && LA176_2 <= NEXT)||(LA176_2 >= NOT && LA176_2 <= NULL)||LA176_2==NUMBER||LA176_2==QUESTION||LA176_2==STRING_LITERAL||LA176_2==TRUE) ) {
											alt176=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 176, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 176, 0, input);
										throw nvae;
									}

									switch (alt176) {
										case 1 :
											// PhoenixSQL.g:962:38: (r= bind_expression )
											{
											// PhoenixSQL.g:962:38: (r= bind_expression )
											// PhoenixSQL.g:962:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression6933);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:963:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:963:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:963:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6974); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression6978);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6980); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:964:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:964:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:964:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7021); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression7025);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7027); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:967:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:968:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression7127); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7129); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression7133);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7135); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:971:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:972:5: (b= bind_name )
			// PhoenixSQL.g:972:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression7163);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:975:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:976:5: (i= add_expression )
			// PhoenixSQL.g:976:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression7194);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:979:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:981:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:981:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression7225);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:981:43: ( PLUS i= subtract_expression )*
			loop180:
			while (true) {
				int alt180=2;
				int LA180_0 = input.LA(1);
				if ( (LA180_0==PLUS) ) {
					alt180=1;
				}

				switch (alt180) {
				case 1 :
					// PhoenixSQL.g:981:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression7230); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression7234);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop180;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:984:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:986:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:986:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression7269);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:986:41: ( MINUS i= concat_expression )*
			loop181:
			while (true) {
				int alt181=2;
				int LA181_0 = input.LA(1);
				if ( (LA181_0==MINUS) ) {
					alt181=1;
				}

				switch (alt181) {
				case 1 :
					// PhoenixSQL.g:986:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression7274); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression7278);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop181;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:989:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:991:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:991:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7313);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:991:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop182:
			while (true) {
				int alt182=2;
				int LA182_0 = input.LA(1);
				if ( (LA182_0==CONCAT) ) {
					alt182=1;
				}

				switch (alt182) {
				case 1 :
					// PhoenixSQL.g:991:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression7318); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7322);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop182;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:994:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:996:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:996:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7357);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:997:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop183:
			while (true) {
				int alt183=2;
				int LA183_0 = input.LA(1);
				if ( (LA183_0==ASTERISK||LA183_0==DIVIDE||LA183_0==PERCENT) ) {
					alt183=1;
				}

				switch (alt183) {
				case 1 :
					// PhoenixSQL.g:997:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7387);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop183;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:1008:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:1009:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:1009:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node7430); if (state.failed) return ret;
			// PhoenixSQL.g:1009:10: ( DEFAULT |s= identifier )
			int alt184=2;
			int LA184_0 = input.LA(1);
			if ( (LA184_0==DEFAULT) ) {
				alt184=1;
			}
			else if ( (LA184_0==NAME) ) {
				alt184=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 184, 0, input);
				throw nvae;
			}

			switch (alt184) {
				case 1 :
					// PhoenixSQL.g:1009:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node7433); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:1009:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node7439);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:1013:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:1014:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:1014:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:1014:10: (m= MINUS )?
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==MINUS) ) {
				alt185=1;
			}
			switch (alt185) {
				case 1 :
					// PhoenixSQL.g:1014:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression7475); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression7480);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:1018:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:1019:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:1019:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression7508);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1019:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==LSQUARE) ) {
				alt186=1;
			}
			switch (alt186) {
				case 1 :
					// PhoenixSQL.g:1019:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression7511); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression7515);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression7517); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:1022:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:1023:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt193=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt193=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt193=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case BETWEEN:
				case CACHE:
				case CASCADE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt193=2;
					}
					break;
				case DOT:
					{
					alt193=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt193=6;
						}
						break;
					case DISTINCT:
						{
						alt193=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt193=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 193, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 193, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt193=3;
				}
				break;
			case CASE:
				{
				alt193=8;
				}
				break;
			case LPAREN:
				{
				alt193=9;
				}
				break;
			case CAST:
				{
				alt193=10;
				}
				break;
			case NEXT:
				{
				int LA193_7 = input.LA(2);
				if ( (LA193_7==VALUE) ) {
					alt193=11;
				}
				else if ( (LA193_7==BIND_NAME||LA193_7==DECIMAL||LA193_7==DOUBLE||LA193_7==FALSE||LA193_7==NAME||LA193_7==NULL||LA193_7==NUMBER||LA193_7==QUESTION||LA193_7==STRING_LITERAL||LA193_7==TRUE) ) {
					alt193=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 193, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt193=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 193, 0, input);
				throw nvae;
			}
			switch (alt193) {
				case 1 :
					// PhoenixSQL.g:1023:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term7550);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1024:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term7564);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1025:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7578); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term7580); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7584);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term7586); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:1026:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term7600);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term7602); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7606);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1027:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term7620);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7622); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7626);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7628); if (state.failed) return ret;
					// PhoenixSQL.g:1027:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt188=2;
					int LA188_0 = input.LA(1);
					if ( (LA188_0==WITHIN) ) {
						alt188=1;
					}
					switch (alt188) {
						case 1 :
							// PhoenixSQL.g:1027:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term7633); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term7635); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term7637); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term7639); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term7641); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term7645);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:1027:127: (a= ASC | DESC )
							int alt187=2;
							int LA187_0 = input.LA(1);
							if ( (LA187_0==ASC) ) {
								alt187=1;
							}
							else if ( (LA187_0==DESC) ) {
								alt187=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 187, 0, input);
								throw nvae;
							}

							switch (alt187) {
								case 1 :
									// PhoenixSQL.g:1027:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term7650); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:1027:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term7654); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term7657); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1036:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7682);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7684); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term7688); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7690); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1048:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7714);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7716); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term7720); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7724);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7726); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1057:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term7749);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1058:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term7761); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7765);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7767); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1067:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term7785); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7787); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term7791);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term7793); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7797);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1067:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt190=2;
					int LA190_0 = input.LA(1);
					if ( (LA190_0==LPAREN) ) {
						alt190=1;
					}
					switch (alt190) {
						case 1 :
							// PhoenixSQL.g:1067:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term7800); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7804); if (state.failed) return ret;
							// PhoenixSQL.g:1067:73: ( COMMA scale= NUMBER )?
							int alt189=2;
							int LA189_0 = input.LA(1);
							if ( (LA189_0==COMMA) ) {
								alt189=1;
							}
							switch (alt189) {
								case 1 :
									// PhoenixSQL.g:1067:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term7807); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7811); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term7815); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1067:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt191=3;
					int LA191_0 = input.LA(1);
					if ( (LA191_0==ARRAY) ) {
						alt191=1;
					}
					else if ( (LA191_0==LSQUARE) ) {
						alt191=2;
					}
					switch (alt191) {
						case 1 :
							// PhoenixSQL.g:1067:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7822); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1067:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1067:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1067:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term7827); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term7829); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term7834); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1073:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1073:9: (n= NEXT | CURRENT )
					int alt192=2;
					int LA192_0 = input.LA(1);
					if ( (LA192_0==NEXT) ) {
						alt192=1;
					}
					else if ( (LA192_0==CURRENT) ) {
						alt192=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 192, 0, input);
						throw nvae;
					}

					switch (alt192) {
						case 1 :
							// PhoenixSQL.g:1073:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7857); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1073:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term7861); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term7864); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7866); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7870);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1076:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1076:9: (n= NEXT )
					// PhoenixSQL.g:1076:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7898); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term7903);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term7905); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7907); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7911);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1081:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1083:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1083:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions7956);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1083:39: ( COMMA e= expression )*
			loop194:
			while (true) {
				int alt194=2;
				int LA194_0 = input.LA(1);
				if ( (LA194_0==COMMA) ) {
					alt194=1;
				}

				switch (alt194) {
				case 1 :
					// PhoenixSQL.g:1083:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions7962); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions7968);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop194;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1086:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1088:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1088:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7999);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1088:49: ( COMMA jarPath= jar_path )*
			loop195:
			while (true) {
				int alt195=2;
				int LA195_0 = input.LA(1);
				if ( (LA195_0==COMMA) ) {
					alt195=1;
				}

				switch (alt195) {
				case 1 :
					// PhoenixSQL.g:1088:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths8005); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8011);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop195;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1091:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1093:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1093:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1093:8: (v= expression )?
			int alt196=2;
			int LA196_0 = input.LA(1);
			if ( (LA196_0==ARRAY||LA196_0==BIND_NAME||(LA196_0 >= CASE && LA196_0 <= CAST)||LA196_0==CURRENT||LA196_0==DECIMAL||LA196_0==DOUBLE||LA196_0==EXISTS||LA196_0==FALSE||LA196_0==LPAREN||LA196_0==MINUS||(LA196_0 >= NAME && LA196_0 <= NEXT)||(LA196_0 >= NOT && LA196_0 <= NULL)||LA196_0==NUMBER||LA196_0==QUESTION||LA196_0==STRING_LITERAL||LA196_0==TRUE) ) {
				alt196=1;
			}
			switch (alt196) {
				case 1 :
					// PhoenixSQL.g:1093:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8044);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1093:42: ( COMMA v= expression )*
			loop197:
			while (true) {
				int alt197=2;
				int LA197_0 = input.LA(1);
				if ( (LA197_0==COMMA) ) {
					alt197=1;
				}

				switch (alt197) {
				case 1 :
					// PhoenixSQL.g:1093:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions8052); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8058);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop197;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1096:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1098:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1098:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1098:7: (fa= function_argument )?
			int alt198=2;
			int LA198_0 = input.LA(1);
			if ( (LA198_0==NAME) ) {
				alt198=1;
			}
			switch (alt198) {
				case 1 :
					// PhoenixSQL.g:1098:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8089);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1098:49: ( COMMA fa= function_argument )*
			loop199:
			while (true) {
				int alt199=2;
				int LA199_0 = input.LA(1);
				if ( (LA199_0==COMMA) ) {
					alt199=1;
				}

				switch (alt199) {
				case 1 :
					// PhoenixSQL.g:1098:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types8096); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8102);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop199;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1101:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1102:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1102:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1102:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1102:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument8127);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1102:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt201=2;
			int LA201_0 = input.LA(1);
			if ( (LA201_0==LPAREN) ) {
				alt201=1;
			}
			switch (alt201) {
				case 1 :
					// PhoenixSQL.g:1102:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument8130); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8134); if (state.failed) return ret;
					// PhoenixSQL.g:1102:38: ( COMMA s= NUMBER )?
					int alt200=2;
					int LA200_0 = input.LA(1);
					if ( (LA200_0==COMMA) ) {
						alt200=1;
					}
					switch (alt200) {
						case 1 :
							// PhoenixSQL.g:1102:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument8137); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8141); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument8145); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1102:67: (ar= ARRAY )?
			int alt202=2;
			int LA202_0 = input.LA(1);
			if ( (LA202_0==ARRAY) ) {
				alt202=1;
			}
			switch (alt202) {
				case 1 :
					// PhoenixSQL.g:1102:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument8151); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1102:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt204=2;
			int LA204_0 = input.LA(1);
			if ( (LA204_0==LSQUARE) ) {
				alt204=1;
			}
			switch (alt204) {
				case 1 :
					// PhoenixSQL.g:1102:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument8157); if (state.failed) return ret;
					// PhoenixSQL.g:1102:88: (a= NUMBER )?
					int alt203=2;
					int LA203_0 = input.LA(1);
					if ( (LA203_0==NUMBER) ) {
						alt203=1;
					}
					switch (alt203) {
						case 1 :
							// PhoenixSQL.g:1102:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8162); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument8166); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1102:110: (c= CONSTANT )?
			int alt205=2;
			int LA205_0 = input.LA(1);
			if ( (LA205_0==CONSTANT) ) {
				alt205=1;
			}
			switch (alt205) {
				case 1 :
					// PhoenixSQL.g:1102:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument8175); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1102:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt206=2;
			int LA206_0 = input.LA(1);
			if ( (LA206_0==DEFAULTVALUE) ) {
				alt206=1;
			}
			switch (alt206) {
				case 1 :
					// PhoenixSQL.g:1102:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument8180); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8182); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8188);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1102:161: ( MINVALUE EQ minv= expression )?
			int alt207=2;
			int LA207_0 = input.LA(1);
			if ( (LA207_0==MINVALUE) ) {
				alt207=1;
			}
			switch (alt207) {
				case 1 :
					// PhoenixSQL.g:1102:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument8193); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8195); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8201);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1102:195: ( MAXVALUE EQ maxv= expression )?
			int alt208=2;
			int LA208_0 = input.LA(1);
			if ( (LA208_0==MAXVALUE) ) {
				alt208=1;
			}
			switch (alt208) {
				case 1 :
					// PhoenixSQL.g:1102:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument8207); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8209); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8215);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1109:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1111:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1111:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list8245); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list8251);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1111:52: ( COMMA e= value_expression )*
			loop209:
			while (true) {
				int alt209=2;
				int LA209_0 = input.LA(1);
				if ( (LA209_0==COMMA) ) {
					alt209=1;
				}

				switch (alt209) {
				case 1 :
					// PhoenixSQL.g:1111:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list8257); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list8263);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop209;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list8270); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1114:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1115:5: (name= identifier )
			// PhoenixSQL.g:1115:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name8291);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1118:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1119:5: (name= identifier )
			// PhoenixSQL.g:1119:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name8318);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1123:1: table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1124:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt210=2;
			int LA210_0 = input.LA(1);
			if ( (LA210_0==NAME) ) {
				int LA210_1 = input.LA(2);
				if ( (LA210_1==FROM||LA210_1==TO) ) {
					alt210=1;
				}
				else if ( (LA210_1==DOT) ) {
					int LA210_3 = input.LA(3);
					if ( (LA210_3==NAME) ) {
						switch ( input.LA(4) ) {
						case EOF:
						case AND:
						case AS:
						case ASC:
						case ASTERISK:
						case BETWEEN:
						case CACHE:
						case CASCADE:
						case COMMA:
						case CONCAT:
						case CONSTRAINT:
						case CYCLE:
						case DESC:
						case DIVIDE:
						case ELSE:
						case END:
						case EQ:
						case FETCH:
						case FULL:
						case GROUP:
						case GT:
						case HAVING:
						case ILIKE:
						case IN:
						case INCREMENT:
						case INNER:
						case IS:
						case JOIN:
						case LEFT:
						case LIKE:
						case LIMIT:
						case LSQUARE:
						case LT:
						case MAXVALUE:
						case MINUS:
						case MINVALUE:
						case NAME:
						case NOEQ1:
						case NOEQ2:
						case NOT:
						case NULLS:
						case OFFSET:
						case OR:
						case ORDER:
						case PERCENT:
						case PLUS:
						case PRIMARY:
						case RIGHT:
						case RPAREN:
						case RSQUARE:
						case SEMICOLON:
						case THEN:
						case UNION:
						case WHEN:
						case WHERE:
							{
							alt210=1;
							}
							break;
						case FROM:
							{
							switch ( input.LA(5) ) {
							case BIND_NAME:
							case LPAREN:
							case QUESTION:
								{
								alt210=1;
								}
								break;
							case NAME:
								{
								int LA210_7 = input.LA(6);
								if ( (LA210_7==EOF||LA210_7==AS||LA210_7==COMMA||LA210_7==DOT||LA210_7==FETCH||LA210_7==FULL||LA210_7==GROUP||LA210_7==HAVING||LA210_7==INNER||LA210_7==JOIN||LA210_7==LEFT||LA210_7==LIMIT||LA210_7==LPAREN||LA210_7==NAME||LA210_7==OFFSET||LA210_7==ORDER||LA210_7==RIGHT||LA210_7==RPAREN||LA210_7==SEMICOLON||LA210_7==TABLESAMPLE||LA210_7==UNION||LA210_7==WHERE) ) {
									alt210=1;
								}
								else if ( (LA210_7==STRING_LITERAL) ) {
									alt210=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 210, 7, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case GROUP:
							case NULL:
							case NUMBER:
							case STRING_LITERAL:
							case TRUE:
								{
								alt210=2;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 210, 5, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}
							}
							break;
						case DOT:
						case TO:
							{
							alt210=2;
							}
							break;
						default:
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 210, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 210, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 210, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 210, 0, input);
				throw nvae;
			}

			switch (alt210) {
				case 1 :
					// PhoenixSQL.g:1124:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name8346);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1125:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name8360);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name8362); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_table_name8366);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1129:1: from_table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1130:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt211=2;
			int LA211_0 = input.LA(1);
			if ( (LA211_0==NAME) ) {
				int LA211_1 = input.LA(2);
				if ( (LA211_1==EOF||(LA211_1 >= ACTIVE && LA211_1 <= ALL)||LA211_1==AND||(LA211_1 >= AS && LA211_1 <= ASTERISK)||LA211_1==BETWEEN||(LA211_1 >= CACHE && LA211_1 <= CASCADE)||(LA211_1 >= COLUMNS && LA211_1 <= COMMA)||LA211_1==CONCAT||LA211_1==CONSTRAINT||LA211_1==CYCLE||LA211_1==DESC||LA211_1==DISABLE||LA211_1==DIVIDE||LA211_1==DROP||(LA211_1 >= ELSE && LA211_1 <= END)||LA211_1==EQ||LA211_1==FETCH||(LA211_1 >= FROM && LA211_1 <= FULL)||(LA211_1 >= GROUP && LA211_1 <= HAVING)||LA211_1==ILIKE||LA211_1==IN||(LA211_1 >= INCREMENT && LA211_1 <= INNER)||LA211_1==IS||LA211_1==JOIN||LA211_1==LEFT||(LA211_1 >= LIKE && LA211_1 <= LIMIT)||(LA211_1 >= LPAREN && LA211_1 <= MINVALUE)||LA211_1==NAME||(LA211_1 >= NOEQ1 && LA211_1 <= NOT)||LA211_1==NULLS||(LA211_1 >= OFFSET && LA211_1 <= ON)||(LA211_1 >= OR && LA211_1 <= ORDER)||(LA211_1 >= PERCENT && LA211_1 <= PLUS)||LA211_1==PRIMARY||LA211_1==REBUILD||LA211_1==RIGHT||(LA211_1 >= RPAREN && LA211_1 <= RSQUARE)||(LA211_1 >= SELECT && LA211_1 <= SEMICOLON)||LA211_1==SET||LA211_1==START||LA211_1==TABLESAMPLE||LA211_1==THEN||(LA211_1 >= UNION && LA211_1 <= UNUSABLE)||LA211_1==USABLE||LA211_1==VALUES||(LA211_1 >= WHEN && LA211_1 <= WHERE)) ) {
					alt211=1;
				}
				else if ( (LA211_1==DOT) ) {
					alt211=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 211, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 211, 0, input);
				throw nvae;
			}

			switch (alt211) {
				case 1 :
					// PhoenixSQL.g:1130:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name8394);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1131:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name8408);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name8410); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_from_table_name8414);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "table_identifier"
	// PhoenixSQL.g:1134:1: table_identifier returns [String ret] : c= identifier ;
	public final String table_identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1135:5: (c= identifier )
			// PhoenixSQL.g:1135:9: c= identifier
			{
			pushFollow(FOLLOW_identifier_in_table_identifier8441);
			c=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			           if (c.contains(QueryConstants.NAMESPACE_SEPARATOR) ) { throw new RuntimeException("Table or schema name cannot contain colon"); }
			           ret = c;
			    }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_identifier"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1142:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1143:5: (e= literal |b= bind_name )
			int alt212=2;
			int LA212_0 = input.LA(1);
			if ( (LA212_0==DECIMAL||LA212_0==DOUBLE||LA212_0==FALSE||LA212_0==NAME||LA212_0==NULL||LA212_0==NUMBER||LA212_0==STRING_LITERAL||LA212_0==TRUE) ) {
				alt212=1;
			}
			else if ( (LA212_0==BIND_NAME||LA212_0==QUESTION) ) {
				alt212=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 212, 0, input);
				throw nvae;
			}

			switch (alt212) {
				case 1 :
					// PhoenixSQL.g:1143:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind8473);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1144:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind8487);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1148:1: literal returns [LiteralParseNode ret] : (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		String dt =null;

		try {
			// PhoenixSQL.g:1149:5: (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt213=8;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt213=1;
				}
				break;
			case NUMBER:
				{
				alt213=2;
				}
				break;
			case DECIMAL:
				{
				alt213=3;
				}
				break;
			case DOUBLE:
				{
				alt213=4;
				}
				break;
			case NULL:
				{
				alt213=5;
				}
				break;
			case TRUE:
				{
				alt213=6;
				}
				break;
			case FALSE:
				{
				alt213=7;
				}
				break;
			case NAME:
				{
				alt213=8;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 213, 0, input);
				throw nvae;
			}
			switch (alt213) {
				case 1 :
					// PhoenixSQL.g:1149:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8519); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1152:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal8533); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1155:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal8547); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1158:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal8562); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1161:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal8579); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 6 :
					// PhoenixSQL.g:1162:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal8591); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 7 :
					// PhoenixSQL.g:1163:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal8604); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1164:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal8618);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8622); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1173:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1174:5: (n= NUMBER )
			// PhoenixSQL.g:1174:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal8653); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1180:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1181:5: (n= BIND_NAME | QUESTION )
			int alt214=2;
			int LA214_0 = input.LA(1);
			if ( (LA214_0==BIND_NAME) ) {
				alt214=1;
			}
			else if ( (LA214_0==QUESTION) ) {
				alt214=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 214, 0, input);
				throw nvae;
			}

			switch (alt214) {
				case 1 :
					// PhoenixSQL.g:1181:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name8681); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1182:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name8694); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1186:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1187:5: (c= parseNoReserved )
			// PhoenixSQL.g:1187:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier8723);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1190:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1191:5: (n= NAME )
			// PhoenixSQL.g:1191:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved8750); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1194:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1196:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt219=2;
			int LA219_0 = input.LA(1);
			if ( (LA219_0==CASE) ) {
				int LA219_1 = input.LA(2);
				if ( (LA219_1==ARRAY||LA219_1==BIND_NAME||(LA219_1 >= CASE && LA219_1 <= CAST)||LA219_1==CURRENT||LA219_1==DECIMAL||LA219_1==DOUBLE||LA219_1==EXISTS||LA219_1==FALSE||LA219_1==LPAREN||LA219_1==MINUS||(LA219_1 >= NAME && LA219_1 <= NEXT)||(LA219_1 >= NOT && LA219_1 <= NULL)||LA219_1==NUMBER||LA219_1==QUESTION||LA219_1==STRING_LITERAL||LA219_1==TRUE) ) {
					alt219=1;
				}
				else if ( (LA219_1==WHEN) ) {
					alt219=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 219, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 219, 0, input);
				throw nvae;
			}

			switch (alt219) {
				case 1 :
					// PhoenixSQL.g:1196:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8777); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement8781);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1196:26: ( WHEN e2= expression THEN t= expression )+
					int cnt215=0;
					loop215:
					while (true) {
						int alt215=2;
						int LA215_0 = input.LA(1);
						if ( (LA215_0==WHEN) ) {
							alt215=1;
						}

						switch (alt215) {
						case 1 :
							// PhoenixSQL.g:1196:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8784); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8788);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8790); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8794);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt215 >= 1 ) break loop215;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(215, input);
							throw eee;
						}
						cnt215++;
					}

					// PhoenixSQL.g:1196:106: ( ELSE el= expression )?
					int alt216=2;
					int LA216_0 = input.LA(1);
					if ( (LA216_0==ELSE) ) {
						alt216=1;
					}
					switch (alt216) {
						case 1 :
							// PhoenixSQL.g:1196:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8801); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8805);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8811); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1197:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8821); if (state.failed) return ret;
					// PhoenixSQL.g:1197:12: ( WHEN c= expression THEN t= expression )+
					int cnt217=0;
					loop217:
					while (true) {
						int alt217=2;
						int LA217_0 = input.LA(1);
						if ( (LA217_0==WHEN) ) {
							alt217=1;
						}

						switch (alt217) {
						case 1 :
							// PhoenixSQL.g:1197:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8824); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8828);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8830); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8834);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt217 >= 1 ) break loop217;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(217, input);
							throw eee;
						}
						cnt217++;
					}

					// PhoenixSQL.g:1197:72: ( ELSE el= expression )?
					int alt218=2;
					int LA218_0 = input.LA(1);
					if ( (LA218_0==ELSE) ) {
						alt218=1;
					}
					switch (alt218) {
						case 1 :
							// PhoenixSQL.g:1197:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8841); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8845);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8851); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:943:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:943:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:943:10: ( NOT )?
		int alt220=2;
		int LA220_0 = input.LA(1);
		if ( (LA220_0==NOT) ) {
			alt220=1;
		}
		switch (alt220) {
			case 1 :
				// PhoenixSQL.g:943:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL6521); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6524);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1295 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1299 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1334 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1364 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1398 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1444 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1456 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1492 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1516 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1552 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_node_in_oneStatement1576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1600 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1612 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1636 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1660 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1670 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grant_permission_node_in_oneStatement1682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revoke_permission_node_in_oneStatement1694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1736 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1748 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1793 = new BitSet(new long[]{0x50401208020000A0L,0x0100000400000102L,0x0000544000420080L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1797 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1823 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L,0x0000000080000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1828 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node1832 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_table_node1835 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node1837 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node1841 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node1847 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node1859 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node1863 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node1868 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node1872 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node1886 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node1899 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_table_node1901 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node1905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node1944 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node1946 = new BitSet(new long[]{0x0000040000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node1949 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node1951 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node1955 = new BitSet(new long[]{0x0000040000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_create_schema_node1960 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node1966 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRANT_in_grant_permission_node2001 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2005 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_ON_in_grant_permission_node2008 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L,0x0000000080008000L});
	public static final BitSet FOLLOW_TABLE_in_grant_permission_node2012 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_name_in_grant_permission_node2018 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_SCHEMA_in_grant_permission_node2024 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_grant_permission_node2028 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_TO_in_grant_permission_node2033 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000201L,0x0000008040000000L});
	public static final BitSet FOLLOW_GROUP_in_grant_permission_node2038 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REVOKE_in_revoke_permission_node2078 = new BitSet(new long[]{0x0008010000000000L,0x004A100000000021L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2083 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000020L});
	public static final BitSet FOLLOW_ON_in_revoke_permission_node2088 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L,0x0000000080008000L});
	public static final BitSet FOLLOW_TABLE_in_revoke_permission_node2092 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_name_in_revoke_permission_node2098 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_SCHEMA_in_revoke_permission_node2104 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_revoke_permission_node2108 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_revoke_permission_node2113 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000201L,0x0000008040000000L});
	public static final BitSet FOLLOW_GROUP_in_revoke_permission_node2118 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_TABLES_in_show_node2160 = new BitSet(new long[]{0x0000000000000002L,0x0000000100020000L});
	public static final BitSet FOLLOW_IN_in_show_node2163 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_show_node2167 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2176 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2190 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SCHEMAS_in_show_node2192 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2195 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2199 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node2227 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node2229 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_view_node2232 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node2234 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node2238 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2244 = new BitSet(new long[]{0x0000000000000802L,0x0000101000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node2256 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node2260 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node2265 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node2269 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node2283 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node2285 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node2287 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_create_view_node2299 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2303 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node2316 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_create_view_node2320 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2374 = new BitSet(new long[]{0x0000000000000000L,0x0000000800100000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2378 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2381 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2384 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2386 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2390 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2396 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2398 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2402 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2413 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2417 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2419 = new BitSet(new long[]{0x0000000000004002L,0x0000100000040000L,0x0000000008000000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2431 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2434 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2438 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2440 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2456 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2471 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2484 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2486 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2490 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2526 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2528 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node2532 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node2534 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node2538 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node2544 = new BitSet(new long[]{0x0000004000080002L,0x0000028000080000L,0x0000000010000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node2555 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0020008040000004L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node2557 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2562 = new BitSet(new long[]{0x0000004000080002L,0x0000028000080000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node2575 = new BitSet(new long[]{0x0008011000660400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node2577 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2582 = new BitSet(new long[]{0x0000004000080002L,0x0000028000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node2595 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2599 = new BitSet(new long[]{0x0000004000080002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node2612 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2616 = new BitSet(new long[]{0x0000004000080002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node2631 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node2645 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node2649 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind2680 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind2692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_string_literal2720 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node2746 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node2748 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node2752 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node2756 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node2762 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint2791 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint2794 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint2798 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint2800 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint2802 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint2804 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2808 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint2810 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2841 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2847 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2853 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2880 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2885 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2889 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2896 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint2931 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2958 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list2964 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2970 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order2997 = new BitSet(new long[]{0x0000200000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order3003 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order3007 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3035 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3037 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3041 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties3047 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3051 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3053 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3057 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3087 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3101 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name3103 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3107 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value3138 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value3152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3183 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3197 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name3199 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name3203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names3235 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names3241 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names3247 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node3274 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000080000000L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node3279 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node3283 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node3287 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node3291 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node3297 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node3302 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node3337 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node3339 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node3342 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node3346 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3352 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3357 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3392 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3394 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3397 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3401 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3407 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3409 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3413 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3443 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3445 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3448 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3452 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3458 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3460 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3464 = new BitSet(new long[]{0x0000800000000010L,0x0000000000000000L,0x0000220000000010L});
	public static final BitSet FOLLOW_USABLE_in_alter_index_node3477 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_UNUSABLE_in_alter_index_node3481 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_REBUILD_in_alter_index_node3485 = new BitSet(new long[]{0x0000000000004042L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ALL_in_alter_index_node3490 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_DISABLE_in_alter_index_node3496 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ACTIVE_in_alter_index_node3500 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node3507 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_SET_in_alter_index_node3513 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_index_node3518 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node3553 = new BitSet(new long[]{0x0000000000000000L,0x0050000000000000L});
	public static final BitSet FOLLOW_ON_in_trace_node3561 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_WITH_in_trace_node3566 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node3568 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node3574 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node3585 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node3619 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000080L,0x0000000400000000L});
	public static final BitSet FOLLOW_OR_in_create_function_node3622 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node3626 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x0000000400000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node3633 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node3637 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3641 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node3652 = new BitSet(new long[]{0x0000000020000000L,0x0000100000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node3656 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node3658 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node3668 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3672 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node3674 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3680 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_USING_in_create_function_node3691 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node3693 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path3737 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node3760 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node3762 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node3765 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node3769 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node3775 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node3798 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node3800 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node3806 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node3829 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node3831 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node3854 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node3856 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node3862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node3888 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node3890 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node3893 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node3897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node3931 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000080000000L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node3934 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node3940 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node3945 = new BitSet(new long[]{0x0040000000000020L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node3958 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node3960 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3963 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3967 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node3973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node3979 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3982 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node3984 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3988 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node3995 = new BitSet(new long[]{0x0000000000100002L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4001 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_alter_table_node4009 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_alter_table_node4011 = new BitSet(new long[]{0x0000000000000040L,0x0000100000000000L});
	public static final BitSet FOLLOW_indexes_in_alter_table_node4016 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_alter_table_node4022 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node4030 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4035 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node4069 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node4071 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node4075 = new BitSet(new long[]{0x0000000010000042L,0x0000000000100000L,0x0000000000200000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node4080 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node4086 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node4092 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node4097 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node4102 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node4126 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node4128 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name4154 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties4188 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties4190 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4194 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_properties4200 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties4204 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties4206 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4210 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs4245 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs4251 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs4257 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_index_name_in_indexes4288 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_indexes4294 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_indexes4300 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_column_def4326 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def4330 = new BitSet(new long[]{0x0000040000000402L,0x0003003000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_column_def4333 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4337 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_column_def4340 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4344 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_column_def4348 = new BitSet(new long[]{0x0000040000000402L,0x0003002000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_column_def4354 = new BitSet(new long[]{0x0000040000000002L,0x0003002000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def4360 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4365 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def4369 = new BitSet(new long[]{0x0000040000000002L,0x0003000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_column_def4376 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def4381 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def4386 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_column_def4390 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def4397 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_KEY_in_column_def4399 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ASC_in_column_def4404 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_DESC_in_column_def4408 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def4414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4457 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs4463 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4469 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def4495 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def4499 = new BitSet(new long[]{0x0000000000000402L,0x0000003000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def4502 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4506 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def4509 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4513 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def4517 = new BitSet(new long[]{0x0000000000000402L,0x0000002000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def4523 = new BitSet(new long[]{0x0000000000000002L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def4529 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4534 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def4538 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def4575 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def4580 = new BitSet(new long[]{0x0000000000000402L,0x0000003000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def4583 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4587 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def4590 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4594 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def4598 = new BitSet(new long[]{0x0000000000000402L,0x0000002000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def4604 = new BitSet(new long[]{0x0000000000000002L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def4610 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4615 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def4619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression4659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select4692 = new BitSet(new long[]{0x2009011000622440L,0x000B391000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_hintClause_in_single_select4697 = new BitSet(new long[]{0x2009011000622440L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select4713 = new BitSet(new long[]{0x2008011000622400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_ALL_in_single_select4717 = new BitSet(new long[]{0x2008011000622400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_select_list_in_single_select4723 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000A20L,0x0010000000000000L});
	public static final BitSet FOLLOW_FROM_in_single_select4734 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_parseFrom_in_single_select4738 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000A00L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_single_select4751 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_single_select4755 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000A00L});
	public static final BitSet FOLLOW_GROUP_in_single_select4768 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_single_select4770 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_group_by_in_single_select4774 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_HAVING_in_single_select4787 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_single_select4791 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4835 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects4840 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects4842 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4846 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node4884 = new BitSet(new long[]{0x0000000000000002L,0x0420000200000002L});
	public static final BitSet FOLLOW_ORDER_in_select_node4895 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_select_node4897 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_order_by_in_select_node4901 = new BitSet(new long[]{0x0000000000000002L,0x0020000200000002L});
	public static final BitSet FOLLOW_LIMIT_in_select_node4914 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_limit_in_select_node4918 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_select_node4931 = new BitSet(new long[]{0x0000000000020000L,0x0008001000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_offset_in_select_node4935 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_select_node4948 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000008L});
	public static final BitSet FOLLOW_set_in_select_node4950 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000604L});
	public static final BitSet FOLLOW_limit_in_select_node4961 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000600L});
	public static final BitSet FOLLOW_set_in_select_node4965 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_ONLY_in_select_node4973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node5012 = new BitSet(new long[]{0x0000000000000000L,0x0000080000400000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node5017 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node5021 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node5025 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L,0x0002000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5036 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node5040 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5042 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000020000L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node5056 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5058 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node5062 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5064 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_upsert_node5068 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node5070 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node5072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L,0x0000040000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node5078 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node5084 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node5088 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_upsert_node5103 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5144 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs5156 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5160 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair5185 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair5187 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_update_column_pair5191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5220 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs5233 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5237 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node5265 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node5269 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node5271 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node5273 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node5277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node5311 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node5315 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node5342 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node5346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node5372 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node5374 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000020L,0x0000000000000600L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node5379 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L,0x0000000000000600L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node5390 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node5394 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node5420 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000020L});
	public static final BitSet FOLLOW_hintClause_in_delete_node5425 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_delete_node5429 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node5433 = new BitSet(new long[]{0x0000000000000002L,0x0400000200000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_delete_node5444 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_delete_node5448 = new BitSet(new long[]{0x0000000000000002L,0x0400000200000000L});
	public static final BitSet FOLLOW_ORDER_in_delete_node5461 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_delete_node5463 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_order_by_in_delete_node5467 = new BitSet(new long[]{0x0000000000000002L,0x0000000200000000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node5480 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_limit_in_delete_node5484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit5519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit5531 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset5557 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000600L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset5578 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000600L});
	public static final BitSet FOLLOW_LPAREN_in_offset5597 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset5601 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_offset5603 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_offset5605 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_offset5607 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset5611 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_offset5613 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate5638 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_tableSampleNode5663 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause5689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5721 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list5726 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_selectable_in_select_list5730 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list5742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable5771 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable5776 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5791 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5793 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5810 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5812 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable5816 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5818 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5820 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by5853 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by5866 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_group_by5872 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5906 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by5919 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5925 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField5962 = new BitSet(new long[]{0x0000200000001002L,0x0004000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField5974 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField5980 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField5995 = new BitSet(new long[]{0x0000000000000000L,0x0000000010000008L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField5998 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField6004 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom6044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list6075 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list6080 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_ref_in_table_list6084 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6108 = new BitSet(new long[]{0x0000000000000002L,0x0000000044200040L,0x0000000000000100L});
	public static final BitSet FOLLOW_join_type_in_table_ref6115 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref6117 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6121 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_table_ref6123 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_table_ref6127 = new BitSet(new long[]{0x0000000000000002L,0x0000000044200040L,0x0000000000000100L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6151 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_list_in_table_factor6155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6157 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor6171 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6175 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6181 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor6198 = new BitSet(new long[]{0x0000000000000802L,0x0000101000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6202 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6208 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6213 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor6217 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6219 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_TABLESAMPLE_in_table_factor6224 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6226 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_tableSampleNode_in_table_factor6230 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6232 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6246 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_select_node_in_table_factor6250 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6252 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6256 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6262 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type6289 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type6304 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6306 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type6321 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type6337 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6340 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias6371 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias6376 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression6404 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6436 = new BitSet(new long[]{0x0000000000000002L,0x0200000000000000L});
	public static final BitSet FOLLOW_OR_in_or_expression6441 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6445 = new BitSet(new long[]{0x0000000000000002L,0x0200000000000000L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6481 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression6486 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6490 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression6532 = new BitSet(new long[]{0x2008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression6537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression6551 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression6554 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_not_expression6558 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression6560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6587 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6594 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6601 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6603 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6610 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6612 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op6619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6650 = new BitSet(new long[]{0x0800000000010002L,0x0001C04100828400L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression6656 = new BitSet(new long[]{0x0008011000620640L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6661 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6666 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6670 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6681 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6687 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6690 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6694 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6696 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6706 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6712 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6715 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6719 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6721 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression6751 = new BitSet(new long[]{0x0000000000000000L,0x0003000000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6755 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression6758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6789 = new BitSet(new long[]{0x0000000000010000L,0x0000000100028000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression6794 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6798 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression6836 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6840 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression6878 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6882 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression6884 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression6927 = new BitSet(new long[]{0x0000000000020000L,0x0000001000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression6933 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6974 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6978 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6980 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7021 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression7025 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7027 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression7127 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7129 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7133 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression7163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression7194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7225 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_PLUS_in_add_expression7230 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7234 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7269 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression7274 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7278 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7313 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression7318 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7322 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7357 = new BitSet(new long[]{0x0002000000002002L,0x4000000000000000L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression7373 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7387 = new BitSet(new long[]{0x0002000000002002L,0x4000000000000000L});
	public static final BitSet FOLLOW_USE_in_use_schema_node7430 = new BitSet(new long[]{0x0000040000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node7433 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node7439 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression7475 = new BitSet(new long[]{0x0008011000620400L,0x000A301000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression7480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression7508 = new BitSet(new long[]{0x0000000000000002L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression7511 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_array_expression7515 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression7517 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term7578 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7580 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7586 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term7600 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_term7602 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_term7606 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7620 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7622 = new BitSet(new long[]{0x2008011020620400L,0x000B311000000001L,0x0000008040001004L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7626 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7628 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_WITHIN_in_term7633 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_GROUP_in_term7635 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7637 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_ORDER_in_term7639 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_term7641 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7645 = new BitSet(new long[]{0x0000200000001000L});
	public static final BitSet FOLLOW_ASC_in_term7650 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_DESC_in_term7654 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7682 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7684 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term7688 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7690 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7714 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7716 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term7720 = new BitSet(new long[]{0x2008011020620400L,0x000B311000000001L,0x0000008040001004L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7724 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term7749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term7761 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7765 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7767 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term7785 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7787 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_term7791 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term7793 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_term7797 = new BitSet(new long[]{0x0000000000000400L,0x0000003000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_LPAREN_in_term7800 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7804 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_term7807 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7811 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7815 = new BitSet(new long[]{0x0000000000000400L,0x0000002000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_ARRAY_in_term7822 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7827 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7829 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7857 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_CURRENT_in_term7861 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_VALUE_in_term7864 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7866 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7870 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7898 = new BitSet(new long[]{0x0008010000020000L,0x000A100000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7903 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_VALUES_in_term7905 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7907 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7911 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7956 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions7962 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7968 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7999 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths8005 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8011 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8044 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions8052 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8058 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8089 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types8096 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8102 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument8127 = new BitSet(new long[]{0x0000080200000402L,0x000002B000000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument8130 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8134 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_function_argument8137 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8141 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument8145 = new BitSet(new long[]{0x0000080200000402L,0x000002A000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument8151 = new BitSet(new long[]{0x0000080200000002L,0x000002A000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument8157 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8162 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument8166 = new BitSet(new long[]{0x0000080200000002L,0x0000028000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument8175 = new BitSet(new long[]{0x0000080000000002L,0x0000028000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument8180 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument8182 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_function_argument8188 = new BitSet(new long[]{0x0000000000000002L,0x0000028000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument8193 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument8195 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_function_argument8201 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument8207 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument8209 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_function_argument8215 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list8245 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8251 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list8257 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8263 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list8270 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name8291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name8318 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8360 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name8362 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8394 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8408 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name8410 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_identifier8441 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind8473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind8487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal8533 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal8547 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal8562 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal8579 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal8591 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal8604 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal8618 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8622 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal8653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name8681 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name8694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier8723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved8750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8777 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8784 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8788 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8790 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8794 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8801 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8805 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8821 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8824 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8828 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8830 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8834 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8841 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8845 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8851 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL6521 = new BitSet(new long[]{0x2008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6524 = new BitSet(new long[]{0x0000000000000002L});
}
