// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import java.io.IOException;
// 34, 1
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
// 35, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 36, 1
import org.apache.hadoop.hbase.client.TableDescriptor;
// 37, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
// 38, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
// 39, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 42, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.TableName;
// 45, 1
import org.apache.hadoop.hbase.client.Admin;
// 46, 1
import org.apache.hadoop.hbase.client.MasterSwitchType;
// 47, 1
import org.apache.hadoop.hbase.client.TableState;
// 48, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 49, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 50, 1
import org.apache.hadoop.hbase.master.HMaster;
// 51, 1
import org.apache.hadoop.hbase.master.RegionState;
// 52, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 53, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 54, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;
// 55, 1
import org.apache.hadoop.hbase.security.access.PermissionStorage;
// 56, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 57, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos.SnapshotDescription;
// 58, 1
import org.apache.hadoop.hbase.tool.CanaryTool;
// 59, 1
import org.apache.hadoop.hbase.util.Bytes;
// 60, 1
import org.apache.hadoop.hbase.util.CommonFSUtils;
// 61, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 62, 1
import org.apache.hadoop.hbase.util.PrettyPrinter;
// 63, 1
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final String format;
  private final Map<String,Integer> frags;
  private final ServerName metaLocation;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  // 75, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  // 102, 1
  
  public static String getUserTables(HMaster master, List<TableDescriptor> tables){
    if (master.isInitialized()){
      try {
        Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
        if (descriptorMap != null) {
          for (TableDescriptor desc : descriptorMap.values()) {
            if (!desc.getTableName().isSystemTable()) {
             tables.add(desc);
            }
          }
        }
      } catch (IOException e) {
        return "Got user tables error, " + e.getMessage();
      }
    }
    return null;
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    metaLocation = p_implData.getMetaLocation();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 66, 1
    if (format.equals("json") )
    {
      // 66, 30
      jamonWriter.write("\n  ");
      // 67, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_7.setFilter(filter);
        __jamon__var_7.setFormat("json" );
        __jamon__var_7.renderNoFlush(jamonWriter);
      }
      // 67, 68
      jamonWriter.write("\n  ");
      // 68, 3
      return; 
    }
    // 69, 7
    jamonWriter.write("\n");
    // 70, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 122, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 127, 12
    if (master.isActiveMaster() )
    {
      // 127, 43
      jamonWriter.write("Master: ");
    }
    // 127, 51
    else
    {
      // 127, 58
      jamonWriter.write("Backup Master: ");
    }
    // 127, 79
    jamonWriter.write("\n    ");
    // 128, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 128, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
    // 152, 17
    if (master.isActiveMaster() )
    {
      // 152, 48
      jamonWriter.write("\n                    <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                    <li><a href=\"/hbck.jsp\">HBCK Report</a></li>\n                    ");
      // 155, 21
      if (master.getConfiguration().getBoolean(QuotaUtil.QUOTA_CONF_KEY, false) )
      {
        // 155, 98
        jamonWriter.write("\n                        <li><a href=\"/quotas.jsp\">Quotas</a></li>\n                    ");
      }
      // 157, 27
      jamonWriter.write("\n                ");
    }
    // 158, 23
    jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 165, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 165, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 167, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 174, 2
    if (master.isActiveMaster() )
    {
      // 174, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 177, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 177, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 183, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 183, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 185, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 185, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
      }
      // 190, 15
      jamonWriter.write("\n        ");
      // 191, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 191, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 196, 15
      jamonWriter.write("\n        ");
      // 197, 9
      if (master.isInMaintenanceMode() )
      {
        // 197, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This is because hbase.master.maintenance_mode is\n          set to true. Under the maintenance mode, no quota or no Master coprocessor is loaded.\n          </div>\n        ");
      }
      // 202, 15
      jamonWriter.write("\n        ");
      // 203, 9
      if (!master.isBalancerOn() )
      {
        // 203, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 209, 15
      jamonWriter.write("\n        ");
      // 210, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT) )
      {
        // 210, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 216, 15
      jamonWriter.write("\n        ");
      // 217, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.MERGE) )
      {
        // 217, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 223, 15
      jamonWriter.write("\n        ");
      // 224, 9
      if (master.getAssignmentManager() != null )
      {
        // 224, 54
        jamonWriter.write("\n          ");
        // 225, 11
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_8.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 225, 92
        jamonWriter.write("\n        ");
      }
      // 226, 15
      jamonWriter.write("\n        ");
      // 227, 9
      if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null )
      {
        // 227, 91
        jamonWriter.write("\n          ");
        // 228, 11
        if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null &&
            serverManager.getOnlineServersList().size() > 0 )
        {
          // 229, 63
          jamonWriter.write("\n            <section>\n              <h2><a name=\"rsgroup\">RSGroup</a></h2>\n              ");
          // 232, 15
          {
            org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl(this.getTemplateManager());
            __jamon__var_9.renderNoFlush(jamonWriter, master, serverManager);
          }
          // 232, 81
          jamonWriter.write("\n            </section>\n          ");
        }
        // 234, 17
        jamonWriter.write("\n        ");
      }
      // 235, 15
      jamonWriter.write("\n        <section>\n            <h2><a name=\"regionservers\">Region Servers</a></h2>\n            ");
      // 238, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_10.setServers(servers );
        __jamon__var_10.renderNoFlush(jamonWriter, master);
      }
      // 238, 74
      jamonWriter.write("\n\n            ");
      // 240, 13
      if ((deadServers != null) )
      {
        // 240, 42
        jamonWriter.write("\n                ");
        // 241, 17
        {
          // 241, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 241, 40
        jamonWriter.write("\n            ");
      }
      // 242, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 245, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_11.renderNoFlush(jamonWriter, master );
      }
      // 245, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"tables\">Tables</a></h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 263, 25
      if ((metaLocation != null) )
      {
        // 263, 55
        jamonWriter.write("\n                            ");
        // 264, 29
        {
          // 264, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 264, 45
        jamonWriter.write("\n                        ");
      }
      // 265, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 268, 25
      if ((metaLocation != null) )
      {
        // 268, 55
        jamonWriter.write("\n                            ");
        // 269, 29
        {
          // 269, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 269, 48
        jamonWriter.write("\n                        ");
      }
      // 270, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 273, 25
      {
        // 273, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 273, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2><a name=\"peers\">Peers</a></h2>\n            ");
      // 280, 13
      {
        // 280, 13
        __jamon_innerUnit__peerConfigs(jamonWriter);
      }
      // 280, 30
      jamonWriter.write("\n        </section>\n\t");
    }
    // 282, 2
    else
    {
      // 282, 9
      jamonWriter.write("\n        <section>\n            ");
      // 284, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_12 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_12.renderNoFlush(jamonWriter, master );
      }
      // 284, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 286, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 290, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_13 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_13.setFilter(filter);
      __jamon__var_13.setParent("/master-status" );
      __jamon__var_13.renderNoFlush(jamonWriter);
    }
    // 290, 88
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2><a name=\"attributes\">Software Attributes</a></h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>JVM Version</td>\n                    <td>");
    // 303, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(JvmVersion.getVersion()), jamonWriter);
    // 303, 54
    jamonWriter.write("</td>\n                    <td>JVM vendor and version</td>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 308, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 308, 84
    jamonWriter.write(", revision=");
    // 308, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 308, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 312, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 312, 81
    jamonWriter.write(", ");
    // 312, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 312, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 317, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 317, 88
    jamonWriter.write("</td>\n                    <td>HBase source SHA512 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 322, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 322, 78
    jamonWriter.write(", revision=");
    // 322, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 322, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 327, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 327, 75
    jamonWriter.write(", ");
    // 327, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 327, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 332, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 332, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 337, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 337, 72
    jamonWriter.write(", revision=");
    // 337, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevisionHash()), jamonWriter);
    // 337, 135
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision hash</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 342, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 342, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
    // 348, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 348, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
    // 353, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 353, 79
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>Cluster Key</td>\n                    <td> ");
    // 358, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 358, 48
    jamonWriter.write(":");
    // 358, 49
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 358, 102
    jamonWriter.write("</td>\n                    <td>Key to add this cluster as a peer for replication. Use 'help \"add_peer\"' in the shell for details.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 363, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(CommonFSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 363, 93
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 368, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 368, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 371, 17
    if (master.isActiveMaster() )
    {
      // 371, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 374, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 374, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 379, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 379, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 384, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 385, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 388, 18
      if (frags != null )
      {
        // 388, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 391, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 391, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 394, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 397, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 398, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 403, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 403, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 406, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jqSpager.js\" type=\"text/javascript\"></script>\n    <script>\n    $(document).ready(function()\n        {\n            $.tablesorter.addParser(\n            {\n                id: 'filesize',\n                is: function(s) {\n                    return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n                },\n                format: function(s) {\n                    var suf = s.match(new RegExp( /(KB|B|GB|MB|TB)$/ ))[1];\n                    var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                    switch(suf) {\n                        case 'B':\n                            return num;\n                        case 'KB':\n                           return num * 1024;\n                        case 'MB':\n                            return num * 1024 * 1024;\n                        case 'GB':\n                            return num * 1024 * 1024 * 1024;\n                        case 'TB':\n                            return num * 1024 * 1024 * 1024 * 1024;\n                    }\n                },\n                type: 'numeric'\n            });\n            $.tablesorter.addParser(\n            {\n                id: \"separator\",\n                is: function (s) {\n                    return /^[0-9]?[0-9,]*$/.test(s);\n                }, format: function (s) {\n                    return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n                }, type: \"numeric\"\n            });\n            $(\"#baseStatsTable\").tablesorter({\n                headers: {\n                    4: {sorter: 'separator'},\n                    5: {sorter: 'separator'}\n                }\n            });\n            $(\"#memoryStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'filesize'},\n                    2: {sorter: 'filesize'},\n                    3: {sorter: 'filesize'}\n                }\n            });\n            $(\"#requestStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n                    4: {sorter: 'separator'}\n                }\n            });\n            $(\"#storeStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'filesize'},\n                    4: {sorter: 'filesize'},\n                    5: {sorter: 'filesize'},\n                    6: {sorter: 'filesize'}\n                }\n            });\n            $(\"#compactionStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'}\n                }\n            });\n\n            $(\"#userTables\").tablesorter();\n\n            function showRitPages() {\n                if (!$(\"#rit_page_num\")) {\n                  return;\n                }\n                var ritTotalNum = parseInt($(\"#rit_page_num\").val());\n                if (!ritTotalNum || ritTotalNum < 1) {\n                  return;\n                }\n                var ritPerPage = parseInt($(\"#rit_per_page\").val());\n\n                 $(\"#rit_pagination\").sPage({\n                      page:1,\n                      total:ritTotalNum,\n                      pageSize:ritPerPage,\n                      noData: false,\n                      showPN:true,\n                      prevPage:\"prev\",\n                      nextPage:\"next\",\n                      fastForward: 5,\n                      backFun:function(page){\n                          $(\"div[id^='tab_rits']\").removeClass('active');\n                          $(\"#tab_rits\"+page).addClass('active');\n                      }\n                  });\n\n            }\n            showRitPages();\n\n        }\n    );\n    </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 528, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 529, 1
    
 List<TableDescriptor> sysTables = master.isInitialized() ?
   master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;

    // 533, 1
    if ((sysTables != null && sysTables.size() > 0))
    {
      // 533, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 537, 5
      if ((frags != null) )
      {
        // 537, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 539, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 542, 1
      for (TableDescriptor systemTable : sysTables)
      {
        // 542, 48
        jamonWriter.write("\n<tr>\n");
        // 544, 1
        TableName tableName = systemTable.getTableName();
        // 545, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 545, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 545, 48
        jamonWriter.write("\">");
        // 545, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 545, 65
        jamonWriter.write("</a></td>\n    ");
        // 546, 5
        if ((frags != null))
        {
          // 546, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 547, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 548, 37
          jamonWriter.write("</td>\n    ");
        }
        // 549, 11
        jamonWriter.write("\n    ");
        // 550, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(CanaryTool.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(PermissionStorage.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl.";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups.";
        } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
            description = "The hbase:replication table tracks cross cluster replication through " +
            "WAL file offsets.";
        }
    
        // 572, 5
        jamonWriter.write("<td>");
        // 572, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 572, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 574, 8
      jamonWriter.write("\n</table>\n");
    }
    // 576, 7
    jamonWriter.write("\n");
  }
  
  
  // 699, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 701, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 701, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 709, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 715, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 717, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 717, 33
      jamonWriter.write("</td>\n        <td>");
      // 718, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 718, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 720, 5
      
        }
    
      // 723, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 725, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 725, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 729, 7
    jamonWriter.write("\n");
  }
  
  
  // 732, 1
  private void __jamon_innerUnit__peerConfigs(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 733, 1
    
    List<ReplicationPeerDescription> peers = null;
    if (master.getReplicationPeerManager() != null) {
        peers = master.getReplicationPeerManager().listPeers(null);
    }

    // 739, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Endpoint</th>\n        <th>State</th>\n        <th>IsSerial</th>\n        <th>Bandwidth</th>\n        <th>ReplicateAll</th>\n        <th>Namespaces</th>\n        <th>Exclude Namespaces</th>\n        <th>Table Cfs</th>\n        <th>Exclude Table Cfs</th>\n    </tr>\n");
    // 753, 1
    if ((peers != null && peers.size() > 0))
    {
      // 753, 43
      jamonWriter.write("\n    ");
      // 754, 5
      for (ReplicationPeerDescription peer : peers )
      {
        // 754, 53
        jamonWriter.write("\n    ");
        // 755, 5
        
        String peerId = peer.getPeerId();
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
    
        // 759, 5
        jamonWriter.write("<tr>\n        <td>");
        // 760, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerId), jamonWriter);
        // 760, 25
        jamonWriter.write("</td>\n        <td>");
        // 761, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
        // 761, 45
        jamonWriter.write("</td>\n        <td>");
        // 762, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getReplicationEndpointImpl()), jamonWriter);
        // 762, 58
        jamonWriter.write("</td>\n        <td>");
        // 763, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peer.isEnabled() ? "ENABLED" : "DISABLED"), jamonWriter);
        // 763, 60
        jamonWriter.write("</td>\n        <td>");
        // 764, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.isSerial()), jamonWriter);
        // 764, 40
        jamonWriter.write("</td>\n        <td>");
        // 765, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getBandwidth() == 0? "UNLIMITED" : StringUtils.humanReadableInt(peerConfig.getBandwidth())), jamonWriter);
        // 765, 120
        jamonWriter.write("</td>\n        <td>");
        // 766, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.replicateAllUserTables()), jamonWriter);
        // 766, 54
        jamonWriter.write("</td>\n        <td>\n           ");
        // 768, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 768, 151
        jamonWriter.write("\n        </td>\n        <td>\n            ");
        // 771, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 771, 166
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 774, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 774, 153
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 777, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 777, 167
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 780, 12
      jamonWriter.write("\n");
    }
    // 781, 7
    jamonWriter.write("\n<tr><td>Total: ");
    // 782, 16
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf((peers != null) ? peers.size() : 0), jamonWriter);
    // 782, 56
    jamonWriter.write("</td></tr>\n</table>\n");
  }
  
  
  // 663, 1
  private void __jamon_innerUnit__userSnapshots(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 664, 1
    
   List<SnapshotDescription> snapshots = master.isInitialized() ?
     master.getSnapshotManager().getCompletedSnapshots() : null;

    // 668, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 668, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n        <th>Owner</th>\n        <th>TTL</th>\n    </tr>\n    ");
      // 677, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 677, 57
        jamonWriter.write("\n    ");
        // 678, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 681, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 682, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 682, 68
        jamonWriter.write("\">");
        // 682, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 682, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 683, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 683, 74
        jamonWriter.write("\">");
        // 683, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 683, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 685, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 685, 59
        jamonWriter.write("</td>\n        <td>");
        // 686, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getOwner()), jamonWriter);
        // 686, 42
        jamonWriter.write("</td>\n\n        <td>\n          ");
        // 689, 11
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getTtl() == 0 ? "FOREVER": PrettyPrinter.format(String.valueOf(snapshotDesc.getTtl()), PrettyPrinter.Unit.TIME_INTERVAL)), jamonWriter);
        // 689, 150
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 692, 12
      jamonWriter.write("\n    <p>");
      // 693, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 693, 30
      jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
    }
    // 695, 7
    jamonWriter.write("\n");
  }
  
  
  // 579, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 580, 1
    
   List<TableDescriptor> tables = new ArrayList<TableDescriptor>();
   String errorMessage = getUserTables(master, tables);

    // 584, 1
    if ((tables.size() == 0 && errorMessage != null))
    {
      // 584, 52
      jamonWriter.write("\n<p> ");
      // 585, 5
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(errorMessage), jamonWriter);
      // 585, 23
      jamonWriter.write(" </p>\n");
    }
    // 586, 7
    jamonWriter.write("\n\n");
    // 588, 1
    if ((tables != null && tables.size() > 0))
    {
      // 588, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Namespace</th>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Name</th>\n        ");
      // 594, 9
      if ((frags != null) )
      {
        // 594, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 596, 15
      jamonWriter.write("\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">State</th>\n        <th style=\"text-align: center\" colspan=\"8\">Regions</th>\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">Description</th>\n    </tr>\n    <tr>\n        <th>OPEN</th>\n        <th>OPENING</th>\n        <th>CLOSED</th>\n        <th>CLOSING</th>\n        <th>OFFLINE</th>\n        <th>FAILED</th>\n        <th>SPLIT</th>\n        <th>Other</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 613, 5
      for (TableDescriptor desc : tables)
      {
        // 613, 42
        jamonWriter.write("\n    ");
        // 614, 5
        
      HTableDescriptor htDesc = new HTableDescriptor(desc);
      TableName tableName = htDesc.getTableName();
      TableState tableState = master.getTableStateManager().getTableState(tableName);
      Map<RegionState.State, List<RegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int openingRegionsCount = tableRegions.get(RegionState.State.OPENING).size();
      int closedRegionsCount = tableRegions.get(RegionState.State.CLOSED).size();
      int closingRegionsCount = tableRegions.get(RegionState.State.CLOSING).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<RegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount - openingRegionsCount
                     - closedRegionsCount - closingRegionsCount;
    
        // 639, 5
        jamonWriter.write("<tr>\n        <td>");
        // 640, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 640, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 641, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
        // 641, 69
        jamonWriter.write(">");
        // 641, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
        // 641, 108
        jamonWriter.write("</a> </td>\n        ");
        // 642, 9
        if ((frags != null) )
        {
          // 642, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 643, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 643, 150
          jamonWriter.write("</td>\n        ");
        }
        // 644, 15
        jamonWriter.write("\n        <td>");
        // 645, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableState.getState()), jamonWriter);
        // 645, 40
        jamonWriter.write("</td>\n        <td>");
        // 646, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 646, 35
        jamonWriter.write("</td>\n        ");
        // 647, 9
        if ((openingRegionsCount > 0) )
        {
          // 647, 42
          jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
          // 647, 72
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
          // 647, 105
          jamonWriter.write("&state=OPENING\">");
          // 647, 121
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 647, 146
          jamonWriter.write("</td> ");
        }
        // 647, 152
        else
        {
          // 647, 159
          jamonWriter.write("<td>");
          // 647, 163
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 647, 188
          jamonWriter.write("</td> ");
        }
        // 647, 200
        jamonWriter.write("\n        <td>");
        // 648, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
        // 648, 37
        jamonWriter.write("</td>\n        ");
        // 649, 9
        if ((closingRegionsCount > 0) )
        {
          // 649, 42
          jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
          // 649, 72
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
          // 649, 105
          jamonWriter.write("&state=CLOSING\">");
          // 649, 121
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 649, 146
          jamonWriter.write("</td> ");
        }
        // 649, 152
        else
        {
          // 649, 159
          jamonWriter.write("<td>");
          // 649, 163
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 649, 188
          jamonWriter.write("</td> ");
        }
        // 649, 200
        jamonWriter.write("\n        <td>");
        // 650, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 650, 38
        jamonWriter.write("</td>\n        <td>");
        // 651, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 651, 37
        jamonWriter.write("</td>\n        <td>");
        // 652, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 652, 36
        jamonWriter.write("</td>\n        <td>");
        // 653, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 653, 36
        jamonWriter.write("</td>\n        <td>");
        // 654, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 654, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 656, 12
      jamonWriter.write("\n    <p>");
      // 657, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.size()), jamonWriter);
      // 657, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</tbody>\n</table>\n");
    }
    // 660, 7
    jamonWriter.write("\n");
  }
  
  
}
