// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RSStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 27, 1
import java.util.*;
// 28, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 29, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 30, 1
import org.apache.hadoop.hbase.ServerName;
// 31, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 1
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
// 33, 1
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
// 34, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.ServerInfo;
// 35, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 36, 1
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;

public class RSStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.Intf

{
  private final HRegionServer regionServer;
  private final String bcn;
  private final String bcv;
  private final String filter;
  private final String format;
  // 56, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = regionServer.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getBcn__IsNotDefault())
    {
      p_implData.setBcn("");
    }
    if(! p_implData.getBcv__IsNotDefault())
    {
      p_implData.setBcv("");
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    return p_implData;
  }
  public RSStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    bcn = p_implData.getBcn();
    bcv = p_implData.getBcv();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 39, 1
    if (format.equals("json") && bcn != null && bcn.length() > 0  )
    {
      // 39, 66
      jamonWriter.write("\n  ");
      // 40, 3
      {
        org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl(this.getTemplateManager());
        __jamon__var_0.renderNoFlush(jamonWriter, new CacheConfig(regionServer.getConfiguration()), regionServer.getConfiguration(), bcn, bcv, regionServer.getBlockCache().orElse(null)  );
      }
      // 40, 210
      jamonWriter.write("\n  ");
      // 41, 3
      return; 
    }
    // 42, 1
    else if (format.equals("json") )
    {
      // 42, 34
      jamonWriter.write("\n  ");
      // 43, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_1.setFilter(filter);
        __jamon__var_1.setFormat("json" );
        __jamon__var_1.renderNoFlush(jamonWriter);
      }
      // 43, 68
      jamonWriter.write("\n  ");
      // 44, 3
      return; 
    }
    // 45, 7
    jamonWriter.write("\n");
    // 46, 1
    
  ServerInfo serverInfo = ProtobufUtil.getServerInfo(null, regionServer.getRSRpcServices());
  ServerName serverName = ProtobufUtil.toServerName(serverInfo.getServerName());
  List<RegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(regionServer.getRSRpcServices());
  MasterAddressTracker masterAddressTracker = regionServer.getMasterAddressTracker();
  ServerName masterServerName = masterAddressTracker == null ? null
    : masterAddressTracker.getMasterAddress();
  int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();

    // 83, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
    // 88, 33
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
    // 88, 63
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/rs-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/rs-status\">Home</a></li>\n                <li><a href=\"/processRS.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 118, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 118, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 120, 23
    jamonWriter.write("\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
    // 130, 37
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 130, 53
    jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
    // 137, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl(this.getTemplateManager());
      __jamon__var_2.renderNoFlush(jamonWriter, regionServer.getMetrics().getRegionServerWrapper(), regionServer.getRpcServer().getMetrics().getHBaseServerWrapper(), regionServer.getRpcServer().getByteBuffAllocator());
    }
    // 139, 75
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Block Cache</h2>\n    ");
    // 144, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl(this.getTemplateManager());
      __jamon__var_3.renderNoFlush(jamonWriter, new CacheConfig(regionServer.getConfiguration()), regionServer.getConfiguration(), regionServer.getBlockCache().orElse(null) );
    }
    // 144, 179
    jamonWriter.write("\n    </section>\n\n    <section>\n    ");
    // 148, 5
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_4.setFilter(filter);
      __jamon__var_4.setParent("/rs-status" );
      __jamon__var_4.renderNoFlush(jamonWriter);
    }
    // 148, 76
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
    // 153, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl(this.getTemplateManager());
      __jamon__var_5.renderNoFlush(jamonWriter, regionServer, onlineRegions);
    }
    // 153, 86
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Replication Status</h1>\n    ");
    // 158, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.ReplicationStatusTmpl __jamon__var_6 = new org.apache.hadoop.hbase.tmpl.regionserver.ReplicationStatusTmpl(this.getTemplateManager());
      __jamon__var_6.renderNoFlush(jamonWriter, regionServer);
    }
    // 158, 62
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>JVM Version</td>\n            <td>");
    // 171, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(JvmVersion.getVersion()), jamonWriter);
    // 171, 46
    jamonWriter.write("</td>\n            <td>JVM vendor and version</td>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
    // 176, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 176, 76
    jamonWriter.write(", revision=");
    // 176, 87
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 176, 147
    jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
    // 181, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 181, 73
    jamonWriter.write(", ");
    // 181, 75
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 181, 131
    jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>HBase Source Checksum</td>\n            <td>");
    // 186, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 186, 80
    jamonWriter.write("</td>\n            <td>HBase source SHA512 checksum</td>\n        </tr>\n        <tr>\n            <td>Hadoop Version</td>\n            <td>");
    // 191, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 191, 70
    jamonWriter.write(", revision=");
    // 191, 81
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 191, 135
    jamonWriter.write("</td>\n            <td>Hadoop version and revision</td>\n        </tr>\n        <tr>\n            <td>Hadoop Compiled</td>\n            <td>");
    // 196, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 196, 67
    jamonWriter.write(", ");
    // 196, 69
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 196, 119
    jamonWriter.write("</td>\n            <td>When Hadoop version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Hadoop Source Checksum</td>\n            <td>");
    // 201, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 201, 74
    jamonWriter.write("</td>\n            <td>Hadoop source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Version</td>\n            <td>");
    // 206, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 206, 64
    jamonWriter.write(", revision=");
    // 206, 75
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevisionHash()), jamonWriter);
    // 206, 127
    jamonWriter.write("</td>\n            <td>ZooKeeper client version and revision hash</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Compiled</td>\n            <td>");
    // 211, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 211, 66
    jamonWriter.write("</td>\n            <td>When ZooKeeper client version was compiled</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Quorum</td>\n            <td>");
    // 217, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 217, 39
    jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
    // 222, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(regionServer.getRegionServerCoprocessors())), jamonWriter);
    // 222, 92
    jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
    // 227, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(regionServer.getStartcode())), jamonWriter);
    // 227, 60
    jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
    // 233, 17
    if (masterServerName == null )
    {
      // 233, 49
      jamonWriter.write("\n                No master found\n                ");
    }
    // 235, 17
    else
    {
      // 235, 24
      jamonWriter.write("\n                ");
      // 236, 17
      
                String host = masterServerName.getHostname() + ":" + infoPort;
                String url = "//" + host + "/master-status";
                
      // 240, 17
      jamonWriter.write("<a href=\"");
      // 240, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 240, 35
      jamonWriter.write("\">");
      // 240, 37
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(host), jamonWriter);
      // 240, 47
      jamonWriter.write("</a>\n                ");
    }
    // 241, 23
    jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n<script>\n$(document).ready(function()\n    {\n        $.tablesorter.addParser({\n            id: 'filesize',\n            is: function(s) {\n                return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n            },\n            format: function(s) {\n                var suf = s.match(new RegExp( /(KB|B|GB|MB|TB)$/ ))[1];\n                var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                switch(suf) {\n                    case 'B':\n                        return num;\n                    case 'KB':\n                        return num * 1024;\n                    case 'MB':\n                        return num * 1024 * 1024;\n                    case 'GB':\n                        return num * 1024 * 1024 * 1024;\n                    case 'TB':\n                        return num * 1024 * 1024 * 1024 * 1024;\n                }\n            },\n            type: 'numeric'\n        });\n        $.tablesorter.addParser(\n        {\n            id: \"separator\",\n            is: function (s) {\n                return /^[0-9]?[0-9,]*$/.test(s);\n            },\n            format: function (s) {\n                return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n            },\n            type: \"numeric\"\n        });\n\n        $(\"#baseStatsTable\").tablesorter();\n        $(\"#requestStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'},\n                2: {sorter: 'separator'},\n                3: {sorter: 'separator'}\n            }\n        });\n        $(\"#storeStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'},\n                2: {sorter: 'separator'},\n                3: {sorter: 'filesize'},\n                4: {sorter: 'filesize'},\n                5: {sorter: 'filesize'},\n                6: {sorter: 'filesize'}\n            }\n        });\n        $(\"#compactionStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'},\n                2: {sorter: 'separator'}\n            }\n        });\n        $(\"#memstoreStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'filesize'}\n            }\n        });\n    }\n);\n</script>\n</body>\n</html>\n");
  }
  
  
}
