// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/ServerMetricsTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 25, 1
import java.util.*;
// 26, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 1
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
// 28, 1
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
// 29, 1
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
// 30, 1
import org.apache.hadoop.hbase.util.Bytes;
// 31, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 32, 1
import org.apache.hadoop.hbase.ServerName;
// 33, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 34, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 35, 1
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 36, 1
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 37, 1
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
// 38, 1
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;
// 39, 1
import java.lang.management.MemoryUsage;
// 40, 1
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;

public class ServerMetricsTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.Intf

{
  private final MetricsRegionServerWrapper mWrap;
  private final MetricsHBaseServerWrapper mServerWrap;
  private final ByteBuffAllocator bbAllocator;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public ServerMetricsTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    mWrap = p_implData.getMWrap();
    mServerWrap = p_implData.getMServerWrap();
    bbAllocator = p_implData.getBbAllocator();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 42, 1
    jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_walStats\" data-toggle=\"tab\">WALs</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_queueStats\" data-toggle=\"tab\">Queues</a></li>\n        <li class=\"\"><a href=\"#tab_byteBuffAllocatorStats\" data-toggle=\"tab\">ByteBuffAllocator Stats</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
    // 54, 13
    {
      // 54, 13
      __jamon_innerUnit__baseStats(jamonWriter, mWrap );
    }
    // 54, 43
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
    // 57, 13
    {
      // 57, 13
      __jamon_innerUnit__memoryStats(jamonWriter, mWrap );
    }
    // 57, 45
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
    // 60, 13
    {
      // 60, 13
      __jamon_innerUnit__requestStats(jamonWriter, mWrap );
    }
    // 60, 46
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_walStats\">\n            ");
    // 63, 13
    {
      // 63, 13
      __jamon_innerUnit__walStats(jamonWriter, mWrap );
    }
    // 63, 42
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
    // 66, 13
    {
      // 66, 13
      __jamon_innerUnit__storeStats(jamonWriter, mWrap );
    }
    // 66, 44
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\">\n            ");
    // 69, 13
    {
      // 69, 13
      __jamon_innerUnit__queueStats(jamonWriter, mWrap, mServerWrap);
    }
    // 69, 72
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_byteBuffAllocatorStats\">\n            ");
    // 72, 13
    {
      // 72, 13
      __jamon_innerUnit__byteBuffAllocatorStats(jamonWriter, bbAllocator);
    }
    // 72, 69
    jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
  }
  
  
  // 77, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 81, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Block locality (Secondary replicas)</th>\n        <th>Slow WAL Append Count</th>\n    </tr>\n    <tr>\n        <td>");
    // 91, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
    // 91, 70
    jamonWriter.write("</td>\n        <td>");
    // 92, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumOnlineRegions()), jamonWriter);
    // 92, 46
    jamonWriter.write("</td>\n        <td>");
    // 93, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f",mWrap.getPercentFileLocal())), jamonWriter);
    // 93, 68
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 93, 77
    jamonWriter.write("</td>\n        <td>");
    // 94, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f",mWrap.getPercentFileLocalSecondaryRegions())), jamonWriter);
    // 94, 84
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 94, 93
    jamonWriter.write("</td>\n        <td>");
    // 95, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumWALSlowAppend()), jamonWriter);
    // 95, 46
    jamonWriter.write("</td>\n    </tr>\n</table>\n");
  }
  
  
  // 235, 1
  private void __jamon_innerUnit__byteBuffAllocatorStats(final java.io.Writer jamonWriter, final ByteBuffAllocator bbAllocator)
    throws java.io.IOException
  {
    // 239, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Total Heap Allocation</th>\n    <th>Total Pool Allocation</th>\n    <th>Heap Allocation Ratio</th>\n    <th>Total Buffer Count</th>\n    <th>Used Buffer Count</th>\n    <th>Buffer Size</th>\n</tr>\n<tr>\n    <td>");
    // 249, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(ByteBuffAllocator.getHeapAllocationBytes(bbAllocator, ByteBuffAllocator.HEAP), "B", 1)), jamonWriter);
    // 249, 137
    jamonWriter.write("</td>\n    <td>");
    // 250, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bbAllocator.getPoolAllocationBytes(), "B", 1)), jamonWriter);
    // 250, 96
    jamonWriter.write("</td>\n    <td>");
    // 251, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f", ByteBuffAllocator.getHeapAllocationRatio(bbAllocator, ByteBuffAllocator.HEAP) * 100)), jamonWriter);
    // 251, 121
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 251, 130
    jamonWriter.write("</td>\n    <td>");
    // 252, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bbAllocator.getTotalBufferCount()), jamonWriter);
    // 252, 48
    jamonWriter.write("</td>\n    <td>");
    // 253, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bbAllocator.getUsedBufferCount()), jamonWriter);
    // 253, 47
    jamonWriter.write("</td>\n    <td>");
    // 254, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bbAllocator.getBufferSize(), "B", 1)), jamonWriter);
    // 254, 87
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 100, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 104, 1
    long usedHeap = -1L;
  long maxHeap = -1L;
  final MemoryUsage usage = MemorySizeUtil.safeGetHeapMemoryUsage();
  if (usage != null) {
    maxHeap = usage.getMax();
    usedHeap = usage.getUsed();
  }

    // 113, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Direct Memory Used</th>\n        <th>Direct Memory Configured</th>\n        <th>Memstore Size</th>\n        <th>Memstore Limit</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
    // 126, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(usedHeap, "B", 1)), jamonWriter);
    // 126, 68
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 129, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(maxHeap, "B", 1)), jamonWriter);
    // 129, 67
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 132, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(DirectMemoryUtils.getDirectMemoryUsage(), "B", 1)), jamonWriter);
    // 132, 100
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 135, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(DirectMemoryUtils.getDirectMemorySize(), "B", 1)), jamonWriter);
    // 135, 99
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 138, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getMemStoreSize(), "B", 1)), jamonWriter);
    // 138, 83
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 141, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getMemStoreLimit(), "B", 1)), jamonWriter);
    // 141, 84
    jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
  }
  
  
  // 209, 1
  private void __jamon_innerUnit__queueStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap, final MetricsHBaseServerWrapper mServerWrap)
    throws java.io.IOException
  {
    // 214, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction Queue Length</th>\n    <th>Flush Queue Length</th>\n    <th>Priority Call Queue Length</th>\n    <th>General Call Queue Length</th>\n    <th>Replication Call Queue Length</th>\n    <th>Total Call Queue Size</th>\n\n</tr>\n<tr>\n    <td>");
    // 225, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getCompactionQueueSize()), jamonWriter);
    // 225, 45
    jamonWriter.write("</td>\n    <td>");
    // 226, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getFlushQueueSize()), jamonWriter);
    // 226, 40
    jamonWriter.write("</td>\n    <td>");
    // 227, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mServerWrap.getPriorityQueueLength()), jamonWriter);
    // 227, 51
    jamonWriter.write("</td>\n    <td>");
    // 228, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mServerWrap.getGeneralQueueLength()), jamonWriter);
    // 228, 50
    jamonWriter.write("</td>\n    <td>");
    // 229, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mServerWrap.getReplicationQueueLength()), jamonWriter);
    // 229, 54
    jamonWriter.write("</td>\n    <td>");
    // 230, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mServerWrap.getTotalQueueSize(), "B", 1)), jamonWriter);
    // 230, 91
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 189, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 193, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
    // 201, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
    // 201, 66
    jamonWriter.write("</td>\n    <td>");
    // 202, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getReadRequestsCount()), jamonWriter);
    // 202, 43
    jamonWriter.write("</td>\n    <td>");
    // 203, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getFilteredReadRequestsCount()), jamonWriter);
    // 203, 51
    jamonWriter.write("</td>\n    <td>");
    // 204, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getWriteRequestsCount()), jamonWriter);
    // 204, 44
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 165, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 169, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n<tr>\n    <td>");
    // 179, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumStores()), jamonWriter);
    // 179, 35
    jamonWriter.write("</td>\n    <td>");
    // 180, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumStoreFiles()), jamonWriter);
    // 180, 39
    jamonWriter.write("</td>\n    <td>");
    // 181, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getStoreFileIndexSize(), "B", 1)), jamonWriter);
    // 181, 89
    jamonWriter.write("</td>\n    <td>");
    // 182, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getTotalStaticIndexSize(), "B", 1)), jamonWriter);
    // 182, 91
    jamonWriter.write("</td>\n    <td>");
    // 183, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getTotalStaticBloomSize(), "B", 1)), jamonWriter);
    // 183, 91
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 147, 1
  private void __jamon_innerUnit__walStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 151, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Num. WAL Files</th>\n        <th>Size. WAL Files</th>\n    </tr>\n</tr>\n<tr>\n    <td>");
    // 159, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumWALFiles()), jamonWriter);
    // 159, 37
    jamonWriter.write("</td>\n    <td>");
    // 160, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getWALFileSize(), "B", 1)), jamonWriter);
    // 160, 82
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
}
