/*
 * Copyright (c) 2017, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.inject.hk2;

import java.lang.annotation.Annotation;

import javax.inject.Singleton;

import org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.internal.inject.ForeignDescriptorImpl;
import org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.internal.inject.InjecteeImpl;
import org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.internal.util.ReflectionHelper;

import org.apache.hbase.thirdparty.org.glassfish.hk2.api.Factory;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.Injectee;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.InjectionResolver;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.ServiceHandle;

/**
 * This class wraps the org.apache.hbase.thirdparty.jersery class {@link org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.internal.inject.InjectionResolver} to make HK2 version of this
 * provided functionality. HK2 {@link InjectionResolver} can be then register in {@link org.apache.hbase.thirdparty.org.glassfish.hk2.api.ServiceLocator} and
 * HK2 can handle the annotation which is register along with the interface.
 */
@Singleton
public class InjectionResolverWrapper<T extends Annotation> implements InjectionResolver<T> {

    private final org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.internal.inject.InjectionResolver org.apache.hbase.thirdparty.jerseryResolver;

    /**
     * C'tor accepts org.apache.hbase.thirdparty.jersery-like {@code InjectionResolver} on which the the processing is delegated.
     *
     * @param org.apache.hbase.thirdparty.jerseryResolver org.apache.hbase.thirdparty.jersery injection resolver.
     */
    InjectionResolverWrapper(org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.internal.inject.InjectionResolver<T> org.apache.hbase.thirdparty.jerseryResolver) {
        this.org.apache.hbase.thirdparty.jerseryResolver = org.apache.hbase.thirdparty.jerseryResolver;
    }

    @Override
    public Object resolve(Injectee injectee, ServiceHandle root) {
        InjecteeImpl injecteeWrapper = new InjecteeImpl();
        injecteeWrapper.setRequiredType(injectee.getRequiredType());
        injecteeWrapper.setParent(injectee.getParent());
        injecteeWrapper.setRequiredQualifiers(injectee.getRequiredQualifiers());
        injecteeWrapper.setOptional(injectee.isOptional());
        injecteeWrapper.setPosition(injectee.getPosition());
        injecteeWrapper.setFactory(ReflectionHelper.isSubClassOf(injectee.getRequiredType(), Factory.class));
        injecteeWrapper.setInjecteeDescriptor(new ForeignDescriptorImpl(injectee.getInjecteeDescriptor()));

        Object instance = org.apache.hbase.thirdparty.jerseryResolver.resolve(injecteeWrapper);
        if (injecteeWrapper.isFactory()) {
            return asFactory(instance);
        } else {
            return instance;
        }
    }

    private Factory asFactory(Object instance) {
        return new Factory() {
            @Override
            public Object provide() {
                return instance;
            }

            @Override
            public void dispose(final Object instance) {
            }
        };
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return org.apache.hbase.thirdparty.jerseryResolver.isConstructorParameterIndicator();
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return org.apache.hbase.thirdparty.jerseryResolver.isMethodParameterIndicator();
    }
}
