/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.hbase.thirdparty.org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;

import org.apache.hbase.thirdparty.org.glassfish.hk2.api.ActiveDescriptor;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.PerLookup;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.ServiceHandle;

/**
 * @author jwells
 *
 */
public class PerLookupContext implements Context<PerLookup> {

    /* (non-Javadoc)
     * @see org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context#getScope()
     */
    @Override
    public Class<? extends Annotation> getScope() {
        return PerLookup.class;
    }

    /* (non-Javadoc)
     * @see org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context#findOrCreate(org.apache.hbase.thirdparty.org.glassfish.hk2.api.ActiveDescriptor, org.apache.hbase.thirdparty.org.glassfish.hk2.api.ServiceHandle)
     */
    @Override
    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor,
            ServiceHandle<?> root) {
        return activeDescriptor.create(root);
    }

    /* (non-Javadoc)
     * @see org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context#find(org.apache.hbase.thirdparty.org.glassfish.hk2.api.Descriptor)
     */
    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        return false;
    }

    /* (non-Javadoc)
     * @see org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context#isActive()
     */
    @Override
    public boolean isActive() {
        return true;
    }

    /* (non-Javadoc)
     * @see org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context#supportsNullCreation()
     */
    @Override
    public boolean supportsNullCreation() {
        return true;
    }

    /* (non-Javadoc)
     * @see org.apache.hbase.thirdparty.org.glassfish.hk2.api.Context#supportsNullCreation()
     */
    @Override
    public void shutdown() {
    }

    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        // Do nothing, this is a special case
        
    }
}
