/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.hbase.thirdparty.org.glassfish.hk2.api;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Scope annotations that are also marked with this
 * annotation are proxiable.  All objects that are
 * produced by this scope must be able to be proxied,
 * and will be proxied by the system.  Whether or
 * not individual {@link Descriptor}s in a Proxiable
 * scope are proxied can be controlled with
 * the {@link UseProxy} annotation.  All proxies
 * generated by HK2 will implement {@link ProxyCtl}
 * <p>
 * A scope must not be marked with both {@link Proxiable} and {@link Unproxiable}
 * <p>
 * @see Proxiable Unproxiable UseProxy ProxyCtl
 * 
 * @author jwells
 *
 */
@Retention(RUNTIME)
@Target( { ANNOTATION_TYPE })
public @interface Proxiable {
    /**
     * This value determines whether or not services in this scope
     * should be proxied when being injected into other services of
     * the same scope.  This value can be overridden by individual
     * {@link Descriptor}s in this scope.
     * 
     * @return If true then this service will be proxied even when
     * being injected into the same scope.  If
     * false then this service will NOT be proxied when
     * being injected into the same scope (i.e., it cannot
     * be used for lazy initialization of the service when
     * injected into the same scope)
     */
    public boolean proxyForSameScope() default true;

}
