// $ANTLR 3.5.2 PhoenixSQL.g 2022-12-20 21:53:02

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.filter.CompareFilter.CompareOp;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "BETWEEN", 
		"BIND_NAME", "BY", "CACHE", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_ESC", 
		"CLOSE", "COLON", "COLUMN", "COLUMNS", "COMMA", "COMMENT_AND_HINT_END", 
		"COMMENT_START", "CONCAT", "CONSTANT", "CONSTRAINT", "CREATE", "CURRENT", 
		"CURSOR", "CYCLE", "DBL_QUOTE_CHAR", "DECIMAL", "DECLARE", "DEFAULT", 
		"DEFAULTVALUE", "DELETE", "DESC", "DIGIT", "DISABLE", "DISTINCT", "DIVIDE", 
		"DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", "DROP", "DUPLICATE", "ELSE", 
		"END", "EOL", "EQ", "EXECUTE", "EXISTS", "EXPLAIN", "Exponent", "FALSE", 
		"FETCH", "FIELDCHAR", "FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GRANT", 
		"GROUP", "GT", "HAVING", "HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", 
		"IN", "INCLUDE", "INCREMENT", "INDEX", "INNER", "INTO", "IS", "JAR", "JARS", 
		"JOIN", "KEY", "LAST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", 
		"LOCAL", "LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NULL", "NULLS", "NUMBER", 
		"OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", "OTHER", "OUTER", 
		"OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "PRIMARY", "QUESTION", 
		"RCURLY", "REBUILD", "REPLACE", "RETURNS", "REVOKE", "RIGHT", "ROW", "ROWS", 
		"ROW_TIMESTAMP", "RPAREN", "RSQUARE", "SAMPLING", "SCHEMA", "SCHEMAS", 
		"SELECT", "SEMICOLON", "SEQUENCE", "SESSION", "SET", "SHOW", "SL_COMMENT", 
		"SL_COMMENT1", "SL_COMMENT2", "SOME", "SPLIT", "START", "STATISTICS", 
		"STRING_LITERAL", "TABLE", "TABLES", "TABLESAMPLE", "TEMPORARY", "THEN", 
		"TILDE", "TO", "TRACE", "TRUE", "UNION", "UNUSABLE", "UPDATE", "UPGRADE", 
		"UPSERT", "USABLE", "USE", "USING", "VALUE", "VALUES", "VIEW", "WHEN", 
		"WHERE", "WITH", "WITHIN", "WS"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int BETWEEN=16;
	public static final int BIND_NAME=17;
	public static final int BY=18;
	public static final int CACHE=19;
	public static final int CASCADE=20;
	public static final int CASE=21;
	public static final int CAST=22;
	public static final int CHAR=23;
	public static final int CHAR_ESC=24;
	public static final int CLOSE=25;
	public static final int COLON=26;
	public static final int COLUMN=27;
	public static final int COLUMNS=28;
	public static final int COMMA=29;
	public static final int COMMENT_AND_HINT_END=30;
	public static final int COMMENT_START=31;
	public static final int CONCAT=32;
	public static final int CONSTANT=33;
	public static final int CONSTRAINT=34;
	public static final int CREATE=35;
	public static final int CURRENT=36;
	public static final int CURSOR=37;
	public static final int CYCLE=38;
	public static final int DBL_QUOTE_CHAR=39;
	public static final int DECIMAL=40;
	public static final int DECLARE=41;
	public static final int DEFAULT=42;
	public static final int DEFAULTVALUE=43;
	public static final int DELETE=44;
	public static final int DESC=45;
	public static final int DIGIT=46;
	public static final int DISABLE=47;
	public static final int DISTINCT=48;
	public static final int DIVIDE=49;
	public static final int DOT=50;
	public static final int DOUBLE=51;
	public static final int DOUBLE_EQ=52;
	public static final int DOUBLE_QUOTE=53;
	public static final int DROP=54;
	public static final int DUPLICATE=55;
	public static final int ELSE=56;
	public static final int END=57;
	public static final int EOL=58;
	public static final int EQ=59;
	public static final int EXECUTE=60;
	public static final int EXISTS=61;
	public static final int EXPLAIN=62;
	public static final int Exponent=63;
	public static final int FALSE=64;
	public static final int FETCH=65;
	public static final int FIELDCHAR=66;
	public static final int FIRST=67;
	public static final int FOR=68;
	public static final int FROM=69;
	public static final int FULL=70;
	public static final int FUNCTION=71;
	public static final int GRANT=72;
	public static final int GROUP=73;
	public static final int GT=74;
	public static final int HAVING=75;
	public static final int HINT_START=76;
	public static final int IF=77;
	public static final int IGNORE=78;
	public static final int ILIKE=79;
	public static final int IMMUTABLE=80;
	public static final int IN=81;
	public static final int INCLUDE=82;
	public static final int INCREMENT=83;
	public static final int INDEX=84;
	public static final int INNER=85;
	public static final int INTO=86;
	public static final int IS=87;
	public static final int JAR=88;
	public static final int JARS=89;
	public static final int JOIN=90;
	public static final int KEY=91;
	public static final int LAST=92;
	public static final int LCURLY=93;
	public static final int LEFT=94;
	public static final int LETTER=95;
	public static final int LIKE=96;
	public static final int LIMIT=97;
	public static final int LIST=98;
	public static final int LOCAL=99;
	public static final int LPAREN=100;
	public static final int LSQUARE=101;
	public static final int LT=102;
	public static final int MAXVALUE=103;
	public static final int MINUS=104;
	public static final int MINVALUE=105;
	public static final int ML_COMMENT=106;
	public static final int ML_HINT=107;
	public static final int NAME=108;
	public static final int NEXT=109;
	public static final int NOEQ1=110;
	public static final int NOEQ2=111;
	public static final int NOT=112;
	public static final int NULL=113;
	public static final int NULLS=114;
	public static final int NUMBER=115;
	public static final int OFF=116;
	public static final int OFFSET=117;
	public static final int ON=118;
	public static final int ONLY=119;
	public static final int OPEN=120;
	public static final int OR=121;
	public static final int ORDER=122;
	public static final int OTHER=123;
	public static final int OUTER=124;
	public static final int OUTER_JOIN=125;
	public static final int PERCENT=126;
	public static final int PLUS=127;
	public static final int POSINTEGER=128;
	public static final int PRIMARY=129;
	public static final int QUESTION=130;
	public static final int RCURLY=131;
	public static final int REBUILD=132;
	public static final int REPLACE=133;
	public static final int RETURNS=134;
	public static final int REVOKE=135;
	public static final int RIGHT=136;
	public static final int ROW=137;
	public static final int ROWS=138;
	public static final int ROW_TIMESTAMP=139;
	public static final int RPAREN=140;
	public static final int RSQUARE=141;
	public static final int SAMPLING=142;
	public static final int SCHEMA=143;
	public static final int SCHEMAS=144;
	public static final int SELECT=145;
	public static final int SEMICOLON=146;
	public static final int SEQUENCE=147;
	public static final int SESSION=148;
	public static final int SET=149;
	public static final int SHOW=150;
	public static final int SL_COMMENT=151;
	public static final int SL_COMMENT1=152;
	public static final int SL_COMMENT2=153;
	public static final int SOME=154;
	public static final int SPLIT=155;
	public static final int START=156;
	public static final int STATISTICS=157;
	public static final int STRING_LITERAL=158;
	public static final int TABLE=159;
	public static final int TABLES=160;
	public static final int TABLESAMPLE=161;
	public static final int TEMPORARY=162;
	public static final int THEN=163;
	public static final int TILDE=164;
	public static final int TO=165;
	public static final int TRACE=166;
	public static final int TRUE=167;
	public static final int UNION=168;
	public static final int UNUSABLE=169;
	public static final int UPDATE=170;
	public static final int UPGRADE=171;
	public static final int UPSERT=172;
	public static final int USABLE=173;
	public static final int USE=174;
	public static final int USING=175;
	public static final int VALUE=176;
	public static final int VALUES=177;
	public static final int VIEW=178;
	public static final int WHEN=179;
	public static final int WHERE=180;
	public static final int WITH=181;
	public static final int WITHIN=182;
	public static final int WS=183;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }
	    
	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:385:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:386:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==GRANT||LA1_0==LIST||LA1_0==OPEN||LA1_0==REVOKE||LA1_0==SELECT||LA1_0==SHOW||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:386:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1295);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1299); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:393:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1308); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:397:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:398:5: (s= oneStatement EOF )
			// PhoenixSQL.g:398:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1334);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1338); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:408:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:409:5: (s= select_node EOF )
			// PhoenixSQL.g:409:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1364);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1366); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:413:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:415:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:415:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:415:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=33;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=23;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case SEQUENCE:
					{
					alt2=25;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=19;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=8;
				}
				break;
			case CLOSE:
				{
				alt2=9;
				}
				break;
			case FETCH:
				{
				alt2=10;
				}
				break;
			case DECLARE:
				{
				alt2=11;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=13;
					}
					break;
				case FUNCTION:
					{
					alt2=20;
					}
					break;
				case SEQUENCE:
					{
					alt2=28;
					}
					break;
				case SCHEMA:
					{
					alt2=29;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=12;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case SESSION:
					{
					alt2=24;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=15;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case SHOW:
				{
				int LA2_11 = input.LA(2);
				if ( (LA2_11==SCHEMAS||LA2_11==TABLES) ) {
					alt2=16;
				}
				else if ( (LA2_11==CREATE) ) {
					alt2=17;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TRACE:
				{
				alt2=18;
				}
				break;
			case ADD:
				{
				alt2=21;
				}
				break;
			case LIST:
				{
				alt2=22;
				}
				break;
			case GRANT:
				{
				alt2=26;
				}
				break;
			case REVOKE:
				{
				alt2=27;
				}
				break;
			case USE:
				{
				alt2=30;
				}
				break;
			case UPDATE:
				{
				alt2=31;
				}
				break;
			case EXECUTE:
				{
				alt2=32;
				}
				break;
			case EXPLAIN:
				{
				alt2=33;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:415:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1398);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:416:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1408);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:417:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1420);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:418:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1432);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:419:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1444);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:420:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1456);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:421:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1468);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:422:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1480);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:423:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1492);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:424:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1504);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:425:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1516);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:426:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1528);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:427:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1540);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:428:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1552);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:429:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1564);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:430:9: s= show_node
					{
					pushFollow(FOLLOW_show_node_in_oneStatement1576);
					s=show_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:431:9: s= show_create_table_node
					{
					pushFollow(FOLLOW_show_create_table_node_in_oneStatement1588);
					s=show_create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:432:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1600);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:433:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1612);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:434:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1624);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:435:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1636);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:436:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1648);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:437:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1660);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:438:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1672);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:439:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1682);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:440:9: s= grant_permission_node
					{
					pushFollow(FOLLOW_grant_permission_node_in_oneStatement1694);
					s=grant_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:441:9: s= revoke_permission_node
					{
					pushFollow(FOLLOW_revoke_permission_node_in_oneStatement1706);
					s=revoke_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:442:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1716);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:443:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1726);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 30 :
					// PhoenixSQL.g:444:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1736);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 31 :
					// PhoenixSQL.g:445:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1748);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 32 :
					// PhoenixSQL.g:446:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1760);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 33 :
					// PhoenixSQL.g:447:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1772);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:451:1: explain_node returns [BindableStatement ret] : EXPLAIN q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement q =null;

		try {
			// PhoenixSQL.g:452:5: ( EXPLAIN q= oneStatement )
			// PhoenixSQL.g:452:9: EXPLAIN q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1805); if (state.failed) return ret;
			pushFollow(FOLLOW_oneStatement_in_explain_node1809);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =factory.explain(q);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:456:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;

		try {
			// PhoenixSQL.g:457:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? )
			// PhoenixSQL.g:457:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1835); if (state.failed) return ret;
			// PhoenixSQL.g:457:16: (im= IMMUTABLE )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==IMMUTABLE) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:457:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1840); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node1844); if (state.failed) return ret;
			// PhoenixSQL.g:457:38: ( IF NOT ex= EXISTS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==IF) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:457:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node1847); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node1849); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node1853); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node1859);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:458:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:458:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node1871); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node1875);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:458:31: (pk= pk_constraint )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==COMMA||LA5_0==CONSTRAINT) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:458:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node1880);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node1884); if (state.failed) return ret;
			}

			// PhoenixSQL.g:459:9: (p= fam_properties )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==NAME) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:459:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node1898);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:460:9: ( SPLIT ON s= value_expression_list )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==SPLIT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:460:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node1911); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node1913); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node1917);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:465:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:466:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier )
			// PhoenixSQL.g:466:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node1956); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node1958); if (state.failed) return ret;
			// PhoenixSQL.g:466:23: ( IF NOT ex= EXISTS )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==IF) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:466:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node1961); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node1963); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node1967); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_create_schema_node1973);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "grant_permission_node"
	// PhoenixSQL.g:471:1: grant_permission_node returns [ChangePermsStatement ret] : GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal ;
	public final ChangePermsStatement grant_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:472:5: ( GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal )
			// PhoenixSQL.g:472:9: GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal
			{
			match(input,GRANT,FOLLOW_GRANT_in_grant_permission_node2007); if (state.failed) return ret;
			pushFollow(FOLLOW_literal_in_grant_permission_node2011);
			p=literal();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:472:25: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==ON) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// PhoenixSQL.g:472:26: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_grant_permission_node2014); if (state.failed) return ret;
					// PhoenixSQL.g:472:29: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt10=2;
					int LA10_0 = input.LA(1);
					if ( (LA10_0==NAME||LA10_0==TABLE) ) {
						alt10=1;
					}
					else if ( (LA10_0==SCHEMA) ) {
						alt10=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 10, 0, input);
						throw nvae;
					}

					switch (alt10) {
						case 1 :
							// PhoenixSQL.g:472:30: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:472:30: ( TABLE )?
							int alt9=2;
							int LA9_0 = input.LA(1);
							if ( (LA9_0==TABLE) ) {
								alt9=1;
							}
							switch (alt9) {
								case 1 :
									// PhoenixSQL.g:472:31: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_grant_permission_node2018); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_grant_permission_node2024);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:472:58: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_grant_permission_node2030); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_grant_permission_node2034);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,TO,FOLLOW_TO_in_grant_permission_node2039); if (state.failed) return ret;
			// PhoenixSQL.g:472:91: (g= GROUP )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==GROUP) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:472:92: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_grant_permission_node2044); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_grant_permission_node2050);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.TRUE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "grant_permission_node"



	// $ANTLR start "revoke_permission_node"
	// PhoenixSQL.g:483:1: revoke_permission_node returns [ChangePermsStatement ret] : REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal ;
	public final ChangePermsStatement revoke_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:484:5: ( REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal )
			// PhoenixSQL.g:484:9: REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal
			{
			match(input,REVOKE,FOLLOW_REVOKE_in_revoke_permission_node2084); if (state.failed) return ret;
			// PhoenixSQL.g:484:16: (p= literal )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==DECIMAL||LA13_0==DOUBLE||LA13_0==FALSE||LA13_0==NAME||LA13_0==NULL||LA13_0==NUMBER||LA13_0==STRING_LITERAL||LA13_0==TRUE) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// PhoenixSQL.g:484:17: p= literal
					{
					pushFollow(FOLLOW_literal_in_revoke_permission_node2089);
					p=literal();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:484:29: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==ON) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// PhoenixSQL.g:484:30: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_revoke_permission_node2094); if (state.failed) return ret;
					// PhoenixSQL.g:484:33: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt15=2;
					int LA15_0 = input.LA(1);
					if ( (LA15_0==NAME||LA15_0==TABLE) ) {
						alt15=1;
					}
					else if ( (LA15_0==SCHEMA) ) {
						alt15=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 15, 0, input);
						throw nvae;
					}

					switch (alt15) {
						case 1 :
							// PhoenixSQL.g:484:34: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:484:34: ( TABLE )?
							int alt14=2;
							int LA14_0 = input.LA(1);
							if ( (LA14_0==TABLE) ) {
								alt14=1;
							}
							switch (alt14) {
								case 1 :
									// PhoenixSQL.g:484:35: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_revoke_permission_node2098); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_revoke_permission_node2104);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:484:62: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_revoke_permission_node2110); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_revoke_permission_node2114);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_revoke_permission_node2119); if (state.failed) return ret;
			// PhoenixSQL.g:484:97: (g= GROUP )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==GROUP) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:484:98: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_revoke_permission_node2124); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_revoke_permission_node2130);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.FALSE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "revoke_permission_node"



	// $ANTLR start "show_node"
	// PhoenixSQL.g:495:1: show_node returns [ShowStatement ret] : ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? );
	public final ShowStatement show_node() throws RecognitionException {
		ShowStatement ret = null;


		String schema =null;
		String pattern =null;

		try {
			// PhoenixSQL.g:496:5: ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? )
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==SHOW) ) {
				int LA21_1 = input.LA(2);
				if ( (LA21_1==TABLES) ) {
					alt21=1;
				}
				else if ( (LA21_1==SCHEMAS) ) {
					alt21=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 21, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// PhoenixSQL.g:496:9: SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2164); if (state.failed) return ret;
					match(input,TABLES,FOLLOW_TABLES_in_show_node2166); if (state.failed) return ret;
					// PhoenixSQL.g:496:21: ( IN schema= identifier )?
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==IN) ) {
						alt18=1;
					}
					switch (alt18) {
						case 1 :
							// PhoenixSQL.g:496:22: IN schema= identifier
							{
							match(input,IN,FOLLOW_IN_in_show_node2169); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_show_node2173);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:496:45: ( LIKE pattern= string_literal )?
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==LIKE) ) {
						alt19=1;
					}
					switch (alt19) {
						case 1 :
							// PhoenixSQL.g:496:46: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2178); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2182);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showTablesStatement(schema, pattern); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:497:9: SHOW SCHEMAS ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2196); if (state.failed) return ret;
					match(input,SCHEMAS,FOLLOW_SCHEMAS_in_show_node2198); if (state.failed) return ret;
					// PhoenixSQL.g:497:22: ( LIKE pattern= string_literal )?
					int alt20=2;
					int LA20_0 = input.LA(1);
					if ( (LA20_0==LIKE) ) {
						alt20=1;
					}
					switch (alt20) {
						case 1 :
							// PhoenixSQL.g:497:23: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2201); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2205);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showSchemasStatement(pattern); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_node"



	// $ANTLR start "show_create_table_node"
	// PhoenixSQL.g:501:1: show_create_table_node returns [ShowCreateTable ret] : SHOW CREATE TABLE tablename= from_table_name ;
	public final ShowCreateTable show_create_table_node() throws RecognitionException {
		ShowCreateTable ret = null;


		TableName tablename =null;

		try {
			// PhoenixSQL.g:502:5: ( SHOW CREATE TABLE tablename= from_table_name )
			// PhoenixSQL.g:502:9: SHOW CREATE TABLE tablename= from_table_name
			{
			match(input,SHOW,FOLLOW_SHOW_in_show_create_table_node2233); if (state.failed) return ret;
			match(input,CREATE,FOLLOW_CREATE_in_show_create_table_node2235); if (state.failed) return ret;
			match(input,TABLE,FOLLOW_TABLE_in_show_create_table_node2237); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_show_create_table_node2241);
			tablename=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.showCreateTable(tablename); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_create_table_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:506:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:507:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:507:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node2267); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node2269); if (state.failed) return ret;
			// PhoenixSQL.g:507:21: ( IF NOT ex= EXISTS )?
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==IF) ) {
				alt22=1;
			}
			switch (alt22) {
				case 1 :
					// PhoenixSQL.g:507:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node2272); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node2274); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node2278); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node2284);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:508:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==LPAREN) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// PhoenixSQL.g:508:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node2296); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node2300);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:508:31: (pk= pk_constraint )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==COMMA||LA23_0==CONSTRAINT) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// PhoenixSQL.g:508:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node2305);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node2309); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:509:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==AS) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PhoenixSQL.g:509:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node2323); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node2325); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node2327); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node2339); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node2343);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:511:11: ( WHERE w= expression )?
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==WHERE) ) {
						alt25=1;
					}
					switch (alt25) {
						case 1 :
							// PhoenixSQL.g:511:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node2356); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node2360);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:512:9: (p= fam_properties )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==NAME) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// PhoenixSQL.g:512:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2378);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:517:1: create_index_node returns [CreateIndexStatement ret] : CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token l=null;
		Token ex=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:518:5: ( CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:518:9: CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2414); if (state.failed) return ret;
			// PhoenixSQL.g:518:17: (l= LOCAL )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==LOCAL) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:518:17: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2418); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2421); if (state.failed) return ret;
			// PhoenixSQL.g:518:31: ( IF NOT ex= EXISTS )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==IF) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// PhoenixSQL.g:518:32: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2424); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2426); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2430); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2436);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2438); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2442);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:519:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:519:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2453); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2457);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2459); if (state.failed) return ret;
			}

			// PhoenixSQL.g:520:9: ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==INCLUDE) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:520:10: INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2471); if (state.failed) return ret;
					// PhoenixSQL.g:520:18: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:520:19: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2474); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2478);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2480); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:521:9: (async= ASYNC )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==ASYNC) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:521:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2496); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:522:9: (p= fam_properties )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==NAME) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:522:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2511);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:523:9: ( SPLIT ON v= value_expression_list )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==SPLIT) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:523:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2524); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2526); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2530);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null, l==null ? IndexType.getDefault() : IndexType.LOCAL, async != null, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:528:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:529:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:529:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2566); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2568); if (state.failed) return ret;
			// PhoenixSQL.g:529:26: ( IF NOT ex= EXISTS )?
			int alt34=2;
			int LA34_0 = input.LA(1);
			if ( (LA34_0==IF) ) {
				alt34=1;
			}
			switch (alt34) {
				case 1 :
					// PhoenixSQL.g:529:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node2572); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node2574); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node2578); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node2584);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:530:9: ( START ( WITH )? s= value_expression )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==START) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// PhoenixSQL.g:530:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node2595); if (state.failed) return ret;
					// PhoenixSQL.g:530:16: ( WITH )?
					int alt35=2;
					int LA35_0 = input.LA(1);
					if ( (LA35_0==WITH) ) {
						alt35=1;
					}
					switch (alt35) {
						case 1 :
							// PhoenixSQL.g:530:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node2597); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2602);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:531:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==INCREMENT) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// PhoenixSQL.g:531:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node2615); if (state.failed) return ret;
					// PhoenixSQL.g:531:20: ( BY )?
					int alt37=2;
					int LA37_0 = input.LA(1);
					if ( (LA37_0==BY) ) {
						alt37=1;
					}
					switch (alt37) {
						case 1 :
							// PhoenixSQL.g:531:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node2617); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2622);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:532:9: ( MINVALUE min= value_expression )?
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==MINVALUE) ) {
				alt39=1;
			}
			switch (alt39) {
				case 1 :
					// PhoenixSQL.g:532:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node2635); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2639);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:533:9: ( MAXVALUE max= value_expression )?
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==MAXVALUE) ) {
				alt40=1;
			}
			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:533:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node2652); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2656);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:534:9: (cyc= CYCLE )?
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==CYCLE) ) {
				alt41=1;
			}
			switch (alt41) {
				case 1 :
					// PhoenixSQL.g:534:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node2671); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:535:9: ( CACHE c= int_literal_or_bind )?
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==CACHE) ) {
				alt42=1;
			}
			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:535:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node2685); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node2689);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:539:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:540:5: (n= int_or_long_literal |b= bind_expression )
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==NUMBER) ) {
				alt43=1;
			}
			else if ( (LA43_0==BIND_NAME||LA43_0==QUESTION) ) {
				alt43=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 43, 0, input);
				throw nvae;
			}

			switch (alt43) {
				case 1 :
					// PhoenixSQL.g:540:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind2720);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:541:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind2732);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "string_literal"
	// PhoenixSQL.g:545:1: string_literal returns [String ret] : s= STRING_LITERAL ;
	public final String string_literal() throws RecognitionException {
		String ret = null;


		Token s=null;

		try {
			// PhoenixSQL.g:546:5: (s= STRING_LITERAL )
			// PhoenixSQL.g:546:9: s= STRING_LITERAL
			{
			s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_string_literal2760); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = SchemaUtil.normalizeLiteral(factory.literal(s.getText())); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "string_literal"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:550:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:551:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:551:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node2786); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node2788); if (state.failed) return ret;
			// PhoenixSQL.g:551:24: ( IF ex= EXISTS )?
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==IF) ) {
				alt44=1;
			}
			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:551:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node2792); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node2796); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node2802);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:555:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:556:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:556:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:556:9: ( COMMA )?
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==COMMA) ) {
				alt45=1;
			}
			switch (alt45) {
				case 1 :
					// PhoenixSQL.g:556:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint2831); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint2834); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint2838);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint2840); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint2842); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint2844); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2848);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint2850); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:559:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:561:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:561:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2881);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:561:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop46:
			while (true) {
				int alt46=2;
				int LA46_0 = input.LA(1);
				if ( (LA46_0==COMMA) ) {
					alt46=1;
				}

				switch (alt46) {
				case 1 :
					// PhoenixSQL.g:561:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2887); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2893);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop46;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:564:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:565:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:565:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2920);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:565:22: (order= ASC |order= DESC )?
			int alt47=3;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==ASC) ) {
				alt47=1;
			}
			else if ( (LA47_0==DESC) ) {
				alt47=2;
			}
			switch (alt47) {
				case 1 :
					// PhoenixSQL.g:565:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2925); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:565:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2929); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:565:46: (rr= ROW_TIMESTAMP )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==ROW_TIMESTAMP) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:565:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2936); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:569:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:570:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:570:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint2971);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:573:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:575:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:575:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2998);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:575:54: ( COMMA p= expression_with_sort_order )*
			loop49:
			while (true) {
				int alt49=2;
				int LA49_0 = input.LA(1);
				if ( (LA49_0==COMMA) ) {
					alt49=1;
				}

				switch (alt49) {
				case 1 :
					// PhoenixSQL.g:575:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list3004); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3010);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop49;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:578:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:579:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:579:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:579:9: (x= expression )
			// PhoenixSQL.g:579:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order3037);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:579:24: (order= ASC |order= DESC )?
			int alt50=3;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==ASC) ) {
				alt50=1;
			}
			else if ( (LA50_0==DESC) ) {
				alt50=2;
			}
			switch (alt50) {
				case 1 :
					// PhoenixSQL.g:579:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order3043); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:579:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order3047); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:582:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:584:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:584:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties3075);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties3077); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties3081);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:584:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop51:
			while (true) {
				int alt51=2;
				int LA51_0 = input.LA(1);
				if ( (LA51_0==COMMA) ) {
					alt51=1;
				}

				switch (alt51) {
				case 1 :
					// PhoenixSQL.g:584:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties3087); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties3091);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties3093); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties3097);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop51;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:587:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:588:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==NAME) ) {
				int LA52_1 = input.LA(2);
				if ( (LA52_1==EQ) ) {
					alt52=1;
				}
				else if ( (LA52_1==DOT) ) {
					alt52=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 52, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 52, 0, input);
				throw nvae;
			}

			switch (alt52) {
				case 1 :
					// PhoenixSQL.g:588:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3127);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:589:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3141);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name3143); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name3147);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:592:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:593:5: (v= identifier |l= literal )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==NAME) ) {
				int LA53_1 = input.LA(2);
				if ( (LA53_1==EOF||LA53_1==CASCADE||LA53_1==COMMA||LA53_1==SEMICOLON||LA53_1==SPLIT) ) {
					alt53=1;
				}
				else if ( (LA53_1==STRING_LITERAL) ) {
					alt53=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 53, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA53_0==DECIMAL||LA53_0==DOUBLE||LA53_0==FALSE||LA53_0==NULL||LA53_0==NUMBER||LA53_0==STRING_LITERAL||LA53_0==TRUE) ) {
				alt53=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:593:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value3178);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:594:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value3192);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:597:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:598:5: (field= identifier |family= identifier DOT field= identifier )
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==NAME) ) {
				int LA54_1 = input.LA(2);
				if ( (LA54_1==EOF||LA54_1==COMMA||LA54_1==EQ||LA54_1==NAME||LA54_1==RPAREN||LA54_1==SEMICOLON) ) {
					alt54=1;
				}
				else if ( (LA54_1==DOT) ) {
					alt54=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 54, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}

			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:598:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3223);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:599:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3237);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name3239); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name3243);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:602:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:604:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:604:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names3275);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:604:40: ( COMMA v= column_name )*
			loop55:
			while (true) {
				int alt55=2;
				int LA55_0 = input.LA(1);
				if ( (LA55_0==COMMA) ) {
					alt55=1;
				}

				switch (alt55) {
				case 1 :
					// PhoenixSQL.g:604:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names3281); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names3287);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop55;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:609:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:610:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:610:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node3314); if (state.failed) return ret;
			// PhoenixSQL.g:610:14: (v= VIEW | TABLE )
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==VIEW) ) {
				alt56=1;
			}
			else if ( (LA56_0==TABLE) ) {
				alt56=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 56, 0, input);
				throw nvae;
			}

			switch (alt56) {
				case 1 :
					// PhoenixSQL.g:610:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node3319); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:610:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node3323); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:610:31: ( IF ex= EXISTS )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==IF) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// PhoenixSQL.g:610:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node3327); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node3331); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node3337);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:610:65: (c= CASCADE )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==CASCADE) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:610:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node3342); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:614:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:615:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:615:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node3377); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node3379); if (state.failed) return ret;
			// PhoenixSQL.g:615:21: ( IF ex= EXISTS )?
			int alt59=2;
			int LA59_0 = input.LA(1);
			if ( (LA59_0==IF) ) {
				alt59=1;
			}
			switch (alt59) {
				case 1 :
					// PhoenixSQL.g:615:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node3382); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node3386); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3392);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:615:50: (c= CASCADE )?
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==CASCADE) ) {
				alt60=1;
			}
			switch (alt60) {
				case 1 :
					// PhoenixSQL.g:615:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3397); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:621:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:622:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:622:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3432); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3434); if (state.failed) return ret;
			// PhoenixSQL.g:622:18: ( IF ex= EXISTS )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==IF) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// PhoenixSQL.g:622:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3437); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3441); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3447);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3449); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3453);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:627:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token isRebuildAll=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:628:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) )
			// PhoenixSQL.g:628:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3483); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3485); if (state.failed) return ret;
			// PhoenixSQL.g:628:19: ( IF ex= EXISTS )?
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==IF) ) {
				alt62=1;
			}
			switch (alt62) {
				case 1 :
					// PhoenixSQL.g:628:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3488); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3492); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3498);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3500); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3504);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:629:7: ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			// PhoenixSQL.g:629:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )?
			{
			// PhoenixSQL.g:629:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) )
			// PhoenixSQL.g:629:9: s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			{
			// PhoenixSQL.g:629:11: ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			int alt64=5;
			switch ( input.LA(1) ) {
			case USABLE:
				{
				alt64=1;
				}
				break;
			case UNUSABLE:
				{
				alt64=2;
				}
				break;
			case REBUILD:
				{
				alt64=3;
				}
				break;
			case DISABLE:
				{
				alt64=4;
				}
				break;
			case ACTIVE:
				{
				alt64=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}
			switch (alt64) {
				case 1 :
					// PhoenixSQL.g:629:12: USABLE
					{
					s=(Token)match(input,USABLE,FOLLOW_USABLE_in_alter_index_node3517); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:629:21: UNUSABLE
					{
					s=(Token)match(input,UNUSABLE,FOLLOW_UNUSABLE_in_alter_index_node3521); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:629:32: REBUILD (isRebuildAll= ALL )?
					{
					s=(Token)match(input,REBUILD,FOLLOW_REBUILD_in_alter_index_node3525); if (state.failed) return ret;
					// PhoenixSQL.g:629:40: (isRebuildAll= ALL )?
					int alt63=2;
					int LA63_0 = input.LA(1);
					if ( (LA63_0==ALL) ) {
						alt63=1;
					}
					switch (alt63) {
						case 1 :
							// PhoenixSQL.g:629:41: isRebuildAll= ALL
							{
							isRebuildAll=(Token)match(input,ALL,FOLLOW_ALL_in_alter_index_node3530); if (state.failed) return ret;
							}
							break;

					}

					}
					break;
				case 4 :
					// PhoenixSQL.g:629:62: DISABLE
					{
					s=(Token)match(input,DISABLE,FOLLOW_DISABLE_in_alter_index_node3536); if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:629:72: ACTIVE
					{
					s=(Token)match(input,ACTIVE,FOLLOW_ACTIVE_in_alter_index_node3540); if (state.failed) return ret;
					}
					break;

			}

			}

			// PhoenixSQL.g:629:81: (async= ASYNC )?
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==ASYNC) ) {
				alt65=1;
			}
			switch (alt65) {
				case 1 :
					// PhoenixSQL.g:629:82: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node3547); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:629:96: ( ( ( SET )? ) p= fam_properties )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==NAME||LA67_0==SET) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// PhoenixSQL.g:629:97: ( ( SET )? ) p= fam_properties
					{
					// PhoenixSQL.g:629:97: ( ( SET )? )
					// PhoenixSQL.g:629:98: ( SET )?
					{
					// PhoenixSQL.g:629:98: ( SET )?
					int alt66=2;
					int LA66_0 = input.LA(1);
					if ( (LA66_0==SET) ) {
						alt66=1;
					}
					switch (alt66) {
						case 1 :
							// PhoenixSQL.g:629:98: SET
							{
							match(input,SET,FOLLOW_SET_in_alter_index_node3553); if (state.failed) return ret;
							}
							break;

					}

					}

					pushFollow(FOLLOW_fam_properties_in_alter_index_node3558);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), isRebuildAll!=null, async!=null, p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:634:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:635:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:635:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node3593); if (state.failed) return ret;
			// PhoenixSQL.g:635:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==ON) ) {
				alt69=1;
			}
			else if ( (LA69_0==OFF) ) {
				alt69=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}

			switch (alt69) {
				case 1 :
					// PhoenixSQL.g:635:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:635:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:635:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node3601); if (state.failed) return ret;
					// PhoenixSQL.g:635:28: ( WITH SAMPLING s= sampling_rate )?
					int alt68=2;
					int LA68_0 = input.LA(1);
					if ( (LA68_0==WITH) ) {
						alt68=1;
					}
					switch (alt68) {
						case 1 :
							// PhoenixSQL.g:635:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node3606); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node3608); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node3614);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:635:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node3625); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:640:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:641:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:641:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node3659); if (state.failed) return ret;
			// PhoenixSQL.g:641:16: ( OR replace= REPLACE )?
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==OR) ) {
				alt70=1;
			}
			switch (alt70) {
				case 1 :
					// PhoenixSQL.g:641:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node3662); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node3666); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:641:38: (temp= TEMPORARY )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==TEMPORARY) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:641:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node3673); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node3677); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3681);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:642:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:642:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node3692); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node3696);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node3698); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node3708); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3712);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node3714); if (state.failed) return ret;
			// PhoenixSQL.g:643:32: (className= jar_path )
			// PhoenixSQL.g:643:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node3720);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:644:8: ( USING JAR (jarPath= jar_path ) )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==USING) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// PhoenixSQL.g:644:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node3731); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node3733); if (state.failed) return ret;
					// PhoenixSQL.g:644:19: (jarPath= jar_path )
					// PhoenixSQL.g:644:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node3740);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:650:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:651:5: (l= literal )
			// PhoenixSQL.g:651:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path3777);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:654:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:655:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:655:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node3800); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node3802); if (state.failed) return ret;
			// PhoenixSQL.g:655:21: ( IF ex= EXISTS )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==IF) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:655:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node3805); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node3809); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node3815);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:658:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:659:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:659:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node3838); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node3840); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node3846);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:662:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:663:5: ( LIST JARS )
			// PhoenixSQL.g:663:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node3869); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node3871); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:666:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:667:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:667:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node3894); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node3896); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node3902);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:671:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:672:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:672:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node3928); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node3930); if (state.failed) return ret;
			// PhoenixSQL.g:672:23: ( SET p= properties )
			// PhoenixSQL.g:672:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node3933); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node3937);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:677:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token cas=null;
		Token all=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> d =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<NamedNode> list =null;

		try {
			// PhoenixSQL.g:678:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) )
			// PhoenixSQL.g:678:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node3971); if (state.failed) return ret;
			// PhoenixSQL.g:678:15: ( TABLE |v= VIEW )
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==TABLE) ) {
				alt74=1;
			}
			else if ( (LA74_0==VIEW) ) {
				alt74=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 74, 0, input);
				throw nvae;
			}

			switch (alt74) {
				case 1 :
					// PhoenixSQL.g:678:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node3974); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:678:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node3980); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node3985);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:679:9: ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			int alt80=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt80=1;
				}
				break;
			case ADD:
				{
				alt80=2;
				}
				break;
			case SET:
				{
				alt80=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 80, 0, input);
				throw nvae;
			}
			switch (alt80) {
				case 1 :
					// PhoenixSQL.g:679:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					{
					// PhoenixSQL.g:679:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					// PhoenixSQL.g:679:12: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node3998); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node4000); if (state.failed) return ret;
					// PhoenixSQL.g:679:24: ( IF ex= EXISTS )?
					int alt75=2;
					int LA75_0 = input.LA(1);
					if ( (LA75_0==IF) ) {
						alt75=1;
					}
					switch (alt75) {
						case 1 :
							// PhoenixSQL.g:679:25: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node4003); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node4007); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node4013);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:679:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					{
					// PhoenixSQL.g:679:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					// PhoenixSQL.g:679:59: ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )?
					{
					match(input,ADD,FOLLOW_ADD_in_alter_table_node4019); if (state.failed) return ret;
					// PhoenixSQL.g:679:63: ( IF NOT ex= EXISTS )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==IF) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// PhoenixSQL.g:679:64: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node4022); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node4024); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node4028); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:679:83: (d= column_defs )
					// PhoenixSQL.g:679:84: d= column_defs
					{
					pushFollow(FOLLOW_column_defs_in_alter_table_node4035);
					d=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					}

					// PhoenixSQL.g:679:99: (p= fam_properties )?
					int alt77=2;
					int LA77_0 = input.LA(1);
					if ( (LA77_0==NAME) ) {
						alt77=1;
					}
					switch (alt77) {
						case 1 :
							// PhoenixSQL.g:679:100: p= fam_properties
							{
							pushFollow(FOLLOW_fam_properties_in_alter_table_node4041);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					// PhoenixSQL.g:679:120: (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					int alt79=2;
					int LA79_0 = input.LA(1);
					if ( (LA79_0==CASCADE) ) {
						alt79=1;
					}
					switch (alt79) {
						case 1 :
							// PhoenixSQL.g:679:121: cas= CASCADE INDEX (list= indexes |all= ALL )
							{
							cas=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_alter_table_node4049); if (state.failed) return ret;
							match(input,INDEX,FOLLOW_INDEX_in_alter_table_node4051); if (state.failed) return ret;
							// PhoenixSQL.g:679:139: (list= indexes |all= ALL )
							int alt78=2;
							int LA78_0 = input.LA(1);
							if ( (LA78_0==NAME) ) {
								alt78=1;
							}
							else if ( (LA78_0==ALL) ) {
								alt78=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 78, 0, input);
								throw nvae;
							}

							switch (alt78) {
								case 1 :
									// PhoenixSQL.g:679:140: list= indexes
									{
									pushFollow(FOLLOW_indexes_in_alter_table_node4056);
									list=indexes();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:679:155: all= ALL
									{
									all=(Token)match(input,ALL,FOLLOW_ALL_in_alter_table_node4062); if (state.failed) return ret;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 3 :
					// PhoenixSQL.g:679:168: ( SET (p= fam_properties ) )
					{
					// PhoenixSQL.g:679:168: ( SET (p= fam_properties ) )
					// PhoenixSQL.g:679:169: SET (p= fam_properties )
					{
					match(input,SET,FOLLOW_SET_in_alter_table_node4070); if (state.failed) return ret;
					// PhoenixSQL.g:679:173: (p= fam_properties )
					// PhoenixSQL.g:679:174: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_alter_table_node4075);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { PTableType tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW; ret = ( c == null ? factory.addColumn(factory.namedTable(null,t), tt, d, ex!=null, p, cas!=null, (all == null ? list : null)) : factory.dropColumn(factory.namedTable(null,t), tt, c, ex!=null) ); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:683:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:684:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:684:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node4109); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node4111); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node4115);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:684:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt81=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt81=1;
					}
					break;
				case ALL:
					{
					alt81=2;
					}
					break;
				case COLUMNS:
					{
					alt81=3;
					}
					break;
			}
			switch (alt81) {
				case 1 :
					// PhoenixSQL.g:684:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node4120); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:684:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node4126); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:684:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node4132); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:684:73: ( SET (p= properties ) )?
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==SET) ) {
				alt82=1;
			}
			switch (alt82) {
				case 1 :
					// PhoenixSQL.g:684:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node4137); if (state.failed) return ret;
					// PhoenixSQL.g:684:78: (p= properties )
					// PhoenixSQL.g:684:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node4142);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:688:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:689:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:689:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node4166); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node4168); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:693:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:694:5: (p= identifier )
			// PhoenixSQL.g:694:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name4194);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:697:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:699:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:699:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties4228);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties4230); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties4234);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:699:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop83:
			while (true) {
				int alt83=2;
				int LA83_0 = input.LA(1);
				if ( (LA83_0==COMMA) ) {
					alt83=1;
				}

				switch (alt83) {
				case 1 :
					// PhoenixSQL.g:699:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties4240); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties4244);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties4246); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties4250);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop83;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:702:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:704:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:704:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs4285);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:704:39: ( COMMA v= column_def )*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==COMMA) ) {
					int LA84_1 = input.LA(2);
					if ( (LA84_1==NAME) ) {
						alt84=1;
					}

				}

				switch (alt84) {
				case 1 :
					// PhoenixSQL.g:704:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs4291); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs4297);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop84;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "indexes"
	// PhoenixSQL.g:707:1: indexes returns [List<NamedNode> ret] : v= index_name ( COMMA v= index_name )* ;
	public final List<NamedNode> indexes() throws RecognitionException {
		List<NamedNode> ret = null;


		NamedNode v =null;

		ret = new ArrayList<NamedNode>(); 
		try {
			// PhoenixSQL.g:709:5: (v= index_name ( COMMA v= index_name )* )
			// PhoenixSQL.g:709:8: v= index_name ( COMMA v= index_name )*
			{
			pushFollow(FOLLOW_index_name_in_indexes4328);
			v=index_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:709:39: ( COMMA v= index_name )*
			loop85:
			while (true) {
				int alt85=2;
				int LA85_0 = input.LA(1);
				if ( (LA85_0==COMMA) ) {
					alt85=1;
				}

				switch (alt85) {
				case 1 :
					// PhoenixSQL.g:709:40: COMMA v= index_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_indexes4334); if (state.failed) return ret;
					pushFollow(FOLLOW_index_name_in_indexes4340);
					v=index_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop85;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "indexes"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:712:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:713:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? )
			// PhoenixSQL.g:713:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			{
			pushFollow(FOLLOW_column_name_in_column_def4366);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def4370);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:713:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==LPAREN) ) {
				alt87=1;
			}
			switch (alt87) {
				case 1 :
					// PhoenixSQL.g:713:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def4373); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4377); if (state.failed) return ret;
					// PhoenixSQL.g:713:54: ( COMMA s= NUMBER )?
					int alt86=2;
					int LA86_0 = input.LA(1);
					if ( (LA86_0==COMMA) ) {
						alt86=1;
					}
					switch (alt86) {
						case 1 :
							// PhoenixSQL.g:713:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def4380); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4384); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def4388); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:713:83: (ar= ARRAY )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==ARRAY) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// PhoenixSQL.g:713:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def4394); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:713:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==LSQUARE) ) {
				alt90=1;
			}
			switch (alt90) {
				case 1 :
					// PhoenixSQL.g:713:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def4400); if (state.failed) return ret;
					// PhoenixSQL.g:713:104: (a= NUMBER )?
					int alt89=2;
					int LA89_0 = input.LA(1);
					if ( (LA89_0==NUMBER) ) {
						alt89=1;
					}
					switch (alt89) {
						case 1 :
							// PhoenixSQL.g:713:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4405); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def4409); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:713:126: ( (nn= NOT )? n= NULL )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( ((LA92_0 >= NOT && LA92_0 <= NULL)) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// PhoenixSQL.g:713:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:713:129: (nn= NOT )?
					int alt91=2;
					int LA91_0 = input.LA(1);
					if ( (LA91_0==NOT) ) {
						alt91=1;
					}
					switch (alt91) {
						case 1 :
							// PhoenixSQL.g:713:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def4416); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def4421); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:713:144: ( DEFAULT df= expression )?
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==DEFAULT) ) {
				alt93=1;
			}
			switch (alt93) {
				case 1 :
					// PhoenixSQL.g:713:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def4426); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def4430);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:713:169: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==PRIMARY) ) {
				alt96=1;
			}
			switch (alt96) {
				case 1 :
					// PhoenixSQL.g:713:170: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def4437); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def4439); if (state.failed) return ret;
					// PhoenixSQL.g:713:185: (order= ASC |order= DESC )?
					int alt94=3;
					int LA94_0 = input.LA(1);
					if ( (LA94_0==ASC) ) {
						alt94=1;
					}
					else if ( (LA94_0==DESC) ) {
						alt94=2;
					}
					switch (alt94) {
						case 1 :
							// PhoenixSQL.g:713:186: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def4444); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:713:196: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def4448); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:713:211: (rr= ROW_TIMESTAMP )?
					int alt95=2;
					int LA95_0 = input.LA(1);
					if ( (LA95_0==ROW_TIMESTAMP) ) {
						alt95=1;
					}
					switch (alt95) {
						case 1 :
							// PhoenixSQL.g:713:211: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def4454); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null, 
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:723:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:725:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:725:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4497);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:725:43: ( COMMA v= dyn_column_def )*
			loop97:
			while (true) {
				int alt97=2;
				int LA97_0 = input.LA(1);
				if ( (LA97_0==COMMA) ) {
					alt97=1;
				}

				switch (alt97) {
				case 1 :
					// PhoenixSQL.g:725:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs4503); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4509);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop97;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:728:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:729:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:729:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def4535);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def4539);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:729:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==LPAREN) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// PhoenixSQL.g:729:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def4542); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4546); if (state.failed) return ret;
					// PhoenixSQL.g:729:54: ( COMMA s= NUMBER )?
					int alt98=2;
					int LA98_0 = input.LA(1);
					if ( (LA98_0==COMMA) ) {
						alt98=1;
					}
					switch (alt98) {
						case 1 :
							// PhoenixSQL.g:729:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def4549); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4553); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def4557); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:729:83: (ar= ARRAY )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==ARRAY) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:729:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def4563); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:729:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==LSQUARE) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// PhoenixSQL.g:729:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def4569); if (state.failed) return ret;
					// PhoenixSQL.g:729:104: (a= NUMBER )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==NUMBER) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// PhoenixSQL.g:729:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4574); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def4578); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:738:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:739:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:739:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def4615);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:739:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt108=2;
			int LA108_0 = input.LA(1);
			if ( (LA108_0==NAME) ) {
				alt108=1;
			}
			switch (alt108) {
				case 1 :
					// PhoenixSQL.g:739:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def4620);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:739:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt104=2;
					int LA104_0 = input.LA(1);
					if ( (LA104_0==LPAREN) ) {
						alt104=1;
					}
					switch (alt104) {
						case 1 :
							// PhoenixSQL.g:739:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def4623); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4627); if (state.failed) return ret;
							// PhoenixSQL.g:739:55: ( COMMA s= NUMBER )?
							int alt103=2;
							int LA103_0 = input.LA(1);
							if ( (LA103_0==COMMA) ) {
								alt103=1;
							}
							switch (alt103) {
								case 1 :
									// PhoenixSQL.g:739:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def4630); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4634); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def4638); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:739:84: (ar= ARRAY )?
					int alt105=2;
					int LA105_0 = input.LA(1);
					if ( (LA105_0==ARRAY) ) {
						alt105=1;
					}
					switch (alt105) {
						case 1 :
							// PhoenixSQL.g:739:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def4644); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:739:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt107=2;
					int LA107_0 = input.LA(1);
					if ( (LA107_0==LSQUARE) ) {
						alt107=1;
					}
					switch (alt107) {
						case 1 :
							// PhoenixSQL.g:739:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def4650); if (state.failed) return ret;
							// PhoenixSQL.g:739:105: (a= NUMBER )?
							int alt106=2;
							int LA106_0 = input.LA(1);
							if ( (LA106_0==NUMBER) ) {
								alt106=1;
							}
							switch (alt106) {
								case 1 :
									// PhoenixSQL.g:739:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4655); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def4659); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:748:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:749:5: (s= select_node )
			// PhoenixSQL.g:749:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression4699);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:752:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:754:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:754:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select4732); if (state.failed) return ret;
			// PhoenixSQL.g:754:16: (h= hintClause )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==ML_HINT) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// PhoenixSQL.g:754:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select4737);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:755:9: (d= DISTINCT | ALL )?
			int alt110=3;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==DISTINCT) ) {
				alt110=1;
			}
			else if ( (LA110_0==ALL) ) {
				alt110=2;
			}
			switch (alt110) {
				case 1 :
					// PhoenixSQL.g:755:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select4753); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:755:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select4757); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select4763);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:756:9: ( FROM from= parseFrom )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==FROM) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// PhoenixSQL.g:756:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select4774); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select4778);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:757:9: ( WHERE where= expression )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==WHERE) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// PhoenixSQL.g:757:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select4791); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4795);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:758:9: ( GROUP BY group= group_by )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==GROUP) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// PhoenixSQL.g:758:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select4808); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select4810); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select4814);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:759:9: ( HAVING having= expression )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==HAVING) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// PhoenixSQL.g:759:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select4827); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4831);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:764:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:766:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:766:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects4875);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:766:39: ( UNION ALL s= single_select )*
			loop115:
			while (true) {
				int alt115=2;
				int LA115_0 = input.LA(1);
				if ( (LA115_0==UNION) ) {
					alt115=1;
				}

				switch (alt115) {
				case 1 :
					// PhoenixSQL.g:766:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects4880); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects4882); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects4886);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop115;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:770:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:772:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:772:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node4924);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:773:9: ( ORDER BY order= order_by )?
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==ORDER) ) {
				alt116=1;
			}
			switch (alt116) {
				case 1 :
					// PhoenixSQL.g:773:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node4935); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node4937); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node4941);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:774:9: ( LIMIT l= limit )?
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==LIMIT) ) {
				alt117=1;
			}
			switch (alt117) {
				case 1 :
					// PhoenixSQL.g:774:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node4954); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node4958);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:775:9: ( OFFSET o= offset )?
			int alt118=2;
			int LA118_0 = input.LA(1);
			if ( (LA118_0==OFFSET) ) {
				alt118=1;
			}
			switch (alt118) {
				case 1 :
					// PhoenixSQL.g:775:10: OFFSET o= offset
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node4971); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node4975);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:776:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt120=2;
			int LA120_0 = input.LA(1);
			if ( (LA120_0==FETCH) ) {
				alt120=1;
			}
			switch (alt120) {
				case 1 :
					// PhoenixSQL.g:776:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node4988); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:776:31: (l= limit )?
					int alt119=2;
					int LA119_0 = input.LA(1);
					if ( (LA119_0==BIND_NAME||LA119_0==NUMBER||LA119_0==QUESTION) ) {
						alt119=1;
					}
					switch (alt119) {
						case 1 :
							// PhoenixSQL.g:776:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node5001);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node5013); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:782:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:783:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) )
			// PhoenixSQL.g:783:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node5052); if (state.failed) return ret;
			// PhoenixSQL.g:783:16: (hint= hintClause )?
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==ML_HINT) ) {
				alt121=1;
			}
			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:783:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node5057);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node5061); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node5065);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:784:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt122=2;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==LPAREN) ) {
				alt122=1;
			}
			switch (alt122) {
				case 1 :
					// PhoenixSQL.g:784:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5076); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node5080);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5082); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:785:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt125=2;
			int LA125_0 = input.LA(1);
			if ( (LA125_0==VALUES) ) {
				alt125=1;
			}
			else if ( (LA125_0==SELECT) ) {
				alt125=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 125, 0, input);
				throw nvae;
			}

			switch (alt125) {
				case 1 :
					// PhoenixSQL.g:785:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:785:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:785:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node5096); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5098); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node5102);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5104); if (state.failed) return ret;
					// PhoenixSQL.g:785:58: ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					int alt124=2;
					int LA124_0 = input.LA(1);
					if ( (LA124_0==ON) ) {
						alt124=1;
					}
					switch (alt124) {
						case 1 :
							// PhoenixSQL.g:785:60: ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node5108); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node5110); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node5112); if (state.failed) return ret;
							// PhoenixSQL.g:785:77: (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							int alt123=2;
							int LA123_0 = input.LA(1);
							if ( (LA123_0==IGNORE) ) {
								alt123=1;
							}
							else if ( (LA123_0==UPDATE) ) {
								alt123=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 123, 0, input);
								throw nvae;
							}

							switch (alt123) {
								case 1 :
									// PhoenixSQL.g:785:79: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node5118); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:785:91: ( UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:785:91: ( UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:785:93: UPDATE pairs= update_column_pairs
									{
									match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node5124); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node5128);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:785:137: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node5143);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:794:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:796:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:796:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5184);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:797:8: ( COMMA p= update_column_pair )*
			loop126:
			while (true) {
				int alt126=2;
				int LA126_0 = input.LA(1);
				if ( (LA126_0==COMMA) ) {
					alt126=1;
				}

				switch (alt126) {
				case 1 :
					// PhoenixSQL.g:797:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs5196); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5200);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop126;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:800:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:801:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:801:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair5225);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair5227); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair5231);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:805:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:807:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:807:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5260);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:808:8: ( COMMA d= dyn_column_name_or_def )*
			loop127:
			while (true) {
				int alt127=2;
				int LA127_0 = input.LA(1);
				if ( (LA127_0==COMMA) ) {
					alt127=1;
				}

				switch (alt127) {
				case 1 :
					// PhoenixSQL.g:808:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs5273); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5277);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop127;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:813:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:814:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:814:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node5305); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node5309);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node5311); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node5313); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node5317);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:818:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:819:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:819:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node5351); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node5355);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:822:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:823:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:823:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node5382); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node5386);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:826:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:827:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:827:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node5412); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node5414); if (state.failed) return ret;
			// PhoenixSQL.g:827:21: (a= NUMBER )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==NUMBER) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// PhoenixSQL.g:827:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node5419); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:827:33: ( ROW | ROWS )?
			int alt129=2;
			int LA129_0 = input.LA(1);
			if ( ((LA129_0 >= ROW && LA129_0 <= ROWS)) ) {
				alt129=1;
			}
			switch (alt129) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node5430); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node5434);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:831:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:832:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? )
			// PhoenixSQL.g:832:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node5460); if (state.failed) return ret;
			// PhoenixSQL.g:832:16: (hint= hintClause )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==ML_HINT) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// PhoenixSQL.g:832:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node5465);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node5469); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node5473);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:833:9: ( WHERE v= expression )?
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==WHERE) ) {
				alt131=1;
			}
			switch (alt131) {
				case 1 :
					// PhoenixSQL.g:833:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node5484); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node5488);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:834:9: ( ORDER BY order= order_by )?
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==ORDER) ) {
				alt132=1;
			}
			switch (alt132) {
				case 1 :
					// PhoenixSQL.g:834:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node5501); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node5503); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node5507);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:835:9: ( LIMIT l= limit )?
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==LIMIT) ) {
				alt133=1;
			}
			switch (alt133) {
				case 1 :
					// PhoenixSQL.g:835:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node5520); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node5524);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:839:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:840:5: (b= bind_expression |l= int_or_long_literal )
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==BIND_NAME||LA134_0==QUESTION) ) {
				alt134=1;
			}
			else if ( (LA134_0==NUMBER) ) {
				alt134=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 134, 0, input);
				throw nvae;
			}

			switch (alt134) {
				case 1 :
					// PhoenixSQL.g:840:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit5559);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:841:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit5571);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:844:1: offset returns [OffsetNode ret] : (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;
		List<ParseNode> lhs =null;
		List<ParseNode> rhs =null;

		try {
			// PhoenixSQL.g:845:2: (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN )
			int alt137=3;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case QUESTION:
				{
				alt137=1;
				}
				break;
			case NUMBER:
				{
				alt137=2;
				}
				break;
			case LPAREN:
				{
				alt137=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}
			switch (alt137) {
				case 1 :
					// PhoenixSQL.g:845:4: b= bind_expression ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_bind_expression_in_offset5597);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:845:22: ( ROW | ROWS )?
					int alt135=2;
					int LA135_0 = input.LA(1);
					if ( ((LA135_0 >= ROW && LA135_0 <= ROWS)) ) {
						alt135=1;
					}
					switch (alt135) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) {  try { ret = factory.offset(b); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 2 :
					// PhoenixSQL.g:846:7: l= int_or_long_literal ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset5618);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:846:29: ( ROW | ROWS )?
					int alt136=2;
					int LA136_0 = input.LA(1);
					if ( ((LA136_0 >= ROW && LA136_0 <= ROWS)) ) {
						alt136=1;
					}
					switch (alt136) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) { try { ret = factory.offset(l); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 3 :
					// PhoenixSQL.g:847:7: LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_offset5637); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset5641);
					lhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset5643); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_offset5645); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_offset5647); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset5651);
					rhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset5653); if (state.failed) return ret;
					if ( state.backtracking==0 ) { try { ret = factory.offset(factory.comparison(CompareOp.EQUAL,factory.rowValueConstructor(lhs),factory.rowValueConstructor(rhs)));  } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:850:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:851:5: (l= literal )
			// PhoenixSQL.g:851:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate5678);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "tableSampleNode"
	// PhoenixSQL.g:854:1: tableSampleNode returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode tableSampleNode() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:855:5: (l= literal )
			// PhoenixSQL.g:855:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_tableSampleNode5703);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "tableSampleNode"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:858:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:859:5: (c= ML_HINT )
			// PhoenixSQL.g:859:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause5729); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:863:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:865:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt139=2;
			int LA139_0 = input.LA(1);
			if ( (LA139_0==ARRAY||LA139_0==BIND_NAME||(LA139_0 >= CASE && LA139_0 <= CAST)||LA139_0==CURRENT||LA139_0==DECIMAL||LA139_0==DOUBLE||LA139_0==EXISTS||LA139_0==FALSE||LA139_0==LPAREN||LA139_0==MINUS||(LA139_0 >= NAME && LA139_0 <= NEXT)||(LA139_0 >= NOT && LA139_0 <= NULL)||LA139_0==NUMBER||LA139_0==QUESTION||LA139_0==STRING_LITERAL||LA139_0==TRUE) ) {
				alt139=1;
			}
			else if ( (LA139_0==ASTERISK) ) {
				alt139=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}

			switch (alt139) {
				case 1 :
					// PhoenixSQL.g:865:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list5761);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:865:36: ( COMMA n= selectable )*
					loop138:
					while (true) {
						int alt138=2;
						int LA138_0 = input.LA(1);
						if ( (LA138_0==COMMA) ) {
							alt138=1;
						}

						switch (alt138) {
						case 1 :
							// PhoenixSQL.g:865:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list5766); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list5770);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop138;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:866:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list5782); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:870:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:871:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt141=3;
			int LA141_0 = input.LA(1);
			if ( (LA141_0==ARRAY||LA141_0==BIND_NAME||(LA141_0 >= CASE && LA141_0 <= CAST)||LA141_0==CURRENT||LA141_0==DECIMAL||LA141_0==DOUBLE||LA141_0==EXISTS||LA141_0==FALSE||LA141_0==LPAREN||LA141_0==MINUS||LA141_0==NEXT||(LA141_0 >= NOT && LA141_0 <= NULL)||LA141_0==NUMBER||LA141_0==QUESTION||LA141_0==STRING_LITERAL||LA141_0==TRUE) ) {
				alt141=1;
			}
			else if ( (LA141_0==NAME) ) {
				int LA141_2 = input.LA(2);
				if ( (LA141_2==EOF||LA141_2==AND||LA141_2==AS||LA141_2==ASTERISK||LA141_2==BETWEEN||LA141_2==COMMA||LA141_2==CONCAT||LA141_2==DIVIDE||LA141_2==EQ||LA141_2==FETCH||LA141_2==FROM||(LA141_2 >= GROUP && LA141_2 <= HAVING)||LA141_2==ILIKE||LA141_2==IN||LA141_2==IS||(LA141_2 >= LIKE && LA141_2 <= LIMIT)||(LA141_2 >= LPAREN && LA141_2 <= LT)||LA141_2==MINUS||LA141_2==NAME||(LA141_2 >= NOEQ1 && LA141_2 <= NOT)||LA141_2==OFFSET||(LA141_2 >= OR && LA141_2 <= ORDER)||(LA141_2 >= PERCENT && LA141_2 <= PLUS)||LA141_2==RPAREN||LA141_2==SEMICOLON||LA141_2==STRING_LITERAL||LA141_2==UNION||LA141_2==WHERE) ) {
					alt141=1;
				}
				else if ( (LA141_2==DOT) ) {
					int LA141_3 = input.LA(3);
					if ( (LA141_3==ASTERISK) ) {
						alt141=2;
					}
					else if ( (LA141_3==NAME) ) {
						int LA141_5 = input.LA(4);
						if ( (LA141_5==EOF||LA141_5==AND||LA141_5==AS||LA141_5==ASTERISK||LA141_5==BETWEEN||LA141_5==COMMA||LA141_5==CONCAT||LA141_5==DIVIDE||LA141_5==EQ||LA141_5==FETCH||LA141_5==FROM||(LA141_5 >= GROUP && LA141_5 <= HAVING)||LA141_5==ILIKE||LA141_5==IN||LA141_5==IS||(LA141_5 >= LIKE && LA141_5 <= LIMIT)||(LA141_5 >= LSQUARE && LA141_5 <= LT)||LA141_5==MINUS||LA141_5==NAME||(LA141_5 >= NOEQ1 && LA141_5 <= NOT)||LA141_5==OFFSET||(LA141_5 >= OR && LA141_5 <= ORDER)||(LA141_5 >= PERCENT && LA141_5 <= PLUS)||LA141_5==RPAREN||LA141_5==SEMICOLON||LA141_5==UNION||LA141_5==WHERE) ) {
							alt141=1;
						}
						else if ( (LA141_5==DOT) ) {
							int LA141_6 = input.LA(5);
							if ( (LA141_6==ASTERISK) ) {
								alt141=3;
							}
							else if ( (LA141_6==NAME) ) {
								alt141=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 141, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 141, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 141, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 141, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}

			switch (alt141) {
				case 1 :
					// PhoenixSQL.g:871:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable5811);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:871:26: (a= parseAlias )?
					int alt140=2;
					int LA140_0 = input.LA(1);
					if ( (LA140_0==AS||LA140_0==NAME) ) {
						alt140=1;
					}
					switch (alt140) {
						case 1 :
							// PhoenixSQL.g:871:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable5816);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:872:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5831);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5833); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5835); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:873:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5850);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5852); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable5856);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5858); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5860); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:878:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:880:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:880:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by5893);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:881:9: ( COMMA expr= expression )*
			loop142:
			while (true) {
				int alt142=2;
				int LA142_0 = input.LA(1);
				if ( (LA142_0==COMMA) ) {
					alt142=1;
				}

				switch (alt142) {
				case 1 :
					// PhoenixSQL.g:881:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by5906); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by5912);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop142;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:885:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:887:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:887:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by5946);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:888:9: ( COMMA field= parseOrderByField )*
			loop143:
			while (true) {
				int alt143=2;
				int LA143_0 = input.LA(1);
				if ( (LA143_0==COMMA) ) {
					alt143=1;
				}

				switch (alt143) {
				case 1 :
					// PhoenixSQL.g:888:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by5959); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by5965);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop143;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:892:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:894:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:894:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:894:9: (expr= expression )
			// PhoenixSQL.g:894:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField6002);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:895:9: ( ASC | DESC )?
			int alt144=3;
			int LA144_0 = input.LA(1);
			if ( (LA144_0==ASC) ) {
				alt144=1;
			}
			else if ( (LA144_0==DESC) ) {
				alt144=2;
			}
			switch (alt144) {
				case 1 :
					// PhoenixSQL.g:895:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField6014); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:895:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField6020); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:896:9: ( NULLS ( FIRST | LAST ) )?
			int alt146=2;
			int LA146_0 = input.LA(1);
			if ( (LA146_0==NULLS) ) {
				alt146=1;
			}
			switch (alt146) {
				case 1 :
					// PhoenixSQL.g:896:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField6035); if (state.failed) return ret;
					// PhoenixSQL.g:896:16: ( FIRST | LAST )
					int alt145=2;
					int LA145_0 = input.LA(1);
					if ( (LA145_0==FIRST) ) {
						alt145=1;
					}
					else if ( (LA145_0==LAST) ) {
						alt145=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 145, 0, input);
						throw nvae;
					}

					switch (alt145) {
						case 1 :
							// PhoenixSQL.g:896:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField6038); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:896:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField6044); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:900:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:901:5: (t= table_list )
			// PhoenixSQL.g:901:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom6084);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:904:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:905:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:905:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list6115);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:905:33: ( COMMA s= table_ref )*
			loop147:
			while (true) {
				int alt147=2;
				int LA147_0 = input.LA(1);
				if ( (LA147_0==COMMA) ) {
					alt147=1;
				}

				switch (alt147) {
				case 1 :
					// PhoenixSQL.g:905:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list6120); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list6124);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop147;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:908:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:909:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:909:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref6148);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:909:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop148:
			while (true) {
				int alt148=2;
				int LA148_0 = input.LA(1);
				if ( (LA148_0==FULL||LA148_0==INNER||LA148_0==JOIN||LA148_0==LEFT||LA148_0==RIGHT) ) {
					alt148=1;
				}

				switch (alt148) {
				case 1 :
					// PhoenixSQL.g:909:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref6155);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref6157); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref6161);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref6163); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref6167);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop148;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:912:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		LiteralParseNode tableSample =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:913:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt157=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA157_1 = input.LA(2);
				if ( (LA157_1==BIND_NAME||LA157_1==LPAREN||LA157_1==NAME||LA157_1==QUESTION) ) {
					alt157=1;
				}
				else if ( (LA157_1==SELECT) ) {
					alt157=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 157, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt157=2;
				}
				break;
			case NAME:
				{
				alt157=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 157, 0, input);
				throw nvae;
			}
			switch (alt157) {
				case 1 :
					// PhoenixSQL.g:913:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6191); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor6195);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6197); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:914:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor6211);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:914:21: ( ( AS )? alias= identifier )?
					int alt150=2;
					int LA150_0 = input.LA(1);
					if ( (LA150_0==AS||LA150_0==NAME) ) {
						alt150=1;
					}
					switch (alt150) {
						case 1 :
							// PhoenixSQL.g:914:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:914:22: ( AS )?
							int alt149=2;
							int LA149_0 = input.LA(1);
							if ( (LA149_0==AS) ) {
								alt149=1;
							}
							switch (alt149) {
								case 1 :
									// PhoenixSQL.g:914:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6215); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6221);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:915:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor6238);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:915:27: ( ( AS )? alias= identifier )?
					int alt152=2;
					int LA152_0 = input.LA(1);
					if ( (LA152_0==AS||LA152_0==NAME) ) {
						alt152=1;
					}
					switch (alt152) {
						case 1 :
							// PhoenixSQL.g:915:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:915:28: ( AS )?
							int alt151=2;
							int LA151_0 = input.LA(1);
							if ( (LA151_0==AS) ) {
								alt151=1;
							}
							switch (alt151) {
								case 1 :
									// PhoenixSQL.g:915:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6242); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6248);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:915:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt153=2;
					int LA153_0 = input.LA(1);
					if ( (LA153_0==LPAREN) ) {
						alt153=1;
					}
					switch (alt153) {
						case 1 :
							// PhoenixSQL.g:915:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6253); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor6257);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6259); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:915:92: ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					int alt154=2;
					int LA154_0 = input.LA(1);
					if ( (LA154_0==TABLESAMPLE) ) {
						alt154=1;
					}
					switch (alt154) {
						case 1 :
							// PhoenixSQL.g:915:93: TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN
							{
							match(input,TABLESAMPLE,FOLLOW_TABLESAMPLE_in_table_factor6264); if (state.failed) return ret;
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6266); if (state.failed) return ret;
							pushFollow(FOLLOW_tableSampleNode_in_table_factor6270);
							tableSample=tableSampleNode();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6272); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs, tableSample);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:916:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6286); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor6290);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6292); if (state.failed) return ret;
					// PhoenixSQL.g:916:37: ( ( AS )? alias= identifier )?
					int alt156=2;
					int LA156_0 = input.LA(1);
					if ( (LA156_0==AS||LA156_0==NAME) ) {
						alt156=1;
					}
					switch (alt156) {
						case 1 :
							// PhoenixSQL.g:916:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:916:38: ( AS )?
							int alt155=2;
							int LA155_0 = input.LA(1);
							if ( (LA155_0==AS) ) {
								alt155=1;
							}
							switch (alt155) {
								case 1 :
									// PhoenixSQL.g:916:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6296); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6302);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:919:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:920:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt162=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt162=1;
				}
				break;
			case LEFT:
				{
				alt162=2;
				}
				break;
			case RIGHT:
				{
				alt162=3;
				}
				break;
			case FULL:
				{
				alt162=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}
			switch (alt162) {
				case 1 :
					// PhoenixSQL.g:920:9: ( INNER )?
					{
					// PhoenixSQL.g:920:9: ( INNER )?
					int alt158=2;
					int LA158_0 = input.LA(1);
					if ( (LA158_0==INNER) ) {
						alt158=1;
					}
					switch (alt158) {
						case 1 :
							// PhoenixSQL.g:920:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type6329); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:921:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type6344); if (state.failed) return ret;
					// PhoenixSQL.g:921:14: ( OUTER )?
					int alt159=2;
					int LA159_0 = input.LA(1);
					if ( (LA159_0==OUTER) ) {
						alt159=1;
					}
					switch (alt159) {
						case 1 :
							// PhoenixSQL.g:921:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6346); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:922:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type6361); if (state.failed) return ret;
					// PhoenixSQL.g:922:15: ( OUTER )?
					int alt160=2;
					int LA160_0 = input.LA(1);
					if ( (LA160_0==OUTER) ) {
						alt160=1;
					}
					switch (alt160) {
						case 1 :
							// PhoenixSQL.g:922:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6363); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:923:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type6377); if (state.failed) return ret;
					// PhoenixSQL.g:923:15: ( OUTER )?
					int alt161=2;
					int LA161_0 = input.LA(1);
					if ( (LA161_0==OUTER) ) {
						alt161=1;
					}
					switch (alt161) {
						case 1 :
							// PhoenixSQL.g:923:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6380); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:926:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:927:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:927:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:927:9: ( AS )?
			int alt163=2;
			int LA163_0 = input.LA(1);
			if ( (LA163_0==AS) ) {
				alt163=1;
			}
			switch (alt163) {
				case 1 :
					// PhoenixSQL.g:927:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias6411); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias6416);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:931:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:932:5: (e= or_expression )
			// PhoenixSQL.g:932:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression6444);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:936:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:938:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:938:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression6476);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:938:38: ( OR i= and_expression )*
			loop164:
			while (true) {
				int alt164=2;
				int LA164_0 = input.LA(1);
				if ( (LA164_0==OR) ) {
					alt164=1;
				}

				switch (alt164) {
				case 1 :
					// PhoenixSQL.g:938:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression6481); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression6485);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop164;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:942:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:944:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:944:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression6521);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:944:38: ( AND i= not_expression )*
			loop165:
			while (true) {
				int alt165=2;
				int LA165_0 = input.LA(1);
				if ( (LA165_0==AND) ) {
					alt165=1;
				}

				switch (alt165) {
				case 1 :
					// PhoenixSQL.g:944:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression6526); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression6530);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop165;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:948:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:949:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt168=2;
			int LA168_0 = input.LA(1);
			if ( (LA168_0==NOT) ) {
				int LA168_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt168=1;
				}
				else if ( (true) ) {
					alt168=2;
				}

			}
			else if ( (LA168_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==NULL) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==NAME) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==CASE) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==LPAREN) ) {
				int LA168_15 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt168=1;
				}
				else if ( (true) ) {
					alt168=2;
				}

			}
			else if ( (LA168_0==CAST) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}
			else if ( (LA168_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt168=1;
			}

			switch (alt168) {
				case 1 :
					// PhoenixSQL.g:949:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:949:40: (n= NOT )?
					int alt166=2;
					int LA166_0 = input.LA(1);
					if ( (LA166_0==NOT) ) {
						alt166=1;
					}
					switch (alt166) {
						case 1 :
							// PhoenixSQL.g:949:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6572); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression6577);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:950:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:950:10: (n= NOT )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==NOT) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// PhoenixSQL.g:950:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6591); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression6594); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression6598);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression6600); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:953:1: comparison_op returns [CompareOp ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOp comparison_op() throws RecognitionException {
		CompareOp ret = null;


		try {
			// PhoenixSQL.g:954:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt169=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt169=1;
				}
				break;
			case LT:
				{
				int LA169_2 = input.LA(2);
				if ( (LA169_2==EQ) ) {
					alt169=4;
				}
				else if ( (LA169_2==ALL||(LA169_2 >= ANY && LA169_2 <= ARRAY)||LA169_2==BIND_NAME||(LA169_2 >= CASE && LA169_2 <= CAST)||LA169_2==CURRENT||LA169_2==DECIMAL||LA169_2==DOUBLE||LA169_2==FALSE||LA169_2==LPAREN||LA169_2==MINUS||(LA169_2 >= NAME && LA169_2 <= NEXT)||LA169_2==NULL||LA169_2==NUMBER||LA169_2==QUESTION||LA169_2==STRING_LITERAL||LA169_2==TRUE) ) {
					alt169=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 169, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA169_3 = input.LA(2);
				if ( (LA169_3==EQ) ) {
					alt169=5;
				}
				else if ( (LA169_3==ALL||(LA169_3 >= ANY && LA169_3 <= ARRAY)||LA169_3==BIND_NAME||(LA169_3 >= CASE && LA169_3 <= CAST)||LA169_3==CURRENT||LA169_3==DECIMAL||LA169_3==DOUBLE||LA169_3==FALSE||LA169_3==LPAREN||LA169_3==MINUS||(LA169_3 >= NAME && LA169_3 <= NEXT)||LA169_3==NULL||LA169_3==NUMBER||LA169_3==QUESTION||LA169_3==STRING_LITERAL||LA169_3==TRUE) ) {
					alt169=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 169, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt169=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 169, 0, input);
				throw nvae;
			}
			switch (alt169) {
				case 1 :
					// PhoenixSQL.g:954:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op6620); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:955:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6627); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:956:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6634); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:957:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6641); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6643); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:958:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6650); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6652); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:959:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOp.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:962:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOp op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:963:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt178=2;
			int LA178_0 = input.LA(1);
			if ( (LA178_0==ARRAY||LA178_0==BIND_NAME||(LA178_0 >= CASE && LA178_0 <= CAST)||LA178_0==CURRENT||LA178_0==DECIMAL||LA178_0==DOUBLE||LA178_0==FALSE||LA178_0==LPAREN||LA178_0==MINUS||(LA178_0 >= NAME && LA178_0 <= NEXT)||LA178_0==NULL||LA178_0==NUMBER||LA178_0==QUESTION||LA178_0==STRING_LITERAL||LA178_0==TRUE) ) {
				alt178=1;
			}
			else if ( (LA178_0==EXISTS) ) {
				alt178=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 178, 0, input);
				throw nvae;
			}

			switch (alt178) {
				case 1 :
					// PhoenixSQL.g:963:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression6690);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:963:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt177=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt177=1;
						}
						break;
					case IS:
						{
						alt177=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt177=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case CASCADE:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt177=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 177, 0, input);
						throw nvae;
					}
					switch (alt177) {
						case 1 :
							// PhoenixSQL.g:963:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:963:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:963:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression6696);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:963:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt172=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt172=1;
								}
								break;
							case LPAREN:
								{
								int LA172_2 = input.LA(2);
								if ( (LA172_2==ARRAY||LA172_2==BIND_NAME||(LA172_2 >= CASE && LA172_2 <= CAST)||LA172_2==CURRENT||LA172_2==DECIMAL||LA172_2==DOUBLE||LA172_2==EXISTS||LA172_2==FALSE||LA172_2==LPAREN||LA172_2==MINUS||(LA172_2 >= NAME && LA172_2 <= NEXT)||(LA172_2 >= NOT && LA172_2 <= NULL)||LA172_2==NUMBER||LA172_2==QUESTION||LA172_2==STRING_LITERAL||LA172_2==TRUE) ) {
									alt172=1;
								}
								else if ( (LA172_2==SELECT) ) {
									alt172=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 172, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA172_3 = input.LA(2);
								if ( (LA172_3==LPAREN) ) {
									int LA172_6 = input.LA(3);
									if ( (LA172_6==ARRAY||LA172_6==BIND_NAME||(LA172_6 >= CASE && LA172_6 <= CAST)||LA172_6==CURRENT||LA172_6==DECIMAL||LA172_6==DOUBLE||LA172_6==FALSE||LA172_6==LPAREN||LA172_6==MINUS||(LA172_6 >= NAME && LA172_6 <= NEXT)||LA172_6==NULL||LA172_6==NUMBER||LA172_6==QUESTION||LA172_6==STRING_LITERAL||LA172_6==TRUE) ) {
										alt172=3;
									}
									else if ( (LA172_6==SELECT) ) {
										alt172=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 172, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 172, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA172_4 = input.LA(2);
								if ( (LA172_4==LPAREN) ) {
									int LA172_6 = input.LA(3);
									if ( (LA172_6==ARRAY||LA172_6==BIND_NAME||(LA172_6 >= CASE && LA172_6 <= CAST)||LA172_6==CURRENT||LA172_6==DECIMAL||LA172_6==DOUBLE||LA172_6==FALSE||LA172_6==LPAREN||LA172_6==MINUS||(LA172_6 >= NAME && LA172_6 <= NEXT)||LA172_6==NULL||LA172_6==NUMBER||LA172_6==QUESTION||LA172_6==STRING_LITERAL||LA172_6==TRUE) ) {
										alt172=3;
									}
									else if ( (LA172_6==SELECT) ) {
										alt172=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 172, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 172, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 172, 0, input);
								throw nvae;
							}
							switch (alt172) {
								case 1 :
									// PhoenixSQL.g:963:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression6701);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:963:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:963:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:963:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6706); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6710);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6712); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:963:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:963:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:963:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:963:110: (all= ALL |any= ANY )
									int alt170=2;
									int LA170_0 = input.LA(1);
									if ( (LA170_0==ALL) ) {
										alt170=1;
									}
									else if ( (LA170_0==ANY) ) {
										alt170=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 170, 0, input);
										throw nvae;
									}

									switch (alt170) {
										case 1 :
											// PhoenixSQL.g:963:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6721); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:963:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6727); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6730); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6734);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6736); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:963:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:963:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:963:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:963:168: (all= ALL |any= ANY )
									int alt171=2;
									int LA171_0 = input.LA(1);
									if ( (LA171_0==ALL) ) {
										alt171=1;
									}
									else if ( (LA171_0==ANY) ) {
										alt171=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 171, 0, input);
										throw nvae;
									}

									switch (alt171) {
										case 1 :
											// PhoenixSQL.g:963:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6746); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:963:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6752); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6755); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6759);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6761); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:964:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:964:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:964:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression6791); if (state.failed) return ret;
							// PhoenixSQL.g:964:27: (n= NOT )?
							int alt173=2;
							int LA173_0 = input.LA(1);
							if ( (LA173_0==NOT) ) {
								alt173=1;
							}
							switch (alt173) {
								case 1 :
									// PhoenixSQL.g:964:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6795); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression6798); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:965:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:965:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:965:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:965:25: (n= NOT )?
							int alt174=2;
							int LA174_0 = input.LA(1);
							if ( (LA174_0==NOT) ) {
								alt174=1;
							}
							switch (alt174) {
								case 1 :
									// PhoenixSQL.g:965:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6829); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:965:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt176=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt176=1;
								}
								break;
							case ILIKE:
								{
								alt176=2;
								}
								break;
							case BETWEEN:
								{
								alt176=3;
								}
								break;
							case IN:
								{
								alt176=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 176, 0, input);
								throw nvae;
							}
							switch (alt176) {
								case 1 :
									// PhoenixSQL.g:965:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:965:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:965:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression6834); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6838);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:966:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:966:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:966:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression6876); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6880);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:967:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:967:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:967:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression6918); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6922);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression6924); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6928);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:968:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:968:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:968:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:968:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:968:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression6967); if (state.failed) return ret;
									// PhoenixSQL.g:968:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt175=3;
									int LA175_0 = input.LA(1);
									if ( (LA175_0==BIND_NAME||LA175_0==QUESTION) ) {
										alt175=1;
									}
									else if ( (LA175_0==LPAREN) ) {
										int LA175_2 = input.LA(2);
										if ( (LA175_2==SELECT) ) {
											alt175=2;
										}
										else if ( (LA175_2==ARRAY||LA175_2==BIND_NAME||(LA175_2 >= CASE && LA175_2 <= CAST)||LA175_2==CURRENT||LA175_2==DECIMAL||LA175_2==DOUBLE||LA175_2==EXISTS||LA175_2==FALSE||LA175_2==LPAREN||LA175_2==MINUS||(LA175_2 >= NAME && LA175_2 <= NEXT)||(LA175_2 >= NOT && LA175_2 <= NULL)||LA175_2==NUMBER||LA175_2==QUESTION||LA175_2==STRING_LITERAL||LA175_2==TRUE) ) {
											alt175=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 175, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 175, 0, input);
										throw nvae;
									}

									switch (alt175) {
										case 1 :
											// PhoenixSQL.g:968:38: (r= bind_expression )
											{
											// PhoenixSQL.g:968:38: (r= bind_expression )
											// PhoenixSQL.g:968:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression6973);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:969:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:969:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:969:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7014); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression7018);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7020); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:970:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:970:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:970:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7061); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression7065);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7067); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:973:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:974:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression7167); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7169); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression7173);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7175); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:977:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:978:5: (b= bind_name )
			// PhoenixSQL.g:978:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression7203);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:981:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:982:5: (i= add_expression )
			// PhoenixSQL.g:982:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression7234);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:985:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:987:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:987:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression7265);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:987:43: ( PLUS i= subtract_expression )*
			loop179:
			while (true) {
				int alt179=2;
				int LA179_0 = input.LA(1);
				if ( (LA179_0==PLUS) ) {
					alt179=1;
				}

				switch (alt179) {
				case 1 :
					// PhoenixSQL.g:987:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression7270); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression7274);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop179;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:990:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:992:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:992:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression7309);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:992:41: ( MINUS i= concat_expression )*
			loop180:
			while (true) {
				int alt180=2;
				int LA180_0 = input.LA(1);
				if ( (LA180_0==MINUS) ) {
					alt180=1;
				}

				switch (alt180) {
				case 1 :
					// PhoenixSQL.g:992:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression7314); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression7318);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop180;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:995:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:997:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:997:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7353);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:997:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop181:
			while (true) {
				int alt181=2;
				int LA181_0 = input.LA(1);
				if ( (LA181_0==CONCAT) ) {
					alt181=1;
				}

				switch (alt181) {
				case 1 :
					// PhoenixSQL.g:997:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression7358); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7362);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop181;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:1000:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:1002:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:1002:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7397);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:1003:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop182:
			while (true) {
				int alt182=2;
				int LA182_0 = input.LA(1);
				if ( (LA182_0==ASTERISK||LA182_0==DIVIDE||LA182_0==PERCENT) ) {
					alt182=1;
				}

				switch (alt182) {
				case 1 :
					// PhoenixSQL.g:1003:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7427);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop182;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:1014:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:1015:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:1015:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node7470); if (state.failed) return ret;
			// PhoenixSQL.g:1015:10: ( DEFAULT |s= identifier )
			int alt183=2;
			int LA183_0 = input.LA(1);
			if ( (LA183_0==DEFAULT) ) {
				alt183=1;
			}
			else if ( (LA183_0==NAME) ) {
				alt183=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 183, 0, input);
				throw nvae;
			}

			switch (alt183) {
				case 1 :
					// PhoenixSQL.g:1015:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node7473); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:1015:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node7479);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:1019:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:1020:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:1020:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:1020:10: (m= MINUS )?
			int alt184=2;
			int LA184_0 = input.LA(1);
			if ( (LA184_0==MINUS) ) {
				alt184=1;
			}
			switch (alt184) {
				case 1 :
					// PhoenixSQL.g:1020:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression7515); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression7520);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:1024:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:1025:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:1025:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression7548);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1025:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==LSQUARE) ) {
				alt185=1;
			}
			switch (alt185) {
				case 1 :
					// PhoenixSQL.g:1025:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression7551); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression7555);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression7557); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:1028:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:1029:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt192=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt192=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt192=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case BETWEEN:
				case CACHE:
				case CASCADE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt192=2;
					}
					break;
				case DOT:
					{
					alt192=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt192=6;
						}
						break;
					case DISTINCT:
						{
						alt192=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt192=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 192, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 192, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt192=3;
				}
				break;
			case CASE:
				{
				alt192=8;
				}
				break;
			case LPAREN:
				{
				alt192=9;
				}
				break;
			case CAST:
				{
				alt192=10;
				}
				break;
			case NEXT:
				{
				int LA192_7 = input.LA(2);
				if ( (LA192_7==VALUE) ) {
					alt192=11;
				}
				else if ( (LA192_7==BIND_NAME||LA192_7==DECIMAL||LA192_7==DOUBLE||LA192_7==FALSE||LA192_7==NAME||LA192_7==NULL||LA192_7==NUMBER||LA192_7==QUESTION||LA192_7==STRING_LITERAL||LA192_7==TRUE) ) {
					alt192=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 192, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt192=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 192, 0, input);
				throw nvae;
			}
			switch (alt192) {
				case 1 :
					// PhoenixSQL.g:1029:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term7590);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1030:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term7604);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1031:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7618); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term7620); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7624);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term7626); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:1032:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term7640);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term7642); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7646);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1033:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term7660);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7662); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7666);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7668); if (state.failed) return ret;
					// PhoenixSQL.g:1033:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt187=2;
					int LA187_0 = input.LA(1);
					if ( (LA187_0==WITHIN) ) {
						alt187=1;
					}
					switch (alt187) {
						case 1 :
							// PhoenixSQL.g:1033:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term7673); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term7675); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term7677); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term7679); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term7681); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term7685);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:1033:127: (a= ASC | DESC )
							int alt186=2;
							int LA186_0 = input.LA(1);
							if ( (LA186_0==ASC) ) {
								alt186=1;
							}
							else if ( (LA186_0==DESC) ) {
								alt186=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 186, 0, input);
								throw nvae;
							}

							switch (alt186) {
								case 1 :
									// PhoenixSQL.g:1033:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term7690); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:1033:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term7694); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term7697); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1042:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7722);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7724); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term7728); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7730); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1054:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7754);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7756); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term7760); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7764);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7766); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1063:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term7789);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1064:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term7801); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7805);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7807); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1073:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term7825); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7827); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term7831);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term7833); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7837);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1073:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt189=2;
					int LA189_0 = input.LA(1);
					if ( (LA189_0==LPAREN) ) {
						alt189=1;
					}
					switch (alt189) {
						case 1 :
							// PhoenixSQL.g:1073:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term7840); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7844); if (state.failed) return ret;
							// PhoenixSQL.g:1073:73: ( COMMA scale= NUMBER )?
							int alt188=2;
							int LA188_0 = input.LA(1);
							if ( (LA188_0==COMMA) ) {
								alt188=1;
							}
							switch (alt188) {
								case 1 :
									// PhoenixSQL.g:1073:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term7847); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7851); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term7855); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1073:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt190=3;
					int LA190_0 = input.LA(1);
					if ( (LA190_0==ARRAY) ) {
						alt190=1;
					}
					else if ( (LA190_0==LSQUARE) ) {
						alt190=2;
					}
					switch (alt190) {
						case 1 :
							// PhoenixSQL.g:1073:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7862); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1073:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1073:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1073:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term7867); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term7869); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term7874); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1079:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1079:9: (n= NEXT | CURRENT )
					int alt191=2;
					int LA191_0 = input.LA(1);
					if ( (LA191_0==NEXT) ) {
						alt191=1;
					}
					else if ( (LA191_0==CURRENT) ) {
						alt191=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 191, 0, input);
						throw nvae;
					}

					switch (alt191) {
						case 1 :
							// PhoenixSQL.g:1079:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7897); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1079:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term7901); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term7904); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7906); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7910);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1082:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1082:9: (n= NEXT )
					// PhoenixSQL.g:1082:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7938); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term7943);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term7945); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7947); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7951);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1087:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1089:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1089:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions7996);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1089:39: ( COMMA e= expression )*
			loop193:
			while (true) {
				int alt193=2;
				int LA193_0 = input.LA(1);
				if ( (LA193_0==COMMA) ) {
					alt193=1;
				}

				switch (alt193) {
				case 1 :
					// PhoenixSQL.g:1089:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions8002); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions8008);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop193;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1092:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1094:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1094:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8039);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1094:49: ( COMMA jarPath= jar_path )*
			loop194:
			while (true) {
				int alt194=2;
				int LA194_0 = input.LA(1);
				if ( (LA194_0==COMMA) ) {
					alt194=1;
				}

				switch (alt194) {
				case 1 :
					// PhoenixSQL.g:1094:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths8045); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8051);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop194;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1097:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1099:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1099:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1099:8: (v= expression )?
			int alt195=2;
			int LA195_0 = input.LA(1);
			if ( (LA195_0==ARRAY||LA195_0==BIND_NAME||(LA195_0 >= CASE && LA195_0 <= CAST)||LA195_0==CURRENT||LA195_0==DECIMAL||LA195_0==DOUBLE||LA195_0==EXISTS||LA195_0==FALSE||LA195_0==LPAREN||LA195_0==MINUS||(LA195_0 >= NAME && LA195_0 <= NEXT)||(LA195_0 >= NOT && LA195_0 <= NULL)||LA195_0==NUMBER||LA195_0==QUESTION||LA195_0==STRING_LITERAL||LA195_0==TRUE) ) {
				alt195=1;
			}
			switch (alt195) {
				case 1 :
					// PhoenixSQL.g:1099:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8084);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1099:42: ( COMMA v= expression )*
			loop196:
			while (true) {
				int alt196=2;
				int LA196_0 = input.LA(1);
				if ( (LA196_0==COMMA) ) {
					alt196=1;
				}

				switch (alt196) {
				case 1 :
					// PhoenixSQL.g:1099:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions8092); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8098);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop196;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1102:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1104:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1104:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1104:7: (fa= function_argument )?
			int alt197=2;
			int LA197_0 = input.LA(1);
			if ( (LA197_0==NAME) ) {
				alt197=1;
			}
			switch (alt197) {
				case 1 :
					// PhoenixSQL.g:1104:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8129);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1104:49: ( COMMA fa= function_argument )*
			loop198:
			while (true) {
				int alt198=2;
				int LA198_0 = input.LA(1);
				if ( (LA198_0==COMMA) ) {
					alt198=1;
				}

				switch (alt198) {
				case 1 :
					// PhoenixSQL.g:1104:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types8136); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8142);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop198;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1107:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1108:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1108:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1108:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1108:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument8167);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1108:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt200=2;
			int LA200_0 = input.LA(1);
			if ( (LA200_0==LPAREN) ) {
				alt200=1;
			}
			switch (alt200) {
				case 1 :
					// PhoenixSQL.g:1108:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument8170); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8174); if (state.failed) return ret;
					// PhoenixSQL.g:1108:38: ( COMMA s= NUMBER )?
					int alt199=2;
					int LA199_0 = input.LA(1);
					if ( (LA199_0==COMMA) ) {
						alt199=1;
					}
					switch (alt199) {
						case 1 :
							// PhoenixSQL.g:1108:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument8177); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8181); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument8185); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1108:67: (ar= ARRAY )?
			int alt201=2;
			int LA201_0 = input.LA(1);
			if ( (LA201_0==ARRAY) ) {
				alt201=1;
			}
			switch (alt201) {
				case 1 :
					// PhoenixSQL.g:1108:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument8191); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1108:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt203=2;
			int LA203_0 = input.LA(1);
			if ( (LA203_0==LSQUARE) ) {
				alt203=1;
			}
			switch (alt203) {
				case 1 :
					// PhoenixSQL.g:1108:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument8197); if (state.failed) return ret;
					// PhoenixSQL.g:1108:88: (a= NUMBER )?
					int alt202=2;
					int LA202_0 = input.LA(1);
					if ( (LA202_0==NUMBER) ) {
						alt202=1;
					}
					switch (alt202) {
						case 1 :
							// PhoenixSQL.g:1108:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8202); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument8206); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1108:110: (c= CONSTANT )?
			int alt204=2;
			int LA204_0 = input.LA(1);
			if ( (LA204_0==CONSTANT) ) {
				alt204=1;
			}
			switch (alt204) {
				case 1 :
					// PhoenixSQL.g:1108:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument8215); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1108:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt205=2;
			int LA205_0 = input.LA(1);
			if ( (LA205_0==DEFAULTVALUE) ) {
				alt205=1;
			}
			switch (alt205) {
				case 1 :
					// PhoenixSQL.g:1108:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument8220); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8222); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8228);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1108:161: ( MINVALUE EQ minv= expression )?
			int alt206=2;
			int LA206_0 = input.LA(1);
			if ( (LA206_0==MINVALUE) ) {
				alt206=1;
			}
			switch (alt206) {
				case 1 :
					// PhoenixSQL.g:1108:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument8233); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8235); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8241);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1108:195: ( MAXVALUE EQ maxv= expression )?
			int alt207=2;
			int LA207_0 = input.LA(1);
			if ( (LA207_0==MAXVALUE) ) {
				alt207=1;
			}
			switch (alt207) {
				case 1 :
					// PhoenixSQL.g:1108:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument8247); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8249); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8255);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1115:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1117:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1117:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list8285); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list8291);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1117:52: ( COMMA e= value_expression )*
			loop208:
			while (true) {
				int alt208=2;
				int LA208_0 = input.LA(1);
				if ( (LA208_0==COMMA) ) {
					alt208=1;
				}

				switch (alt208) {
				case 1 :
					// PhoenixSQL.g:1117:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list8297); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list8303);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop208;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list8310); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1120:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1121:5: (name= identifier )
			// PhoenixSQL.g:1121:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name8331);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1124:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1125:5: (name= identifier )
			// PhoenixSQL.g:1125:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name8358);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1129:1: table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1130:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt209=2;
			int LA209_0 = input.LA(1);
			if ( (LA209_0==NAME) ) {
				int LA209_1 = input.LA(2);
				if ( (LA209_1==FROM||LA209_1==TO) ) {
					alt209=1;
				}
				else if ( (LA209_1==DOT) ) {
					int LA209_3 = input.LA(3);
					if ( (LA209_3==NAME) ) {
						switch ( input.LA(4) ) {
						case EOF:
						case AND:
						case AS:
						case ASC:
						case ASTERISK:
						case BETWEEN:
						case CACHE:
						case CASCADE:
						case COMMA:
						case CONCAT:
						case CONSTRAINT:
						case CYCLE:
						case DESC:
						case DIVIDE:
						case ELSE:
						case END:
						case EQ:
						case FETCH:
						case FULL:
						case GROUP:
						case GT:
						case HAVING:
						case ILIKE:
						case IN:
						case INCREMENT:
						case INNER:
						case IS:
						case JOIN:
						case LEFT:
						case LIKE:
						case LIMIT:
						case LSQUARE:
						case LT:
						case MAXVALUE:
						case MINUS:
						case MINVALUE:
						case NAME:
						case NOEQ1:
						case NOEQ2:
						case NOT:
						case NULLS:
						case OFFSET:
						case OR:
						case ORDER:
						case PERCENT:
						case PLUS:
						case PRIMARY:
						case RIGHT:
						case RPAREN:
						case RSQUARE:
						case SEMICOLON:
						case THEN:
						case UNION:
						case WHEN:
						case WHERE:
							{
							alt209=1;
							}
							break;
						case FROM:
							{
							switch ( input.LA(5) ) {
							case BIND_NAME:
							case LPAREN:
							case QUESTION:
								{
								alt209=1;
								}
								break;
							case NAME:
								{
								int LA209_7 = input.LA(6);
								if ( (LA209_7==EOF||LA209_7==AS||LA209_7==COMMA||LA209_7==DOT||LA209_7==FETCH||LA209_7==FULL||LA209_7==GROUP||LA209_7==HAVING||LA209_7==INNER||LA209_7==JOIN||LA209_7==LEFT||LA209_7==LIMIT||LA209_7==LPAREN||LA209_7==NAME||LA209_7==OFFSET||LA209_7==ORDER||LA209_7==RIGHT||LA209_7==RPAREN||LA209_7==SEMICOLON||LA209_7==TABLESAMPLE||LA209_7==UNION||LA209_7==WHERE) ) {
									alt209=1;
								}
								else if ( (LA209_7==STRING_LITERAL) ) {
									alt209=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 209, 7, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case GROUP:
							case NULL:
							case NUMBER:
							case STRING_LITERAL:
							case TRUE:
								{
								alt209=2;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 209, 5, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}
							}
							break;
						case DOT:
						case TO:
							{
							alt209=2;
							}
							break;
						default:
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 209, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 209, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 209, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 209, 0, input);
				throw nvae;
			}

			switch (alt209) {
				case 1 :
					// PhoenixSQL.g:1130:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name8386);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1131:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name8400);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name8402); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_table_name8406);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1135:1: from_table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1136:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt210=2;
			int LA210_0 = input.LA(1);
			if ( (LA210_0==NAME) ) {
				int LA210_1 = input.LA(2);
				if ( (LA210_1==EOF||(LA210_1 >= ACTIVE && LA210_1 <= ALL)||LA210_1==AND||(LA210_1 >= AS && LA210_1 <= ASTERISK)||LA210_1==BETWEEN||(LA210_1 >= CACHE && LA210_1 <= CASCADE)||(LA210_1 >= COLUMNS && LA210_1 <= COMMA)||LA210_1==CONCAT||LA210_1==CONSTRAINT||LA210_1==CYCLE||LA210_1==DESC||LA210_1==DISABLE||LA210_1==DIVIDE||LA210_1==DROP||(LA210_1 >= ELSE && LA210_1 <= END)||LA210_1==EQ||LA210_1==FETCH||(LA210_1 >= FROM && LA210_1 <= FULL)||(LA210_1 >= GROUP && LA210_1 <= HAVING)||LA210_1==ILIKE||LA210_1==IN||(LA210_1 >= INCREMENT && LA210_1 <= INNER)||LA210_1==IS||LA210_1==JOIN||LA210_1==LEFT||(LA210_1 >= LIKE && LA210_1 <= LIMIT)||(LA210_1 >= LPAREN && LA210_1 <= MINVALUE)||LA210_1==NAME||(LA210_1 >= NOEQ1 && LA210_1 <= NOT)||LA210_1==NULLS||(LA210_1 >= OFFSET && LA210_1 <= ON)||(LA210_1 >= OR && LA210_1 <= ORDER)||(LA210_1 >= PERCENT && LA210_1 <= PLUS)||LA210_1==PRIMARY||LA210_1==REBUILD||LA210_1==RIGHT||(LA210_1 >= RPAREN && LA210_1 <= RSQUARE)||(LA210_1 >= SELECT && LA210_1 <= SEMICOLON)||LA210_1==SET||LA210_1==START||LA210_1==TABLESAMPLE||LA210_1==THEN||(LA210_1 >= UNION && LA210_1 <= UNUSABLE)||LA210_1==USABLE||LA210_1==VALUES||(LA210_1 >= WHEN && LA210_1 <= WHERE)) ) {
					alt210=1;
				}
				else if ( (LA210_1==DOT) ) {
					alt210=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 210, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 210, 0, input);
				throw nvae;
			}

			switch (alt210) {
				case 1 :
					// PhoenixSQL.g:1136:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name8434);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1137:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name8448);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name8450); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_from_table_name8454);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "table_identifier"
	// PhoenixSQL.g:1140:1: table_identifier returns [String ret] : c= identifier ;
	public final String table_identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1141:5: (c= identifier )
			// PhoenixSQL.g:1141:9: c= identifier
			{
			pushFollow(FOLLOW_identifier_in_table_identifier8481);
			c=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			           if (c.contains(QueryConstants.NAMESPACE_SEPARATOR) ) { throw new RuntimeException("Table or schema name cannot contain colon"); }
			           ret = c;
			    }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_identifier"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1148:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1149:5: (e= literal |b= bind_name )
			int alt211=2;
			int LA211_0 = input.LA(1);
			if ( (LA211_0==DECIMAL||LA211_0==DOUBLE||LA211_0==FALSE||LA211_0==NAME||LA211_0==NULL||LA211_0==NUMBER||LA211_0==STRING_LITERAL||LA211_0==TRUE) ) {
				alt211=1;
			}
			else if ( (LA211_0==BIND_NAME||LA211_0==QUESTION) ) {
				alt211=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 211, 0, input);
				throw nvae;
			}

			switch (alt211) {
				case 1 :
					// PhoenixSQL.g:1149:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind8513);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1150:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind8527);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1154:1: literal returns [LiteralParseNode ret] : (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		String dt =null;

		try {
			// PhoenixSQL.g:1155:5: (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt212=8;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt212=1;
				}
				break;
			case NUMBER:
				{
				alt212=2;
				}
				break;
			case DECIMAL:
				{
				alt212=3;
				}
				break;
			case DOUBLE:
				{
				alt212=4;
				}
				break;
			case NULL:
				{
				alt212=5;
				}
				break;
			case TRUE:
				{
				alt212=6;
				}
				break;
			case FALSE:
				{
				alt212=7;
				}
				break;
			case NAME:
				{
				alt212=8;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 212, 0, input);
				throw nvae;
			}
			switch (alt212) {
				case 1 :
					// PhoenixSQL.g:1155:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8559); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1158:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal8573); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1161:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal8587); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1164:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal8602); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1167:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal8619); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 6 :
					// PhoenixSQL.g:1168:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal8631); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 7 :
					// PhoenixSQL.g:1169:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal8644); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1170:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal8658);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8662); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1179:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1180:5: (n= NUMBER )
			// PhoenixSQL.g:1180:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal8693); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1186:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1187:5: (n= BIND_NAME | QUESTION )
			int alt213=2;
			int LA213_0 = input.LA(1);
			if ( (LA213_0==BIND_NAME) ) {
				alt213=1;
			}
			else if ( (LA213_0==QUESTION) ) {
				alt213=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 213, 0, input);
				throw nvae;
			}

			switch (alt213) {
				case 1 :
					// PhoenixSQL.g:1187:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name8721); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1188:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name8734); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1192:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1193:5: (c= parseNoReserved )
			// PhoenixSQL.g:1193:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier8763);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1196:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1197:5: (n= NAME )
			// PhoenixSQL.g:1197:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved8790); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1200:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1202:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt218=2;
			int LA218_0 = input.LA(1);
			if ( (LA218_0==CASE) ) {
				int LA218_1 = input.LA(2);
				if ( (LA218_1==ARRAY||LA218_1==BIND_NAME||(LA218_1 >= CASE && LA218_1 <= CAST)||LA218_1==CURRENT||LA218_1==DECIMAL||LA218_1==DOUBLE||LA218_1==EXISTS||LA218_1==FALSE||LA218_1==LPAREN||LA218_1==MINUS||(LA218_1 >= NAME && LA218_1 <= NEXT)||(LA218_1 >= NOT && LA218_1 <= NULL)||LA218_1==NUMBER||LA218_1==QUESTION||LA218_1==STRING_LITERAL||LA218_1==TRUE) ) {
					alt218=1;
				}
				else if ( (LA218_1==WHEN) ) {
					alt218=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 218, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 218, 0, input);
				throw nvae;
			}

			switch (alt218) {
				case 1 :
					// PhoenixSQL.g:1202:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8817); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement8821);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1202:26: ( WHEN e2= expression THEN t= expression )+
					int cnt214=0;
					loop214:
					while (true) {
						int alt214=2;
						int LA214_0 = input.LA(1);
						if ( (LA214_0==WHEN) ) {
							alt214=1;
						}

						switch (alt214) {
						case 1 :
							// PhoenixSQL.g:1202:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8824); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8828);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8830); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8834);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt214 >= 1 ) break loop214;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(214, input);
							throw eee;
						}
						cnt214++;
					}

					// PhoenixSQL.g:1202:106: ( ELSE el= expression )?
					int alt215=2;
					int LA215_0 = input.LA(1);
					if ( (LA215_0==ELSE) ) {
						alt215=1;
					}
					switch (alt215) {
						case 1 :
							// PhoenixSQL.g:1202:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8841); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8845);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8851); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1203:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8861); if (state.failed) return ret;
					// PhoenixSQL.g:1203:12: ( WHEN c= expression THEN t= expression )+
					int cnt216=0;
					loop216:
					while (true) {
						int alt216=2;
						int LA216_0 = input.LA(1);
						if ( (LA216_0==WHEN) ) {
							alt216=1;
						}

						switch (alt216) {
						case 1 :
							// PhoenixSQL.g:1203:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8864); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8868);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8870); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8874);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt216 >= 1 ) break loop216;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(216, input);
							throw eee;
						}
						cnt216++;
					}

					// PhoenixSQL.g:1203:72: ( ELSE el= expression )?
					int alt217=2;
					int LA217_0 = input.LA(1);
					if ( (LA217_0==ELSE) ) {
						alt217=1;
					}
					switch (alt217) {
						case 1 :
							// PhoenixSQL.g:1203:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8881); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8885);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8891); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:949:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:949:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:949:10: ( NOT )?
		int alt219=2;
		int LA219_0 = input.LA(1);
		if ( (LA219_0==NOT) ) {
			alt219=1;
		}
		switch (alt219) {
			case 1 :
				// PhoenixSQL.g:949:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL6561); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6564);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1295 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1299 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1334 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1364 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1398 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1444 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1456 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1492 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1516 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1552 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_node_in_oneStatement1576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_create_table_node_in_oneStatement1588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1600 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1612 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1636 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1660 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grant_permission_node_in_oneStatement1694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revoke_permission_node_in_oneStatement1706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1736 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1748 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1772 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1805 = new BitSet(new long[]{0x50401208020000A0L,0x0100000400000102L,0x0000544000420080L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1809 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1835 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L,0x0000000080000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node1844 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_table_node1847 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node1849 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node1853 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node1859 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node1871 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node1875 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node1880 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node1884 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node1898 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node1911 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_table_node1913 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node1917 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node1956 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node1958 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node1961 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node1963 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node1967 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node1973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRANT_in_grant_permission_node2007 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2011 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_ON_in_grant_permission_node2014 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L,0x0000000080008000L});
	public static final BitSet FOLLOW_TABLE_in_grant_permission_node2018 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_name_in_grant_permission_node2024 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_SCHEMA_in_grant_permission_node2030 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_grant_permission_node2034 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_TO_in_grant_permission_node2039 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000201L,0x0000008040000000L});
	public static final BitSet FOLLOW_GROUP_in_grant_permission_node2044 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REVOKE_in_revoke_permission_node2084 = new BitSet(new long[]{0x0008010000000000L,0x004A100000000021L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2089 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000020L});
	public static final BitSet FOLLOW_ON_in_revoke_permission_node2094 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L,0x0000000080008000L});
	public static final BitSet FOLLOW_TABLE_in_revoke_permission_node2098 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_name_in_revoke_permission_node2104 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_SCHEMA_in_revoke_permission_node2110 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_revoke_permission_node2114 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_revoke_permission_node2119 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000201L,0x0000008040000000L});
	public static final BitSet FOLLOW_GROUP_in_revoke_permission_node2124 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2130 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2164 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_TABLES_in_show_node2166 = new BitSet(new long[]{0x0000000000000002L,0x0000000100020000L});
	public static final BitSet FOLLOW_IN_in_show_node2169 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_show_node2173 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2178 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2182 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2196 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SCHEMAS_in_show_node2198 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2201 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2205 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_create_table_node2233 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_CREATE_in_show_create_table_node2235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_TABLE_in_show_create_table_node2237 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_show_create_table_node2241 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node2267 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node2269 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_view_node2272 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node2274 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node2278 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2284 = new BitSet(new long[]{0x0000000000000802L,0x0000101000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node2296 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node2300 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node2305 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node2309 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node2323 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node2325 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node2327 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_create_view_node2339 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2343 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node2356 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_create_view_node2360 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2414 = new BitSet(new long[]{0x0000000000000000L,0x0000000800100000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2418 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2421 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2424 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2426 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2430 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2436 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2438 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2442 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2453 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2459 = new BitSet(new long[]{0x0000000000004002L,0x0000100000040000L,0x0000000008000000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2471 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2474 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2478 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2480 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2496 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2511 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2524 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2526 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2566 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2568 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node2572 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node2574 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node2578 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node2584 = new BitSet(new long[]{0x0000004000080002L,0x0000028000080000L,0x0000000010000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node2595 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0020008040000004L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node2597 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2602 = new BitSet(new long[]{0x0000004000080002L,0x0000028000080000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node2615 = new BitSet(new long[]{0x0008011000660400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node2617 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2622 = new BitSet(new long[]{0x0000004000080002L,0x0000028000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node2635 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2639 = new BitSet(new long[]{0x0000004000080002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node2652 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2656 = new BitSet(new long[]{0x0000004000080002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node2671 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node2685 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node2689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind2720 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind2732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_string_literal2760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node2786 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node2788 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node2792 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node2796 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node2802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint2831 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint2834 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint2838 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint2840 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint2842 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint2844 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2848 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint2850 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2881 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2887 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2893 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2920 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2925 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2929 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint2971 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2998 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list3004 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3010 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order3037 = new BitSet(new long[]{0x0000200000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order3043 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order3047 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3075 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3077 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3081 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties3087 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3091 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3093 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3097 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3141 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name3143 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3147 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value3178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value3192 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3223 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3237 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name3239 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name3243 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names3275 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names3281 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names3287 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node3314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000080000000L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node3319 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node3323 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node3327 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node3331 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node3337 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node3342 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node3377 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node3379 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node3382 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node3386 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3392 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3434 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3437 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3441 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3447 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3449 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3483 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3485 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3488 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3492 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3498 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3500 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3504 = new BitSet(new long[]{0x0000800000000010L,0x0000000000000000L,0x0000220000000010L});
	public static final BitSet FOLLOW_USABLE_in_alter_index_node3517 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_UNUSABLE_in_alter_index_node3521 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_REBUILD_in_alter_index_node3525 = new BitSet(new long[]{0x0000000000004042L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ALL_in_alter_index_node3530 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_DISABLE_in_alter_index_node3536 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ACTIVE_in_alter_index_node3540 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node3547 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_SET_in_alter_index_node3553 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_index_node3558 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node3593 = new BitSet(new long[]{0x0000000000000000L,0x0050000000000000L});
	public static final BitSet FOLLOW_ON_in_trace_node3601 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_WITH_in_trace_node3606 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node3608 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node3614 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node3625 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node3659 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000080L,0x0000000400000000L});
	public static final BitSet FOLLOW_OR_in_create_function_node3662 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node3666 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x0000000400000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node3673 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node3677 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3681 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node3692 = new BitSet(new long[]{0x0000000020000000L,0x0000100000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node3696 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node3698 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node3708 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3712 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node3714 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3720 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_USING_in_create_function_node3731 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node3733 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path3777 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node3800 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node3802 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node3805 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node3809 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node3815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node3838 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node3840 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node3846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node3869 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node3871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node3894 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node3896 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node3902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node3928 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node3930 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node3933 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node3937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node3971 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000080000000L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node3974 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node3980 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node3985 = new BitSet(new long[]{0x0040000000000020L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node3998 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node4000 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node4003 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node4007 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node4013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node4019 = new BitSet(new long[]{0x0000000000000000L,0x0000100000002000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node4022 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node4024 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node4028 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node4035 = new BitSet(new long[]{0x0000000000100002L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4041 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_alter_table_node4049 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_INDEX_in_alter_table_node4051 = new BitSet(new long[]{0x0000000000000040L,0x0000100000000000L});
	public static final BitSet FOLLOW_indexes_in_alter_table_node4056 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_alter_table_node4062 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node4070 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4075 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node4109 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node4111 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node4115 = new BitSet(new long[]{0x0000000010000042L,0x0000000000100000L,0x0000000000200000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node4120 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node4126 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node4132 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node4137 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node4142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node4166 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node4168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name4194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties4228 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties4230 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4234 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_properties4240 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties4244 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties4246 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4250 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs4285 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs4291 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs4297 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_index_name_in_indexes4328 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_indexes4334 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_indexes4340 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_column_def4366 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def4370 = new BitSet(new long[]{0x0000040000000402L,0x0003003000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_column_def4373 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4377 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_column_def4380 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4384 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_column_def4388 = new BitSet(new long[]{0x0000040000000402L,0x0003002000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_column_def4394 = new BitSet(new long[]{0x0000040000000002L,0x0003002000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def4400 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4405 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def4409 = new BitSet(new long[]{0x0000040000000002L,0x0003000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_column_def4416 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def4421 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def4426 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_column_def4430 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def4437 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_KEY_in_column_def4439 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ASC_in_column_def4444 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_DESC_in_column_def4448 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def4454 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4497 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs4503 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4509 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def4535 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def4539 = new BitSet(new long[]{0x0000000000000402L,0x0000003000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def4542 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4546 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def4549 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4553 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def4557 = new BitSet(new long[]{0x0000000000000402L,0x0000002000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def4563 = new BitSet(new long[]{0x0000000000000002L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def4569 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4574 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def4578 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def4615 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def4620 = new BitSet(new long[]{0x0000000000000402L,0x0000003000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def4623 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4627 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def4630 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4634 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def4638 = new BitSet(new long[]{0x0000000000000402L,0x0000002000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def4644 = new BitSet(new long[]{0x0000000000000002L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def4650 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4655 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def4659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression4699 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select4732 = new BitSet(new long[]{0x2009011000622440L,0x000B391000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_hintClause_in_single_select4737 = new BitSet(new long[]{0x2009011000622440L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select4753 = new BitSet(new long[]{0x2008011000622400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_ALL_in_single_select4757 = new BitSet(new long[]{0x2008011000622400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_select_list_in_single_select4763 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000A20L,0x0010000000000000L});
	public static final BitSet FOLLOW_FROM_in_single_select4774 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_parseFrom_in_single_select4778 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000A00L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_single_select4791 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_single_select4795 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000A00L});
	public static final BitSet FOLLOW_GROUP_in_single_select4808 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_single_select4810 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_group_by_in_single_select4814 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_HAVING_in_single_select4827 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_single_select4831 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4875 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects4880 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects4882 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4886 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node4924 = new BitSet(new long[]{0x0000000000000002L,0x0420000200000002L});
	public static final BitSet FOLLOW_ORDER_in_select_node4935 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_select_node4937 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_order_by_in_select_node4941 = new BitSet(new long[]{0x0000000000000002L,0x0020000200000002L});
	public static final BitSet FOLLOW_LIMIT_in_select_node4954 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_limit_in_select_node4958 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_select_node4971 = new BitSet(new long[]{0x0000000000020000L,0x0008001000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_offset_in_select_node4975 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_select_node4988 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000008L});
	public static final BitSet FOLLOW_set_in_select_node4990 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000604L});
	public static final BitSet FOLLOW_limit_in_select_node5001 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000600L});
	public static final BitSet FOLLOW_set_in_select_node5005 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_ONLY_in_select_node5013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node5052 = new BitSet(new long[]{0x0000000000000000L,0x0000080000400000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node5057 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node5061 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node5065 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L,0x0002000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5076 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node5080 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000020000L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node5096 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5098 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node5102 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5104 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_upsert_node5108 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node5110 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node5112 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L,0x0000040000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node5118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node5124 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node5128 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_upsert_node5143 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5184 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs5196 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5200 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair5225 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair5227 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_update_column_pair5231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5260 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs5273 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5277 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node5305 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node5309 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node5311 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node5313 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node5317 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node5351 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node5355 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node5382 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node5386 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node5412 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node5414 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000020L,0x0000000000000600L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node5419 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L,0x0000000000000600L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node5430 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node5434 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node5460 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000020L});
	public static final BitSet FOLLOW_hintClause_in_delete_node5465 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_delete_node5469 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node5473 = new BitSet(new long[]{0x0000000000000002L,0x0400000200000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_delete_node5484 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_delete_node5488 = new BitSet(new long[]{0x0000000000000002L,0x0400000200000000L});
	public static final BitSet FOLLOW_ORDER_in_delete_node5501 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_delete_node5503 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_order_by_in_delete_node5507 = new BitSet(new long[]{0x0000000000000002L,0x0000000200000000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node5520 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_limit_in_delete_node5524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit5559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit5571 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset5597 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000600L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset5618 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000600L});
	public static final BitSet FOLLOW_LPAREN_in_offset5637 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset5641 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_offset5643 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_offset5645 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_offset5647 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset5651 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_offset5653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate5678 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_tableSampleNode5703 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause5729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5761 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list5766 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_selectable_in_select_list5770 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list5782 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable5811 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable5816 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5831 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5833 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5835 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5850 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5852 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable5856 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5858 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5860 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by5893 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by5906 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_group_by5912 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5946 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by5959 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5965 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField6002 = new BitSet(new long[]{0x0000200000001002L,0x0004000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField6014 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField6020 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField6035 = new BitSet(new long[]{0x0000000000000000L,0x0000000010000008L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField6038 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField6044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom6084 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list6115 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list6120 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_ref_in_table_list6124 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6148 = new BitSet(new long[]{0x0000000000000002L,0x0000000044200040L,0x0000000000000100L});
	public static final BitSet FOLLOW_join_type_in_table_ref6155 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref6157 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6161 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_table_ref6163 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_table_ref6167 = new BitSet(new long[]{0x0000000000000002L,0x0000000044200040L,0x0000000000000100L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6191 = new BitSet(new long[]{0x0000000000020000L,0x0000101000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_list_in_table_factor6195 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6197 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor6211 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6215 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6221 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor6238 = new BitSet(new long[]{0x0000000000000802L,0x0000101000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6242 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6248 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6253 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor6257 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6259 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_TABLESAMPLE_in_table_factor6264 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6266 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_tableSampleNode_in_table_factor6270 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6272 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6286 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_select_node_in_table_factor6290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6292 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6296 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6302 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type6329 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type6344 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type6361 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type6377 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6380 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias6411 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias6416 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression6444 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6476 = new BitSet(new long[]{0x0000000000000002L,0x0200000000000000L});
	public static final BitSet FOLLOW_OR_in_or_expression6481 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6485 = new BitSet(new long[]{0x0000000000000002L,0x0200000000000000L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6521 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression6526 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6530 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression6572 = new BitSet(new long[]{0x2008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression6577 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression6591 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression6594 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_not_expression6598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression6600 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6620 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6627 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6634 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6641 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6643 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6650 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6652 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op6659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6690 = new BitSet(new long[]{0x0800000000010002L,0x0001C04100828400L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression6696 = new BitSet(new long[]{0x0008011000620640L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6701 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6706 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6710 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6712 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6721 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6727 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6730 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6734 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6736 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6746 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6752 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6755 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6759 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6761 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression6791 = new BitSet(new long[]{0x0000000000000000L,0x0003000000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6795 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression6798 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6829 = new BitSet(new long[]{0x0000000000010000L,0x0000000100028000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression6834 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression6876 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6880 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression6918 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6922 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression6924 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6928 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression6967 = new BitSet(new long[]{0x0000000000020000L,0x0000001000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression6973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7014 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7018 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7061 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression7065 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7067 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression7167 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7169 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7173 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7175 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression7203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression7234 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7265 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_PLUS_in_add_expression7270 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7274 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7309 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression7314 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7318 = new BitSet(new long[]{0x0000000000000002L,0x0000010000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7353 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression7358 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7362 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7397 = new BitSet(new long[]{0x0002000000002002L,0x4000000000000000L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression7413 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7427 = new BitSet(new long[]{0x0002000000002002L,0x4000000000000000L});
	public static final BitSet FOLLOW_USE_in_use_schema_node7470 = new BitSet(new long[]{0x0000040000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node7473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node7479 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression7515 = new BitSet(new long[]{0x0008011000620400L,0x000A301000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression7520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression7548 = new BitSet(new long[]{0x0000000000000002L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression7551 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_array_expression7555 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression7557 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7590 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7604 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term7618 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7620 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7624 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term7640 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_term7642 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_term7646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7660 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7662 = new BitSet(new long[]{0x2008011020620400L,0x000B311000000001L,0x0000008040001004L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7666 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7668 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_WITHIN_in_term7673 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_GROUP_in_term7675 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7677 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_ORDER_in_term7679 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_term7681 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7685 = new BitSet(new long[]{0x0000200000001000L});
	public static final BitSet FOLLOW_ASC_in_term7690 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_DESC_in_term7694 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7697 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7722 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7724 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term7728 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7730 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7754 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7756 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term7760 = new BitSet(new long[]{0x2008011020620400L,0x000B311000000001L,0x0000008040001004L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7764 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7766 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term7789 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term7801 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7805 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7807 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term7825 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7827 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_term7831 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term7833 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_term7837 = new BitSet(new long[]{0x0000000000000400L,0x0000003000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_LPAREN_in_term7840 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7844 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_term7847 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7851 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7855 = new BitSet(new long[]{0x0000000000000400L,0x0000002000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_ARRAY_in_term7862 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7867 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7869 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_term7874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7897 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_CURRENT_in_term7901 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_VALUE_in_term7904 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7906 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7910 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7938 = new BitSet(new long[]{0x0008010000020000L,0x000A100000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7943 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_VALUES_in_term7945 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7947 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7951 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7996 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions8002 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions8008 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8039 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths8045 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000008040000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8051 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8084 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions8092 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8098 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8129 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types8136 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8142 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument8167 = new BitSet(new long[]{0x0000080200000402L,0x000002B000000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument8170 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8174 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_function_argument8177 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8181 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument8185 = new BitSet(new long[]{0x0000080200000402L,0x000002A000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument8191 = new BitSet(new long[]{0x0000080200000002L,0x000002A000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument8197 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8202 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument8206 = new BitSet(new long[]{0x0000080200000002L,0x0000028000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument8215 = new BitSet(new long[]{0x0000080000000002L,0x0000028000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument8220 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument8222 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_function_argument8228 = new BitSet(new long[]{0x0000000000000002L,0x0000028000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument8233 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument8235 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_function_argument8241 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument8247 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument8249 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_function_argument8255 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list8285 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8291 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list8297 = new BitSet(new long[]{0x0008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8303 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list8310 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name8331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name8358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8386 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8400 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name8402 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_identifier_in_table_name8406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8434 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8448 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name8450 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name8454 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_identifier8481 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind8513 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind8527 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal8573 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal8587 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal8602 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal8619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal8631 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal8644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal8658 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8662 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal8693 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name8721 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name8734 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier8763 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved8790 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8817 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8821 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8824 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8828 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8830 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8834 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8841 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8845 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8851 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8861 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8864 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8868 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8870 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8874 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8881 = new BitSet(new long[]{0x2008011000620400L,0x000B311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8885 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8891 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL6561 = new BitSet(new long[]{0x2008011000620400L,0x000A311000000001L,0x0000008040000004L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6564 = new BitSet(new long[]{0x0000000000000002L});
}
