/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;

public class CompatUtil {
    private CompatUtil() {
    }

    public static int getCellSerializedSize(Cell cell) {
        return cell.getSerializedSize();
    }

    public static ListMultimap<String, ? extends Permission> readPermissions(byte[] data, Configuration conf) throws DeserializationException {
        return AccessControlLists.readPermissions((byte[])data, (Configuration)conf);
    }

    public static HFileContextBuilder withComparator(HFileContextBuilder contextBuilder, CellComparatorImpl cellComparator) {
        return contextBuilder;
    }

    public static StoreFileWriter.Builder withComparator(StoreFileWriter.Builder builder, CellComparatorImpl cellComparator) {
        return builder.withComparator((CellComparator)cellComparator);
    }

    public static Scan getScanForTableName(Connection conn, TableName tableName) {
        return MetaTableAccessor.getScanForTableName((Connection)conn, (TableName)tableName);
    }

    public static boolean isAnyStoreRefCountLeaked(Admin admin) throws IOException {
        return false;
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        return HStore.getChecksumType((Configuration)conf);
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return HStore.getBytesPerChecksum((Configuration)conf);
    }
}

