/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatUtil.class);

    private CompatUtil() {
    }

    public static int getCellSerializedSize(Cell cell) {
        return cell.getSerializedSize();
    }

    public static ListMultimap<String, ? extends Permission> readPermissions(byte[] data, Configuration conf) throws DeserializationException {
        return PermissionStorage.readPermissions((byte[])data, (Configuration)conf);
    }

    public static HFileContext createHFileContext(Configuration conf, Compression.Algorithm compression, Integer blockSize, DataBlockEncoding encoding, CellComparator comparator) {
        return new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType((Configuration)conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum((Configuration)conf)).withBlockSize(blockSize.intValue()).withDataBlockEncoding(encoding).build();
    }

    public static HFileContextBuilder withComparator(HFileContextBuilder contextBuilder, CellComparatorImpl cellComparator) {
        return contextBuilder.withCellComparator((CellComparator)cellComparator);
    }

    public static StoreFileWriter.Builder withComparator(StoreFileWriter.Builder builder, CellComparatorImpl cellComparator) {
        return builder;
    }

    public static Scan getScanForTableName(Connection conn, TableName tableName) {
        return MetaTableAccessor.getScanForTableName((Connection)conn, (TableName)tableName);
    }

    public static synchronized boolean isAnyStoreRefCountLeaked(Admin admin) throws IOException {
        for (int retries = 5; retries > 0; --retries) {
            boolean isStoreRefCountLeaked = CompatUtil.isStoreRefCountLeaked(admin);
            if (!isStoreRefCountLeaked) {
                return false;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while sleeping", (Throwable)e);
                break;
            }
        }
        return true;
    }

    private static boolean isStoreRefCountLeaked(Admin admin) throws IOException {
        for (ServerName serverName : admin.getRegionServers()) {
            for (RegionMetrics regionMetrics : admin.getRegionMetrics(serverName)) {
                int regionTotalRefCount;
                if (regionMetrics.getNameAsString().contains(TableName.META_TABLE_NAME.getNameAsString()) || (regionTotalRefCount = regionMetrics.getStoreRefCount()) <= 0) continue;
                LOGGER.error("Region {} has refCount leak. Total refCount of all storeFiles combined for the region: {}", (Object)regionMetrics.getNameAsString(), (Object)regionTotalRefCount);
                return true;
            }
        }
        return false;
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        return HStore.getChecksumType((Configuration)conf);
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return HStore.getBytesPerChecksum((Configuration)conf);
    }
}

