/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatUtil.class);

    private CompatUtil() {
    }

    public static HFileContext createHFileContext(Configuration conf, Compression.Algorithm compression, Integer blockSize, DataBlockEncoding encoding, CellComparator comparator) {
        return new HFileContextBuilder().withCompression(compression).withChecksumType(StoreUtils.getChecksumType((Configuration)conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum((Configuration)conf)).withBlockSize(blockSize.intValue()).withDataBlockEncoding(encoding).build();
    }

    public static List<RegionInfo> getMergeRegions(Connection conn, RegionInfo regionInfo) throws IOException {
        return MetaTableAccessor.getMergeRegions((Connection)conn, (RegionInfo)regionInfo);
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        return StoreUtils.getChecksumType((Configuration)conf);
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return StoreUtils.getBytesPerChecksum((Configuration)conf);
    }

    public static Connection createShortCircuitConnection(Configuration configuration, RegionCoprocessorEnvironment env) throws IOException {
        return env.createConnection(configuration);
    }
}

