/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RuleBasedDataGenerator;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class SequentialDateDataGenerator
implements RuleBasedDataGenerator {
    private static DateTimeFormatter FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final Column columnRule;
    private final AtomicInteger counter;
    private final LocalDateTime startDateTime = LocalDateTime.parse(LocalDateTime.now().format(FMT), FMT);

    public SequentialDateDataGenerator(Column columnRule) {
        Preconditions.checkArgument(columnRule.getDataSequence() == DataSequence.SEQUENTIAL);
        Preconditions.checkArgument(this.isDateType(columnRule.getType()));
        this.columnRule = columnRule;
        this.counter = new AtomicInteger(0);
    }

    @VisibleForTesting
    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    @Override
    public DataValue getDataValue() {
        LocalDateTime newDateTime = this.startDateTime.plusSeconds(this.counter.getAndIncrement());
        String formattedDateTime = newDateTime.format(FMT);
        return new DataValue(this.columnRule.getType(), formattedDateTime);
    }

    boolean isDateType(DataTypeMapping mapping) {
        switch (mapping) {
            case DATE: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }
}

