/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.HandlerFactory;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactory;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactoryImpl;
import org.eclipse.jetty.server.Handler;

public final class Main
extends Configured
implements Tool,
Runnable {
    protected static final Log LOG = LogFactory.getLog(Main.class);
    private final String[] argv;
    private final CountDownLatch runningLatch = new CountDownLatch(1);
    private HttpServer server = null;
    private int retCode = 0;
    private Throwable t = null;

    public static void logJVMInfo() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        if (runtime != null) {
            LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
            LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        }
    }

    public static void logProcessInfo(Configuration conf) {
        if (conf == null || !conf.getBoolean("phoenix.queryserver.envvars.logging.disabled", false)) {
            String[] confSkipWords;
            HashSet<String> skipWords = new HashSet<String>(QueryServicesOptions.DEFAULT_QUERY_SERVER_SKIP_WORDS);
            if (conf != null && (confSkipWords = conf.getStrings("phoenix.queryserver.envvars.logging.skipwords")) != null) {
                skipWords.addAll(Arrays.asList(confSkipWords));
            }
            block0: for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = entry.getKey().toLowerCase();
                String value = entry.getValue().toLowerCase();
                for (String skipWord : skipWords) {
                    if (!key.contains(skipWord) && !value.contains(skipWord)) continue;
                    continue block0;
                }
                LOG.info((Object)("env:" + entry));
            }
        }
        Main.logJVMInfo();
    }

    public Main() {
        this(null, null);
    }

    public Main(String[] argv, Configuration conf) {
        this.argv = argv;
        this.setConf(conf);
    }

    @VisibleForTesting
    public int getPort() {
        if (this.server == null) {
            return -1;
        }
        return this.server.getPort();
    }

    @VisibleForTesting
    public int getRetCode() {
        return this.retCode;
    }

    @VisibleForTesting
    public Throwable getThrowable() {
        return this.t;
    }

    public void awaitRunning() throws InterruptedException {
        this.runningLatch.await();
    }

    public void awaitRunning(long timeout, TimeUnit unit) throws InterruptedException {
        this.runningLatch.await(timeout, unit);
    }

    public int run(String[] args) throws Exception {
        Main.logProcessInfo(this.getConf());
        try {
            if ("kerberos".equalsIgnoreCase(this.getConf().get("hbase.security.authentication"))) {
                String hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)this.getConf().get("phoenix.queryserver.dns.interface", "default"), (String)this.getConf().get("phoenix.queryserver.dns.nameserver", "default")));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Login to " + hostname + " using " + this.getConf().get("phoenix.queryserver.keytab.file") + " and principal " + this.getConf().get("phoenix.queryserver.kerberos.principal") + "."));
                }
                SecurityUtil.login((Configuration)this.getConf(), (String)"phoenix.queryserver.keytab.file", (String)"phoenix.queryserver.kerberos.principal", (String)hostname);
                LOG.info((Object)"Login successful.");
            }
            Class factoryClass = this.getConf().getClass("phoenix.queryserver.metafactory.class", PhoenixMetaFactoryImpl.class, PhoenixMetaFactory.class);
            int port = this.getConf().getInt("phoenix.queryserver.http.port", 8765);
            LOG.debug((Object)("Listening on port " + port));
            PhoenixMetaFactory factory = (PhoenixMetaFactory)factoryClass.getDeclaredConstructor(Configuration.class).newInstance(this.getConf());
            Meta meta = factory.create(Arrays.asList(args));
            HandlerFactory handlerFactory = new HandlerFactory();
            LocalService service = new LocalService(meta);
            this.server = new HttpServer(port, this.getHandler(this.getConf(), (Service)service, handlerFactory));
            this.server.start();
            this.runningLatch.countDown();
            this.server.join();
            return 0;
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Unrecoverable service error. Shutting down.", t);
            this.t = t;
            return -1;
        }
    }

    Handler getHandler(Configuration conf, Service service, HandlerFactory handlerFactory) {
        Driver.Serialization serialization;
        String serializationName = conf.get("phoenix.queryserver.serialization", "PROTOBUF");
        try {
            serialization = Driver.Serialization.valueOf((String)serializationName);
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown message serialization type for " + serializationName));
            throw e;
        }
        Handler handler = handlerFactory.getHandler(service, serialization);
        LOG.info((Object)("Instantiated " + handler.getClass() + " for QueryServer"));
        return handler;
    }

    @Override
    public void run() {
        try {
            this.retCode = this.run(this.argv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Main(), (String[])argv);
        System.exit(ret);
    }
}

