/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.jdbc.JdbcMeta;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactory;
import org.apache.phoenix.util.QueryUtil;

public class PhoenixMetaFactoryImpl
extends Configured
implements PhoenixMetaFactory {
    public PhoenixMetaFactoryImpl() {
        super(HBaseConfiguration.create());
    }

    public PhoenixMetaFactoryImpl(Configuration conf) {
        super(conf);
    }

    public Meta create(List<String> args) {
        Configuration conf = (Configuration)Preconditions.checkNotNull((Object)this.getConf(), (Object)"Configuration must not be null.");
        Properties info = new Properties();
        info.putAll((Map<?, ?>)conf.getValByRegex("avatica.*"));
        try {
            String url;
            if (args.size() == 0) {
                url = QueryUtil.getConnectionUrl((Properties)info, (Configuration)conf);
            } else if (args.size() == 1) {
                url = args.get(0);
            } else {
                throw new RuntimeException("0 or 1 argument expected. Received " + Arrays.toString(args.toArray()));
            }
            return new JdbcMeta(url, info);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

