/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.spark;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.util.ColumnInfo;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ConfigurationUtil$
implements Serializable {
    public static final ConfigurationUtil$ MODULE$;

    static {
        new ConfigurationUtil$();
    }

    public Configuration getOutputConfiguration(String tableName, Seq<String> columns, Option<String> zkUrl, Option<Configuration> conf) {
        Configuration configuration;
        Option<Configuration> option = conf;
        if (option instanceof Some) {
            Some some = (Some)option;
            Configuration c = (Configuration)some.x();
            configuration = HBaseConfiguration.create((Configuration)c);
        } else {
            configuration = HBaseConfiguration.create();
        }
        Configuration config = configuration;
        PhoenixConfigurationUtil.setOutputTableName((Configuration)config, (String)tableName);
        PhoenixConfigurationUtil.setPhysicalTableName((Configuration)config, (String)tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames((Configuration)config, (String[])((String[])Array$.MODULE$.apply(columns, ClassTag$.MODULE$.apply(String.class))));
        Option<String> option2 = zkUrl;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String url = (String)some.x();
            config.set("hbase.zookeeper.quorum", url);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (config.get("hbase.zookeeper.quorum") == null) {
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"One of zkUrl or '", "' config property must be provided"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hbase.zookeeper.quorum"})));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return config;
    }

    public Option<Configuration> getOutputConfiguration$default$4() {
        return None$.MODULE$;
    }

    public void encodeColumns(Configuration conf) {
        ColumnInfoToStringEncoderDecoder.encode((Configuration)conf, (java.util.List)PhoenixConfigurationUtil.getUpsertColumnMetadataList((Configuration)conf));
    }

    public List<ColumnInfo> decodeColumns(Configuration conf) {
        return JavaConversions$.MODULE$.asScalaBuffer(ColumnInfoToStringEncoderDecoder.decode((Configuration)conf)).toList();
    }

    public Option<String> getZookeeperURL(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get("hbase.zookeeper.quorum"));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ConfigurationUtil$() {
        MODULE$ = this;
    }
}

