/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tracingwebapp.http;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;

public final class Main
extends Configured
implements Tool {
    protected static final Log LOG = LogFactory.getLog(Main.class);
    public static final String PHONIX_DBSERVER_PORT_KEY = "phoenix.dbserver.port";
    public static final int DEFAULT_DBSERVER_PORT = 2181;
    public static final String PHONIX_DBSERVER_HOST_KEY = "phoenix.dbserver.host";
    public static final String DEFAULT_DBSERVER_HOST = "localhost";
    public static final String TRACE_SERVER_HTTP_PORT_KEY = "phoenix.traceserver.http.port";
    public static final int DEFAULT_HTTP_PORT = 8864;
    public static final String TRACE_SERVER_HTTP_JETTY_HOME_KEY = "phoenix.traceserver.http.home";
    public static final String DEFAULT_HTTP_HOME = "/";
    public static final String DEFAULT_WEBAPP_DIR_LOCATION = "src/main/webapp";

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Main(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] arg0) throws Exception {
        int port = this.getConf().getInt(TRACE_SERVER_HTTP_PORT_KEY, 8864);
        BasicConfigurator.configure();
        String home = this.getConf().get(TRACE_SERVER_HTTP_JETTY_HOME_KEY, DEFAULT_HTTP_HOME);
        Server server = new Server(port);
        WebAppContext root = new WebAppContext();
        URL webAppDir = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_WEBAPP_DIR_LOCATION);
        if (webAppDir == null) {
            throw new RuntimeException(String.format("No %s directory was found into the JAR file", DEFAULT_WEBAPP_DIR_LOCATION));
        }
        root.setContextPath(home);
        root.setDescriptor("src/main/webapp/WEB-INF/web.xml");
        root.setResourceBase(webAppDir.toURI().toString());
        root.setParentLoaderPriority(true);
        server.setHandler((Handler)root);
        server.start();
        server.join();
        return 0;
    }
}

