/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tracingwebapp.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.phoenix.tracingwebapp.http.ConnectionFactory;
import org.apache.phoenix.tracingwebapp.http.EntityFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class TraceServlet
extends HttpServlet {
    private static final long serialVersionUID = -354285100083055559L;
    private static Connection con;
    protected String DEFAULT_LIMIT = "25";
    protected String DEFAULT_COUNTBY = "hostname";
    protected String LOGIC_AND = "AND";
    protected String LOGIC_OR = "OR";
    protected String TRACING_TABLE = "SYSTEM.TRACING_STATS";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        String limit = request.getParameter("limit");
        String traceid = request.getParameter("traceid");
        String parentid = request.getParameter("parentid");
        String jsonObject = "{}";
        jsonObject = "getall".equals(action) ? this.getAll(limit) : ("getCount".equals(action) ? this.getCount("description") : ("getDistribution".equals(action) ? this.getCount(this.DEFAULT_COUNTBY) : ("searchTrace".equals(action) ? this.searchTrace(parentid, traceid, this.LOGIC_OR) : "{ \"Server\": \"Phoenix Tracing Web App\", \"API version\": 0.1 }")));
        response.setContentType("application/json");
        String output = jsonObject;
        PrintWriter out = response.getWriter();
        out.print(output);
        out.flush();
    }

    protected String getAll(String limit) {
        String json = null;
        if (limit == null) {
            limit = this.DEFAULT_LIMIT;
        }
        String sqlQuery = "SELECT * FROM " + this.TRACING_TABLE + " LIMIT " + limit;
        json = this.getResults(sqlQuery);
        return this.getJson(json);
    }

    protected String getCount(String countby) {
        String json = null;
        if (countby == null) {
            countby = this.DEFAULT_COUNTBY;
        }
        String sqlQuery = "SELECT " + countby + ", COUNT(*) AS count FROM " + this.TRACING_TABLE + " GROUP BY " + countby + " HAVING COUNT(*) > 1 ";
        json = this.getResults(sqlQuery);
        return json;
    }

    protected String searchTrace(String parentId, String traceId, String logic) {
        String json = null;
        String query = null;
        if (parentId != null && traceId != null) {
            query = "SELECT * FROM " + this.TRACING_TABLE + " WHERE parent_id=" + parentId + " " + logic + " trace_id=" + traceId;
        } else if (parentId != null && traceId == null) {
            query = "SELECT * FROM " + this.TRACING_TABLE + " WHERE parent_id=" + parentId;
        } else if (parentId == null && traceId != null) {
            query = "SELECT * FROM " + this.TRACING_TABLE + " WHERE trace_id=" + traceId;
        }
        json = this.getResults(query);
        return this.getJson(json);
    }

    protected String getJson(String json) {
        String output = json.toString().replace("_id\":", "_id\":\"").replace(",\"hostname", "\",\"hostname").replace(",\"parent", "\",\"parent").replace(",\"end", "\",\"end");
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResults(String sqlQuery) {
        String json = null;
        if (sqlQuery == null) {
            json = "{error:true,msg:'SQL was null'}";
        } else {
            try {
                con = ConnectionFactory.getConnection();
                EntityFactory nutrientEntityFactory = new EntityFactory(con, sqlQuery);
                List<Map<String, Object>> nutrients = nutrientEntityFactory.findMultiple(new Object[0]);
                ObjectMapper mapper = new ObjectMapper();
                json = mapper.writeValueAsString(nutrients);
            }
            catch (Exception e) {
                json = "{error:true,msg:'Serrver Error:" + e.getMessage() + "'}";
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        json = "{error:true,msg:'SQL Serrver Error:" + e.getMessage() + "'}";
                    }
                }
            }
        }
        return json;
    }
}

