/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataType;
import org.apache.pig.piggybank.storage.avro.AvroStorageLog;
import org.apache.pig.piggybank.storage.avro.AvroStorageUtils;
import org.codehaus.jackson.JsonNode;

public class PigSchema2Avro {
    public static final String TUPLE_NAME = "TUPLE";
    public static final String FIELD_NAME = "FIELD";
    public static int tupleIndex = 0;

    public static Schema convert(ResourceSchema pigSchema, boolean nullable) throws IOException {
        ResourceSchema.ResourceFieldSchema[] pigFields = pigSchema.getFields();
        if (pigFields.length == 1) {
            AvroStorageLog.details("Ignore the pig tuple wrapper.");
            return PigSchema2Avro.convert(pigFields[0], nullable);
        }
        return PigSchema2Avro.convertRecord(pigFields, nullable);
    }

    protected static Schema convert(ResourceSchema.ResourceFieldSchema pigSchema, boolean nullable) throws IOException {
        AvroStorageLog.details("Convert pig field schema:" + pigSchema);
        byte pigType = pigSchema.getType();
        if (pigType == 110) {
            AvroStorageLog.details("Convert a pig field tuple: " + pigSchema);
            ResourceSchema.ResourceFieldSchema[] listSchemas = pigSchema.getSchema().getFields();
            Schema outSchema = null;
            if (AvroStorageUtils.isTupleWrapper(pigSchema)) {
                AvroStorageLog.details("Ignore the pig tuple wrapper.");
                if (listSchemas.length != 1) {
                    throw new IOException("Expect one subfield from " + pigSchema);
                }
                outSchema = PigSchema2Avro.convert(listSchemas[0], nullable);
            } else {
                outSchema = PigSchema2Avro.convertRecord(listSchemas, nullable);
            }
            return AvroStorageUtils.wrapAsUnion(outSchema, nullable);
        }
        if (pigType == 120) {
            AvroStorageLog.details("Convert a pig field bag:" + pigSchema);
            ResourceSchema.ResourceFieldSchema[] fs = pigSchema.getSchema().getFields();
            if (fs == null || fs.length != 1 || fs[0].getType() != 110) {
                throw new IOException("Expect one tuple field in a bag");
            }
            Schema outSchema = Schema.createArray((Schema)PigSchema2Avro.convert(fs[0], nullable));
            return AvroStorageUtils.wrapAsUnion(outSchema, nullable);
        }
        if (pigType == 100) {
            throw new IOException("Please provide schema for Map field!");
        }
        if (pigType == 0) {
            throw new IOException("Must specify a schema for UNKNOWN pig type.");
        }
        if (pigType == 55 || pigType == 60 || pigType == 5 || pigType == 6 || pigType == 50 || pigType == 25 || pigType == 20 || pigType == 10 || pigType == 15) {
            AvroStorageLog.details("Convert a pig field primitive:" + pigSchema);
            Schema outSchema = PigSchema2Avro.convertPrimitiveType(pigType);
            return AvroStorageUtils.wrapAsUnion(outSchema, nullable);
        }
        throw new IOException("unsupported pig type:" + DataType.findTypeName((byte)pigType));
    }

    protected static Schema convertRecord(ResourceSchema.ResourceFieldSchema[] pigFields, boolean nullable) throws IOException {
        AvroStorageLog.funcCall("convertRecord");
        String typeName = PigSchema2Avro.getRecordName();
        Schema outSchema = Schema.createRecord((String)typeName, null, null, (boolean)false);
        ArrayList<Schema.Field> outFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < pigFields.length; ++i) {
            Schema fieldSchema = PigSchema2Avro.convert(pigFields[i], nullable);
            String outname = pigFields[i].getName();
            if (outname == null) {
                outname = "FIELD_" + i;
            }
            String desc = pigFields[i].getDescription();
            outFields.add(new Schema.Field(outname, fieldSchema, desc, null));
        }
        outSchema.setFields(outFields);
        return outSchema;
    }

    public static void setTupleIndex(int index) {
        tupleIndex = index;
    }

    private static String getRecordName() {
        String name = "TUPLE_" + tupleIndex;
        ++tupleIndex;
        return name;
    }

    protected static Schema convertPrimitiveType(byte pigType) throws IOException {
        if (pigType == 5) {
            return AvroStorageUtils.BooleanSchema;
        }
        if (pigType == 50) {
            return AvroStorageUtils.BytesSchema;
        }
        if (pigType == 55 || pigType == 60) {
            return AvroStorageUtils.StringSchema;
        }
        if (pigType == 25) {
            return AvroStorageUtils.DoubleSchema;
        }
        if (pigType == 20) {
            return AvroStorageUtils.FloatSchema;
        }
        if (pigType == 10) {
            return AvroStorageUtils.IntSchema;
        }
        if (pigType == 15) {
            return AvroStorageUtils.LongSchema;
        }
        throw new IOException("unsupported pig type:" + DataType.findTypeName((byte)pigType));
    }

    public static Schema validateAndConvert(Schema avroSchema, ResourceSchema pigSchema) throws IOException {
        return PigSchema2Avro.validateAndConvertRecord(avroSchema, pigSchema.getFields());
    }

    protected static Schema validateAndConvert(Schema avroSchema, ResourceSchema.ResourceFieldSchema pigSchema) throws IOException {
        AvroStorageLog.details("Validate pig field schema:" + pigSchema);
        if (!PigSchema2Avro.isCompatible(avroSchema, pigSchema)) {
            throw new IOException("Schemas are not compatible.\n Avro=" + avroSchema + "\n" + "Pig=" + pigSchema);
        }
        byte pigType = pigSchema.getType();
        if (avroSchema.getType().equals((Object)Schema.Type.UNION)) {
            AvroStorageLog.details("Validate Pig schema with Avro union:" + avroSchema);
            List unionSchemas = avroSchema.getTypes();
            for (Schema schema : unionSchemas) {
                try {
                    Schema s = PigSchema2Avro.validateAndConvert(schema, pigSchema);
                    return avroSchema;
                }
                catch (IOException iOException) {
                }
            }
            throw new IOException("pig schema " + pigSchema + " is not compatible with avro " + avroSchema);
        }
        if (pigType == 110) {
            AvroStorageLog.details("Validate a pig tuple: " + pigSchema);
            ResourceSchema.ResourceFieldSchema[] pigFields = pigSchema.getSchema().getFields();
            Schema outSchema = PigSchema2Avro.validateAndConvertRecord(avroSchema, pigFields);
            return outSchema;
        }
        if (pigType == 120) {
            AvroStorageLog.details("Validate a pig bag:" + pigSchema);
            ResourceSchema.ResourceFieldSchema[] fs = pigSchema.getSchema().getFields();
            if (fs == null || fs.length != 1 || fs[0].getType() != 110) {
                throw new IOException("Expect one tuple field in a bag");
            }
            Schema inElemSchema = avroSchema.getElementType();
            Schema outSchema = Schema.createArray((Schema)PigSchema2Avro.validateAndConvert(inElemSchema, fs[0]));
            return outSchema;
        }
        if (pigType == 100) {
            AvroStorageLog.details("Cannot validate a pig map. Will use user defined Avro schema.");
            return avroSchema;
        }
        if (pigType == 0 || pigType == 55 || pigType == 60 || pigType == 5 || pigType == 6 || pigType == 50 || pigType == 25 || pigType == 20 || pigType == 10 || pigType == 15) {
            AvroStorageLog.details("Validate a pig primitive type:" + pigSchema);
            return avroSchema;
        }
        throw new IOException("Unsupported pig type:" + DataType.findTypeName((byte)pigType));
    }

    protected static Schema validateAndConvertRecord(Schema avroSchema, ResourceSchema.ResourceFieldSchema[] pigFields) throws IOException {
        if (!avroSchema.getType().equals((Object)Schema.Type.RECORD)) {
            if (pigFields.length != 1) {
                throw new IOException("Expect only one field in Pig tuple schema. Avro schema is " + avroSchema.getType());
            }
            return PigSchema2Avro.validateAndConvert(avroSchema, pigFields[0]);
        }
        boolean isPartialSchema = AvroStorageUtils.isUDPartialRecordSchema(avroSchema);
        AvroStorageLog.details("isPartialSchema=" + isPartialSchema);
        String typeName = isPartialSchema ? PigSchema2Avro.getRecordName() : avroSchema.getName();
        Schema outSchema = Schema.createRecord((String)typeName, (String)avroSchema.getDoc(), (String)avroSchema.getNamespace(), (boolean)false);
        List inFields = avroSchema.getFields();
        if (!isPartialSchema && inFields.size() != pigFields.length) {
            throw new IOException("Expect " + inFields.size() + " fields in pig schema." + " But there are " + pigFields.length);
        }
        ArrayList<Schema.Field> outFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < pigFields.length; ++i) {
            String outname;
            Schema.Field inputField = isPartialSchema ? AvroStorageUtils.getUDField(avroSchema, i) : (Schema.Field)inFields.get(i);
            Schema fieldSchema = null;
            fieldSchema = inputField == null ? PigSchema2Avro.convert(pigFields[i], true) : (inputField.schema() == null ? PigSchema2Avro.convert(pigFields[i], false) : PigSchema2Avro.validateAndConvert(inputField.schema(), pigFields[i]));
            String string = outname = isPartialSchema ? pigFields[i].getName() : inputField.name();
            if (outname == null) {
                outname = "FIELD_" + i;
            }
            String doc = isPartialSchema ? pigFields[i].getDescription() : inputField.doc();
            JsonNode defaultvalue = inputField != null ? inputField.defaultValue() : null;
            outFields.add(new Schema.Field(outname, fieldSchema, doc, defaultvalue));
        }
        outSchema.setFields(outFields);
        return outSchema;
    }

    protected static boolean isCompatible(Schema avroSchema, ResourceSchema.ResourceFieldSchema pigSchema) {
        Schema.Type avroType = avroSchema.getType();
        byte pigType = pigSchema.getType();
        if (avroType.equals((Object)Schema.Type.UNION)) {
            return true;
        }
        if (pigType == 110) {
            return true;
        }
        return avroType.equals((Object)Schema.Type.ARRAY) && pigType == 120 || avroType.equals((Object)Schema.Type.MAP) && pigType == 100 || avroType.equals((Object)Schema.Type.STRING) && pigType == 55 || pigType == 60 || avroType.equals((Object)Schema.Type.ENUM) && pigType == 55 || avroType.equals((Object)Schema.Type.BOOLEAN) && pigType == 5 || pigType == 10 || avroType.equals((Object)Schema.Type.BYTES) && pigType == 50 || avroType.equals((Object)Schema.Type.DOUBLE) && pigType == 25 || pigType == 20 || pigType == 10 || pigType == 15 || avroType.equals((Object)Schema.Type.FLOAT) && pigType == 20 || pigType == 10 || pigType == 15 || avroType.equals((Object)Schema.Type.FIXED) && pigType == 50 || avroType.equals((Object)Schema.Type.INT) && pigType == 10 || avroType.equals((Object)Schema.Type.LONG) && pigType == 15 || pigType == 10;
    }
}

