/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.utils.SchemaUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.spi.config.provider.PinotConfigProvider;
import org.apache.pinot.spi.config.provider.SchemaChangeListener;
import org.apache.pinot.spi.config.provider.TableConfigChangeListener;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCache
implements PinotConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableCache.class);
    private static final String TABLE_CONFIG_PARENT_PATH = "/CONFIGS/TABLE";
    private static final String TABLE_CONFIG_PATH_PREFIX = "/CONFIGS/TABLE/";
    private static final String SCHEMA_PARENT_PATH = "/SCHEMAS";
    private static final String SCHEMA_PATH_PREFIX = "/SCHEMAS/";
    private static final String LOWER_CASE_OFFLINE_TABLE_SUFFIX = "_offline";
    private static final String LOWER_CASE_REALTIME_TABLE_SUFFIX = "_realtime";
    private final Set<TableConfigChangeListener> _tableConfigChangeListeners = ConcurrentHashMap.newKeySet();
    private final Set<SchemaChangeListener> _schemaChangeListeners = ConcurrentHashMap.newKeySet();
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final boolean _caseInsensitive;
    private final ZkTableConfigChangeListener _zkTableConfigChangeListener = new ZkTableConfigChangeListener();
    private final Map<String, TableConfig> _tableConfigMap = new ConcurrentHashMap<String, TableConfig>();
    private final Map<String, String> _schemaNameMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> _tableNameMap;
    private final ZkSchemaChangeListener _zkSchemaChangeListener = new ZkSchemaChangeListener();
    private final Map<String, SchemaInfo> _schemaInfoMap = new ConcurrentHashMap<String, SchemaInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCache(ZkHelixPropertyStore<ZNRecord> propertyStore, boolean caseInsensitive) {
        ArrayList<String> pathsToAdd;
        List tables;
        this._propertyStore = propertyStore;
        this._caseInsensitive = caseInsensitive;
        this._tableNameMap = caseInsensitive ? new ConcurrentHashMap() : null;
        Object object = this._zkTableConfigChangeListener;
        synchronized (object) {
            this._propertyStore.subscribeChildChanges(TABLE_CONFIG_PARENT_PATH, (IZkChildListener)this._zkTableConfigChangeListener);
            tables = this._propertyStore.getChildNames(TABLE_CONFIG_PARENT_PATH, AccessOption.PERSISTENT);
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                pathsToAdd = new ArrayList<String>(tables.size());
                for (String tableNameWithType : tables) {
                    pathsToAdd.add(TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
                }
                this.addTableConfigs(pathsToAdd);
            }
        }
        object = this._zkSchemaChangeListener;
        synchronized (object) {
            this._propertyStore.subscribeChildChanges(SCHEMA_PARENT_PATH, (IZkChildListener)this._zkSchemaChangeListener);
            tables = this._propertyStore.getChildNames(SCHEMA_PARENT_PATH, AccessOption.PERSISTENT);
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                pathsToAdd = new ArrayList(tables.size());
                for (String rawTableName : tables) {
                    pathsToAdd.add(SCHEMA_PATH_PREFIX + rawTableName);
                }
                this.addSchemas(pathsToAdd);
            }
        }
        LOGGER.info("Initialized TableCache with caseInsensitive: {}", (Object)caseInsensitive);
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    @Nullable
    public String getActualTableName(String caseInsensitiveTableName) {
        Preconditions.checkState((boolean)this._caseInsensitive, (Object)"TableCache is not case-insensitive");
        return this._tableNameMap.get(caseInsensitiveTableName.toLowerCase());
    }

    @Nullable
    public Map<String, String> getColumnNameMap(String rawTableName) {
        String schemaName = this._schemaNameMap.getOrDefault(rawTableName, rawTableName);
        SchemaInfo schemaInfo = this._schemaInfoMap.getOrDefault(schemaName, this._schemaInfoMap.get(rawTableName));
        return schemaInfo != null ? schemaInfo._columnNameMap : null;
    }

    @Nullable
    public TableConfig getTableConfig(String tableNameWithType) {
        return this._tableConfigMap.get(tableNameWithType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableConfig> registerTableConfigChangeListener(TableConfigChangeListener tableConfigChangeListener) {
        ZkTableConfigChangeListener zkTableConfigChangeListener = this._zkTableConfigChangeListener;
        synchronized (zkTableConfigChangeListener) {
            this._tableConfigChangeListeners.add(tableConfigChangeListener);
            return Lists.newArrayList(this._tableConfigMap.values());
        }
    }

    @Nullable
    public Schema getSchema(String rawTableName) {
        String schemaName = this._schemaNameMap.getOrDefault(rawTableName, rawTableName);
        SchemaInfo schemaInfo = this._schemaInfoMap.get(schemaName);
        return schemaInfo != null ? schemaInfo._schema : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schema> registerSchemaChangeListener(SchemaChangeListener schemaChangeListener) {
        ZkSchemaChangeListener zkSchemaChangeListener = this._zkSchemaChangeListener;
        synchronized (zkSchemaChangeListener) {
            this._schemaChangeListeners.add(schemaChangeListener);
            return this._schemaInfoMap.values().stream().map(s -> s._schema).collect(Collectors.toList());
        }
    }

    private void addTableConfigs(List<String> paths) {
        for (String path : paths) {
            this._propertyStore.subscribeDataChanges(path, (IZkDataListener)this._zkTableConfigChangeListener);
        }
        List znRecords = this._propertyStore.get(paths, null, AccessOption.PERSISTENT);
        for (ZNRecord znRecord : znRecords) {
            if (znRecord == null) continue;
            try {
                this.putTableConfig(znRecord);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding table config for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            }
        }
    }

    private void putTableConfig(ZNRecord znRecord) throws IOException {
        TableConfig tableConfig = TableConfigUtils.fromZNRecord(znRecord);
        String tableNameWithType = tableConfig.getTableName();
        this._tableConfigMap.put(tableNameWithType, tableConfig);
        String schemaName = tableConfig.getValidationConfig().getSchemaName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        if (schemaName != null && !schemaName.equals(rawTableName)) {
            this._schemaNameMap.put(tableNameWithType, schemaName);
            this._schemaNameMap.put(rawTableName, schemaName);
        } else {
            this.removeSchemaName(tableNameWithType);
        }
        if (this._caseInsensitive) {
            this._tableNameMap.put(tableNameWithType.toLowerCase(), tableNameWithType);
            this._tableNameMap.put(rawTableName.toLowerCase(), rawTableName);
        }
    }

    private void removeTableConfig(String path) {
        this._propertyStore.unsubscribeDataChanges(path, (IZkDataListener)this._zkTableConfigChangeListener);
        String tableNameWithType = path.substring(TABLE_CONFIG_PATH_PREFIX.length());
        this._tableConfigMap.remove(tableNameWithType);
        this.removeSchemaName(tableNameWithType);
        if (this._caseInsensitive) {
            this._tableNameMap.remove(tableNameWithType.toLowerCase());
            String lowerCaseRawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType).toLowerCase();
            if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
                if (!this._tableNameMap.containsKey(lowerCaseRawTableName + LOWER_CASE_REALTIME_TABLE_SUFFIX)) {
                    this._tableNameMap.remove(lowerCaseRawTableName);
                }
            } else if (!this._tableNameMap.containsKey(lowerCaseRawTableName + LOWER_CASE_OFFLINE_TABLE_SUFFIX)) {
                this._tableNameMap.remove(lowerCaseRawTableName);
            }
        }
    }

    private void removeSchemaName(String tableNameWithType) {
        if (this._schemaNameMap.remove(tableNameWithType) != null) {
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
            if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
                if (!this._schemaNameMap.containsKey(TableNameBuilder.REALTIME.tableNameWithType(rawTableName))) {
                    this._schemaNameMap.remove(rawTableName);
                }
            } else if (!this._schemaNameMap.containsKey(TableNameBuilder.OFFLINE.tableNameWithType(rawTableName))) {
                this._schemaNameMap.remove(rawTableName);
            }
        }
    }

    private void addSchemas(List<String> paths) {
        for (String path : paths) {
            this._propertyStore.subscribeDataChanges(path, (IZkDataListener)this._zkSchemaChangeListener);
        }
        List znRecords = this._propertyStore.get(paths, null, AccessOption.PERSISTENT);
        for (ZNRecord znRecord : znRecords) {
            if (znRecord == null) continue;
            try {
                this.putSchema(znRecord);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding schema for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            }
        }
    }

    private void putSchema(ZNRecord znRecord) throws IOException {
        Schema schema = SchemaUtils.fromZNRecord(znRecord);
        TableCache.addBuiltInVirtualColumns(schema);
        String schemaName = schema.getSchemaName();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        if (this._caseInsensitive) {
            for (String columnName : schema.getColumnNames()) {
                columnNameMap.put(columnName.toLowerCase(), columnName);
            }
        } else {
            for (String columnName : schema.getColumnNames()) {
                columnNameMap.put(columnName, columnName);
            }
        }
        this._schemaInfoMap.put(schemaName, new SchemaInfo(schema, columnNameMap));
    }

    private static void addBuiltInVirtualColumns(Schema schema) {
        if (!schema.hasColumn("$docId")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$docId", FieldSpec.DataType.INT, true));
        }
        if (!schema.hasColumn("$hostName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$hostName", FieldSpec.DataType.STRING, true));
        }
        if (!schema.hasColumn("$segmentName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$segmentName", FieldSpec.DataType.STRING, true));
        }
    }

    private void removeSchema(String path) {
        this._propertyStore.unsubscribeDataChanges(path, (IZkDataListener)this._zkSchemaChangeListener);
        String schemaName = path.substring(SCHEMA_PATH_PREFIX.length());
        this._schemaInfoMap.remove(schemaName);
    }

    private void notifyTableConfigChangeListeners() {
        for (TableConfigChangeListener tableConfigChangeListener : this._tableConfigChangeListeners) {
            tableConfigChangeListener.onChange((List)Lists.newArrayList(this._tableConfigMap.values()));
        }
    }

    private void notifySchemaChangeListeners() {
        for (SchemaChangeListener schemaChangeListener : this._schemaChangeListeners) {
            schemaChangeListener.onChange(this._schemaInfoMap.values().stream().map(s -> s._schema).collect(Collectors.toList()));
        }
    }

    private static class SchemaInfo {
        final Schema _schema;
        final Map<String, String> _columnNameMap;

        private SchemaInfo(Schema schema, Map<String, String> columnNameMap) {
            this._schema = schema;
            this._columnNameMap = columnNameMap;
        }
    }

    private class ZkSchemaChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private ZkSchemaChangeListener() {
        }

        public synchronized void handleChildChange(String path, List<String> schemaNames) {
            if (CollectionUtils.isEmpty(schemaNames)) {
                return;
            }
            ArrayList<String> pathsToAdd = new ArrayList<String>();
            for (String schemaName : schemaNames) {
                if (TableCache.this._schemaInfoMap.containsKey(schemaName)) continue;
                pathsToAdd.add(TableCache.SCHEMA_PATH_PREFIX + schemaName);
            }
            if (!pathsToAdd.isEmpty()) {
                TableCache.this.addSchemas(pathsToAdd);
            }
            TableCache.this.notifySchemaChangeListeners();
        }

        public synchronized void handleDataChange(String path, Object data) {
            if (data != null) {
                ZNRecord znRecord = (ZNRecord)data;
                try {
                    TableCache.this.putSchema(znRecord);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while refreshing schema for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
                }
                TableCache.this.notifySchemaChangeListeners();
            }
        }

        public synchronized void handleDataDeleted(String path) {
            String schemaName = path.substring(path.lastIndexOf(47) + 1);
            TableCache.this.removeSchema(TableCache.SCHEMA_PATH_PREFIX + schemaName);
            TableCache.this.notifySchemaChangeListeners();
        }
    }

    private class ZkTableConfigChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private ZkTableConfigChangeListener() {
        }

        public synchronized void handleChildChange(String path, List<String> tableNamesWithType) {
            if (CollectionUtils.isEmpty(tableNamesWithType)) {
                return;
            }
            ArrayList<String> pathsToAdd = new ArrayList<String>();
            for (String tableNameWithType : tableNamesWithType) {
                if (TableCache.this._tableConfigMap.containsKey(tableNameWithType)) continue;
                pathsToAdd.add(TableCache.TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
            }
            if (!pathsToAdd.isEmpty()) {
                TableCache.this.addTableConfigs(pathsToAdd);
            }
            TableCache.this.notifyTableConfigChangeListeners();
        }

        public synchronized void handleDataChange(String path, Object data) {
            if (data != null) {
                ZNRecord znRecord = (ZNRecord)data;
                try {
                    TableCache.this.putTableConfig(znRecord);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while refreshing table config for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
                }
                TableCache.this.notifyTableConfigChangeListeners();
            }
        }

        public synchronized void handleDataDeleted(String path) {
            String tableNameWithType = path.substring(path.lastIndexOf(47) + 1);
            TableCache.this.removeTableConfig(TableCache.TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
            TableCache.this.notifyTableConfigChangeListeners();
        }
    }
}

