/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.zookeeper.data.Stat;

public final class MinionTaskMetadataUtils {
    private MinionTaskMetadataUtils() {
    }

    @Nullable
    public static ZNRecord fetchTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        Stat stat;
        String path = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskType, tableNameWithType);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat = new Stat(), AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    public static void deleteTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        String path = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskType, tableNameWithType);
        if (!propertyStore.remove(path, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to delete task metadata: " + taskType + ", " + tableNameWithType);
        }
    }

    public static void persistTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, BaseTaskMetadata taskMetadata, int expectedVersion) {
        String path = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskType, taskMetadata.getTableNameWithType());
        if (!propertyStore.set(path, (Object)taskMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to persist minion metadata for task: " + taskType + " and metadata: " + taskMetadata);
        }
    }
}

