/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class FilterQuery
implements TBase<FilterQuery, _Fields>,
Serializable,
Cloneable,
Comparable<FilterQuery> {
    private static final TStruct STRUCT_DESC = new TStruct("FilterQuery");
    private static final TField ID_FIELD_DESC = new TField("id", 8, 1);
    private static final TField COLUMN_FIELD_DESC = new TField("column", 11, 2);
    private static final TField VALUE_FIELD_DESC = new TField("value", 15, 3);
    private static final TField OPERATOR_FIELD_DESC = new TField("operator", 8, 4);
    private static final TField NESTED_FILTER_QUERY_IDS_FIELD_DESC = new TField("nestedFilterQueryIds", 15, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new FilterQueryStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new FilterQueryTupleSchemeFactory();
    private int id;
    @Nullable
    private String column;
    @Nullable
    private List<String> value;
    @Nullable
    private FilterOperator operator;
    @Nullable
    private List<Integer> nestedFilterQueryIds;
    private static final int __ID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.COLUMN, _Fields.OPERATOR};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FilterQuery() {
    }

    public FilterQuery(int id, List<String> value, List<Integer> nestedFilterQueryIds) {
        this();
        this.id = id;
        this.setIdIsSet(true);
        this.value = value;
        this.nestedFilterQueryIds = nestedFilterQueryIds;
    }

    public FilterQuery(FilterQuery other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.id = other.id;
        if (other.isSetColumn()) {
            this.column = other.column;
        }
        if (other.isSetValue()) {
            ArrayList<String> __this__value = new ArrayList<String>(other.value);
            this.value = __this__value;
        }
        if (other.isSetOperator()) {
            this.operator = other.operator;
        }
        if (other.isSetNestedFilterQueryIds()) {
            ArrayList<Integer> __this__nestedFilterQueryIds = new ArrayList<Integer>(other.nestedFilterQueryIds);
            this.nestedFilterQueryIds = __this__nestedFilterQueryIds;
        }
    }

    public FilterQuery deepCopy() {
        return new FilterQuery(this);
    }

    public void clear() {
        this.setIdIsSet(false);
        this.id = 0;
        this.column = null;
        this.value = null;
        this.operator = null;
        this.nestedFilterQueryIds = null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.setIdIsSet(true);
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public String getColumn() {
        return this.column;
    }

    public void setColumn(@Nullable String column) {
        this.column = column;
    }

    public void unsetColumn() {
        this.column = null;
    }

    public boolean isSetColumn() {
        return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
        if (!value) {
            this.column = null;
        }
    }

    public int getValueSize() {
        return this.value == null ? 0 : this.value.size();
    }

    @Nullable
    public Iterator<String> getValueIterator() {
        return this.value == null ? null : this.value.iterator();
    }

    public void addToValue(String elem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(elem);
    }

    @Nullable
    public List<String> getValue() {
        return this.value;
    }

    public void setValue(@Nullable List<String> value) {
        this.value = value;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    @Nullable
    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(@Nullable FilterOperator operator) {
        this.operator = operator;
    }

    public void unsetOperator() {
        this.operator = null;
    }

    public boolean isSetOperator() {
        return this.operator != null;
    }

    public void setOperatorIsSet(boolean value) {
        if (!value) {
            this.operator = null;
        }
    }

    public int getNestedFilterQueryIdsSize() {
        return this.nestedFilterQueryIds == null ? 0 : this.nestedFilterQueryIds.size();
    }

    @Nullable
    public Iterator<Integer> getNestedFilterQueryIdsIterator() {
        return this.nestedFilterQueryIds == null ? null : this.nestedFilterQueryIds.iterator();
    }

    public void addToNestedFilterQueryIds(int elem) {
        if (this.nestedFilterQueryIds == null) {
            this.nestedFilterQueryIds = new ArrayList<Integer>();
        }
        this.nestedFilterQueryIds.add(elem);
    }

    @Nullable
    public List<Integer> getNestedFilterQueryIds() {
        return this.nestedFilterQueryIds;
    }

    public void setNestedFilterQueryIds(@Nullable List<Integer> nestedFilterQueryIds) {
        this.nestedFilterQueryIds = nestedFilterQueryIds;
    }

    public void unsetNestedFilterQueryIds() {
        this.nestedFilterQueryIds = null;
    }

    public boolean isSetNestedFilterQueryIds() {
        return this.nestedFilterQueryIds != null;
    }

    public void setNestedFilterQueryIdsIsSet(boolean value) {
        if (!value) {
            this.nestedFilterQueryIds = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Integer)value);
                break;
            }
            case COLUMN: {
                if (value == null) {
                    this.unsetColumn();
                    break;
                }
                this.setColumn((String)value);
                break;
            }
            case VALUE: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((List)value);
                break;
            }
            case OPERATOR: {
                if (value == null) {
                    this.unsetOperator();
                    break;
                }
                this.setOperator((FilterOperator)((Object)value));
                break;
            }
            case NESTED_FILTER_QUERY_IDS: {
                if (value == null) {
                    this.unsetNestedFilterQueryIds();
                    break;
                }
                this.setNestedFilterQueryIds((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ID: {
                return this.getId();
            }
            case COLUMN: {
                return this.getColumn();
            }
            case VALUE: {
                return this.getValue();
            }
            case OPERATOR: {
                return this.getOperator();
            }
            case NESTED_FILTER_QUERY_IDS: {
                return this.getNestedFilterQueryIds();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ID: {
                return this.isSetId();
            }
            case COLUMN: {
                return this.isSetColumn();
            }
            case VALUE: {
                return this.isSetValue();
            }
            case OPERATOR: {
                return this.isSetOperator();
            }
            case NESTED_FILTER_QUERY_IDS: {
                return this.isSetNestedFilterQueryIds();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof FilterQuery) {
            return this.equals((FilterQuery)that);
        }
        return false;
    }

    public boolean equals(FilterQuery that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_id = true;
        boolean that_present_id = true;
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_column = this.isSetColumn();
        boolean that_present_column = that.isSetColumn();
        if (this_present_column || that_present_column) {
            if (!this_present_column || !that_present_column) {
                return false;
            }
            if (!this.column.equals(that.column)) {
                return false;
            }
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!this.value.equals(that.value)) {
                return false;
            }
        }
        boolean this_present_operator = this.isSetOperator();
        boolean that_present_operator = that.isSetOperator();
        if (this_present_operator || that_present_operator) {
            if (!this_present_operator || !that_present_operator) {
                return false;
            }
            if (!this.operator.equals((Object)that.operator)) {
                return false;
            }
        }
        boolean this_present_nestedFilterQueryIds = this.isSetNestedFilterQueryIds();
        boolean that_present_nestedFilterQueryIds = that.isSetNestedFilterQueryIds();
        if (this_present_nestedFilterQueryIds || that_present_nestedFilterQueryIds) {
            if (!this_present_nestedFilterQueryIds || !that_present_nestedFilterQueryIds) {
                return false;
            }
            if (!this.nestedFilterQueryIds.equals(that.nestedFilterQueryIds)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.id;
        hashCode = hashCode * 8191 + (this.isSetColumn() ? 131071 : 524287);
        if (this.isSetColumn()) {
            hashCode = hashCode * 8191 + this.column.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetValue() ? 131071 : 524287);
        if (this.isSetValue()) {
            hashCode = hashCode * 8191 + this.value.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOperator() ? 131071 : 524287);
        if (this.isSetOperator()) {
            hashCode = hashCode * 8191 + this.operator.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetNestedFilterQueryIds() ? 131071 : 524287);
        if (this.isSetNestedFilterQueryIds()) {
            hashCode = hashCode * 8191 + this.nestedFilterQueryIds.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(FilterQuery other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetId()).compareTo(other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((int)this.id, (int)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn()).compareTo(other.isSetColumn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn() && (lastComparison = TBaseHelper.compareTo((String)this.column, (String)other.column)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo(this.value, other.value)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOperator()).compareTo(other.isSetOperator());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOperator() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.operator), (Comparable)((Object)other.operator))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNestedFilterQueryIds()).compareTo(other.isSetNestedFilterQueryIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNestedFilterQueryIds() && (lastComparison = TBaseHelper.compareTo(this.nestedFilterQueryIds, other.nestedFilterQueryIds)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        FilterQuery.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        FilterQuery.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilterQuery(");
        boolean first = true;
        sb.append("id:");
        sb.append(this.id);
        first = false;
        if (this.isSetColumn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column:");
            if (this.column == null) {
                sb.append("null");
            } else {
                sb.append(this.column);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("value:");
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append(this.value);
        }
        first = false;
        if (this.isSetOperator()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("operator:");
            if (this.operator == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.operator);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("nestedFilterQueryIds:");
        if (this.nestedFilterQueryIds == null) {
            sb.append("null");
        } else {
            sb.append(this.nestedFilterQueryIds);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetId()) {
            throw new TProtocolException("Required field 'id' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.COLUMN, new FieldMetaData("column", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.OPERATOR, new FieldMetaData("operator", 2, (FieldValueMetaData)new EnumMetaData(16, FilterOperator.class)));
        tmpMap.put(_Fields.NESTED_FILTER_QUERY_IDS, new FieldMetaData("nestedFilterQueryIds", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FilterQuery.class, metaDataMap);
    }

    private static class FilterQueryTupleScheme
    extends TupleScheme<FilterQuery> {
        private FilterQueryTupleScheme() {
        }

        public void write(TProtocol prot, FilterQuery struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.id);
            BitSet optionals = new BitSet();
            if (struct.isSetColumn()) {
                optionals.set(0);
            }
            if (struct.isSetValue()) {
                optionals.set(1);
            }
            if (struct.isSetOperator()) {
                optionals.set(2);
            }
            if (struct.isSetNestedFilterQueryIds()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetColumn()) {
                oprot.writeString(struct.column);
            }
            if (struct.isSetValue()) {
                oprot.writeI32(struct.value.size());
                for (String _iter8 : struct.value) {
                    oprot.writeString(_iter8);
                }
            }
            if (struct.isSetOperator()) {
                oprot.writeI32(struct.operator.getValue());
            }
            if (struct.isSetNestedFilterQueryIds()) {
                oprot.writeI32(struct.nestedFilterQueryIds.size());
                Iterator<Object> iterator = struct.nestedFilterQueryIds.iterator();
                while (iterator.hasNext()) {
                    int _iter9 = (Integer)iterator.next();
                    oprot.writeI32(_iter9);
                }
            }
        }

        public void read(TProtocol prot, FilterQuery struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.id = iprot.readI32();
            struct.setIdIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.column = iprot.readString();
                struct.setColumnIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list10 = new TList(11, iprot.readI32());
                struct.value = new ArrayList<String>(_list10.size);
                for (int _i12 = 0; _i12 < _list10.size; ++_i12) {
                    String _elem11 = iprot.readString();
                    struct.value.add(_elem11);
                }
                struct.setValueIsSet(true);
            }
            if (incoming.get(2)) {
                struct.operator = FilterOperator.findByValue(iprot.readI32());
                struct.setOperatorIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list13 = new TList(8, iprot.readI32());
                struct.nestedFilterQueryIds = new ArrayList<Integer>(_list13.size);
                for (int _i15 = 0; _i15 < _list13.size; ++_i15) {
                    int _elem14 = iprot.readI32();
                    struct.nestedFilterQueryIds.add(_elem14);
                }
                struct.setNestedFilterQueryIdsIsSet(true);
            }
        }
    }

    private static class FilterQueryTupleSchemeFactory
    implements SchemeFactory {
        private FilterQueryTupleSchemeFactory() {
        }

        public FilterQueryTupleScheme getScheme() {
            return new FilterQueryTupleScheme();
        }
    }

    private static class FilterQueryStandardScheme
    extends StandardScheme<FilterQuery> {
        private FilterQueryStandardScheme() {
        }

        public void read(TProtocol iprot, FilterQuery struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.id = iprot.readI32();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.column = iprot.readString();
                            struct.setColumnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.value = new ArrayList<String>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                String _elem1 = iprot.readString();
                                struct.value.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.operator = FilterOperator.findByValue(iprot.readI32());
                            struct.setOperatorIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.nestedFilterQueryIds = new ArrayList<Integer>(_list3.size);
                            for (int _i5 = 0; _i5 < _list3.size; ++_i5) {
                                int _elem4 = iprot.readI32();
                                struct.nestedFilterQueryIds.add(_elem4);
                            }
                            iprot.readListEnd();
                            struct.setNestedFilterQueryIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, FilterQuery struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(ID_FIELD_DESC);
            oprot.writeI32(struct.id);
            oprot.writeFieldEnd();
            if (struct.column != null && struct.isSetColumn()) {
                oprot.writeFieldBegin(COLUMN_FIELD_DESC);
                oprot.writeString(struct.column);
                oprot.writeFieldEnd();
            }
            if (struct.value != null) {
                oprot.writeFieldBegin(VALUE_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.value.size()));
                for (String _iter6 : struct.value) {
                    oprot.writeString(_iter6);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.operator != null && struct.isSetOperator()) {
                oprot.writeFieldBegin(OPERATOR_FIELD_DESC);
                oprot.writeI32(struct.operator.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.nestedFilterQueryIds != null) {
                oprot.writeFieldBegin(NESTED_FILTER_QUERY_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.nestedFilterQueryIds.size()));
                Iterator<Object> iterator = struct.nestedFilterQueryIds.iterator();
                while (iterator.hasNext()) {
                    int _iter7 = (Integer)iterator.next();
                    oprot.writeI32(_iter7);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class FilterQueryStandardSchemeFactory
    implements SchemeFactory {
        private FilterQueryStandardSchemeFactory() {
        }

        public FilterQueryStandardScheme getScheme() {
            return new FilterQueryStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ID(1, "id"),
        COLUMN(2, "column"),
        VALUE(3, "value"),
        OPERATOR(4, "operator"),
        NESTED_FILTER_QUERY_IDS(5, "nestedFilterQueryIds");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ID;
                }
                case 2: {
                    return COLUMN;
                }
                case 3: {
                    return VALUE;
                }
                case 4: {
                    return OPERATOR;
                }
                case 5: {
                    return NESTED_FILTER_QUERY_IDS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

