/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.IsNotNullPredicate;
import org.apache.pinot.common.request.context.predicate.IsNullPredicate;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.common.utils.RegexpPatternConverterUtils;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.sql.parsers.CalciteSqlParser;

public class RequestContextUtils {
    private static final Pql2Compiler PQL_COMPILER = new Pql2Compiler();

    private RequestContextUtils() {
    }

    public static ExpressionContext getExpressionFromSQL(String sqlExpression) {
        if (sqlExpression.equals("*")) {
            return ExpressionContext.forIdentifier("*");
        }
        return RequestContextUtils.getExpression(CalciteSqlParser.compileToExpression(sqlExpression));
    }

    public static ExpressionContext getExpression(Expression thriftExpression) {
        switch (thriftExpression.getType()) {
            case LITERAL: {
                return ExpressionContext.forLiteral(thriftExpression.getLiteral().getFieldValue().toString());
            }
            case IDENTIFIER: {
                return ExpressionContext.forIdentifier(thriftExpression.getIdentifier().getName());
            }
            case FUNCTION: {
                return ExpressionContext.forFunction(RequestContextUtils.getFunction(thriftExpression.getFunctionCall()));
            }
        }
        throw new IllegalStateException();
    }

    public static ExpressionContext getExpressionFromPQL(String pqlExpression) {
        if (pqlExpression.equals("*")) {
            return ExpressionContext.forIdentifier("*");
        }
        return RequestContextUtils.getExpression(PQL_COMPILER.parseToAstNode(pqlExpression));
    }

    public static ExpressionContext getExpression(AstNode astNode) {
        if (astNode instanceof IdentifierAstNode) {
            return ExpressionContext.forIdentifier(((IdentifierAstNode)astNode).getName());
        }
        if (astNode instanceof FunctionCallAstNode) {
            return ExpressionContext.forFunction(RequestContextUtils.getFunction((FunctionCallAstNode)astNode));
        }
        if (astNode instanceof LiteralAstNode) {
            return ExpressionContext.forLiteral(((LiteralAstNode)astNode).getValueAsString());
        }
        throw new IllegalStateException();
    }

    public static FunctionContext getFunction(Function thriftFunction) {
        String functionName = thriftFunction.getOperator();
        if (functionName.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
            return new FunctionContext(FunctionContext.Type.AGGREGATION, AggregationFunctionType.COUNT.getName(), Collections.singletonList(ExpressionContext.forIdentifier("*")));
        }
        FunctionContext.Type functionType = AggregationFunctionType.isAggregationFunction((String)functionName) ? FunctionContext.Type.AGGREGATION : FunctionContext.Type.TRANSFORM;
        List<Expression> operands = thriftFunction.getOperands();
        if (operands != null) {
            ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(operands.size());
            for (Expression operand : operands) {
                arguments.add(RequestContextUtils.getExpression(operand));
            }
            return new FunctionContext(functionType, functionName, arguments);
        }
        return new FunctionContext(functionType, functionName, Collections.emptyList());
    }

    public static FunctionContext getFunction(FunctionCallAstNode astNode) {
        String functionName = astNode.getName();
        if (functionName.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
            return new FunctionContext(FunctionContext.Type.AGGREGATION, AggregationFunctionType.COUNT.getName(), Collections.singletonList(ExpressionContext.forIdentifier("*")));
        }
        FunctionContext.Type functionType = AggregationFunctionType.isAggregationFunction((String)functionName) ? FunctionContext.Type.AGGREGATION : FunctionContext.Type.TRANSFORM;
        List<? extends AstNode> children = astNode.getChildren();
        if (children != null) {
            ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(children.size());
            for (AstNode astNode2 : children) {
                arguments.add(RequestContextUtils.getExpression(astNode2));
            }
            return new FunctionContext(functionType, functionName, arguments);
        }
        return new FunctionContext(functionType, functionName, Collections.emptyList());
    }

    public static FilterContext getFilter(Expression thriftExpression) {
        Function thriftFunction = thriftExpression.getFunctionCall();
        FilterKind filterKind = FilterKind.valueOf(thriftFunction.getOperator().toUpperCase());
        List<Expression> operands = thriftFunction.getOperands();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case NOT: {
                assert (numOperands == 1);
                return new FilterContext(FilterContext.Type.NOT, Collections.singletonList(RequestContextUtils.getFilter(operands.get(0))), null);
            }
            case EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case NOT_EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(RequestContextUtils.getExpression(operands.get(0)), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(RequestContextUtils.getExpression(operands.get(0)), values));
            }
            case GREATER_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case GREATER_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), true, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case LESS_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, "*", false, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LESS_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, "*", true, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case BETWEEN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), true, RequestContextUtils.getStringValue(operands.get(1)), true, RequestContextUtils.getStringValue(operands.get(2))));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(RequestContextUtils.getExpression(operands.get(0)), RegexpPatternConverterUtils.likeToRegexpLike(RequestContextUtils.getStringValue(operands.get(1)))));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case JSON_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new JsonMatchPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(RequestContextUtils.getExpression(operands.get(0))));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(RequestContextUtils.getExpression(operands.get(0))));
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringValue(Expression thriftExpression) {
        if (thriftExpression.getType() != ExpressionType.LITERAL) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return thriftExpression.getLiteral().getFieldValue().toString();
    }

    public static FilterContext getFilter(ExpressionContext filterExpression) {
        FunctionContext filterFunction = filterExpression.getFunction();
        FilterKind filterKind = FilterKind.valueOf(filterFunction.getFunctionName().toUpperCase());
        List<ExpressionContext> operands = filterFunction.getArguments();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (ExpressionContext operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (ExpressionContext operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case NOT_EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(operands.get(0), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(operands.get(0), values));
            }
            case GREATER_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), false, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case GREATER_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), true, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case LESS_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), false, "*", false, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LESS_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), false, "*", true, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case BETWEEN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), true, RequestContextUtils.getStringValue(operands.get(1)), true, RequestContextUtils.getStringValue(operands.get(2))));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(operands.get(0), RegexpPatternConverterUtils.likeToRegexpLike(RequestContextUtils.getStringValue(operands.get(1)))));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case JSON_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new JsonMatchPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(operands.get(0)));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(operands.get(0)));
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringValue(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.LITERAL) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return expressionContext.getLiteral();
    }

    public static FilterContext getFilter(FilterQueryTree node) {
        FilterOperator filterOperator = node.getOperator();
        switch (filterOperator) {
            case AND: {
                List<FilterQueryTree> childNodes = node.getChildren();
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(childNodes.size());
                for (FilterQueryTree childNode : childNodes) {
                    children.add(RequestContextUtils.getFilter(childNode));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                List<FilterQueryTree> childNodes = node.getChildren();
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(childNodes.size());
                for (FilterQueryTree childNode : childNodes) {
                    children.add(RequestContextUtils.getFilter(childNode));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case EQUALITY: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue().get(0)));
            }
            case NOT: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue().get(0)));
            }
            case IN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue()));
            }
            case NOT_IN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue()));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue().get(0)));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue().get(0)));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue().get(0)));
            }
            case JSON_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new JsonMatchPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn()), node.getValue().get(0)));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn())));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(RequestContextUtils.getExpressionFromPQL(node.getColumn())));
            }
        }
        throw new IllegalStateException();
    }
}

