/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context.predicate;

import java.util.List;
import java.util.Objects;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;

public class InPredicate
implements Predicate {
    private final ExpressionContext _lhs;
    private final List<String> _values;

    public InPredicate(ExpressionContext lhs, List<String> values) {
        this._lhs = lhs;
        this._values = values;
    }

    @Override
    public Predicate.Type getType() {
        return Predicate.Type.IN;
    }

    @Override
    public ExpressionContext getLhs() {
        return this._lhs;
    }

    public List<String> getValues() {
        return this._values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InPredicate)) {
            return false;
        }
        InPredicate that = (InPredicate)o;
        return Objects.equals(this._lhs, that._lhs) && Objects.equals(this._values, that._values);
    }

    public int hashCode() {
        return Objects.hash(this._lhs, this._values);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this._lhs.toString()).append(" IN ('").append(this._values.get(0)).append('\'');
        int numValues = this._values.size();
        for (int i = 1; i < numValues; ++i) {
            stringBuilder.append(",'").append(this._values.get(i)).append('\'');
        }
        return stringBuilder.append(')').toString();
    }
}

