/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context.predicate;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;

public class RangePredicate
implements Predicate {
    public static final char DELIMITER = '\u0000';
    public static final char LOWER_EXCLUSIVE = '(';
    public static final char LOWER_INCLUSIVE = '[';
    public static final char UPPER_EXCLUSIVE = ')';
    public static final char UPPER_INCLUSIVE = ']';
    public static final String UNBOUNDED = "*";
    private static final String LEGACY_DELIMITER = "\t\t";
    private final ExpressionContext _lhs;
    private final boolean _lowerInclusive;
    private final String _lowerBound;
    private final boolean _upperInclusive;
    private final String _upperBound;

    public RangePredicate(ExpressionContext lhs, String range) {
        this._lhs = lhs;
        String[] split = StringUtils.split((String)range, (char)'\u0000');
        if (split.length != 2) {
            split = StringUtils.split((String)range, (String)LEGACY_DELIMITER);
        }
        String lower = split[0];
        String upper = split[1];
        this._lowerInclusive = lower.charAt(0) == '[';
        this._lowerBound = lower.substring(1);
        int upperLength = upper.length();
        this._upperInclusive = upper.charAt(upperLength - 1) == ']';
        this._upperBound = upper.substring(0, upperLength - 1);
    }

    public RangePredicate(ExpressionContext lhs, boolean lowerInclusive, String lowerBound, boolean upperInclusive, String upperBound) {
        this._lhs = lhs;
        this._lowerInclusive = lowerInclusive;
        this._lowerBound = lowerBound;
        this._upperInclusive = upperInclusive;
        this._upperBound = upperBound;
    }

    @Override
    public Predicate.Type getType() {
        return Predicate.Type.RANGE;
    }

    @Override
    public ExpressionContext getLhs() {
        return this._lhs;
    }

    public boolean isLowerInclusive() {
        return this._lowerInclusive;
    }

    public String getLowerBound() {
        return this._lowerBound;
    }

    public boolean isUpperInclusive() {
        return this._upperInclusive;
    }

    public String getUpperBound() {
        return this._upperBound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangePredicate)) {
            return false;
        }
        RangePredicate that = (RangePredicate)o;
        return this._lowerInclusive == that._lowerInclusive && this._upperInclusive == that._upperInclusive && Objects.equals(this._lhs, that._lhs) && Objects.equals(this._lowerBound, that._lowerBound) && Objects.equals(this._upperBound, that._upperBound);
    }

    public int hashCode() {
        return Objects.hash(this._lhs, this._lowerInclusive, this._lowerBound, this._upperInclusive, this._upperBound);
    }

    public String toString() {
        if (this._lowerBound.equals(UNBOUNDED)) {
            return this._lhs + (this._upperInclusive ? " <= '" : " < '") + this._upperBound + "'";
        }
        if (this._upperBound.equals(UNBOUNDED)) {
            return this._lhs + (this._lowerInclusive ? " >= '" : " > '") + this._lowerBound + "'";
        }
        if (this._lowerInclusive && this._upperInclusive) {
            return this._lhs + " BETWEEN '" + this._lowerBound + "' AND '" + this._upperBound + "'";
        }
        return "(" + this._lhs + (this._lowerInclusive ? " >= '" : " > '") + this._lowerBound + "' AND " + this._lhs + (this._upperInclusive ? " <= '" : " < '") + this._upperBound + "')";
    }
}

