/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.SegmentName;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LLCSegmentName
extends SegmentName
implements Comparable {
    private static final String DATE_FORMAT = "yyyyMMdd'T'HHmm'Z'";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmm'Z'").withZoneUTC();
    private final String _tableName;
    private final int _partitionGroupId;
    private final int _sequenceNumber;
    private final String _creationTime;
    private final String _segmentName;

    public LLCSegmentName(String segmentName) {
        if (!LLCSegmentName.isLowLevelConsumerSegmentName(segmentName)) {
            throw new RuntimeException(segmentName + " is not a Low level consumer segment name");
        }
        this._segmentName = segmentName;
        String[] parts = StringUtils.splitByWholeSeparator((String)segmentName, (String)"__");
        this._tableName = parts[0];
        this._partitionGroupId = Integer.parseInt(parts[1]);
        this._sequenceNumber = Integer.parseInt(parts[2]);
        this._creationTime = parts[3];
    }

    public LLCSegmentName(String tableName, int partitionGroupId, int sequenceNumber, long msSinceEpoch) {
        if (!this.isValidComponentName(tableName)) {
            throw new RuntimeException("Invalid table name " + tableName);
        }
        this._tableName = tableName;
        this._partitionGroupId = partitionGroupId;
        this._sequenceNumber = sequenceNumber;
        this._creationTime = DATE_FORMATTER.print(msSinceEpoch);
        this._segmentName = tableName + "__" + partitionGroupId + "__" + sequenceNumber + "__" + this._creationTime;
    }

    public static int getSequenceNumber(String segmentName) {
        return Integer.parseInt(StringUtils.splitByWholeSeparator((String)segmentName, (String)"__")[2]);
    }

    @Override
    public SegmentName.RealtimeSegmentType getSegmentType() {
        return SegmentName.RealtimeSegmentType.LLC;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public int getPartitionGroupId() {
        return this._partitionGroupId;
    }

    @Override
    public String getPartitionRange() {
        return Integer.toString(this.getPartitionGroupId());
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public String getCreationTime() {
        return this._creationTime;
    }

    public long getCreationTimeMs() {
        DateTime dateTime = DATE_FORMATTER.parseDateTime(this._creationTime);
        return dateTime.getMillis();
    }

    @Override
    public String getSegmentName() {
        return this._segmentName;
    }

    @Override
    public String getSequenceNumberStr() {
        return Integer.toString(this._sequenceNumber);
    }

    public int compareTo(Object o) {
        LLCSegmentName other = (LLCSegmentName)o;
        if (!this.getTableName().equals(other.getTableName())) {
            throw new RuntimeException("Cannot compare segment names " + this.getSegmentName() + " and " + other.getSegmentName());
        }
        if (this.getPartitionGroupId() > other.getPartitionGroupId()) {
            return 1;
        }
        if (this.getPartitionGroupId() < other.getPartitionGroupId()) {
            return -1;
        }
        if (this.getSequenceNumber() > other.getSequenceNumber()) {
            return 1;
        }
        if (this.getSequenceNumber() < other.getSequenceNumber()) {
            return -1;
        }
        if (!this.getCreationTime().equals(other.getCreationTime())) {
            throw new RuntimeException("Cannot compare segment names " + this.getSegmentName() + " and " + other.getSegmentName());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLCSegmentName segName = (LLCSegmentName)o;
        if (this._partitionGroupId != segName._partitionGroupId) {
            return false;
        }
        if (this._sequenceNumber != segName._sequenceNumber) {
            return false;
        }
        if (this._tableName != null ? !this._tableName.equals(segName._tableName) : segName._tableName != null) {
            return false;
        }
        if (this._creationTime != null ? !this._creationTime.equals(segName._creationTime) : segName._creationTime != null) {
            return false;
        }
        return !(this._segmentName == null ? segName._segmentName != null : !this._segmentName.equals(segName._segmentName));
    }

    public int hashCode() {
        int result = this._tableName != null ? this._tableName.hashCode() : 0;
        result = 31 * result + this._partitionGroupId;
        result = 31 * result + this._sequenceNumber;
        result = 31 * result + (this._creationTime != null ? this._creationTime.hashCode() : 0);
        result = 31 * result + (this._segmentName != null ? this._segmentName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getSegmentName();
    }
}

