/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;

public class SegmentUtils {
    private SegmentUtils() {
    }

    public static int getRealtimeSegmentPartitionId(String segmentName, String realtimeTableName, HelixManager helixManager, String partitionColumn) {
        if (LLCSegmentName.isLowLevelConsumerSegmentName(segmentName)) {
            return new LLCSegmentName(segmentName).getPartitionGroupId();
        }
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore<ZNRecord>)helixManager.getHelixPropertyStore(), realtimeTableName, segmentName);
        Preconditions.checkState((segmentZKMetadata != null ? 1 : 0) != 0, (String)"Failed to find segment ZK metadata for segment: %s of table: %s", (Object)segmentName, (Object)realtimeTableName);
        SegmentPartitionMetadata segmentPartitionMetadata = segmentZKMetadata.getPartitionMetadata();
        Preconditions.checkState((segmentPartitionMetadata != null ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s does not contain partition metadata", (Object)segmentName, (Object)realtimeTableName);
        ColumnPartitionMetadata columnPartitionMetadata = segmentPartitionMetadata.getColumnPartitionMap().get(partitionColumn);
        Preconditions.checkState((columnPartitionMetadata != null ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s does not contain partition metadata for column: %s. Check if the table is an upsert table.", (Object)segmentName, (Object)realtimeTableName, (Object)partitionColumn);
        Set partitions = columnPartitionMetadata.getPartitions();
        Preconditions.checkState((partitions.size() == 1 ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s contains multiple partitions for column: %s with %s", (Object)segmentName, (Object)realtimeTableName, (Object)partitionColumn, (Object)partitions);
        return (Integer)partitions.iterator().next();
    }
}

