/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.manager.zk.client.SharedZkClientFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.services.ServiceRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStartableUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceStartableUtils.class);
    private static final String CLUSTER_CONFIG_ZK_PATH_TEMPLATE = "/%s/CONFIGS/CLUSTER/%s";
    private static final String PINOT_ALL_CONFIG_KEY_PREFIX = "pinot.all.";
    private static final String PINOT_INSTANCE_CONFIG_KEY_PREFIX_TEMPLATE = "pinot.%s.";
    private static final int ZK_TIMEOUT_MS = 30000;

    private ServiceStartableUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyClusterConfig(PinotConfiguration instanceConfig, String zkAddress, String clusterName, ServiceRole serviceRole) {
        HelixZkClient.ZkClientConfig zkClientConfig = new HelixZkClient.ZkClientConfig();
        zkClientConfig.setZkSerializer((ZkSerializer)new ZNRecordSerializer()).setConnectInitTimeout(30000L);
        HelixZkClient zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), zkClientConfig);
        zkClient.waitUntilConnected(30000L, TimeUnit.MILLISECONDS);
        try {
            ZNRecord clusterConfigZNRecord = (ZNRecord)zkClient.readData(String.format(CLUSTER_CONFIG_ZK_PATH_TEMPLATE, clusterName, clusterName), true);
            if (clusterConfigZNRecord == null) {
                LOGGER.warn("Failed to find cluster config for cluster: {}, skipping applying cluster config", (Object)clusterName);
                return;
            }
            Map clusterConfigs = clusterConfigZNRecord.getSimpleFields();
            String instanceConfigKeyPrefix = String.format(PINOT_INSTANCE_CONFIG_KEY_PREFIX_TEMPLATE, serviceRole.name().toLowerCase());
            for (Map.Entry entry : clusterConfigs.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.startsWith(PINOT_ALL_CONFIG_KEY_PREFIX)) {
                    String instanceConfigKey = instanceConfigKeyPrefix + key.substring(PINOT_ALL_CONFIG_KEY_PREFIX.length());
                    ServiceStartableUtils.addConfigIfNotExists(instanceConfig, instanceConfigKey, value);
                    continue;
                }
                ServiceStartableUtils.addConfigIfNotExists(instanceConfig, key, value);
            }
        }
        finally {
            zkClient.close();
        }
    }

    private static void addConfigIfNotExists(PinotConfiguration instanceConfig, String key, String value) {
        if (!instanceConfig.containsKey(key)) {
            instanceConfig.setProperty(key, (Object)value);
        }
    }
}

