/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.spi.config.instance.Instance;

public class InstanceUtils {
    public static final String POOL_KEY = "pool";

    private InstanceUtils() {
    }

    public static String getHelixInstanceId(Instance instance) {
        String prefix;
        switch (instance.getType()) {
            case CONTROLLER: {
                prefix = "Controller_";
                break;
            }
            case BROKER: {
                prefix = "Broker_";
                break;
            }
            case SERVER: {
                prefix = "Server_";
                break;
            }
            case MINION: {
                prefix = "Minion_";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return prefix + instance.getHost() + "_" + instance.getPort();
    }

    public static InstanceConfig toHelixInstanceConfig(Instance instance) {
        InstanceConfig instanceConfig = new InstanceConfig(InstanceUtils.getHelixInstanceId(instance));
        instanceConfig.setInstanceEnabled(true);
        InstanceUtils.updateHelixInstanceConfig(instanceConfig, instance);
        return instanceConfig;
    }

    public static void updateHelixInstanceConfig(InstanceConfig instanceConfig, Instance instance) {
        ZNRecord znRecord = instanceConfig.getRecord();
        Map simpleFields = znRecord.getSimpleFields();
        simpleFields.put(InstanceConfig.InstanceConfigProperty.HELIX_HOST.name(), instance.getHost());
        simpleFields.put(InstanceConfig.InstanceConfigProperty.HELIX_PORT.name(), Integer.toString(instance.getPort()));
        int grpcPort = instance.getGrpcPort();
        if (grpcPort > 0) {
            simpleFields.put("grpcPort", Integer.toString(grpcPort));
        } else {
            simpleFields.remove("grpcPort");
        }
        int adminPort = instance.getAdminPort();
        if (adminPort > 0) {
            simpleFields.put("adminPort", Integer.toString(adminPort));
        } else {
            simpleFields.remove("adminPort");
        }
        boolean queriesDisabled = instance.isQueriesDisabled();
        if (queriesDisabled) {
            simpleFields.put("queriesDisabled", Boolean.toString(true));
        } else {
            simpleFields.remove("queriesDisabled");
        }
        Map listFields = znRecord.getListFields();
        List tags = instance.getTags();
        String tagsKey = InstanceConfig.InstanceConfigProperty.TAG_LIST.name();
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            listFields.put(tagsKey, tags);
        } else {
            listFields.remove(tagsKey);
        }
        Map mapFields = znRecord.getMapFields();
        Map pools = instance.getPools();
        if (MapUtils.isNotEmpty((Map)pools)) {
            TreeMap<String, String> mapValue = new TreeMap<String, String>();
            for (Map.Entry entry : pools.entrySet()) {
                mapValue.put((String)entry.getKey(), ((Integer)entry.getValue()).toString());
            }
            mapFields.put(POOL_KEY, mapValue);
        } else {
            mapFields.remove(POOL_KEY);
        }
    }
}

