/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.RoundRobinURIProvider;
import org.apache.pinot.common.utils.fetcher.BaseSegmentFetcher;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.retry.RetryPolicies;

public class HttpSegmentFetcher
extends BaseSegmentFetcher {
    protected FileUploadDownloadClient _httpClient;

    @Override
    protected void doInit(PinotConfiguration config) {
        this._httpClient = new FileUploadDownloadClient();
    }

    @Override
    public void fetchSegmentToLocal(URI downloadURI, File dest) throws Exception {
        RoundRobinURIProvider uriProvider = new RoundRobinURIProvider(downloadURI);
        int retryCount = Math.max(this._retryCount, uriProvider.numAddresses());
        this._logger.info("Retry downloading for {} times. retryCount from pinot server config: {}, number of IP addresses for download URI: {}", new Object[]{retryCount, this._retryCount, uriProvider.numAddresses()});
        RetryPolicies.exponentialBackoffRetryPolicy((int)retryCount, (long)this._retryWaitMs, (double)this._retryDelayScaleFactor).attempt(() -> {
            URI uri = uriProvider.next();
            try {
                String hostName = downloadURI.getHost();
                int port = downloadURI.getPort();
                LinkedList<Header> httpHeaders = new LinkedList<Header>();
                if (!InetAddresses.isInetAddress((String)hostName)) {
                    httpHeaders.add((Header)new BasicHeader("Host", hostName + ":" + port));
                }
                int statusCode = this._httpClient.downloadFile(uri, dest, this._authToken, httpHeaders);
                this._logger.info("Downloaded segment from: {} to: {} of size: {}; Response status code: {}", new Object[]{uri, dest, dest.length(), statusCode});
                return true;
            }
            catch (HttpErrorStatusException e) {
                int statusCode = e.getStatusCode();
                if (statusCode == 404 || statusCode >= 500) {
                    this._logger.warn("Got temporary error status code: {} while downloading segment from: {} to: {}", new Object[]{statusCode, uri, dest, e});
                    return false;
                }
                this._logger.error("Got permanent error status code: {} while downloading segment from: {} to: {}, won't retry", new Object[]{statusCode, uri, dest, e});
                throw e;
            }
            catch (Exception e) {
                this._logger.warn("Caught exception while downloading segment from: {} to: {}", new Object[]{uri, dest, e});
                return false;
            }
        });
    }

    @Override
    public void fetchSegmentToLocalWithoutRetry(URI uri, File dest) throws Exception {
        try {
            int statusCode = this._httpClient.downloadFile(uri, dest, this._authToken);
            this._logger.info("Downloaded segment from: {} to: {} of size: {}; Response status code: {}", new Object[]{uri, dest, dest.length(), statusCode});
        }
        catch (Exception e) {
            this._logger.warn("Caught exception while downloading segment from: {} to: {}", new Object[]{uri, dest, e});
            throw e;
        }
    }
}

