/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.spi.env.PinotConfiguration;

public class GrpcQueryClient {
    private final ManagedChannel _managedChannel;
    private final PinotQueryServerGrpc.PinotQueryServerBlockingStub _blockingStub;

    public GrpcQueryClient(String host, int port) {
        this(host, port, new Config());
    }

    public GrpcQueryClient(String host, int port, Config config) {
        if (config.isUsePlainText()) {
            this._managedChannel = ManagedChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).usePlaintext().build();
        } else {
            try {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                if (config.getTlsConfig().getKeyStorePath() != null) {
                    KeyManagerFactory keyManagerFactory = TlsUtils.createKeyManagerFactory(config.getTlsConfig());
                    sslContextBuilder.keyManager(keyManagerFactory);
                }
                if (config.getTlsConfig().getTrustStorePath() != null) {
                    TrustManagerFactory trustManagerFactory = TlsUtils.createTrustManagerFactory(config.getTlsConfig());
                    sslContextBuilder.trustManager(trustManagerFactory);
                }
                sslContextBuilder = config.getTlsConfig().getSslProvider() != null ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.valueOf((String)config.getTlsConfig().getSslProvider())) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
                this._managedChannel = NettyChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).sslContext(sslContextBuilder.build()).build();
            }
            catch (SSLException e) {
                throw new RuntimeException("Failed to create Netty gRPC channel with SSL Context", e);
            }
        }
        this._blockingStub = PinotQueryServerGrpc.newBlockingStub((Channel)this._managedChannel);
    }

    public Iterator<Server.ServerResponse> submit(Server.ServerRequest request) {
        return this._blockingStub.submit(request);
    }

    public void close() {
        if (!this._managedChannel.isShutdown()) {
            this._managedChannel.shutdownNow();
        }
    }

    public static class Config {
        public static final String GRPC_TLS_PREFIX = "tls";
        public static final String CONFIG_USE_PLAIN_TEXT = "usePlainText";
        public static final String CONFIG_MAX_INBOUND_MESSAGE_BYTES_SIZE = "maxInboundMessageSizeBytes";
        public static final int DEFAULT_MAX_INBOUND_MESSAGE_BYTES_SIZE = 0x8000000;
        private final int _maxInboundMessageSizeBytes;
        private final boolean _usePlainText;
        private final TlsConfig _tlsConfig;
        private final PinotConfiguration _pinotConfig;

        public Config() {
            this(0x8000000, true);
        }

        public Config(int maxInboundMessageSizeBytes, boolean usePlainText) {
            this((Map<String, Object>)ImmutableMap.of((Object)CONFIG_MAX_INBOUND_MESSAGE_BYTES_SIZE, (Object)maxInboundMessageSizeBytes, (Object)CONFIG_USE_PLAIN_TEXT, (Object)usePlainText));
        }

        public Config(Map<String, Object> configMap) {
            this._pinotConfig = new PinotConfiguration(configMap);
            this._maxInboundMessageSizeBytes = this._pinotConfig.getProperty(CONFIG_MAX_INBOUND_MESSAGE_BYTES_SIZE, 0x8000000);
            this._usePlainText = Boolean.valueOf(configMap.get(CONFIG_USE_PLAIN_TEXT).toString());
            this._tlsConfig = TlsUtils.extractTlsConfig(this._pinotConfig, GRPC_TLS_PREFIX);
        }

        public Object get(String key) {
            return this._pinotConfig.getProperty(key);
        }

        public int getMaxInboundMessageSizeBytes() {
            return this._maxInboundMessageSizeBytes;
        }

        public boolean isUsePlainText() {
            return this._usePlainText;
        }

        public TlsConfig getTlsConfig() {
            return this._tlsConfig;
        }

        public PinotConfiguration getPinotConfig() {
            return this._pinotConfig;
        }
    }
}

