/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.FilterQuery;
import org.apache.pinot.common.request.FilterQueryMap;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FloatingPointLiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IntegerLiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.StringLiteralAstNode;
import org.apache.pinot.spi.utils.BytesUtils;

public class RequestUtils {
    private RequestUtils() {
    }

    public static void generateFilterFromTree(FilterQueryTree filterQueryTree, BrokerRequest request) {
        HashMap<Integer, FilterQuery> filterQueryMap = new HashMap<Integer, FilterQuery>();
        MutableInt currentId = new MutableInt(0);
        FilterQuery root = RequestUtils.traverseFilterQueryAndPopulateMap(filterQueryTree, filterQueryMap, currentId);
        filterQueryMap.put(root.getId(), root);
        request.setFilterQuery(root);
        FilterQueryMap mp = new FilterQueryMap();
        mp.setFilterQueryMap(filterQueryMap);
        request.setFilterSubQueryMap(mp);
    }

    public static Expression createIdentifierExpression(String identifier) {
        Expression expression = new Expression(ExpressionType.IDENTIFIER);
        expression.setIdentifier(new Identifier(identifier));
        return expression;
    }

    public static Expression createLiteralExpression(LiteralAstNode value) {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        if (value instanceof StringLiteralAstNode) {
            literal.setStringValue(((StringLiteralAstNode)value).getText());
        }
        if (value instanceof IntegerLiteralAstNode) {
            literal.setLongValue(((IntegerLiteralAstNode)value).getValue());
        }
        if (value instanceof FloatingPointLiteralAstNode) {
            literal.setDoubleValue(((FloatingPointLiteralAstNode)value).getValue());
        }
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression getIdentifierExpression(String identifier) {
        Expression expression = new Expression(ExpressionType.IDENTIFIER);
        expression.setIdentifier(new Identifier(identifier));
        return expression;
    }

    public static Expression getLiteralExpression(SqlLiteral node) {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        if (node instanceof SqlNumericLiteral) {
            SqlNumericLiteral sqlNumericLiteral = (SqlNumericLiteral)node;
            if (sqlNumericLiteral.getScale() != null && sqlNumericLiteral.isInteger()) {
                literal.setLongValue(node.bigDecimalValue().longValue());
            } else {
                literal.setDoubleValue(node.bigDecimalValue().doubleValue());
            }
        } else {
            literal.setStringValue(StringUtils.replace((String)node.toValue(), (String)"''", (String)"'"));
        }
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression createNewLiteralExpression() {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression getLiteralExpression(boolean value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setBoolValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(long value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setLongValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(double value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setDoubleValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(String value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setStringValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(byte[] value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setStringValue(BytesUtils.toHexString((byte[])value));
        return expression;
    }

    public static Expression getLiteralExpression(Object object) {
        if (object instanceof Integer || object instanceof Long) {
            return RequestUtils.getLiteralExpression(((Number)object).longValue());
        }
        if (object instanceof Float || object instanceof Double) {
            return RequestUtils.getLiteralExpression(((Number)object).doubleValue());
        }
        if (object instanceof byte[]) {
            return RequestUtils.getLiteralExpression((byte[])object);
        }
        return RequestUtils.getLiteralExpression(object.toString());
    }

    public static Expression getFunctionExpression(String operator) {
        Expression expression = new Expression(ExpressionType.FUNCTION);
        Function function = new Function(operator);
        expression.setFunctionCall(function);
        return expression;
    }

    private static FilterQuery traverseFilterQueryAndPopulateMap(FilterQueryTree tree, Map<Integer, FilterQuery> filterQueryMap, MutableInt currentId) {
        int currentNodeId = currentId.intValue();
        currentId.increment();
        ArrayList<Integer> f = new ArrayList<Integer>();
        if (null != tree.getChildren()) {
            for (FilterQueryTree c : tree.getChildren()) {
                FilterQuery q = RequestUtils.traverseFilterQueryAndPopulateMap(c, filterQueryMap, currentId);
                int childNodeId = q.getId();
                f.add(childNodeId);
                filterQueryMap.put(childNodeId, q);
            }
        }
        FilterQuery query = new FilterQuery();
        query.setColumn(tree.getColumn());
        query.setId(currentNodeId);
        query.setNestedFilterQueryIds(f);
        query.setOperator(tree.getOperator());
        query.setValue(tree.getValue());
        return query;
    }

    public static FilterQueryTree generateFilterQueryTree(BrokerRequest request) {
        FilterQueryTree root = null;
        FilterQuery q = request.getFilterQuery();
        if (null != q && null != request.getFilterSubQueryMap()) {
            root = RequestUtils.buildFilterQuery(q.getId(), request.getFilterSubQueryMap().getFilterQueryMap());
        }
        return root;
    }

    public static FilterQueryTree buildFilterQuery(Integer id, Map<Integer, FilterQuery> queryMap) {
        FilterQuery q = queryMap.get(id);
        List<Integer> children = q.getNestedFilterQueryIds();
        ArrayList<FilterQueryTree> c = null;
        if (null != children && !children.isEmpty()) {
            c = new ArrayList<FilterQueryTree>();
            for (Integer i : children) {
                FilterQueryTree t = RequestUtils.buildFilterQuery(i, queryMap);
                c.add(t);
            }
        }
        return new FilterQueryTree(q.getColumn(), q.getValue(), q.getOperator(), c);
    }

    public static Expression getExpression(AstNode astNode) {
        if (astNode instanceof IdentifierAstNode) {
            return RequestUtils.createIdentifierExpression(((IdentifierAstNode)astNode).getName());
        }
        if (astNode instanceof FunctionCallAstNode) {
            Expression expression = RequestUtils.getFunctionExpression(((FunctionCallAstNode)astNode).getName());
            Function func = expression.getFunctionCall();
            List<? extends AstNode> operandsAstNodes = astNode.getChildren();
            if (operandsAstNodes != null) {
                for (AstNode astNode2 : operandsAstNodes) {
                    func.addToOperands(RequestUtils.getExpression(astNode2));
                }
            }
            return expression;
        }
        if (astNode instanceof LiteralAstNode) {
            return RequestUtils.createLiteralExpression((LiteralAstNode)astNode);
        }
        if (astNode instanceof PredicateAstNode) {
            return ((PredicateAstNode)astNode).buildFilterExpression();
        }
        throw new IllegalStateException("Cannot get expression from " + astNode.getClass().getSimpleName());
    }

    public static String prettyPrint(Expression expression) {
        if (expression == null) {
            return "null";
        }
        if (expression.getIdentifier() != null) {
            return expression.getIdentifier().getName();
        }
        if (expression.getLiteral() != null && expression.getLiteral().isSetLongValue()) {
            return Long.toString(expression.getLiteral().getLongValue());
        }
        if (expression.getFunctionCall() != null) {
            String res = expression.getFunctionCall().getOperator() + "(";
            boolean isFirstParam = true;
            for (Expression operand : expression.getFunctionCall().getOperands()) {
                if (!isFirstParam) {
                    res = res + ", ";
                } else {
                    isFirstParam = false;
                }
                res = res + RequestUtils.prettyPrint(operand);
            }
            res = res + ")";
            return res;
        }
        return null;
    }
}

