/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;

public abstract class BaseAstNode
implements AstNode {
    private List<AstNode> _children;
    private AstNode _parent;

    @Override
    public List<? extends AstNode> getChildren() {
        return this._children;
    }

    @Override
    public boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    @Override
    public void addChild(AstNode childNode) {
        if (this._children == null) {
            this._children = new ArrayList<AstNode>();
        }
        this._children.add(childNode);
    }

    @Override
    public void doneProcessingChildren() {
    }

    @Override
    public AstNode getParent() {
        return this._parent;
    }

    @Override
    public void setParent(AstNode parent) {
        this._parent = parent;
    }

    @Override
    public boolean hasParent() {
        return this._parent != null;
    }

    @Override
    public void updateBrokerRequest(BrokerRequest brokerRequest) {
    }

    @Override
    public void updatePinotQuery(PinotQuery pinotQuery) {
    }

    @Override
    public void sendBrokerRequestUpdateToChildren(BrokerRequest brokerRequest) {
        if (this.hasChildren()) {
            for (AstNode child : this._children) {
                child.updateBrokerRequest(brokerRequest);
            }
        }
    }

    @Override
    public void sendPinotQueryUpdateToChildren(PinotQuery pinotQuery) {
        if (this.hasChildren()) {
            for (AstNode child : this._children) {
                child.updatePinotQuery(pinotQuery);
            }
        }
    }

    @Override
    public String toString(int indent) {
        Object str = "";
        for (int i = 0; i < indent; ++i) {
            str = (String)str + " ";
        }
        str = (String)str + this.toString();
        if (this.hasChildren()) {
            for (AstNode child : this._children) {
                str = (String)str + "\n" + child.toString(indent + 2);
            }
        }
        return str;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

