/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;

public class IsNullPredicateAstNode
extends PredicateAstNode {
    private final boolean _isNegation;

    public IsNullPredicateAstNode(boolean notNodeExists) {
        this._isNegation = notNodeExists;
    }

    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("IS predicate has more than one column/function");
            }
            this._identifier = ((IdentifierAstNode)childNode).getName();
        } else {
            if (childNode instanceof FunctionCallAstNode) {
                throw new Pql2CompilationException("IS predicate cannot be applied to function");
            }
            super.addChild(childNode);
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("IS predicate has no identifier");
        }
        if (this._isNegation) {
            return new FilterQueryTree(this._identifier, Collections.emptyList(), FilterOperator.IS_NOT_NULL, null);
        }
        return new FilterQueryTree(this._identifier, Collections.emptyList(), FilterOperator.IS_NULL, null);
    }

    @Override
    public Expression buildFilterExpression() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("IS predicate has no identifier");
        }
        String filterName = this._isNegation ? FilterKind.IS_NOT_NULL.name() : FilterKind.IS_NULL.name();
        Expression expression = RequestUtils.getFunctionExpression(filterName);
        expression.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
        return expression;
    }
}

