/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.pql2.ast.BooleanOperatorAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;

public class PredicateListAstNode
extends PredicateAstNode {
    public void buildQueryTreePredicates(List<FilterQueryTree> filterQueryOrPredicates, List<FilterQueryTree> filterQueryAndPredicates) {
        int childrenCount = this.getChildren().size();
        for (int i = 0; i < childrenCount; i += 2) {
            PredicateAstNode predicate = (PredicateAstNode)this.getChildren().get(i);
            BooleanOperatorAstNode nextOperator = null;
            if (i + 1 < childrenCount) {
                nextOperator = (BooleanOperatorAstNode)this.getChildren().get(i + 1);
            }
            if (nextOperator == null) {
                if (!filterQueryAndPredicates.isEmpty()) {
                    filterQueryAndPredicates.add(predicate.buildFilterQueryTree());
                    if (filterQueryOrPredicates.isEmpty()) continue;
                    filterQueryOrPredicates.add(this.buildFilterPredicate(filterQueryAndPredicates, FilterOperator.AND));
                    continue;
                }
                filterQueryOrPredicates.add(predicate.buildFilterQueryTree());
                continue;
            }
            if (nextOperator == BooleanOperatorAstNode.AND) {
                filterQueryAndPredicates.add(predicate.buildFilterQueryTree());
                continue;
            }
            if (!filterQueryAndPredicates.isEmpty()) {
                filterQueryAndPredicates.add(predicate.buildFilterQueryTree());
                filterQueryOrPredicates.add(this.buildFilterPredicate(filterQueryAndPredicates, FilterOperator.AND));
                filterQueryAndPredicates = new ArrayList<FilterQueryTree>();
                continue;
            }
            filterQueryOrPredicates.add(predicate.buildFilterQueryTree());
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        ArrayList<FilterQueryTree> orPredicates = new ArrayList<FilterQueryTree>();
        ArrayList<FilterQueryTree> andPredicates = new ArrayList<FilterQueryTree>();
        int childrenCount = this.getChildren().size();
        if (childrenCount == 1) {
            return ((PredicateAstNode)this.getChildren().get(0)).buildFilterQueryTree();
        }
        this.buildQueryTreePredicates(orPredicates, andPredicates);
        if (!orPredicates.isEmpty()) {
            return this.buildFilterPredicate(orPredicates, FilterOperator.OR);
        }
        return this.buildFilterPredicate(andPredicates, FilterOperator.AND);
    }

    @Override
    public Expression buildFilterExpression() {
        ArrayList<Expression> filterQueryOrExpressions = new ArrayList<Expression>();
        ArrayList<Expression> filterQueryAndExpressions = new ArrayList<Expression>();
        int childrenCount = this.getChildren().size();
        if (childrenCount == 1) {
            return ((PredicateAstNode)this.getChildren().get(0)).buildFilterExpression();
        }
        for (int i = 0; i < childrenCount; i += 2) {
            PredicateAstNode predicate = (PredicateAstNode)this.getChildren().get(i);
            BooleanOperatorAstNode nextOperator = null;
            if (i + 1 < childrenCount) {
                nextOperator = (BooleanOperatorAstNode)this.getChildren().get(i + 1);
            }
            if (nextOperator == null) {
                if (!filterQueryAndExpressions.isEmpty()) {
                    filterQueryAndExpressions.add(predicate.buildFilterExpression());
                    if (filterQueryOrExpressions.isEmpty()) continue;
                    filterQueryOrExpressions.add(this.buildFilterExpression(FilterKind.AND, filterQueryAndExpressions));
                    continue;
                }
                filterQueryOrExpressions.add(predicate.buildFilterExpression());
                continue;
            }
            if (nextOperator == BooleanOperatorAstNode.AND) {
                filterQueryAndExpressions.add(predicate.buildFilterExpression());
                continue;
            }
            if (!filterQueryAndExpressions.isEmpty()) {
                filterQueryAndExpressions.add(predicate.buildFilterExpression());
                filterQueryOrExpressions.add(this.buildFilterExpression(FilterKind.AND, filterQueryAndExpressions));
                filterQueryAndExpressions = new ArrayList();
                continue;
            }
            filterQueryOrExpressions.add(predicate.buildFilterExpression());
        }
        if (!filterQueryOrExpressions.isEmpty()) {
            return this.buildFilterExpression(FilterKind.OR, filterQueryOrExpressions);
        }
        return this.buildFilterExpression(FilterKind.AND, filterQueryAndExpressions);
    }

    public Expression buildFilterExpression(FilterKind operator, List<Expression> children) {
        Expression expression = RequestUtils.getFunctionExpression(operator.name());
        for (Expression child : children) {
            expression.getFunctionCall().addToOperands(child);
        }
        return expression;
    }

    private FilterQueryTree buildFilterPredicate(List<FilterQueryTree> children, FilterOperator operator) {
        return new FilterQueryTree(null, null, operator, children);
    }
}

