/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;

public class RegexpLikePredicateAstNode
extends PredicateAstNode {
    private String _identifier;

    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("REGEXP_LIKE predicate has more than one column/function");
            }
            this._identifier = ((IdentifierAstNode)childNode).getName();
        } else if (childNode instanceof FunctionCallAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("REGEXP_LIKE predicate has more than one column/function");
            }
            this._identifier = TransformExpressionTree.getStandardExpression(childNode);
        } else {
            super.addChild(childNode);
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("REGEXP_LIKE predicate has no identifier");
        }
        List<? extends AstNode> children = this.getChildren();
        if (children.size() > 1) {
            throw new Pql2CompilationException("Matching more than one regex is NOT supported currently");
        }
        String value = ((LiteralAstNode)children.get(0)).getValueAsString();
        return new FilterQueryTree(this._identifier, Collections.singletonList(value), FilterOperator.REGEXP_LIKE, null);
    }

    @Override
    public Expression buildFilterExpression() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("REGEXP_LIKE predicate has no identifier");
        }
        Expression expression = RequestUtils.getFunctionExpression(FilterKind.REGEXP_LIKE.name());
        expression.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
        if (this.getChildren().size() > 1) {
            throw new Pql2CompilationException("Matching more than one regex is NOT supported currently");
        }
        for (AstNode astNode : this.getChildren()) {
            expression.getFunctionCall().addToOperands(RequestUtils.getExpression(astNode));
        }
        return expression;
    }
}

