/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class StringFunctions {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    private StringFunctions() {
    }

    @ScalarFunction
    public static String reverse(String input) {
        return StringUtils.reverse((String)input);
    }

    @ScalarFunction
    public static String lower(String input) {
        return input.toLowerCase();
    }

    @ScalarFunction
    public static String upper(String input) {
        return input.toUpperCase();
    }

    @ScalarFunction
    public static String substr(String input, int beginIndex) {
        return StringUtils.substring((String)input, (int)beginIndex);
    }

    @ScalarFunction
    public static String substr(String input, int beginIndex, int endIndex) {
        if (endIndex == -1) {
            return StringFunctions.substr(input, beginIndex);
        }
        return StringUtils.substring((String)input, (int)beginIndex, (int)endIndex);
    }

    @ScalarFunction
    public static String concat(String input1, String input2, String seperator) {
        Object result = input1;
        result = (String)result + seperator + input2;
        return result;
    }

    @ScalarFunction
    public static String trim(String input) {
        return input.trim();
    }

    @ScalarFunction
    public static String trim(String end, String characters, String value) {
        int startIndex;
        int length = value.length();
        int endIndex = length;
        if (end.equals("BOTH") || end.equals("LEADING")) {
            for (startIndex = 0; startIndex < endIndex && characters.indexOf(value.charAt(startIndex)) >= 0; ++startIndex) {
            }
        }
        if (end.equals("BOTH") || end.equals("TRAILING")) {
            while (startIndex < endIndex && characters.indexOf(value.charAt(endIndex - 1)) >= 0) {
                --endIndex;
            }
        }
        if (startIndex > 0 || endIndex < length) {
            return value.substring(startIndex, endIndex);
        }
        return value;
    }

    @ScalarFunction
    public static String ltrim(String input) {
        return LTRIM.matcher(input).replaceAll("");
    }

    @ScalarFunction
    public static String rtrim(String input) {
        return RTRIM.matcher(input).replaceAll("");
    }

    @ScalarFunction
    public static String leftSubStr(String input, int length) {
        return StringUtils.left((String)input, (int)length);
    }

    @ScalarFunction
    public static String rightSubStr(String input, int length) {
        return StringUtils.right((String)input, (int)length);
    }

    @ScalarFunction
    public static String regexpExtract(String value, String regexp) {
        return StringFunctions.regexpExtract(value, regexp, 0, "");
    }

    @ScalarFunction
    public static String regexpExtract(String value, String regexp, int group) {
        return StringFunctions.regexpExtract(value, regexp, group, "");
    }

    @ScalarFunction
    public static String regexpExtract(String value, String regexp, int group, String defaultValue) {
        Pattern p = Pattern.compile(regexp);
        Matcher matcher = p.matcher(value);
        if (matcher.find() && matcher.groupCount() >= group) {
            return matcher.group(group);
        }
        return defaultValue;
    }

    @ScalarFunction
    public static int length(String input) {
        return input.length();
    }

    @ScalarFunction
    public static int strpos(String input, String find, int instance) {
        return StringUtils.ordinalIndexOf((CharSequence)input, (CharSequence)find, (int)instance);
    }

    @ScalarFunction
    public static int strpos(String input, String find) {
        return StringUtils.indexOf((CharSequence)input, (CharSequence)find);
    }

    @ScalarFunction
    public static int strrpos(String input, String find) {
        return StringUtils.lastIndexOf((CharSequence)input, (CharSequence)find);
    }

    @ScalarFunction
    public static int strrpos(String input, String find, int instance) {
        return StringUtils.lastIndexOf((CharSequence)input, (CharSequence)find, (int)instance);
    }

    @ScalarFunction
    public static boolean startsWith(String input, String prefix) {
        return StringUtils.startsWith((CharSequence)input, (CharSequence)prefix);
    }

    @ScalarFunction
    public static boolean endsWith(String input, String suffix) {
        return StringUtils.endsWith((CharSequence)input, (CharSequence)suffix);
    }

    @ScalarFunction
    public static String replace(String input, String find, String substitute) {
        return StringUtils.replace((String)input, (String)find, (String)substitute);
    }

    @ScalarFunction
    public static String rpad(String input, int size, String pad) {
        return StringUtils.rightPad((String)input, (int)size, (String)pad);
    }

    @ScalarFunction
    public static String lpad(String input, int size, String pad) {
        return StringUtils.leftPad((String)input, (int)size, (String)pad);
    }

    @ScalarFunction
    public static int codepoint(String input) {
        return input.codePointAt(0);
    }

    @ScalarFunction
    public static String chr(int codepoint) {
        char[] result = Character.toChars(codepoint);
        return new String(result);
    }

    @ScalarFunction
    public static byte[] toUtf8(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    @ScalarFunction
    public static String fromUtf8(byte[] input) {
        return new String(input, StandardCharsets.UTF_8);
    }

    @ScalarFunction
    public static byte[] toAscii(String input) {
        return input.getBytes(StandardCharsets.US_ASCII);
    }

    @ScalarFunction
    public static String normalize(String input) {
        return Normalizer.normalize(input, Normalizer.Form.NFC);
    }

    @ScalarFunction
    public static String normalize(String input, String form) {
        Normalizer.Form targetForm = Normalizer.Form.valueOf(form);
        return Normalizer.normalize(input, targetForm);
    }

    @ScalarFunction
    public static String[] split(String input, String delimiter) {
        return StringUtils.split((String)input, (String)delimiter);
    }

    @ScalarFunction
    public static String[] split(String input, String delimiter, int limit) {
        return StringUtils.split((String)input, (String)delimiter, (int)limit);
    }

    @ScalarFunction
    public static String splitPart(String input, String delimiter, int index) {
        String[] splitString = StringUtils.split((String)input, (String)delimiter);
        if (index < splitString.length) {
            return splitString[index];
        }
        return "null";
    }

    @ScalarFunction
    public static String repeat(String input, int times) {
        return StringUtils.repeat((String)input, (int)times);
    }

    @ScalarFunction
    public static String repeat(String input, String sep, int times) {
        return StringUtils.repeat((String)input, (String)sep, (int)times);
    }

    @ScalarFunction
    public static String remove(String input, String search) {
        return StringUtils.remove((String)input, (String)search);
    }

    @ScalarFunction
    public static int hammingDistance(String input1, String input2) {
        if (input1.length() != input2.length()) {
            return -1;
        }
        int distance = 0;
        for (int i = 0; i < input1.length(); ++i) {
            if (input1.charAt(i) == input2.charAt(i)) continue;
            ++distance;
        }
        return distance;
    }

    @ScalarFunction
    public static boolean contains(String input, String substring) {
        return input.contains(substring);
    }

    @ScalarFunction
    public static int strcmp(String input1, String input2) {
        return input1.compareTo(input2);
    }

    @ScalarFunction
    public static String encodeUrl(String input) throws UnsupportedEncodingException {
        return URLEncoder.encode(input, StandardCharsets.UTF_8.toString());
    }

    @ScalarFunction
    public static String decodeUrl(String input) throws UnsupportedEncodingException {
        return URLDecoder.decode(input, StandardCharsets.UTF_8.toString());
    }

    @ScalarFunction
    public static String toBase64(byte[] input) {
        return Base64.getEncoder().encodeToString(input);
    }

    @ScalarFunction
    public static byte[] fromBase64(String input) {
        return Base64.getDecoder().decode(input);
    }

    @ScalarFunction
    public static String regexpReplace(String inputStr, String matchStr, String replaceStr, int matchStartPos, int occurence, String flag) {
        StringBuffer sb;
        Integer patternFlag;
        switch (flag) {
            case "i": {
                patternFlag = 2;
                break;
            }
            default: {
                patternFlag = null;
            }
        }
        Pattern p = patternFlag != null ? Pattern.compile(matchStr, patternFlag) : Pattern.compile(matchStr);
        Matcher matcher = p.matcher(inputStr).region(matchStartPos, inputStr.length());
        if (occurence >= 0) {
            sb = new StringBuffer(inputStr);
            while (occurence >= 0 && matcher.find()) {
                if (occurence == 0) {
                    sb.replace(matcher.start(), matcher.end(), replaceStr);
                    break;
                }
                --occurence;
            }
        } else {
            sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, replaceStr);
            }
            matcher.appendTail(sb);
        }
        return sb.toString();
    }

    @ScalarFunction
    public static String regexpReplace(String inputStr, String matchStr, String replaceStr) {
        return StringFunctions.regexpReplace(inputStr, matchStr, replaceStr, 0, -1, "");
    }

    @ScalarFunction
    public static String regexpReplace(String inputStr, String matchStr, String replaceStr, int matchStartPos) {
        return StringFunctions.regexpReplace(inputStr, matchStr, replaceStr, matchStartPos, -1, "");
    }

    @ScalarFunction
    public static String regexpReplace(String inputStr, String matchStr, String replaceStr, int matchStartPos, int occurence) {
        return StringFunctions.regexpReplace(inputStr, matchStr, replaceStr, matchStartPos, occurence, "");
    }
}

