/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.utils.SchemaUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.spi.config.provider.PinotConfigProvider;
import org.apache.pinot.spi.config.provider.SchemaChangeListener;
import org.apache.pinot.spi.config.provider.TableConfigChangeListener;
import org.apache.pinot.spi.config.table.QueryConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.TimestampIndexUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCache
implements PinotConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableCache.class);
    private static final String TABLE_CONFIG_PARENT_PATH = "/CONFIGS/TABLE";
    private static final String TABLE_CONFIG_PATH_PREFIX = "/CONFIGS/TABLE/";
    private static final String SCHEMA_PARENT_PATH = "/SCHEMAS";
    private static final String SCHEMA_PATH_PREFIX = "/SCHEMAS/";
    private static final String OFFLINE_TABLE_SUFFIX = "_OFFLINE";
    private static final String REALTIME_TABLE_SUFFIX = "_REALTIME";
    private static final String LOWER_CASE_OFFLINE_TABLE_SUFFIX = "_OFFLINE".toLowerCase();
    private static final String LOWER_CASE_REALTIME_TABLE_SUFFIX = "_REALTIME".toLowerCase();
    private final Set<TableConfigChangeListener> _tableConfigChangeListeners = new HashSet<TableConfigChangeListener>();
    private final Set<SchemaChangeListener> _schemaChangeListeners = new HashSet<SchemaChangeListener>();
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final boolean _ignoreCase;
    private final ZkTableConfigChangeListener _zkTableConfigChangeListener = new ZkTableConfigChangeListener();
    private final Map<String, TableConfigInfo> _tableConfigInfoMap = new ConcurrentHashMap<String, TableConfigInfo>();
    private final Map<String, String> _schemaNameMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> _tableNameMap = new ConcurrentHashMap<String, String>();
    private final ZkSchemaChangeListener _zkSchemaChangeListener = new ZkSchemaChangeListener();
    private final Map<String, SchemaInfo> _schemaInfoMap = new ConcurrentHashMap<String, SchemaInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCache(ZkHelixPropertyStore<ZNRecord> propertyStore, boolean ignoreCase) {
        ArrayList<String> pathsToAdd;
        List tables;
        this._propertyStore = propertyStore;
        this._ignoreCase = ignoreCase;
        Object object = this._zkTableConfigChangeListener;
        synchronized (object) {
            this._propertyStore.subscribeChildChanges(TABLE_CONFIG_PARENT_PATH, (IZkChildListener)this._zkTableConfigChangeListener);
            tables = this._propertyStore.getChildNames(TABLE_CONFIG_PARENT_PATH, AccessOption.PERSISTENT);
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                pathsToAdd = new ArrayList<String>(tables.size());
                for (String tableNameWithType : tables) {
                    pathsToAdd.add(TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
                }
                this.addTableConfigs(pathsToAdd);
            }
        }
        object = this._zkSchemaChangeListener;
        synchronized (object) {
            this._propertyStore.subscribeChildChanges(SCHEMA_PARENT_PATH, (IZkChildListener)this._zkSchemaChangeListener);
            tables = this._propertyStore.getChildNames(SCHEMA_PARENT_PATH, AccessOption.PERSISTENT);
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                pathsToAdd = new ArrayList(tables.size());
                for (String rawTableName : tables) {
                    pathsToAdd.add(SCHEMA_PATH_PREFIX + rawTableName);
                }
                this.addSchemas(pathsToAdd);
            }
        }
        LOGGER.info("Initialized TableCache with IgnoreCase: {}", (Object)ignoreCase);
    }

    public boolean isIgnoreCase() {
        return this._ignoreCase;
    }

    @Nullable
    public String getActualTableName(String tableName) {
        if (this._ignoreCase) {
            return this._tableNameMap.get(tableName.toLowerCase());
        }
        return this._tableNameMap.get(tableName);
    }

    public Map<String, String> getTableNameMap() {
        return this._tableNameMap;
    }

    @Nullable
    public Map<String, String> getColumnNameMap(String rawTableName) {
        String schemaName = this._schemaNameMap.getOrDefault(rawTableName, rawTableName);
        SchemaInfo schemaInfo = this._schemaInfoMap.getOrDefault(schemaName, this._schemaInfoMap.get(rawTableName));
        return schemaInfo != null ? schemaInfo._columnNameMap : null;
    }

    @Nullable
    public Map<Expression, Expression> getExpressionOverrideMap(String tableNameWithType) {
        TableConfigInfo tableConfigInfo = this._tableConfigInfoMap.get(tableNameWithType);
        return tableConfigInfo != null ? tableConfigInfo._expressionOverrideMap : null;
    }

    @Nullable
    public Set<String> getTimestampIndexColumns(String tableNameWithType) {
        TableConfigInfo tableConfigInfo = this._tableConfigInfoMap.get(tableNameWithType);
        return tableConfigInfo != null ? tableConfigInfo._timestampIndexColumns : null;
    }

    @Nullable
    public TableConfig getTableConfig(String tableNameWithType) {
        TableConfigInfo tableConfigInfo = this._tableConfigInfoMap.get(tableNameWithType);
        return tableConfigInfo != null ? tableConfigInfo._tableConfig : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerTableConfigChangeListener(TableConfigChangeListener tableConfigChangeListener) {
        ZkTableConfigChangeListener zkTableConfigChangeListener = this._zkTableConfigChangeListener;
        synchronized (zkTableConfigChangeListener) {
            boolean added = this._tableConfigChangeListeners.add(tableConfigChangeListener);
            if (added) {
                tableConfigChangeListener.onChange(this.getTableConfigs());
            }
            return added;
        }
    }

    @Nullable
    public Schema getSchema(String rawTableName) {
        String schemaName = this._schemaNameMap.getOrDefault(rawTableName, rawTableName);
        SchemaInfo schemaInfo = this._schemaInfoMap.get(schemaName);
        return schemaInfo != null ? schemaInfo._schema : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerSchemaChangeListener(SchemaChangeListener schemaChangeListener) {
        ZkSchemaChangeListener zkSchemaChangeListener = this._zkSchemaChangeListener;
        synchronized (zkSchemaChangeListener) {
            boolean added = this._schemaChangeListeners.add(schemaChangeListener);
            if (added) {
                schemaChangeListener.onChange(this.getSchemas());
            }
            return added;
        }
    }

    private void addTableConfigs(List<String> paths) {
        for (String path : paths) {
            this._propertyStore.subscribeDataChanges(path, (IZkDataListener)this._zkTableConfigChangeListener);
        }
        List znRecords = this._propertyStore.get(paths, null, AccessOption.PERSISTENT);
        for (ZNRecord znRecord : znRecords) {
            if (znRecord == null) continue;
            try {
                this.putTableConfig(znRecord);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding table config for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            }
        }
    }

    private void putTableConfig(ZNRecord znRecord) throws IOException {
        TableConfig tableConfig = TableConfigUtils.fromZNRecord(znRecord);
        String tableNameWithType = tableConfig.getTableName();
        this._tableConfigInfoMap.put(tableNameWithType, new TableConfigInfo(tableConfig));
        String schemaName = tableConfig.getValidationConfig().getSchemaName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        if (schemaName != null && !schemaName.equals(rawTableName)) {
            this._schemaNameMap.put(tableNameWithType, schemaName);
            this._schemaNameMap.put(rawTableName, schemaName);
        } else {
            this.removeSchemaName(tableNameWithType);
        }
        if (this._ignoreCase) {
            this._tableNameMap.put(tableNameWithType.toLowerCase(), tableNameWithType);
            this._tableNameMap.put(rawTableName.toLowerCase(), rawTableName);
        } else {
            this._tableNameMap.put(tableNameWithType, tableNameWithType);
            this._tableNameMap.put(rawTableName, rawTableName);
        }
    }

    private void removeTableConfig(String path) {
        this._propertyStore.unsubscribeDataChanges(path, (IZkDataListener)this._zkTableConfigChangeListener);
        String tableNameWithType = path.substring(TABLE_CONFIG_PATH_PREFIX.length());
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        this._tableConfigInfoMap.remove(tableNameWithType);
        this.removeSchemaName(tableNameWithType);
        if (this._ignoreCase) {
            this._tableNameMap.remove(tableNameWithType.toLowerCase());
            String lowerCaseRawTableName = rawTableName.toLowerCase();
            if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
                if (!this._tableNameMap.containsKey(lowerCaseRawTableName + LOWER_CASE_REALTIME_TABLE_SUFFIX)) {
                    this._tableNameMap.remove(lowerCaseRawTableName);
                }
            } else if (!this._tableNameMap.containsKey(lowerCaseRawTableName + LOWER_CASE_OFFLINE_TABLE_SUFFIX)) {
                this._tableNameMap.remove(lowerCaseRawTableName);
            }
        } else {
            this._tableNameMap.remove(tableNameWithType);
            if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
                if (!this._tableNameMap.containsKey(rawTableName + REALTIME_TABLE_SUFFIX)) {
                    this._tableNameMap.remove(rawTableName);
                }
            } else if (!this._tableNameMap.containsKey(rawTableName + OFFLINE_TABLE_SUFFIX)) {
                this._tableNameMap.remove(rawTableName);
            }
        }
    }

    private void removeSchemaName(String tableNameWithType) {
        if (this._schemaNameMap.remove(tableNameWithType) != null) {
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
            if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
                if (!this._schemaNameMap.containsKey(TableNameBuilder.REALTIME.tableNameWithType(rawTableName))) {
                    this._schemaNameMap.remove(rawTableName);
                }
            } else if (!this._schemaNameMap.containsKey(TableNameBuilder.OFFLINE.tableNameWithType(rawTableName))) {
                this._schemaNameMap.remove(rawTableName);
            }
        }
    }

    private void addSchemas(List<String> paths) {
        for (String path : paths) {
            this._propertyStore.subscribeDataChanges(path, (IZkDataListener)this._zkSchemaChangeListener);
        }
        List znRecords = this._propertyStore.get(paths, null, AccessOption.PERSISTENT);
        for (ZNRecord znRecord : znRecords) {
            if (znRecord == null) continue;
            try {
                this.putSchema(znRecord);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding schema for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            }
        }
    }

    private void putSchema(ZNRecord znRecord) throws IOException {
        Schema schema = SchemaUtils.fromZNRecord(znRecord);
        TableCache.addBuiltInVirtualColumns(schema);
        String schemaName = schema.getSchemaName();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        if (this._ignoreCase) {
            for (String columnName : schema.getColumnNames()) {
                columnNameMap.put(columnName.toLowerCase(), columnName);
            }
        } else {
            for (String columnName : schema.getColumnNames()) {
                columnNameMap.put(columnName, columnName);
            }
        }
        this._schemaInfoMap.put(schemaName, new SchemaInfo(schema, columnNameMap));
    }

    private static void addBuiltInVirtualColumns(Schema schema) {
        if (!schema.hasColumn("$docId")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$docId", FieldSpec.DataType.INT, true));
        }
        if (!schema.hasColumn("$hostName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$hostName", FieldSpec.DataType.STRING, true));
        }
        if (!schema.hasColumn("$segmentName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$segmentName", FieldSpec.DataType.STRING, true));
        }
    }

    private void removeSchema(String path) {
        this._propertyStore.unsubscribeDataChanges(path, (IZkDataListener)this._zkSchemaChangeListener);
        String schemaName = path.substring(SCHEMA_PATH_PREFIX.length());
        this._schemaInfoMap.remove(schemaName);
    }

    private void notifyTableConfigChangeListeners() {
        if (!this._tableConfigChangeListeners.isEmpty()) {
            List<TableConfig> tableConfigs = this.getTableConfigs();
            for (TableConfigChangeListener tableConfigChangeListener : this._tableConfigChangeListeners) {
                tableConfigChangeListener.onChange(tableConfigs);
            }
        }
    }

    private List<TableConfig> getTableConfigs() {
        ArrayList<TableConfig> tableConfigs = new ArrayList<TableConfig>(this._tableConfigInfoMap.size());
        for (TableConfigInfo tableConfigInfo : this._tableConfigInfoMap.values()) {
            tableConfigs.add(tableConfigInfo._tableConfig);
        }
        return tableConfigs;
    }

    private void notifySchemaChangeListeners() {
        if (!this._schemaChangeListeners.isEmpty()) {
            List<Schema> schemas = this.getSchemas();
            for (SchemaChangeListener schemaChangeListener : this._schemaChangeListeners) {
                schemaChangeListener.onChange(schemas);
            }
        }
    }

    private List<Schema> getSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>(this._schemaInfoMap.size());
        for (SchemaInfo schemaInfo : this._schemaInfoMap.values()) {
            schemas.add(schemaInfo._schema);
        }
        return schemas;
    }

    private static class SchemaInfo {
        final Schema _schema;
        final Map<String, String> _columnNameMap;

        private SchemaInfo(Schema schema, Map<String, String> columnNameMap) {
            this._schema = schema;
            this._columnNameMap = columnNameMap;
        }
    }

    private static class TableConfigInfo {
        final TableConfig _tableConfig;
        final Map<Expression, Expression> _expressionOverrideMap;
        final Set<String> _timestampIndexColumns;

        private TableConfigInfo(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            QueryConfig queryConfig = tableConfig.getQueryConfig();
            if (queryConfig != null && MapUtils.isNotEmpty((Map)queryConfig.getExpressionOverrideMap())) {
                TreeMap<Expression, Expression> expressionOverrideMap = new TreeMap<Expression, Expression>();
                for (Map.Entry entry : queryConfig.getExpressionOverrideMap().entrySet()) {
                    try {
                        Expression srcExp = CalciteSqlParser.compileToExpression((String)entry.getKey());
                        Expression destExp = CalciteSqlParser.compileToExpression((String)entry.getValue());
                        expressionOverrideMap.put(srcExp, destExp);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception while compiling expression override: {} -> {} for table: {}, skipping it", new Object[]{entry.getKey(), entry.getValue(), tableConfig.getTableName()});
                    }
                }
                int mapSize = expressionOverrideMap.size();
                if (mapSize == 0) {
                    this._expressionOverrideMap = null;
                } else if (mapSize == 1) {
                    Map.Entry entry;
                    entry = expressionOverrideMap.entrySet().iterator().next();
                    this._expressionOverrideMap = Collections.singletonMap((Expression)entry.getKey(), (Expression)entry.getValue());
                } else {
                    this._expressionOverrideMap = expressionOverrideMap;
                }
            } else {
                this._expressionOverrideMap = null;
            }
            this._timestampIndexColumns = TimestampIndexUtils.extractColumnsWithGranularity((TableConfig)tableConfig);
        }
    }

    private class ZkSchemaChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private ZkSchemaChangeListener() {
        }

        public synchronized void handleChildChange(String path, List<String> schemaNames) {
            if (CollectionUtils.isEmpty(schemaNames)) {
                return;
            }
            ArrayList<String> pathsToAdd = new ArrayList<String>();
            for (String schemaName : schemaNames) {
                if (TableCache.this._schemaInfoMap.containsKey(schemaName)) continue;
                pathsToAdd.add(TableCache.SCHEMA_PATH_PREFIX + schemaName);
            }
            if (!pathsToAdd.isEmpty()) {
                TableCache.this.addSchemas(pathsToAdd);
            }
            TableCache.this.notifySchemaChangeListeners();
        }

        public synchronized void handleDataChange(String path, Object data) {
            if (data != null) {
                ZNRecord znRecord = (ZNRecord)data;
                try {
                    TableCache.this.putSchema(znRecord);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while refreshing schema for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
                }
                TableCache.this.notifySchemaChangeListeners();
            }
        }

        public synchronized void handleDataDeleted(String path) {
            String schemaName = path.substring(path.lastIndexOf(47) + 1);
            TableCache.this.removeSchema(TableCache.SCHEMA_PATH_PREFIX + schemaName);
            TableCache.this.notifySchemaChangeListeners();
        }
    }

    private class ZkTableConfigChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private ZkTableConfigChangeListener() {
        }

        public synchronized void handleChildChange(String path, List<String> tableNamesWithType) {
            if (CollectionUtils.isEmpty(tableNamesWithType)) {
                return;
            }
            ArrayList<String> pathsToAdd = new ArrayList<String>();
            for (String tableNameWithType : tableNamesWithType) {
                if (TableCache.this._tableConfigInfoMap.containsKey(tableNameWithType)) continue;
                pathsToAdd.add(TableCache.TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
            }
            if (!pathsToAdd.isEmpty()) {
                TableCache.this.addTableConfigs(pathsToAdd);
            }
            TableCache.this.notifyTableConfigChangeListeners();
        }

        public synchronized void handleDataChange(String path, Object data) {
            if (data != null) {
                ZNRecord znRecord = (ZNRecord)data;
                try {
                    TableCache.this.putTableConfig(znRecord);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while refreshing table config for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
                }
                TableCache.this.notifyTableConfigChangeListeners();
            }
        }

        public synchronized void handleDataDeleted(String path) {
            String tableNameWithType = path.substring(path.lastIndexOf(47) + 1);
            TableCache.this.removeTableConfig(TableCache.TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
            TableCache.this.notifyTableConfigChangeListeners();
        }
    }
}

