/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.helix;

import org.apache.helix.model.InstanceConfig;

public class ExtraInstanceConfig {
    private final InstanceConfig _proxy;

    public ExtraInstanceConfig(InstanceConfig proxy) {
        this._proxy = proxy;
    }

    public String getTlsPort() {
        return this._proxy.getRecord().getSimpleField(PinotInstanceConfigProperty.PINOT_TLS_PORT.toString());
    }

    public void setTlsPort(String tlsPort) {
        this._proxy.getRecord().setSimpleField(PinotInstanceConfigProperty.PINOT_TLS_PORT.toString(), tlsPort);
    }

    public String getComponentUrl() {
        String protocol = null;
        String port = null;
        try {
            if (Integer.parseInt(this.getTlsPort()) > 0) {
                protocol = "https";
                port = this.getTlsPort();
            }
        }
        catch (Exception e) {
            try {
                if (Integer.parseInt(this._proxy.getPort()) > 0) {
                    protocol = "http";
                    port = this._proxy.getPort();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (port != null) {
            return String.format("%s://%s:%s", protocol, this._proxy.getHostName(), port);
        }
        return null;
    }

    public static enum PinotInstanceConfigProperty {
        PINOT_TLS_PORT;

    }
}

